/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util.logging;

import java.util.logging.Logger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.DefaultConfiguration;
import org.apache.logging.log4j.core.config.NullConfiguration;
import org.apache.logging.log4j.core.config.builder.impl.BuiltConfiguration;
import org.apache.logging.log4j.core.config.json.JsonConfiguration;
import org.apache.logging.log4j.core.config.properties.PropertiesConfiguration;
import org.apache.logging.log4j.core.config.xml.XmlConfiguration;
import org.apache.logging.log4j.core.config.yaml.YamlConfiguration;
import org.geotools.util.logging.Log4J2Logger;
import org.geotools.util.logging.LoggerFactory;

public class Log4J2LoggerFactory
extends LoggerFactory<org.apache.logging.log4j.Logger> {
    private static Log4J2LoggerFactory factory;

    protected Log4J2LoggerFactory() throws NoClassDefFoundError {
        super(org.apache.logging.log4j.Logger.class);
    }

    public static synchronized Log4J2LoggerFactory getInstance() throws NoClassDefFoundError {
        if (factory == null) {
            factory = new Log4J2LoggerFactory();
        }
        return factory;
    }

    @Override
    protected org.apache.logging.log4j.Logger getImplementation(String name) {
        return LogManager.getLogger((String)name);
    }

    @Override
    protected Logger wrap(String name, org.apache.logging.log4j.Logger implementation) {
        return new Log4J2Logger(name, implementation);
    }

    @Override
    protected org.apache.logging.log4j.Logger unwrap(Logger logger) {
        if (logger instanceof Log4J2Logger) {
            Log4J2Logger j2Logger = (Log4J2Logger)logger;
            return j2Logger.logger;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String lookupConfiguration() {
        try (LoggerContext context = (LoggerContext)LogManager.getContext();){
            Configuration configuration = context.getConfiguration();
            if (configuration instanceof XmlConfiguration) {
                XmlConfiguration xmlConfiguration = (XmlConfiguration)configuration;
                String string = xmlConfiguration.getName();
                return string;
            }
            if (configuration instanceof YamlConfiguration) {
                YamlConfiguration yamlConfiguration = (YamlConfiguration)configuration;
                String string = yamlConfiguration.getName();
                return string;
            }
            if (configuration instanceof JsonConfiguration) {
                JsonConfiguration jsonConfiguration = (JsonConfiguration)configuration;
                String string = jsonConfiguration.getName();
                return string;
            }
            if (configuration instanceof PropertiesConfiguration) {
                PropertiesConfiguration propertiesConfiguration = (PropertiesConfiguration)configuration;
                String string = propertiesConfiguration.getName();
                return string;
            }
            if (configuration instanceof DefaultConfiguration) {
                String string = "org.apache.logging.log4j.level=" + System.getProperty("org.apache.logging.log4j.level", "ERROR");
                return string;
            }
            if (configuration instanceof BuiltConfiguration) {
                String string = "built configuration";
                return string;
            }
            if (configuration instanceof NullConfiguration) {
                String string = "null configuration";
                return string;
            }
            String string = null;
            return string;
        }
        catch (Exception unknown) {
            return "unknown";
        }
    }
}

