/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs.web.demo;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.xml.transform.TransformerException;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptContentHeaderItem;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.wcs.responses.CoverageResponseDelegateFinder;
import org.geoserver.wcs.web.demo.GetCoverageRequest;
import org.geoserver.wcs.web.demo.WCS10GetCoverageTransformer;
import org.geoserver.wcs.web.demo.WCS11GetCoverageTransformer;
import org.geoserver.wcs.web.demo.WCSRequestBuilderPanel;
import org.geoserver.web.GeoServerApplication;
import org.geoserver.web.GeoServerBasePage;
import org.geoserver.web.demo.DemoRequestsPage;
import org.geoserver.web.demo.PlainCodePage;
import org.geoserver.web.wicket.GSModalWindow;
import org.geotools.xml.transform.TransformerBase;

public class WCSRequestBuilder
extends GeoServerBasePage {
    WCSRequestBuilderPanel builder;
    TextField<String> xml;

    public WCSRequestBuilder() {
        Form form = new Form("form");
        this.add(new Component[]{form});
        Model model = new Model((Serializable)new WCSRequestModel());
        form.setDefaultModel((IModel)model);
        this.xml = new TextField("xml", (IModel)new PropertyModel((Object)model, "xml"));
        this.xml.setOutputMarkupId(true);
        form.add(new Component[]{this.xml});
        this.builder = new WCSRequestBuilderPanel("requestBuilder", new GetCoverageRequest());
        form.add(new Component[]{this.builder});
        final GSModalWindow xmlWindow = new GSModalWindow("xmlWindow");
        this.add(new Component[]{xmlWindow});
        form.add(new Component[]{new AjaxSubmitLink("execute"){

            protected void onSubmit(AjaxRequestTarget target) {
                HttpServletRequest http = GeoServerApplication.get().servletRequest();
                String url = ResponseUtils.buildURL((String)ResponseUtils.baseURL((HttpServletRequest)http), (String)"ows", Collections.singletonMap("strict", "true"), (URLMangler.URLType)URLMangler.URLType.SERVICE);
                String xml = WCSRequestBuilder.this.getRequestXML();
                PageParameters parameters = new PageParameters();
                parameters.add("url", (Object)url);
                parameters.add("xml", (Object)xml);
                this.getRequestCycle().setResponsePage(DemoRequestsPage.class, parameters);
            }

            protected void onError(AjaxRequestTarget target) {
                super.onError(target);
                target.add(new Component[]{WCSRequestBuilder.this.builder.getFeedbackPanel()});
            }
        }});
        form.add(new Component[]{new AjaxSubmitLink("executeXML"){

            protected void onSubmit(AjaxRequestTarget target) {
                try {
                    xmlWindow.setContent((Component)new PlainCodePage(xmlWindow.getContentId(), WCSRequestBuilder.this.getRequestXML()));
                    xmlWindow.show(target);
                }
                catch (Exception e) {
                    this.error((Serializable)((Object)e.getMessage()));
                    WCSRequestBuilder.this.addFeedbackPanels(target);
                }
            }

            protected void onError(AjaxRequestTarget target) {
                WCSRequestBuilder.this.addFeedbackPanels(target);
            }
        }});
        form.add(new Component[]{new AjaxSubmitLink("setXml"){

            protected void onSubmit(AjaxRequestTarget target) {
                try {
                    String xmlText = WCSRequestBuilder.this.getRequestXML();
                    WCSRequestBuilder.this.xml.setModelObject((Object)xmlText);
                    target.add(new Component[]{WCSRequestBuilder.this.xml});
                }
                catch (Exception e) {
                    this.error((Serializable)((Object)e.getMessage()));
                    WCSRequestBuilder.this.addFeedbackPanels(target);
                }
                target.appendJavaScript((CharSequence)"getCoverage()");
            }

            protected void onError(AjaxRequestTarget target) {
                WCSRequestBuilder.this.addFeedbackPanels(target);
            }
        }});
    }

    String getRequestXML() {
        TransformerBase tx;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        if (this.builder.getCoverage.version == GetCoverageRequest.Version.v1_0_0) {
            tx = new WCS10GetCoverageTransformer(this.getCatalog());
        } else {
            CoverageResponseDelegateFinder responseFactory = (CoverageResponseDelegateFinder)this.getGeoServerApplication().getBean("coverageResponseDelegateFactory");
            tx = new WCS11GetCoverageTransformer(this.getCatalog(), responseFactory);
        }
        try {
            tx.setIndentation(2);
            tx.transform((Object)this.builder.getCoverageRequest(), (OutputStream)out);
        }
        catch (TransformerException e) {
            LOGGER.log(Level.SEVERE, "Error generating xml request", e);
            this.error(e);
        }
        return out.toString();
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)JavaScriptContentHeaderItem.forScript((CharSequence)DemoRequestsPage.demoRequestsJavascript, null));
        response.render((HeaderItem)CssHeaderItem.forCSS((CharSequence)"#xml {display: none;}", (String)"wcsRequestBuilderCSS"));
    }

    public static class WCSRequestModel
    implements Serializable {
        public String xml;

        public String getXml() {
            return this.xml;
        }

        public void setXml(String xml) {
            this.xml = xml;
        }
    }
}

