/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.geojson;

import com.bedatadriven.jackson.datatype.jts.parsers.GenericGeometryParser;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FilenameUtils;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.geojson.DateParser;
import org.geotools.data.geojson.ObjectMapperFactory;
import org.geotools.data.geojson.PagingFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.Geometries;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;

public class GeoJSONReader
implements AutoCloseable {
    public static final String GEOMETRY_NAME = "geometry";
    private static final Logger LOGGER = Logging.getLogger(GeoJSONReader.class);
    public static final Object TOP_LEVEL_ATTRIBUTES = "topLevelAttributes";
    private JsonParser parser;
    private static JsonFactory factory = new JsonFactory();
    private SimpleFeatureType schema;
    private SimpleFeatureBuilder builder;
    private int nextID = 0;
    private String baseName = "features";
    private boolean schemaChanged = false;
    private static GeometryFactory GEOM_FACTORY = new GeometryFactory();
    private static GenericGeometryParser GEOM_PARSER = new GenericGeometryParser(GEOM_FACTORY);
    private URL url;
    private String idPrefix;
    private String idFieldName = "id";
    private InputStream is;
    private boolean guessingDates = true;
    private DateParser dateParser = new DateParser();
    ObjectMapper mapper = new ObjectMapper();
    private IdStrategy idStrategy = IdStrategy.PROVIDED;

    public GeoJSONReader(URL url) throws IOException {
        this.url = url;
        this.parser = factory.createParser(url);
        this.idPrefix = this.baseName = FilenameUtils.getBaseName((String)url.getPath());
    }

    public GeoJSONReader(URL url, IdStrategy idStrategy) throws IOException {
        this(url);
        this.idStrategy = idStrategy;
    }

    public GeoJSONReader(InputStream is) throws IOException {
        this.parser = factory.createParser(is);
    }

    public GeoJSONReader(String json) throws IOException {
        this.parser = factory.createParser(json);
    }

    public IdStrategy getIdStrategy() {
        return this.idStrategy;
    }

    public void setIdStrategy(IdStrategy idStrategy) {
        this.idStrategy = idStrategy;
    }

    public String getIdPrefix() {
        return this.idPrefix;
    }

    public void setIdPrefix(String idPrefix) {
        this.idPrefix = idPrefix;
    }

    public String getIdFieldName() {
        return this.idFieldName;
    }

    public void setIdFieldName(String idFieldName) {
        this.idFieldName = idFieldName;
    }

    public boolean isGuessingDates() {
        return this.guessingDates;
    }

    public void setGuessingDates(boolean guessingDates) {
        this.guessingDates = guessingDates;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean isConnected() {
        if (this.url != null) {
            try (InputStream inputStream = this.url.openStream();){
                boolean bl;
                block17: {
                    if (inputStream != null && inputStream.available() > 0) {
                        boolean bl2 = true;
                        return bl2;
                    }
                    this.url = new URL(this.url.toExternalForm());
                    InputStream inputStream2 = this.url.openStream();
                    try {
                        boolean bl3 = bl = inputStream2 != null && inputStream2.available() > 0;
                        if (inputStream2 == null) break block17;
                    }
                    catch (Throwable throwable) {
                        if (inputStream2 != null) {
                            try {
                                inputStream2.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    inputStream2.close();
                }
                return bl;
            }
            catch (IOException e) {
                LOGGER.log(Level.FINE, "Failure trying to determine if connected", e);
                return false;
            }
        }
        return true;
    }

    public static SimpleFeature parseFeature(String json) throws JsonParseException, IOException {
        try (JsonParser lParser = factory.createParser((InputStream)new ByteArrayInputStream(json.getBytes(StandardCharsets.UTF_8)));){
            SimpleFeature simpleFeature;
            ObjectMapper mapper = ObjectMapperFactory.getDefaultMapper();
            ObjectNode node = (ObjectNode)mapper.readTree(lParser);
            try (GeoJSONReader reader = new GeoJSONReader((InputStream)null);){
                SimpleFeature feature;
                simpleFeature = feature = reader.getNextFeature(node);
            }
            return simpleFeature;
        }
    }

    public static SimpleFeature parseFeature(String json, IdStrategy idStrategy, String idPrefix, String idFieldName) throws JsonParseException, IOException {
        try (JsonParser lParser = factory.createParser((InputStream)new ByteArrayInputStream(json.getBytes(StandardCharsets.UTF_8)));){
            SimpleFeature simpleFeature;
            ObjectMapper mapper = ObjectMapperFactory.getDefaultMapper();
            ObjectNode node = (ObjectNode)mapper.readTree(lParser);
            try (GeoJSONReader reader = new GeoJSONReader((InputStream)null);){
                SimpleFeature feature;
                reader.setIdStrategy(idStrategy);
                if (idPrefix != null) {
                    reader.setIdPrefix(idPrefix);
                }
                if (idFieldName != null) {
                    reader.setIdFieldName(idFieldName);
                }
                simpleFeature = feature = reader.getNextFeature(node);
            }
            return simpleFeature;
        }
    }

    public static SimpleFeatureCollection parseFeatureCollection(String jsonString) {
        SimpleFeatureCollection simpleFeatureCollection;
        GeoJSONReader reader = new GeoJSONReader(new ByteArrayInputStream(jsonString.getBytes(StandardCharsets.UTF_8)));
        try {
            SimpleFeatureCollection features;
            simpleFeatureCollection = features = reader.getFeatures();
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException("problem parsing FeatureCollection", e);
            }
        }
        reader.close();
        return simpleFeatureCollection;
    }

    public static Geometry parseGeometry(String input) {
        Geometry geometry;
        block8: {
            JsonParser lParser = factory.createParser((InputStream)new ByteArrayInputStream(input.getBytes(StandardCharsets.UTF_8)));
            try {
                Geometry g;
                ObjectMapper mapper = ObjectMapperFactory.getDefaultMapper();
                ObjectNode node = (ObjectNode)mapper.readTree(lParser);
                geometry = g = GEOM_PARSER.geometryFromJson((JsonNode)node);
                if (lParser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (lParser != null) {
                        try {
                            lParser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("problem parsing Geometry", e);
                }
            }
            lParser.close();
        }
        return geometry;
    }

    public SimpleFeature getFeature() throws IOException {
        ObjectMapper mapper = ObjectMapperFactory.getDefaultMapper();
        ObjectNode node = (ObjectNode)mapper.readTree(this.parser);
        return this.getNextFeature(node);
    }

    public SimpleFeatureCollection getFeatures() throws IOException {
        JsonToken token;
        if (!this.isConnected()) {
            throw new IOException("not connected to " + this.url.toExternalForm());
        }
        ObjectMapper mapper = ObjectMapperFactory.getDefaultMapper();
        ArrayList<Object> features = new ArrayList<SimpleFeature>();
        ObjectNode next = null;
        Integer matched = null;
        this.builder = null;
        while (!this.parser.isClosed() && (token = this.parser.nextToken()) != null) {
            if (!JsonToken.FIELD_NAME.equals((Object)token)) continue;
            String name = this.parser.currentName();
            if ("features".equalsIgnoreCase(name)) {
                token = this.parser.nextToken();
                if (!JsonToken.START_ARRAY.equals((Object)token) || token == null) break;
                while (this.parser.nextToken() == JsonToken.START_OBJECT) {
                    ObjectNode objectNode = (ObjectNode)mapper.readTree(this.parser);
                    SimpleFeature feature = this.getNextFeature(objectNode);
                    features.add(feature);
                }
                continue;
            }
            if ("links".equalsIgnoreCase(name)) {
                token = this.parser.nextToken();
                if (!JsonToken.START_ARRAY.equals((Object)token) || token == null) break;
                while (this.parser.nextToken() == JsonToken.START_OBJECT) {
                    ObjectNode objectNode = (ObjectNode)mapper.readTree(this.parser);
                    JsonNode rel = objectNode.get("rel");
                    if (LOGGER.isLoggable(Level.FINE)) {
                        JsonNode href = objectNode.get("href");
                        LOGGER.log(Level.FINE, "Found link of type " + (rel == null ? "no rel" : rel.textValue()) + " href: " + (href == null ? "none" : href.textValue()));
                    }
                    if (rel == null || !"next".equals(rel.textValue())) continue;
                    next = objectNode;
                }
                continue;
            }
            if ("context".equalsIgnoreCase(name)) {
                token = this.parser.nextToken();
                if (!JsonToken.START_OBJECT.equals((Object)token) || token == null) break;
                ObjectNode objectNode = (ObjectNode)mapper.readTree(this.parser);
                JsonNode matchedNode = objectNode.get("matched");
                matched = matchedNode.asInt();
                continue;
            }
            if (!"numberMatched".equals(name) || this.parser.nextToken() != JsonToken.VALUE_NUMBER_INT) continue;
            matched = (Integer)mapper.readValue(this.parser, Integer.class);
        }
        if (this.isSchemaChanged()) {
            ArrayList<SimpleFeature> nFeatures = new ArrayList<SimpleFeature>(features.size());
            for (SimpleFeature simpleFeature : features) {
                if (simpleFeature.getFeatureType() != this.schema) {
                    this.builder.init(simpleFeature);
                    SimpleFeature nFeature = this.builder.buildFeature(simpleFeature.getID());
                    nFeatures.add(nFeature);
                    continue;
                }
                nFeatures.add(simpleFeature);
            }
            features = nFeatures;
        }
        if (this.schema == null) {
            this.schema = this.getBuilder((JsonNode)mapper.createObjectNode(), null).getFeatureType();
        }
        ListFeatureCollection result = new ListFeatureCollection(this.schema, features);
        if (next != null) {
            return this.getPagingFeatureCollection(result, matched, next);
        }
        return result;
    }

    protected PagingFeatureCollection getPagingFeatureCollection(SimpleFeatureCollection result, Integer matched, ObjectNode next) {
        return new PagingFeatureCollection(result, next, matched);
    }

    private SimpleFeature getNextFeature(ObjectNode node) throws IOException {
        JsonNode props;
        JsonNode type = node.get("type");
        if (type == null) {
            throw new RuntimeException("Missing object type in GeoJSON Parsing, expected type=Feature here");
        }
        if (!"Feature".equalsIgnoreCase(type.asText())) {
            throw new RuntimeException("Unexpected object type in GeoJSON Parsing, expected Feature got '" + type.asText() + "'");
        }
        JsonNode geom = node.get(GEOMETRY_NAME);
        Geometry g = null;
        if (geom != null && !geom.isNull()) {
            g = GEOM_PARSER.geometryFromJson(geom);
        }
        if ((props = node.get("properties")) == null) {
            props = this.mapper.createObjectNode();
        }
        if (this.builder == null || this.builder.getFeatureType().getGeometryDescriptor() == null && g != null || this.builder.getFeatureType().getGeometryDescriptor() != null && !this.builder.getFeatureType().getGeometryDescriptor().getType().getBinding().isInstance(g)) {
            this.builder = this.getBuilder(props, g);
        }
        boolean restart = true;
        SimpleFeature feature = null;
        while (restart) {
            restart = false;
            for (Map.Entry n : props.properties()) {
                Class binding;
                AttributeDescriptor descriptor = this.schema.getDescriptor((String)n.getKey());
                if (descriptor == null) {
                    restart = true;
                    this.builder = null;
                    this.builder = this.getBuilder(props, g);
                    this.setSchemaChanged(true);
                    descriptor = this.schema.getDescriptor((String)n.getKey());
                }
                if ((binding = descriptor.getType().getBinding()) == Integer.class) {
                    this.builder.set((String)n.getKey(), (Object)((JsonNode)n.getValue()).asInt());
                    continue;
                }
                if (binding == Double.class) {
                    this.builder.set((String)n.getKey(), (Object)((JsonNode)n.getValue()).asDouble());
                    continue;
                }
                if (binding == String.class) {
                    this.builder.set((String)n.getKey(), (Object)((JsonNode)n.getValue()).textValue());
                    continue;
                }
                if (binding == Boolean.class) {
                    this.builder.set((String)n.getKey(), (Object)((JsonNode)n.getValue()).booleanValue());
                    continue;
                }
                if (binding == Object.class) {
                    this.builder.set((String)n.getKey(), n.getValue());
                    continue;
                }
                if (binding == List.class) {
                    ArrayNode array = (ArrayNode)n.getValue();
                    ArrayList<JsonNode> list = new ArrayList<JsonNode>();
                    for (int i = 0; i < array.size(); ++i) {
                        JsonNode item = array.get(i);
                        list.add((JsonNode)(switch (item.getNodeType()) {
                            case JsonNodeType.BOOLEAN -> Boolean.valueOf(item.asBoolean());
                            case JsonNodeType.NUMBER -> Double.valueOf(item.asDouble());
                            case JsonNodeType.STRING -> item.asText();
                            case JsonNodeType.OBJECT -> item;
                            case JsonNodeType.ARRAY -> item;
                            case JsonNodeType.NULL -> null;
                            default -> throw new IllegalArgumentException("Cannot handle arrays with values of type " + String.valueOf(item.getNodeType()));
                        }));
                    }
                    this.builder.set((String)n.getKey(), list);
                    continue;
                }
                if (Geometry.class.isAssignableFrom(binding)) {
                    Geometry geomAtt = GEOM_PARSER.geometryFromJson((JsonNode)n.getValue());
                    this.builder.set((String)n.getKey(), (Object)geomAtt);
                    continue;
                }
                if (Date.class.isAssignableFrom(binding)) {
                    String text = ((JsonNode)n.getValue()).asText();
                    Date date = this.dateParser.parse(text);
                    if (date != null) {
                        this.builder.set((String)n.getKey(), (Object)date);
                        continue;
                    }
                    this.builder.set((String)n.getKey(), (Object)((JsonNode)n.getValue()).asText());
                    continue;
                }
                LOGGER.warning("Unable to parse object of type " + String.valueOf(binding));
                this.builder.set((String)n.getKey(), (Object)((JsonNode)n.getValue()).asText());
            }
            if (g != null) {
                this.builder.set(GEOMETRY_NAME, (Object)g);
            }
            String newId = this.getOrGenerateId(node);
            feature = this.builder.buildFeature(newId);
            if (!node.properties().iterator().hasNext()) continue;
            HashMap topLevelAttributes = new HashMap();
            node.properties().iterator().forEachRemaining(e -> {
                String k = (String)e.getKey();
                if (!(GEOMETRY_NAME.equals(k) || "type".equals(k) || "properties".equals(k) || "bbox".equals(k))) {
                    topLevelAttributes.put(k, e.getValue());
                }
            });
            if (topLevelAttributes.isEmpty()) continue;
            feature.getUserData().put(TOP_LEVEL_ATTRIBUTES, topLevelAttributes);
        }
        return feature;
    }

    private String getOrGenerateId(ObjectNode node) {
        switch (this.idStrategy) {
            case AUTO: {
                return this.autogenerateId(node);
            }
            case PREFIX: {
                return this.prefixId(node);
            }
            case PROVIDED: {
                return this.providedId(node);
            }
        }
        throw new IllegalArgumentException("Unknown id strategy");
    }

    private String providedId(ObjectNode node) {
        if (this.idFieldName != null && node.has(this.idFieldName)) {
            return node.get(this.idFieldName).asText();
        }
        return null;
    }

    private String prefixId(ObjectNode node) {
        String id = null;
        id = this.idFieldName != null && node.has(this.idFieldName) ? node.get(this.idFieldName).asText() : UUID.randomUUID().toString();
        if (this.idPrefix != null) {
            return this.idPrefix + "." + id;
        }
        return this.baseName + "." + id;
    }

    private String autogenerateId(ObjectNode node) {
        return this.baseName + "." + this.nextID++;
    }

    /*
     * Unable to fully structure code
     */
    private SimpleFeatureBuilder getBuilder(JsonNode props, Geometry g) {
        block16: {
            typeBuilder = new SimpleFeatureTypeBuilder();
            typeBuilder.setCRS(DefaultGeographicCRS.WGS84);
            typeBuilder.setName(this.baseName);
            existing = new HashSet<String>();
            if (this.schema == null) break block16;
            for (AttributeDescriptor att : this.schema.getAttributeDescriptors()) {
                if (!(att instanceof GeometryDescriptor)) ** GOTO lbl-1000
                gd = (GeometryDescriptor)att;
                if (this.schema.getGeometryDescriptor() == att && g != null) {
                    currClass = g.getClass();
                    prevClass = gd.getType().getBinding();
                    if (!prevClass.isAssignableFrom(currClass)) {
                        typeBuilder.add("geometry", Geometry.class, DefaultGeographicCRS.WGS84);
                    } else {
                        typeBuilder.add(att);
                    }
                } else lbl-1000:
                // 2 sources

                {
                    typeBuilder.add(att);
                }
                existing.add(att.getLocalName());
            }
        }
        if (typeBuilder.getDefaultGeometry() == null && g != null) {
            typeBuilder.setDefaultGeometry("geometry");
            if (!existing.contains("geometry")) {
                geomType = g.getClass();
                typeBuilder.add("geometry", geomType, DefaultGeographicCRS.WGS84);
            }
        }
        for (Map.Entry n : props.properties()) {
            if (existing.contains(n.getKey())) continue;
            existing.add((String)n.getKey());
            typeBuilder.nillable(true);
            value = (JsonNode)n.getValue();
            if (value instanceof IntNode) {
                typeBuilder.add((String)n.getKey(), Integer.class);
                continue;
            }
            if (value instanceof DoubleNode) {
                typeBuilder.add((String)n.getKey(), Double.class);
                continue;
            }
            if (value instanceof BooleanNode) {
                typeBuilder.add((String)n.getKey(), Boolean.class);
                continue;
            }
            if (value instanceof ObjectNode) {
                if (Optional.ofNullable(value.get("type")).map((Function<JsonNode, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getBuilder$1(com.fasterxml.jackson.databind.JsonNode ), (Lcom/fasterxml/jackson/databind/JsonNode;)Ljava/lang/String;)()).map((Function<String, Geometries>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getBuilder$2(java.lang.String ), (Ljava/lang/String;)Lorg/geotools/geometry/jts/Geometries;)()).isPresent()) {
                    typeBuilder.add((String)n.getKey(), Geometry.class, DefaultGeographicCRS.WGS84);
                    continue;
                }
                typeBuilder.add((String)n.getKey(), Object.class);
                continue;
            }
            if (value instanceof ArrayNode) {
                typeBuilder.add((String)n.getKey(), List.class);
                continue;
            }
            if (value instanceof TextNode && this.guessingDates) {
                date = this.dateParser.parse(value.asText());
                if (date != null) {
                    typeBuilder.add((String)n.getKey(), Date.class);
                    continue;
                }
                typeBuilder.defaultValue("");
                typeBuilder.add((String)n.getKey(), String.class);
                continue;
            }
            typeBuilder.defaultValue("");
            typeBuilder.add((String)n.getKey(), String.class);
        }
        this.schema = typeBuilder.buildFeatureType();
        return new SimpleFeatureBuilder(this.schema);
    }

    public SimpleFeatureIterator getIterator() throws IOException {
        if (!this.isConnected()) {
            LOGGER.fine("trying to read an unconnected data stream");
            return new DefaultFeatureCollection(null, null).features();
        }
        return new GeoJsonIterator(this.parser);
    }

    public FeatureType getSchema() throws IOException {
        if (!this.isConnected()) {
            throw new IOException("not connected to " + this.url.toExternalForm());
        }
        return this.schema;
    }

    public void setSchema(SimpleFeatureType schema) {
        this.schema = schema;
    }

    public boolean isSchemaChanged() {
        return this.schemaChanged;
    }

    public void setSchemaChanged(boolean schemaChanged) {
        this.schemaChanged = schemaChanged;
    }

    @Override
    public void close() throws IOException {
        if (this.parser != null) {
            this.parser.close();
            this.parser = null;
        }
        if (this.is != null) {
            this.is.close();
        }
    }

    private static /* synthetic */ Geometries lambda$getBuilder$2(String t) {
        return Geometries.getForName(t);
    }

    private static /* synthetic */ String lambda$getBuilder$1(JsonNode t) {
        return t.asText();
    }

    public static enum IdStrategy {
        AUTO,
        PREFIX,
        PROVIDED;

    }

    private class GeoJsonIterator
    implements SimpleFeatureIterator,
    AutoCloseable {
        JsonParser parser;
        private SimpleFeature feature;

        public GeoJsonIterator(JsonParser parser) throws IOException {
            JsonToken token;
            if (!GeoJSONReader.this.isConnected()) {
                throw new IOException("not connected to " + GeoJSONReader.this.url.toExternalForm());
            }
            this.parser = parser;
            GeoJSONReader.this.builder = null;
            while (!parser.isClosed() && (token = parser.nextToken()) != null) {
                if (!JsonToken.FIELD_NAME.equals((Object)token) || !"features".equalsIgnoreCase(parser.currentName())) continue;
                token = parser.nextToken();
                if (JsonToken.START_ARRAY.equals((Object)token) && token != null) break;
                throw new IOException("No Features found");
            }
        }

        @Override
        public boolean hasNext() {
            if (this.feature != null) {
                return true;
            }
            try {
                if (this.parser.nextToken() == JsonToken.START_OBJECT) {
                    ObjectNode node = (ObjectNode)GeoJSONReader.this.mapper.readTree(this.parser);
                    this.feature = GeoJSONReader.this.getNextFeature(node);
                    if (this.feature != null) {
                        return true;
                    }
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.FINER, e.getMessage(), e);
            }
            return false;
        }

        @Override
        public SimpleFeature next() throws NoSuchElementException {
            if (this.feature != null) {
                SimpleFeature ret = this.feature;
                this.feature = null;
                return ret;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void close() {
            try {
                try {
                    if (this.parser != null) {
                        this.parser.close();
                    }
                }
                finally {
                    if (GeoJSONReader.this.is != null) {
                        GeoJSONReader.this.is.close();
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Unexpected failure closing iterator", e);
            }
            this.parser = null;
        }
    }
}

