/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.expression.geojson;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Date;
import java.util.Map;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.data.geojson.GeoJSONReader;
import org.geotools.filter.expression.PropertyAccessor;
import org.geotools.filter.expression.PropertyAccessorFactory;
import org.geotools.util.factory.Hints;

public class JSONNodePropertyAccessorFactory
implements PropertyAccessorFactory {
    static PropertyAccessor JSONNODEPROPERTY = new JSONNodePropertyAccessor();
    static final String ROOT = "/";

    @Override
    public PropertyAccessor createPropertyAccessor(Class<?> type, String xpath, Class<?> target, Hints hints) {
        if (xpath == null) {
            return null;
        }
        if (!SimpleFeature.class.isAssignableFrom(type) && !SimpleFeatureType.class.isAssignableFrom(type)) {
            return null;
        }
        return JSONNODEPROPERTY;
    }

    static class JSONNodePropertyAccessor
    implements PropertyAccessor {
        private static final String JSON_NODE_DATE_FORMAT_OFF = "JSON_NODE_DATE_FORMAT_OFF";

        JSONNodePropertyAccessor() {
        }

        public boolean canHandle(Object object, String xpath, Class target) {
            try {
                if (xpath != null && object != null && object instanceof SimpleFeature) {
                    SimpleFeature feature = (SimpleFeature)object;
                    String[] parts = this.stripAndReturnHeadAndRest(xpath);
                    Object value = JSONNodePropertyAccessor.getValue(parts, feature);
                    if (value != null && value instanceof JsonNode) {
                        JsonNode node = (JsonNode)value;
                        if (parts.length < 2) {
                            return true;
                        }
                        JsonPointer pointer = JsonPointer.compile((String)parts[1]);
                        JsonNode jsonNode = node.at(pointer);
                        return !jsonNode.isMissingNode();
                    }
                }
            }
            catch (IllegalArgumentException e) {
                return false;
            }
            return false;
        }

        private static Object getValue(String[] parts, SimpleFeature feature) {
            Object value = feature.getAttribute(parts[0]);
            if (value == null) {
                value = JSONNodePropertyAccessor.getValueFromUserData(parts, feature, value);
            }
            return value;
        }

        private static Object getValueFromUserData(String[] parts, SimpleFeature feature, Object value) {
            Map topLevelAttributes = (Map)feature.getUserData().get(GeoJSONReader.TOP_LEVEL_ATTRIBUTES);
            if (topLevelAttributes != null) {
                value = topLevelAttributes.get(parts[0]);
            }
            return value;
        }

        private String[] stripAndReturnHeadAndRest(String xpath) {
            String[] parts = xpath.split(JSONNodePropertyAccessorFactory.ROOT, 2);
            if (parts.length == 2) {
                parts[1] = JSONNodePropertyAccessorFactory.ROOT + parts[1];
            }
            return parts;
        }

        @Override
        public <T> T get(Object object, String xpath, Class<T> target) throws IllegalArgumentException {
            JsonNode jsonNode = null;
            if (xpath != null && object != null && object instanceof SimpleFeature) {
                SimpleFeature feature = (SimpleFeature)object;
                String[] parts = this.stripAndReturnHeadAndRest(xpath);
                Object value = JSONNodePropertyAccessor.getValue(parts, feature);
                if (value != null && value instanceof JsonNode) {
                    JsonNode node = (JsonNode)value;
                    if (parts.length < 2) {
                        return (T)value;
                    }
                    JsonPointer pointer = JsonPointer.compile((String)parts[1]);
                    jsonNode = node.at(pointer);
                    if (jsonNode.isMissingNode()) {
                        throw new IllegalArgumentException("Cannot get property " + xpath + " from " + String.valueOf(object));
                    }
                    return (T)this.getMostPrimitive(jsonNode);
                }
                throw new IllegalArgumentException("Property at " + xpath + " from " + String.valueOf(object) + " is not a JSON Node");
            }
            throw new IllegalArgumentException("Xpath or object is null or not an Attribute");
        }

        private Object getMostPrimitive(JsonNode jsonNode) {
            if (jsonNode.isNull()) {
                return null;
            }
            if (jsonNode.isBoolean()) {
                return jsonNode.booleanValue();
            }
            if (jsonNode.isNumber()) {
                if (jsonNode.isInt()) {
                    return jsonNode.intValue();
                }
                if (jsonNode.isLong()) {
                    return jsonNode.longValue();
                }
                if (jsonNode.isDouble()) {
                    return jsonNode.doubleValue();
                }
                if (jsonNode.isBigDecimal()) {
                    return jsonNode.decimalValue();
                }
                if (jsonNode.isFloatingPointNumber()) {
                    return jsonNode.doubleValue();
                }
                if (jsonNode.isIntegralNumber()) {
                    return jsonNode.longValue();
                }
                if (jsonNode.isBigInteger()) {
                    return jsonNode.bigIntegerValue();
                }
                if (jsonNode.isShort()) {
                    return jsonNode.shortValue();
                }
                if (jsonNode.isFloatingPointNumber()) {
                    return jsonNode.doubleValue();
                }
                if (jsonNode.isIntegralNumber()) {
                    return jsonNode.longValue();
                }
                if (jsonNode.isBigInteger()) {
                    return jsonNode.bigIntegerValue();
                }
                if (jsonNode.isShort()) {
                    return jsonNode.shortValue();
                }
                return jsonNode.numberValue();
            }
            if (jsonNode.isTextual()) {
                if (Boolean.getBoolean(JSON_NODE_DATE_FORMAT_OFF)) {
                    return jsonNode.textValue();
                }
                return this.toDateIfISO(jsonNode.textValue());
            }
            return jsonNode;
        }

        private Object toDateIfISO(String textValue) {
            try {
                TemporalAccessor ta = DateTimeFormatter.ISO_INSTANT.parse(textValue);
                Instant i = Instant.from(ta);
                return Date.from(i);
            }
            catch (Exception e) {
                try {
                    TemporalAccessor ta = DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse(textValue);
                    Instant i = Instant.from(ta);
                    return Date.from(i);
                }
                catch (Exception e2) {
                    return textValue;
                }
            }
        }

        @Override
        public <T> void set(Object object, String xpath, T value, Class<T> target) throws IllegalArgumentException {
            throw new UnsupportedOperationException("Does not support updating.");
        }
    }
}

