/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.raster;

import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderedImageFactory;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.imagen.ImageN;
import org.eclipse.imagen.Interpolation;
import org.eclipse.imagen.InterpolationNearest;
import org.eclipse.imagen.OperationDescriptor;
import org.eclipse.imagen.ParameterBlockImageN;
import org.eclipse.imagen.RenderedOp;
import org.eclipse.imagen.media.contour.ContourDescriptor;
import org.eclipse.imagen.media.contour.ContourRIF;
import org.eclipse.imagen.media.range.NoDataContainer;
import org.eclipse.imagen.media.range.RangeDouble;
import org.eclipse.imagen.media.range.RangeFactory;
import org.geotools.api.coverage.grid.GridEnvelope;
import org.geotools.api.coverage.grid.GridGeometry;
import org.geotools.api.data.Query;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.metadata.spatial.PixelOrientation;
import org.geotools.api.util.InternationalString;
import org.geotools.api.util.ProgressListener;
import org.geotools.coverage.Category;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.image.jai.Registry;
import org.geotools.metadata.i18n.Vocabulary;
import org.geotools.process.ProcessException;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.geotools.process.raster.CoverageUtilities;
import org.geotools.process.raster.RasterProcess;
import org.geotools.util.NumberRange;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.util.AffineTransformation;

@DescribeProcess(title="Contour", description="Computes contour lines at specified intervals or levels for the values in a raster.")
public class ContourProcess
implements RasterProcess {
    private static final int DEFAULT_PADDING = 10;
    private static final InternationalString NO_DATA = Vocabulary.formatInternational((int)147);

    public static SimpleFeatureCollection process(GridCoverage2D gc2d, Integer band, double[] levels, Double interval, Boolean simplify, Boolean smooth, Geometry roi, ProgressListener progressListener) throws ProcessException {
        ContourProcess process = new ContourProcess();
        return process.execute(gc2d, band, levels, interval, simplify, smooth, roi, progressListener);
    }

    @DescribeResult(name="result", description="Contour line features.  Contour level is in value attribute.")
    public SimpleFeatureCollection execute(@DescribeParameter(name="data", description="Input raster") GridCoverage2D gc2d, @DescribeParameter(name="band", description="Band number (zero base) to use for values to be contoured", min=0, max=1) Integer band, @DescribeParameter(name="levels", description="Values of levels at which to generate contours") double[] levels, @DescribeParameter(name="interval", description="Interval between contour values (ignored if levels parameter is supplied)", min=0, minValue=0.0) Double interval, @DescribeParameter(name="simplify", description="Indicates whether contour lines are simplified", min=0) Boolean simplify, @DescribeParameter(name="smooth", description="Indicates whether contour lines are smoothed using Bezier smoothing", min=0) Boolean smooth, @DescribeParameter(name="roi", description="Geometry delineating the region of interest (in raster coordinate system)", min=0) Geometry roi, ProgressListener progressListener) throws ProcessException {
        boolean hasValues;
        if (gc2d == null) {
            throw new ProcessException("Invalid input, source grid coverage should be not null");
        }
        if (band != null && (band < 0 || band >= gc2d.getNumSampleDimensions())) {
            throw new ProcessException("Invalid input, invalid band number:" + band);
        }
        boolean bl = hasValues = levels != null && levels.length != 0;
        if (!hasValues && interval == null) {
            throw new ProcessException("One between interval and values must be valid");
        }
        AffineTransform mt2D = (AffineTransform)gc2d.getGridGeometry().getGridToCRS2D(PixelOrientation.CENTER);
        ArrayList<Double> noDataList = new ArrayList<Double>();
        NoDataContainer noDataProperty = org.geotools.coverage.util.CoverageUtilities.getNoDataProperty((GridCoverage2D)gc2d);
        if (noDataProperty != null) {
            noDataList.add(noDataProperty.getAsSingleValue());
        }
        for (GridSampleDimension gridSampleDimension : gc2d.getSampleDimensions()) {
            double[] sdNoData = gridSampleDimension.getNoDataValues();
            if (sdNoData != null) {
                for (double nodata : sdNoData) {
                    noDataList.add(nodata);
                }
            }
            if (gridSampleDimension.getCategories() == null) continue;
            Object object = gridSampleDimension.getCategories().iterator();
            while (object.hasNext()) {
                NumberRange catRange;
                Category cat = (Category)object.next();
                if (!cat.getName().equals(NO_DATA) || Double.isNaN((catRange = cat.getRange()).getMinimum())) continue;
                if (catRange.getMinimum() == catRange.getMaximum()) {
                    noDataList.add(catRange.getMinimum());
                    continue;
                }
                RangeDouble noData = RangeFactory.create((double)catRange.getMinimum(), (boolean)catRange.isMinIncluded(), (double)catRange.getMaximum(), (boolean)catRange.isMaxIncluded());
                noDataList.add((Double)noData);
            }
        }
        RenderedImage raster = gc2d.getRenderedImage();
        ParameterBlockImageN pb = new ParameterBlockImageN("Contour");
        pb.setSource("source0", (Object)raster);
        if (roi != null) {
            pb.setParameter("roi", (Object)CoverageUtilities.prepareROI(roi, mt2D));
        }
        if (band != null) {
            pb.setParameter("band", (Object)band);
        }
        if (levels != null && levels.length > 0) {
            ArrayList<Double> elements = new ArrayList<Double>(levels.length);
            for (double level : levels) {
                elements.add(level);
            }
            pb.setParameter("levels", elements);
        } else {
            pb.setParameter("interval", (Object)interval);
        }
        if (simplify != null) {
            pb.setParameter("simplify", (Object)simplify);
        }
        if (smooth != null) {
            pb.setParameter("smooth", (Object)smooth);
        }
        if (!noDataList.isEmpty()) {
            pb.setParameter("nodata", noDataList);
        }
        RenderedOp dest = ImageN.create((String)"Contour", (ParameterBlock)pb);
        Collection collection = (Collection)dest.getProperty("contours");
        SimpleFeatureType schema = CoverageUtilities.createFeatureType(gc2d, LineString.class);
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(schema);
        int i = 0;
        ListFeatureCollection featureCollection = new ListFeatureCollection(schema);
        AffineTransformation jtsTransformation = new AffineTransformation(mt2D.getScaleX(), mt2D.getShearX(), mt2D.getTranslateX(), mt2D.getShearY(), mt2D.getScaleY(), mt2D.getTranslateY());
        for (LineString line : collection) {
            if (!line.isValid()) continue;
            Double value = (Double)line.getUserData();
            line.setUserData(null);
            line.apply((CoordinateSequenceFilter)jtsTransformation);
            builder.set("the_geom", (Object)line);
            builder.set("value", (Object)value);
            featureCollection.add(builder.buildFeature(String.valueOf(i++)));
        }
        return featureCollection;
    }

    public GridGeometry invertGridGeometry(Query targetQuery, GridGeometry gg) {
        Interpolation interpolation;
        if (!(gg instanceof GridGeometry2D)) {
            return gg;
        }
        Object interpolationKeyValue = targetQuery.getHints().get((Object)ImageN.KEY_INTERPOLATION);
        if (interpolationKeyValue instanceof Interpolation && !((interpolation = (Interpolation)interpolationKeyValue) instanceof InterpolationNearest)) {
            return gg;
        }
        GridGeometry2D gg2d = (GridGeometry2D)gg;
        GridEnvelope2D gridRange = gg2d.getGridRange2D();
        GridEnvelope2D newGridRange = new GridEnvelope2D();
        newGridRange.setBounds(gridRange.x - 10, gridRange.y - 10, gridRange.width + 20, gridRange.height + 20);
        return new GridGeometry2D((GridEnvelope)newGridRange, gg.getGridToCRS(), gg2d.getCoordinateReferenceSystem());
    }

    static {
        Registry.registerRIF((ImageN)ImageN.getDefaultInstance(), (OperationDescriptor)new ContourDescriptor(), (RenderedImageFactory)new ContourRIF(), (String)"org.jaitools.media.jai");
    }
}

