/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.raster;

import java.io.IOException;
import org.eclipse.imagen.KernelImageN;
import org.eclipse.imagen.media.kernel.KernelFactory;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.processing.CoverageProcessor;
import org.geotools.process.ProcessException;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.geotools.process.raster.RasterProcess;

@DescribeProcess(title="Convolve Coverage", description="Returns a convoluted version of a given raster")
public class ConvolveCoverageProcess
implements RasterProcess {
    private final CoverageProcessor PROCESSOR = new CoverageProcessor();

    @DescribeResult(name="result", description="Convoluted raster")
    public GridCoverage2D execute(@DescribeParameter(name="data", description="Input raster") GridCoverage2D coverage, @DescribeParameter(name="kernel", description="Convolution kernel", min=0) KernelImageN kernel, @DescribeParameter(name="kernelRadius", description="Radius for a circular kernel", min=0) Integer kernelRadius, @DescribeParameter(name="kernelWidth", description="Width for rectangular kernel", min=0) Integer kernelWidth, @DescribeParameter(name="kernelHeight", description="Height for rectangular kernel", min=0) Integer kernelHeight) throws IOException {
        ParameterValueGroup param = this.PROCESSOR.getOperation("Convolve").getParameters();
        param.parameter("Source").setValue((Object)coverage);
        if (kernel == null) {
            if (kernelRadius != null && kernelRadius > 0) {
                kernel = KernelFactory.createCircle((int)kernelRadius);
            } else if (kernelWidth != null) {
                if (kernelHeight == null) {
                    kernelHeight = kernelWidth;
                }
                kernel = KernelFactory.createRectangle((int)kernelWidth, (int)kernelHeight);
            }
        }
        if (kernel == null) {
            throw new ProcessException("No kernel argument specified");
        }
        param.parameter("kernel").setValue((Object)kernel);
        return (GridCoverage2D)this.PROCESSOR.doOperation(param);
    }
}

