/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.raster;

import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.imagen.media.bandselect.BandSelectDescriptor;
import org.eclipse.imagen.media.classbreaks.ClassBreaksRIF;
import org.eclipse.imagen.media.classbreaks.Classification;
import org.eclipse.imagen.media.classbreaks.ClassificationMethod;
import org.eclipse.imagen.media.range.Range;
import org.eclipse.imagen.media.range.RangeFactory;
import org.eclipse.imagen.media.stats.Statistics;
import org.eclipse.imagen.media.zonal.ZonalStatsDescriptor;
import org.eclipse.imagen.media.zonal.ZoneGeometry;
import org.geotools.api.util.ProgressListener;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.process.ProcessException;
import org.geotools.process.classify.ClassificationStats;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.geotools.process.raster.RasterProcess;

@DescribeProcess(title="coverageClassStats", description="Calculates statistics from coverage values classified into bins/classes.")
public class CoverageClassStats
implements RasterProcess {
    private GridCoverage2D coverage;
    private List<Statistics.StatsType> stats;
    private Integer band;
    private Integer classes;
    private org.geotools.process.classify.ClassificationMethod method;
    private Double noData;
    private ProgressListener progressListener;

    @DescribeResult(name="results", description="The classified results")
    public Results execute(@DescribeParameter(name="coverage", description="The coverage to analyze") GridCoverage2D coverage, @DescribeParameter(name="stats", description="The statistics to calculate for each class", collectionType=Statistics.StatsType.class, min=0) List<Statistics.StatsType> stats, @DescribeParameter(name="band", description="The band to calculate breaks/statistics for", min=0) Integer band, @DescribeParameter(name="classes", description="The number of breaks/classes", min=0) Integer classes, @DescribeParameter(name="method", description="The classification method", min=0) org.geotools.process.classify.ClassificationMethod method, @DescribeParameter(name="noData", description="The pixel value to be ommitted from any calculation", min=0) Double noData, ProgressListener progressListener) throws ProcessException, IOException {
        this.coverage = coverage;
        this.stats = stats;
        this.band = band;
        this.classes = classes;
        this.method = method;
        this.noData = noData;
        this.progressListener = progressListener;
        if (coverage == null) {
            throw new ProcessException(MessageFormat.format("Argument \"{0}\" should not be null.", "coverage"));
        }
        if (classes == null) {
            classes = 10;
        }
        if (classes < 1) {
            throw new ProcessException(MessageFormat.format("Illegal argument: \"{0}={1}\".", "classes", classes));
        }
        RenderedImage sourceImage = coverage.getRenderedImage();
        if (band == null) {
            band = 0;
        }
        int numBands = sourceImage.getSampleModel().getNumBands();
        if (band < 0 || band >= numBands) {
            throw new ProcessException(MessageFormat.format("Illegal argument: \"{0}={1}\".", "band", band));
        }
        if (numBands > 1) {
            sourceImage = BandSelectDescriptor.create((RenderedImage)sourceImage, (int[])new int[]{band}, null);
        }
        if (method == null) {
            method = org.geotools.process.classify.ClassificationMethod.EQUAL_INTERVAL;
        }
        if (stats == null || stats.isEmpty()) {
            stats = Collections.singletonList(Statistics.StatsType.MEAN);
        }
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(sourceImage);
        pb.set(classes, 0);
        pb.set(this.toJAIExtMethod(method), 1);
        pb.set(null, 2);
        pb.set(null, 3);
        pb.set(new Integer[]{0}, 4);
        pb.set(1, 5);
        pb.set(1, 6);
        pb.set(noData, 7);
        RenderedImage op = new ClassBreaksRIF().create(pb, null);
        Classification c = (Classification)op.getProperty("Classification");
        Double[] breaks = (Double[])c.getBreaks()[0];
        ArrayList<Range> ranges = new ArrayList<Range>();
        for (int i = 0; i < breaks.length - 1; ++i) {
            ranges.add(CoverageClassStats.createRange(breaks, i, sourceImage.getSampleModel().getDataType()));
        }
        op = ZonalStatsDescriptor.create((RenderedImage)sourceImage, null, null, null, null, null, (boolean)false, (int[])new int[]{band}, (Statistics.StatsType[])((Statistics.StatsType[])stats.toArray(Statistics.StatsType[]::new)), null, null, null, ranges, (boolean)true, null);
        List zonalStats = (List)op.getProperty("ImageN-EXT.zonalstats");
        if (zonalStats == null || zonalStats.isEmpty()) {
            throw new ProcessException("No zonal statistics were calculated, check the input coverage and ranges.");
        }
        if (zonalStats.size() != 1) {
            throw new ProcessException("Multiple zonal statistics were calculated, expected only one zone.");
        }
        return new Results(stats, (ZoneGeometry)zonalStats.get(0), ranges);
    }

    private static Range createRange(Double[] breaks, int i, int dataType) {
        switch (dataType) {
            case 0: {
                return RangeFactory.create((byte)breaks[i].byteValue(), (boolean)true, (byte)breaks[i + 1].byteValue(), (i == breaks.length - 2 ? 1 : 0) != 0);
            }
            case 2: {
                return RangeFactory.create((short)breaks[i].shortValue(), (boolean)true, (short)breaks[i + 1].shortValue(), (i == breaks.length - 2 ? 1 : 0) != 0);
            }
            case 3: {
                return RangeFactory.create((int)breaks[i].intValue(), (boolean)true, (int)breaks[i + 1].intValue(), (i == breaks.length - 2 ? 1 : 0) != 0);
            }
            case 4: {
                return RangeFactory.create((float)breaks[i].floatValue(), (boolean)true, (float)breaks[i + 1].floatValue(), (i == breaks.length - 2 ? 1 : 0) != 0);
            }
            case 5: {
                return RangeFactory.create((double)breaks[i], (boolean)true, (double)breaks[i + 1], (i == breaks.length - 2 ? 1 : 0) != 0);
            }
        }
        throw new ProcessException(MessageFormat.format("Illegal argument: \"{0}={1}\".", "dataType", dataType));
    }

    private ClassificationMethod toJAIExtMethod(org.geotools.process.classify.ClassificationMethod method) {
        if (method == null) {
            return null;
        }
        return ClassificationMethod.valueOf((String)method.name());
    }

    public static class Results
    implements ClassificationStats {
        List<Statistics.StatsType> stats;
        ZoneGeometry zonalStats;
        List<Range> ranges;

        public Results(List<Statistics.StatsType> stats, ZoneGeometry zonalStats, List<Range> ranges) {
            this.stats = stats;
            this.zonalStats = zonalStats;
            this.ranges = ranges;
        }

        @Override
        public int size() {
            return this.ranges.size();
        }

        @Override
        public Set<Statistics.StatsType> getStats() {
            return new LinkedHashSet<Statistics.StatsType>(this.stats);
        }

        @Override
        public Range range(int i) {
            return this.ranges.get(i);
        }

        @Override
        public Double value(int i, Statistics.StatsType stat) {
            int statIdx = this.stats.indexOf(stat);
            if (statIdx == -1) {
                throw new IllegalArgumentException(MessageFormat.format("Illegal argument: \"{0}={1}\".", "stat", stat));
            }
            Map rangeMap = (Map)this.zonalStats.getStatsPerBand(0).get(0);
            Statistics[] zonalStats = (Statistics[])rangeMap.get(this.range(i));
            return ((Number)zonalStats[statIdx].getResult()).doubleValue();
        }

        @Override
        public Long count(int i) {
            Map rangeMap = (Map)this.zonalStats.getStatsPerBand(0).get(0);
            Statistics[] zonalStats = (Statistics[])rangeMap.get(this.range(i));
            return zonalStats[0].getNumSamples();
        }

        ZoneGeometry getZonalStats() {
            return this.zonalStats;
        }
    }
}

