/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.raster;

import java.awt.image.RenderedImage;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.imagen.ROI;
import org.eclipse.imagen.RenderedOp;
import org.eclipse.imagen.media.range.NoDataContainer;
import org.eclipse.imagen.media.range.Range;
import org.eclipse.imagen.media.rlookup.RangeLookupTable;
import org.geotools.api.coverage.grid.GridCoverage;
import org.geotools.api.util.ProgressListener;
import org.geotools.coverage.Category;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.image.ImageWorker;
import org.geotools.image.util.ColorUtilities;
import org.geotools.process.ProcessException;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.geotools.process.raster.CoverageUtilities;
import org.geotools.process.raster.RasterProcess;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;

@DescribeProcess(title="Reclassify", description="Reclassifies a continuous raster into integer values defined by a set of ranges")
public class RangeLookupProcess
implements RasterProcess {
    private static final double DEFAULT_NODATA = 0.0;

    @DescribeResult(name="reclassified", description="The reclassified raster")
    public GridCoverage2D execute(@DescribeParameter(name="coverage", description="Input raster") GridCoverage2D coverage, @DescribeParameter(name="band", description="Source band to use for classification (default is 0)", min=0, defaultValue="0") Integer classificationBand, @DescribeParameter(name="ranges", description="Specifier for a value range in the format ( START ; END ).  START and END values are optional. [ and ] can also be used as brackets, to indicate inclusion of the relevant range endpoint.", collectionType=Range.class) List<Range> classificationRanges, @DescribeParameter(name="outputPixelValues", description="Value to be assigned to corresponding range", min=0) int[] outputPixelValues, @DescribeParameter(name="noData", description="Value to be assigned to pixels outside any range (defaults to 0)", min=0, defaultValue="0") Double noData, ProgressListener listener) throws ProcessException {
        int ranges;
        if (coverage == null) {
            throw new ProcessException(MessageFormat.format("Argument \"{0}\" should not be null.", "coverage"));
        }
        if (classificationRanges == null) {
            throw new ProcessException(MessageFormat.format("Argument \"{0}\" should not be null.", "classificationRanges"));
        }
        double nd = 0.0;
        NoDataContainer noDataProperty = org.geotools.coverage.util.CoverageUtilities.getNoDataProperty((GridCoverage2D)coverage);
        if (noData != null) {
            nd = noData;
        } else if (noDataProperty != null) {
            nd = noDataProperty.getAsSingleValue();
        }
        if (outputPixelValues != null && outputPixelValues.length > 0 && (ranges = classificationRanges.size()) != outputPixelValues.length) {
            throw new ProcessException(MessageFormat.format("Mismatched array length.", "outputPixelValues"));
        }
        RenderedImage sourceImage = coverage.getRenderedImage();
        ImageWorker worker = new ImageWorker(sourceImage);
        if (classificationBand != null) {
            int band = classificationBand;
            int numbands = sourceImage.getSampleModel().getNumBands();
            if (band < 0 || numbands <= band) {
                throw new ProcessException(MessageFormat.format("Illegal argument: \"{0}={1}\".", "band", band));
            }
            if (band == 0 && numbands > 0 || band > 0) {
                worker.retainBands(new int[]{band});
            }
        }
        int size = classificationRanges.size();
        int transferType = ColorUtilities.getTransferType((int)size);
        RangeLookupTable lookupTable = CoverageUtilities.getRangeLookupTable(classificationRanges, outputPixelValues, (Number)nd, transferType);
        worker.setROI(org.geotools.coverage.util.CoverageUtilities.getROIProperty((GridCoverage2D)coverage));
        worker.setBackground(new double[]{nd});
        RenderedOp indexedClassification = worker.rangeLookup((Object)lookupTable).getRenderedOperation();
        GridSampleDimension outSampleDimension = new GridSampleDimension((CharSequence)"classification", new Category[]{Category.NODATA}, null);
        GridCoverageFactory factory = CoverageFactoryFinder.getGridCoverageFactory((Hints)GeoTools.getDefaultHints());
        HashMap<String, NoDataContainer> properties = new HashMap<String, NoDataContainer>(Map.of("GC_NODATA", new NoDataContainer(0.0)));
        org.geotools.coverage.util.CoverageUtilities.setROIProperty(properties, (ROI)worker.getROI());
        GridCoverage2D output = factory.create((CharSequence)"reclassified", (RenderedImage)indexedClassification, coverage.getGridGeometry(), new GridSampleDimension[]{outSampleDimension}, new GridCoverage[]{coverage}, properties);
        return output;
    }

    public GridCoverage2D execute(GridCoverage2D coverage, Integer classificationBand, List<Range> classificationRanges, ProgressListener listener) throws ProcessException {
        return this.execute(coverage, classificationBand, classificationRanges, null, 0.0, listener);
    }
}

