/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.raster;

import java.awt.image.RenderedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.eclipse.imagen.ROI;
import org.eclipse.imagen.RenderedOp;
import org.eclipse.imagen.media.range.Range;
import org.eclipse.imagen.media.range.RangeDouble;
import org.eclipse.imagen.media.stats.Statistics;
import org.eclipse.imagen.media.zonal.ZonalStatsDescriptor;
import org.eclipse.imagen.media.zonal.ZoneGeometry;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.processing.CoverageProcessor;
import org.geotools.coverage.processing.operation.GridCoverage2DRIA;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.collection.DecoratingSimpleFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.process.ProcessException;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.geotools.process.raster.CoverageUtilities;
import org.geotools.process.raster.RasterProcess;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;

@DescribeProcess(title="Raster Zonal Statistics", description="Computes statistics for the distribution of a certain quantity in a set of polygonal zones.")
public class RasterZonalStatistics
implements RasterProcess {
    private static final CoverageProcessor PROCESSOR = CoverageProcessor.getInstance();

    @DescribeResult(name="statistics", description="A feature collection with the attributes of the zone layer (prefixed by 'z_') and the statistics fields count,min,max,sum,avg,stddev")
    public SimpleFeatureCollection execute(@DescribeParameter(name="data", description="Input raster to compute statistics for") GridCoverage2D coverage, @DescribeParameter(name="band", description="Source band used to compute statistics (default is 0)", min=0, defaultValue="0") Integer band, @DescribeParameter(name="zones", description="Zone polygon features for which to compute statistics") SimpleFeatureCollection zones, @DescribeParameter(name="classification", description="Raster whose values will be used as classes for the statistical analysis. Each zone reports statistics partitioned by classes according to the values of the raster. Must be a single band raster with integer values.", min=0) GridCoverage2D classification) {
        int iband = 0;
        if (band != null) {
            iband = band;
        }
        return new RasterZonalStatisticsCollection(coverage, iband, zones, classification);
    }

    static class RasterZonalStatisticsCollection
    extends DecoratingSimpleFeatureCollection {
        GridCoverage2D coverage;
        SimpleFeatureType targetSchema;
        int band;
        GridCoverage2D classification;

        public RasterZonalStatisticsCollection(GridCoverage2D coverage, int band, SimpleFeatureCollection zones, GridCoverage2D classification) {
            super(zones);
            this.coverage = coverage;
            this.band = band;
            this.classification = classification;
            SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
            for (AttributeDescriptor att : ((SimpleFeatureType)zones.getSchema()).getAttributeDescriptors()) {
                tb.minOccurs(att.getMinOccurs());
                tb.maxOccurs(att.getMaxOccurs());
                tb.restrictions(att.getType().getRestrictions());
                if (att instanceof GeometryDescriptor) {
                    GeometryDescriptor gatt = (GeometryDescriptor)att;
                    tb.crs(gatt.getCoordinateReferenceSystem());
                }
                tb.add("z_" + att.getLocalName(), att.getType().getBinding());
            }
            if (classification != null) {
                tb.add("classification", Integer.class);
            }
            tb.add("count", Long.class);
            tb.add("min", Double.class);
            tb.add("max", Double.class);
            tb.add("sum", Double.class);
            tb.add("avg", Double.class);
            tb.add("stddev", Double.class);
            tb.setName(((SimpleFeatureType)zones.getSchema()).getName());
            this.targetSchema = tb.buildFeatureType();
        }

        @Override
        public SimpleFeatureType getSchema() {
            return this.targetSchema;
        }

        @Override
        public SimpleFeatureIterator features() {
            return new RasterZonalStatisticsIterator(this.delegate.features(), this.coverage, this.band, this.targetSchema, this.classification);
        }
    }

    static class RasterZonalStatisticsIterator
    implements SimpleFeatureIterator {
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        SimpleFeatureIterator zones;
        SimpleFeatureBuilder builder;
        GridCoverage2D dataCoverage;
        int band;
        RenderedImage classificationRaster;
        List<SimpleFeature> features = new ArrayList<SimpleFeature>();

        public RasterZonalStatisticsIterator(SimpleFeatureIterator zones, GridCoverage2D coverage, int band, SimpleFeatureType targetSchema, GridCoverage2D classification) {
            this.zones = zones;
            this.builder = new SimpleFeatureBuilder(targetSchema);
            this.dataCoverage = coverage;
            this.band = band;
            if (classification != null) {
                double[] dArray;
                GridSampleDimension sampleDimension = classification.getSampleDimension(0);
                double[] nodataarr = sampleDimension.getNoDataValues();
                if (nodataarr != null) {
                    dArray = nodataarr;
                } else {
                    double[] dArray2 = new double[1];
                    dArray = dArray2;
                    dArray2[0] = Double.NaN;
                }
                double[] nodata = dArray;
                this.classificationRaster = GridCoverage2DRIA.create((GridCoverage2D)classification, (GridCoverage2D)this.dataCoverage, (double[])nodata);
            }
        }

        @Override
        public void close() {
            this.zones.close();
        }

        @Override
        public boolean hasNext() {
            return !this.features.isEmpty() || this.zones.hasNext();
        }

        @Override
        public SimpleFeature next() throws NoSuchElementException {
            if (this.features.isEmpty()) {
                SimpleFeature zone = (SimpleFeature)this.zones.next();
                try {
                    List<ZoneGeometry> zoneGeometries;
                    Geometry zoneGeom = (Geometry)zone.getDefaultGeometry();
                    CoordinateReferenceSystem dataCrs = this.dataCoverage.getCoordinateReferenceSystem();
                    CoordinateReferenceSystem zonesCrs = this.builder.getFeatureType().getGeometryDescriptor().getCoordinateReferenceSystem();
                    if (!CRS.equalsIgnoreMetadata((Object)zonesCrs, (Object)dataCrs)) {
                        zoneGeom = JTS.transform(zoneGeom, CRS.findMathTransform((CoordinateReferenceSystem)zonesCrs, (CoordinateReferenceSystem)dataCrs, (boolean)true));
                    }
                    if ((zoneGeometries = this.processStatistics(zoneGeom)) != null && !zoneGeometries.isEmpty()) {
                        ZoneGeometry zg = zoneGeometries.get(0);
                        if (this.classificationRaster != null) {
                            Map statsPerBand = zg.getStatsPerBand(this.band);
                            statsPerBand.entrySet().forEach(entry -> {
                                Integer classValue = (Integer)entry.getKey();
                                Map statsMap = (Map)entry.getValue();
                                Statistics[] stats = (Statistics[])statsMap.values().iterator().next();
                                this.builder.addAll(zone.getAttributes());
                                this.builder.add(classValue);
                                if (stats != null) {
                                    this.addStatsToFeature(stats);
                                }
                                this.features.add(this.builder.buildFeature(zone.getID()));
                            });
                        } else {
                            Statistics[] stats = (Statistics[])((Map)zg.getStatsPerBand(0).values().iterator().next()).values().iterator().next();
                            this.builder.addAll(zone.getAttributes());
                            this.addStatsToFeature(stats);
                            this.features.add(this.builder.buildFeature(zone.getID()));
                        }
                    } else {
                        this.builder.addAll(zone.getAttributes());
                        this.features.add(this.builder.buildFeature(zone.getID()));
                    }
                }
                catch (Exception e) {
                    throw new ProcessException("Failed to compute statistics on feature " + String.valueOf(zone), e);
                }
            }
            SimpleFeature f = this.features.remove(0);
            return f;
        }

        void addStatsToFeature(Statistics[] stats) {
            double[] minMax = (double[])stats[0].getResult();
            double count = stats[0].getNumSamples().doubleValue();
            double avg = ((Number)stats[1].getResult()).doubleValue();
            double stdDev = ((Number)stats[2].getResult()).doubleValue();
            double sum = ((Number)stats[3].getResult()).doubleValue();
            this.builder.add(count);
            this.builder.add(minMax[0]);
            this.builder.add(minMax[1]);
            this.builder.add(sum);
            this.builder.add(avg);
            this.builder.add(stdDev);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<ZoneGeometry> processStatistics(Geometry geometry) throws TransformException {
            GridCoverage2D cropped = null;
            try {
                List<RangeDouble> noDataValueRangeList;
                ReferencedEnvelope coverageEnvelope = new ReferencedEnvelope(this.dataCoverage.getEnvelope2D());
                ReferencedEnvelope geometryEnvelope = new ReferencedEnvelope(geometry.getEnvelopeInternal(), this.dataCoverage.getCoordinateReferenceSystem());
                if (!coverageEnvelope.intersects(geometryEnvelope)) {
                    List<ZoneGeometry> list = null;
                    return list;
                }
                if (!coverageEnvelope.contains(geometryEnvelope)) {
                    geometry = JTS.toGeometry((Envelope)coverageEnvelope).intersection(geometry);
                    geometryEnvelope = new ReferencedEnvelope(geometry.getEnvelopeInternal(), this.dataCoverage.getCoordinateReferenceSystem());
                }
                RangeDouble noData = (noDataValueRangeList = CoverageUtilities.getNoDataAsList(this.dataCoverage)) == null || noDataValueRangeList.isEmpty() ? null : noDataValueRangeList.get(0);
                cropped = CoverageUtilities.crop(this.dataCoverage, geometryEnvelope);
                ROI roi = CoverageUtilities.getSimplifiedRoiGeometry(this.dataCoverage, geometry);
                Statistics.StatsType[] reqStatsTypes = new Statistics.StatsType[]{Statistics.StatsType.EXTREMA, Statistics.StatsType.MEAN, Statistics.StatsType.DEV_STD, Statistics.StatsType.SUM};
                RenderedOp op = ZonalStatsDescriptor.create((RenderedImage)cropped.getRenderedImage(), (RenderedImage)this.classificationRaster, null, Arrays.asList(roi), (Range)noData, null, (boolean)false, (int[])new int[]{this.band}, (Statistics.StatsType[])reqStatsTypes, null, (boolean)false, null);
                List list = (List)op.getProperty("ImageN-EXT.zonalstats");
                return list;
            }
            finally {
                if (cropped != null) {
                    cropped.dispose(true);
                }
            }
        }
    }
}

