/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.raster;

import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.util.List;
import org.eclipse.imagen.ImageN;
import org.eclipse.imagen.media.nullop.NullDescriptor;
import org.eclipse.imagen.media.range.Range;
import org.eclipse.imagen.media.stats.Statistics;
import org.eclipse.imagen.media.util.SunTileCache;
import org.eclipse.imagen.media.zonal.ZoneGeometry;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.processing.CoverageProcessor;
import org.geotools.coverage.processing.operation.GridCoverage2DRIA;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.geotools.process.raster.RasterProcess;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;

@DescribeProcess(title="Raster Zonal Statistics", description="Computes statistics for the distribution of a certain quantity in a set of polygonal zones.")
public class RasterZonalStatistics2
implements RasterProcess {
    private static final CoverageProcessor PROCESSOR = CoverageProcessor.getInstance();
    private static final Statistics.StatsType[] DEFAULT_STATISTICS = new Statistics.StatsType[]{Statistics.StatsType.MEAN, Statistics.StatsType.MAX, Statistics.StatsType.MIN, Statistics.StatsType.EXTREMA, Statistics.StatsType.VARIANCE, Statistics.StatsType.DEV_STD};

    @DescribeResult(name="zonal statistics", description="A feature collection with the attributes of the zone layer (prefixed by 'z_') and the statistics fields min,max,sum,avg,stddev")
    public List<ZoneGeometry> execute(@DescribeParameter(name="source", description="Input raster to compute statistics for") GridCoverage2D coverage, @DescribeParameter(name="bands", description="Source band used to compute statistics (default is 0)") int[] bands, @DescribeParameter(name="zones", description="Zone polygon features for which to compute statistics") List<SimpleFeature> zones, @DescribeParameter(name="classifier", description="Raster whose values will be used as classes for the statistical analysis. Each zone reports statistics partitioned by classes according to the values of the raster. Must be a single band raster with integer values.", min=0) GridCoverage2D classifier, @DescribeParameter(name="nodata", description="Input Range for NoData") Range nodata, @DescribeParameter(name="mask", description="Optional mask for the statistic calculations") Geometry mask, @DescribeParameter(name="useROIAccessor", description="Boolean indicating if a RasterAccessor associated to the Mask should be used for calculating statistics. (Only with Mask field present)", defaultValue="false") boolean useROIAccessor, @DescribeParameter(name="roi", description="Optional roi object, if the zones parameter is not used") Polygon roi, @DescribeParameter(name="statistics", description="Statistics to calculate (default are min,max,sum,avg,stddev)") Statistics.StatsType[] stats, @DescribeParameter(name="minbounds", description="Minimum bounds used for calculating Histogram, median and mode operations (for each band)") double[] minbounds, @DescribeParameter(name="maxbounds", description="Maximum bounds used for calculating Histogram, median and mode operations (for each band)") double[] maxbounds, @DescribeParameter(name="numbins", description="Number of Bins used for calculating Histogram, median and mode operations (for each band)") int[] numbins, @DescribeParameter(name="rangeData", description="Maximum bounds used for calculating Histogram, median and mode operations (for each band)") List<Range> rangeData, @DescribeParameter(name="localStats", description="Number of Bins used for calculating Histogram, median and mode operations (for each band)") boolean localStats) {
        int[] ibands = new int[]{0};
        if (bands == null) {
            bands = ibands;
        }
        if (stats == null) {
            stats = DEFAULT_STATISTICS;
        }
        GridCoverage2DRIA classificationRaster = null;
        if (classifier != null) {
            double[] dArray;
            GridSampleDimension sampleDimension = classifier.getSampleDimension(0);
            double[] nodataarr = sampleDimension.getNoDataValues();
            if (nodataarr != null) {
                dArray = nodataarr;
            } else {
                double[] dArray2 = new double[1];
                dArray = dArray2;
                dArray2[0] = Double.NaN;
            }
            double[] noDataClassifier = dArray;
            classificationRaster = GridCoverage2DRIA.create((GridCoverage2D)classifier, (GridCoverage2D)coverage, (double[])noDataClassifier);
            RenderingHints hints = new RenderingHints(ImageN.KEY_TILE_CACHE, new SunTileCache());
            classificationRaster = NullDescriptor.create((RenderedImage)classificationRaster, (RenderingHints)hints);
        }
        ParameterValueGroup param = PROCESSOR.getOperation("Zonal").getParameters();
        param.parameter("Source").setValue((Object)coverage);
        param.parameter("bands").setValue((Object)bands);
        param.parameter("classifier").setValue((Object)classificationRaster);
        param.parameter("roi").setValue((Object)roi);
        param.parameter("roilist").setValue(zones);
        param.parameter("NoData").setValue((Object)nodata);
        param.parameter("mask").setValue((Object)mask);
        param.parameter("useROIAccessor").setValue(useROIAccessor);
        param.parameter("stats").setValue((Object)stats);
        param.parameter("minbound").setValue((Object)minbounds);
        param.parameter("maxbound").setValue((Object)maxbounds);
        param.parameter("numbin").setValue((Object)numbins);
        param.parameter("rangeData").setValue(rangeData);
        param.parameter("localstats").setValue(localStats);
        GridCoverage2D output = (GridCoverage2D)PROCESSOR.doOperation(param);
        List value = (List)output.getProperty("ImageN-EXT.zonalstats");
        return value;
    }
}

