/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.raster;

import java.io.IOException;
import org.eclipse.imagen.Interpolation;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.processing.CoverageProcessor;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.geotools.process.raster.RasterProcess;

@DescribeProcess(title="Scale Coverage", description="Returns a scaled and translated version of a given raster")
public class ScaleCoverage
implements RasterProcess {
    private static final CoverageProcessor PROCESSOR = CoverageProcessor.getInstance();

    @DescribeResult(name="result", description="Scaled raster")
    public GridCoverage2D execute(@DescribeParameter(name="coverage", description="Input raster") GridCoverage2D coverage, @DescribeParameter(name="xScale", description="Scale factor along the x axis") double xScale, @DescribeParameter(name="yScale", description="Scale factor along the y axis") double yScale, @DescribeParameter(name="xTranslate", description="Offset along the x axis") double xTranslate, @DescribeParameter(name="yTranslate", description="Offset along the y axis") double yTranslate, @DescribeParameter(name="interpolation", description="Interpolation function to use.  Values are NEAREST, BILINEAR, BICUBIC2, BICUBIC", min=0) Interpolation interpolation) throws IOException {
        ParameterValueGroup param = PROCESSOR.getOperation("Scale").getParameters();
        param.parameter("Source").setValue((Object)coverage);
        param.parameter("xScale").setValue(xScale);
        param.parameter("yScale").setValue(yScale);
        param.parameter("xTrans").setValue((Object)Float.valueOf(0.0f));
        param.parameter("yTrans").setValue((Object)Float.valueOf(0.0f));
        if (interpolation != null) {
            param.parameter("Interpolation").setValue((Object)interpolation);
        }
        return (GridCoverage2D)PROCESSOR.doOperation(param);
    }
}

