/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.raster;

import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.text.MessageFormat;
import org.eclipse.imagen.media.range.Range;
import org.geotools.api.parameter.ParameterValueGroup;
import org.geotools.api.util.ProgressListener;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.processing.CoverageProcessor;
import org.geotools.image.ImageWorker;
import org.geotools.image.util.ImageUtilities;
import org.geotools.process.ProcessException;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.geotools.process.raster.RasterProcess;

@DescribeProcess(title="TransparencyFill", description="Fill transparent pixels")
public class TransparencyFillProcess
implements RasterProcess {
    private static final CoverageProcessor PROCESSOR = CoverageProcessor.getInstance();

    @DescribeResult(name="result", description="The processed coverage")
    public GridCoverage2D execute(@DescribeParameter(name="data", description="Input coverage") GridCoverage2D coverage, @DescribeParameter(name="width", description="Width inside which searching for nearest pixel value", min=0, max=1) Integer width, ProgressListener listener) throws ProcessException {
        if (coverage == null) {
            throw new ProcessException(MessageFormat.format("Argument \"{0}\" should not be null.", "coverage"));
        }
        RenderedImage ri = coverage.getRenderedImage();
        boolean hasTransparency = false;
        Number noData = 0;
        if (ri.getColorModel().hasAlpha()) {
            hasTransparency = true;
        } else {
            Range noDataRange = new ImageWorker().extractNoDataProperty(ri);
            if (noDataRange != null) {
                noData = noDataRange.getMin();
                hasTransparency = true;
            }
        }
        if (!hasTransparency) {
            return coverage;
        }
        int numBands = ri.getSampleModel().getNumBands();
        RenderingHints renderingHints = null;
        if (numBands == 4 || numBands == 2) {
            renderingHints = ImageUtilities.getRenderingHints((RenderedImage)ri);
            ImageWorker worker = new ImageWorker(ri);
            worker.setRenderingHints(renderingHints);
            double[] mins = worker.getMinimums();
            boolean bl = hasTransparency = mins[mins.length - 1] != 255.0;
        }
        if (!hasTransparency) {
            return coverage;
        }
        ParameterValueGroup param = PROCESSOR.getOperation("TransparencyFill").getParameters();
        param.parameter("source").setValue((Object)coverage);
        param.parameter("noData").setValue((Object)noData);
        param.parameter("width").setValue((Object)width);
        return (GridCoverage2D)PROCESSOR.doOperation(param);
    }
}

