/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.processing.jai;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import java.util.Vector;
import org.eclipse.imagen.AreaOpImage;
import org.eclipse.imagen.BorderExtender;
import org.eclipse.imagen.ImageLayout;
import org.eclipse.imagen.RasterAccessor;
import org.eclipse.imagen.RasterFormatTag;
import org.geotools.processing.jai.TransparencyFillDescriptor;

public class TransparencyFillOpImage
extends AreaOpImage {
    private TransparencyFillDescriptor.FillType type = TransparencyFillDescriptor.FILL_AVERAGE;
    private Number noData = 0;
    private Integer width = 1;
    private TransparencyFillAlgorithm fillAlgorithm = null;

    public TransparencyFillOpImage(RenderedImage source, BorderExtender extender, TransparencyFillDescriptor.FillType type, Map config, ImageLayout layout, Number noData, Integer width) {
        super(source, layout, config, true, extender, 1, 1, 1, 1);
        if (type == null) {
            type = TransparencyFillDescriptor.FILL_AVERAGE;
        }
        this.type = type;
        switch (this.type.getValue()) {
            case 0: {
                this.fillAlgorithm = TransparencyFillAlgorithm.FILL_AVERAGE;
                break;
            }
            case 1: {
                this.fillAlgorithm = TransparencyFillAlgorithm.FILL_CLONE_FIRST;
                break;
            }
            case 2: {
                this.fillAlgorithm = TransparencyFillAlgorithm.FILL_CLONE_SECOND;
            }
        }
        if (noData != null) {
            this.noData = noData;
        }
        if (width != null) {
            this.width = width;
        }
    }

    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        RasterFormatTag[] formatTags = this.getFormatTags();
        Raster source = sources[0];
        Rectangle srcRect = this.mapDestRect(destRect, 0);
        RasterAccessor srcAccessor = new RasterAccessor(source, srcRect, formatTags[0], this.getSourceImage(0).getColorModel());
        RasterAccessor dstAccessor = new RasterAccessor((Raster)dest, destRect, formatTags[1], this.getColorModel());
        switch (dstAccessor.getDataType()) {
            case 0: {
                this.byteLoop(srcAccessor, dstAccessor);
                break;
            }
            case 1: {
                this.ushortLoop(srcAccessor, dstAccessor);
                break;
            }
            case 2: {
                this.shortLoop(srcAccessor, dstAccessor);
                break;
            }
            case 3: {
                this.intLoop(srcAccessor, dstAccessor);
                break;
            }
            case 4: {
                this.floatLoop(srcAccessor, dstAccessor);
                break;
            }
            case 5: {
                this.doubleLoop(srcAccessor, dstAccessor);
            }
        }
        if (dstAccessor.isDataCopy()) {
            dstAccessor.clampDataArrays();
            dstAccessor.copyDataToRaster();
        }
    }

    private void byteLoop(RasterAccessor src, RasterAccessor dst) {
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int numBands = dst.getNumBands();
        int[] dstOffsetsForBands = dst.getOffsetsForBands();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        int[] srcOffsetsForBands = src.getOffsetsForBands();
        int[] srcBandOffsets = src.getBandOffsets();
        int srcPixelStride = src.getPixelStride();
        int srcScanlineStride = src.getScanlineStride();
        byte[][] dstDataArrays = dst.getByteDataArrays();
        byte[][] srcDataArrays = src.getByteDataArrays();
        byte[] srcData = srcDataArrays[numBands - 1];
        int srcScanlineOffset = srcBandOffsets[numBands - 1];
        int srcScanlineDataOffset = srcBandOffsets[srcOffsetsForBands[0]];
        int[] dstScanlineOffset = new int[numBands];
        byte transparentValue = this.noData.byteValue();
        for (int i = 0; i < numBands; ++i) {
            dstScanlineOffset[i] = dstBandOffsets[i];
        }
        for (int j = 0; j < dheight; ++j) {
            int i;
            int srcAlphaCentralPixelOffset = srcScanlineOffset + srcScanlineStride + srcPixelStride;
            int srcDataLeftPixelOffset = srcScanlineDataOffset + srcScanlineStride;
            int srcDataPixelOffset = srcDataLeftPixelOffset + srcPixelStride;
            int dstPixelOffset = dstScanlineOffset[dstOffsetsForBands[0]];
            int imageOffset = srcAlphaCentralPixelOffset;
            int imageDataOffset = srcDataPixelOffset;
            for (i = 0; i < dwidth; ++i) {
                int imageVerticalOffset = imageOffset;
                int imageDataVerticalOffset = imageDataOffset;
                byte centralPixel = srcData[imageVerticalOffset];
                boolean copySource = true;
                if (centralPixel == transparentValue) {
                    int elementAt;
                    int elementAt2;
                    int widthI;
                    int leftPixelStride = srcPixelStride;
                    byte leftPixel = srcData[imageVerticalOffset - srcPixelStride];
                    for (widthI = 1; leftPixel == transparentValue && widthI < this.width && (elementAt2 = imageVerticalOffset - (leftPixelStride += srcPixelStride)) < srcData.length && elementAt2 >= 0; ++widthI) {
                        leftPixel = srcData[elementAt2];
                    }
                    int rightPixelStride = srcPixelStride;
                    byte rightPixel = srcData[imageVerticalOffset + rightPixelStride];
                    for (widthI = 1; rightPixel == transparentValue && widthI < this.width && (elementAt = imageVerticalOffset + (rightPixelStride += srcPixelStride)) < srcData.length && elementAt >= 0; ++widthI) {
                        rightPixel = srcData[elementAt];
                    }
                    if (rightPixel != transparentValue && leftPixel != transparentValue) {
                        this.fillAlgorithm.fillPixel(numBands, srcDataArrays, dstDataArrays, imageDataVerticalOffset, leftPixelStride, rightPixelStride, dstPixelOffset);
                        copySource = false;
                    } else {
                        int elementAt3;
                        int upperScanlineStride = srcScanlineStride;
                        byte upperPixel = srcData[imageVerticalOffset - upperScanlineStride];
                        for (widthI = 1; upperPixel == transparentValue && widthI < this.width && (elementAt3 = imageVerticalOffset - (upperScanlineStride += srcScanlineStride)) < srcData.length && elementAt3 >= 0; ++widthI) {
                            upperPixel = srcData[elementAt3];
                        }
                        if (upperPixel != transparentValue) {
                            int elementAt4;
                            int lowerScanlineStride = srcScanlineStride;
                            byte lowerPixel = srcData[imageVerticalOffset + lowerScanlineStride];
                            for (widthI = 1; lowerPixel == transparentValue && widthI < this.width && (elementAt4 = imageVerticalOffset + (lowerScanlineStride += srcScanlineStride)) < srcData.length && elementAt4 >= 0; ++widthI) {
                                lowerPixel = srcData[imageVerticalOffset + lowerScanlineStride];
                            }
                            if (lowerPixel != transparentValue) {
                                this.fillAlgorithm.fillPixel(numBands, srcDataArrays, dstDataArrays, imageDataVerticalOffset, upperScanlineStride, lowerScanlineStride, dstPixelOffset);
                                copySource = false;
                            }
                        }
                    }
                }
                if (copySource) {
                    for (int k = 0; k < numBands; ++k) {
                        dstDataArrays[k][dstPixelOffset + k] = srcDataArrays[k][imageDataVerticalOffset + k];
                    }
                }
                imageOffset += srcPixelStride;
                imageDataOffset += srcPixelStride;
                dstPixelOffset += dstPixelStride;
            }
            srcScanlineOffset += srcScanlineStride;
            srcScanlineDataOffset += srcScanlineStride;
            i = 0;
            while (i < numBands) {
                int n = i++;
                dstScanlineOffset[n] = dstScanlineOffset[n] + dstScanlineStride;
            }
        }
    }

    private void intLoop(RasterAccessor src, RasterAccessor dst) {
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int numBands = dst.getNumBands();
        int[] dstOffsetsForBands = dst.getOffsetsForBands();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        int[] srcOffsetsForBands = src.getOffsetsForBands();
        int[] srcBandOffsets = src.getBandOffsets();
        int srcPixelStride = src.getPixelStride();
        int srcScanlineStride = src.getScanlineStride();
        int[][] dstDataArrays = dst.getIntDataArrays();
        int[][] srcDataArrays = src.getIntDataArrays();
        int[] srcData = srcDataArrays[numBands - 1];
        int srcScanlineOffset = srcBandOffsets[numBands - 1];
        int srcScanlineDataOffset = srcBandOffsets[srcOffsetsForBands[0]];
        int[] dstScanlineOffset = new int[numBands];
        int transparentValue = this.noData.intValue();
        for (int i = 0; i < numBands; ++i) {
            dstScanlineOffset[i] = dstBandOffsets[i];
        }
        for (int j = 0; j < dheight; ++j) {
            int i;
            int srcAlphaCentralPixelOffset = srcScanlineOffset + srcScanlineStride + srcPixelStride;
            int srcDataLeftPixelOffset = srcScanlineDataOffset + srcScanlineStride;
            int srcDataPixelOffset = srcDataLeftPixelOffset + srcPixelStride;
            int dstPixelOffset = dstScanlineOffset[dstOffsetsForBands[0]];
            int imageOffset = srcAlphaCentralPixelOffset;
            int imageDataOffset = srcDataPixelOffset;
            for (i = 0; i < dwidth; ++i) {
                int imageVerticalOffset = imageOffset;
                int imageDataVerticalOffset = imageDataOffset;
                int centralPixel = srcData[imageVerticalOffset];
                boolean copySource = true;
                if (centralPixel == transparentValue) {
                    int elementAt;
                    int elementAt2;
                    int widthI;
                    int leftPixelStride = srcPixelStride;
                    int leftPixel = srcData[imageVerticalOffset - srcPixelStride];
                    for (widthI = 1; leftPixel == transparentValue && widthI < this.width && (elementAt2 = imageVerticalOffset - (leftPixelStride += srcPixelStride)) < srcData.length && elementAt2 >= 0; ++widthI) {
                        leftPixel = srcData[elementAt2];
                    }
                    int rightPixelStride = srcPixelStride;
                    int rightPixel = srcData[imageVerticalOffset + rightPixelStride];
                    for (widthI = 1; rightPixel == transparentValue && widthI < this.width && (elementAt = imageVerticalOffset + (rightPixelStride += srcPixelStride)) < srcData.length && elementAt >= 0; ++widthI) {
                        rightPixel = srcData[elementAt];
                    }
                    if (rightPixel != transparentValue && leftPixel != transparentValue) {
                        this.fillAlgorithm.fillPixel(numBands, srcDataArrays, dstDataArrays, imageDataVerticalOffset, leftPixelStride, rightPixelStride, dstPixelOffset);
                        copySource = false;
                    } else {
                        int elementAt3;
                        int upperScanlineStride = srcScanlineStride;
                        int upperPixel = srcData[imageVerticalOffset - upperScanlineStride];
                        for (widthI = 1; upperPixel == transparentValue && widthI < this.width && (elementAt3 = imageVerticalOffset - (upperScanlineStride += srcScanlineStride)) < srcData.length && elementAt3 >= 0; ++widthI) {
                            upperPixel = srcData[elementAt3];
                        }
                        if (upperPixel != transparentValue) {
                            int elementAt4;
                            int lowerScanlineStride = srcScanlineStride;
                            int lowerPixel = srcData[imageVerticalOffset + lowerScanlineStride];
                            for (widthI = 1; lowerPixel == transparentValue && widthI < this.width && (elementAt4 = imageVerticalOffset + (lowerScanlineStride += srcScanlineStride)) < srcData.length && elementAt4 >= 0; ++widthI) {
                                lowerPixel = srcData[imageVerticalOffset + lowerScanlineStride];
                            }
                            if (lowerPixel != transparentValue) {
                                this.fillAlgorithm.fillPixel(numBands, srcDataArrays, dstDataArrays, imageDataVerticalOffset, upperScanlineStride, lowerScanlineStride, dstPixelOffset);
                                copySource = false;
                            }
                        }
                    }
                }
                if (copySource) {
                    for (int k = 0; k < numBands; ++k) {
                        dstDataArrays[k][dstPixelOffset + k] = srcDataArrays[k][imageDataVerticalOffset + k];
                    }
                }
                imageOffset += srcPixelStride;
                imageDataOffset += srcPixelStride;
                dstPixelOffset += dstPixelStride;
            }
            srcScanlineOffset += srcScanlineStride;
            srcScanlineDataOffset += srcScanlineStride;
            i = 0;
            while (i < numBands) {
                int n = i++;
                dstScanlineOffset[n] = dstScanlineOffset[n] + dstScanlineStride;
            }
        }
    }

    private void shortLoop(RasterAccessor src, RasterAccessor dst) {
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int numBands = dst.getNumBands();
        int[] dstOffsetsForBands = dst.getOffsetsForBands();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        int[] srcOffsetsForBands = src.getOffsetsForBands();
        int[] srcBandOffsets = src.getBandOffsets();
        int srcPixelStride = src.getPixelStride();
        int srcScanlineStride = src.getScanlineStride();
        short[][] dstDataArrays = dst.getShortDataArrays();
        short[][] srcDataArrays = src.getShortDataArrays();
        short[] srcData = srcDataArrays[numBands - 1];
        int srcScanlineOffset = srcBandOffsets[numBands - 1];
        int srcScanlineDataOffset = srcBandOffsets[srcOffsetsForBands[0]];
        int[] dstScanlineOffset = new int[numBands];
        short transparentValue = this.noData.shortValue();
        for (int i = 0; i < numBands; ++i) {
            dstScanlineOffset[i] = dstBandOffsets[i];
        }
        for (int j = 0; j < dheight; ++j) {
            int i;
            int srcAlphaCentralPixelOffset = srcScanlineOffset + srcScanlineStride + srcPixelStride;
            int srcDataLeftPixelOffset = srcScanlineDataOffset + srcScanlineStride;
            int srcDataPixelOffset = srcDataLeftPixelOffset + srcPixelStride;
            int dstPixelOffset = dstScanlineOffset[dstOffsetsForBands[0]];
            int imageOffset = srcAlphaCentralPixelOffset;
            int imageDataOffset = srcDataPixelOffset;
            for (i = 0; i < dwidth; ++i) {
                int imageVerticalOffset = imageOffset;
                int imageDataVerticalOffset = imageDataOffset;
                short centralPixel = srcData[imageVerticalOffset];
                boolean copySource = true;
                if (centralPixel == transparentValue) {
                    int elementAt;
                    int elementAt2;
                    int widthI;
                    int leftPixelStride = srcPixelStride;
                    short leftPixel = srcData[imageVerticalOffset - srcPixelStride];
                    for (widthI = 1; leftPixel == transparentValue && widthI < this.width && (elementAt2 = imageVerticalOffset - (leftPixelStride += srcPixelStride)) < srcData.length && elementAt2 >= 0; ++widthI) {
                        leftPixel = srcData[elementAt2];
                    }
                    int rightPixelStride = srcPixelStride;
                    short rightPixel = srcData[imageVerticalOffset + rightPixelStride];
                    for (widthI = 1; rightPixel == transparentValue && widthI < this.width && (elementAt = imageVerticalOffset + (rightPixelStride += srcPixelStride)) < srcData.length && elementAt >= 0; ++widthI) {
                        rightPixel = srcData[elementAt];
                    }
                    if (rightPixel != transparentValue && leftPixel != transparentValue) {
                        this.fillAlgorithm.fillPixel(numBands, srcDataArrays, dstDataArrays, imageDataVerticalOffset, leftPixelStride, rightPixelStride, dstPixelOffset);
                        copySource = false;
                    } else {
                        int elementAt3;
                        int upperScanlineStride = srcScanlineStride;
                        short upperPixel = srcData[imageVerticalOffset - upperScanlineStride];
                        for (widthI = 1; upperPixel == transparentValue && widthI < this.width && (elementAt3 = imageVerticalOffset - (upperScanlineStride += srcScanlineStride)) < srcData.length && elementAt3 >= 0; ++widthI) {
                            upperPixel = srcData[elementAt3];
                        }
                        if (upperPixel != transparentValue) {
                            int elementAt4;
                            int lowerScanlineStride = srcScanlineStride;
                            short lowerPixel = srcData[imageVerticalOffset + lowerScanlineStride];
                            for (widthI = 1; lowerPixel == transparentValue && widthI < this.width && (elementAt4 = imageVerticalOffset + (lowerScanlineStride += srcScanlineStride)) < srcData.length && elementAt4 >= 0; ++widthI) {
                                lowerPixel = srcData[imageVerticalOffset + lowerScanlineStride];
                            }
                            if (lowerPixel != transparentValue) {
                                this.fillAlgorithm.fillPixel(numBands, srcDataArrays, dstDataArrays, imageDataVerticalOffset, upperScanlineStride, lowerScanlineStride, dstPixelOffset);
                                copySource = false;
                            }
                        }
                    }
                }
                if (copySource) {
                    for (int k = 0; k < numBands; ++k) {
                        dstDataArrays[k][dstPixelOffset + k] = srcDataArrays[k][imageDataVerticalOffset + k];
                    }
                }
                imageOffset += srcPixelStride;
                imageDataOffset += srcPixelStride;
                dstPixelOffset += dstPixelStride;
            }
            srcScanlineOffset += srcScanlineStride;
            srcScanlineDataOffset += srcScanlineStride;
            i = 0;
            while (i < numBands) {
                int n = i++;
                dstScanlineOffset[n] = dstScanlineOffset[n] + dstScanlineStride;
            }
        }
    }

    private void ushortLoop(RasterAccessor src, RasterAccessor dst) {
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int numBands = dst.getNumBands();
        int[] dstOffsetsForBands = dst.getOffsetsForBands();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        int[] srcOffsetsForBands = src.getOffsetsForBands();
        int[] srcBandOffsets = src.getBandOffsets();
        int srcPixelStride = src.getPixelStride();
        int srcScanlineStride = src.getScanlineStride();
        short[][] dstDataArrays = dst.getShortDataArrays();
        short[][] srcDataArrays = src.getShortDataArrays();
        short[] srcData = srcDataArrays[numBands - 1];
        int srcScanlineOffset = srcBandOffsets[numBands - 1];
        int srcScanlineDataOffset = srcBandOffsets[srcOffsetsForBands[0]];
        int[] dstScanlineOffset = new int[numBands];
        short transparentValue = this.noData.shortValue();
        for (int i = 0; i < numBands; ++i) {
            dstScanlineOffset[i] = dstBandOffsets[i];
        }
        for (int j = 0; j < dheight; ++j) {
            int i;
            int srcAlphaCentralPixelOffset = srcScanlineOffset + srcScanlineStride + srcPixelStride;
            int srcDataLeftPixelOffset = srcScanlineDataOffset + srcScanlineStride;
            int srcDataPixelOffset = srcDataLeftPixelOffset + srcPixelStride;
            int dstPixelOffset = dstScanlineOffset[dstOffsetsForBands[0]];
            int imageOffset = srcAlphaCentralPixelOffset;
            int imageDataOffset = srcDataPixelOffset;
            for (i = 0; i < dwidth; ++i) {
                int imageVerticalOffset = imageOffset;
                int imageDataVerticalOffset = imageDataOffset;
                short centralPixel = srcData[imageVerticalOffset];
                boolean copySource = true;
                if (centralPixel == transparentValue) {
                    int elementAt;
                    int elementAt2;
                    int widthI;
                    int leftPixelStride = srcPixelStride;
                    short leftPixel = srcData[imageVerticalOffset - srcPixelStride];
                    for (widthI = 1; leftPixel == transparentValue && widthI < this.width && (elementAt2 = imageVerticalOffset - (leftPixelStride += srcPixelStride)) < srcData.length && elementAt2 >= 0; ++widthI) {
                        leftPixel = srcData[elementAt2];
                    }
                    int rightPixelStride = srcPixelStride;
                    short rightPixel = srcData[imageVerticalOffset + rightPixelStride];
                    for (widthI = 1; rightPixel == transparentValue && widthI < this.width && (elementAt = imageVerticalOffset + (rightPixelStride += srcPixelStride)) < srcData.length && elementAt >= 0; ++widthI) {
                        rightPixel = srcData[elementAt];
                    }
                    if (rightPixel != transparentValue && leftPixel != transparentValue) {
                        this.fillAlgorithm.fillPixel(numBands, srcDataArrays, dstDataArrays, imageDataVerticalOffset, leftPixelStride, rightPixelStride, dstPixelOffset);
                        copySource = false;
                    } else {
                        int elementAt3;
                        int upperScanlineStride = srcScanlineStride;
                        short upperPixel = srcData[imageVerticalOffset - upperScanlineStride];
                        for (widthI = 1; upperPixel == transparentValue && widthI < this.width && (elementAt3 = imageVerticalOffset - (upperScanlineStride += srcScanlineStride)) < srcData.length && elementAt3 >= 0; ++widthI) {
                            upperPixel = srcData[elementAt3];
                        }
                        if (upperPixel != transparentValue) {
                            int elementAt4;
                            int lowerScanlineStride = srcScanlineStride;
                            short lowerPixel = srcData[imageVerticalOffset + lowerScanlineStride];
                            for (widthI = 1; lowerPixel == transparentValue && widthI < this.width && (elementAt4 = imageVerticalOffset + (lowerScanlineStride += srcScanlineStride)) < srcData.length && elementAt4 >= 0; ++widthI) {
                                lowerPixel = srcData[imageVerticalOffset + lowerScanlineStride];
                            }
                            if (lowerPixel != transparentValue) {
                                this.fillAlgorithm.fillPixel(numBands, srcDataArrays, dstDataArrays, imageDataVerticalOffset, upperScanlineStride, lowerScanlineStride, dstPixelOffset);
                                copySource = false;
                            }
                        }
                    }
                }
                if (copySource) {
                    for (int k = 0; k < numBands; ++k) {
                        dstDataArrays[k][dstPixelOffset + k] = srcDataArrays[k][imageDataVerticalOffset + k];
                    }
                }
                imageOffset += srcPixelStride;
                imageDataOffset += srcPixelStride;
                dstPixelOffset += dstPixelStride;
            }
            srcScanlineOffset += srcScanlineStride;
            srcScanlineDataOffset += srcScanlineStride;
            i = 0;
            while (i < numBands) {
                int n = i++;
                dstScanlineOffset[n] = dstScanlineOffset[n] + dstScanlineStride;
            }
        }
    }

    private void floatLoop(RasterAccessor src, RasterAccessor dst) {
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int numBands = dst.getNumBands();
        int[] dstOffsetsForBands = dst.getOffsetsForBands();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        int[] srcOffsetsForBands = src.getOffsetsForBands();
        int[] srcBandOffsets = src.getBandOffsets();
        int srcPixelStride = src.getPixelStride();
        int srcScanlineStride = src.getScanlineStride();
        float[][] dstDataArrays = dst.getFloatDataArrays();
        float[][] srcDataArrays = src.getFloatDataArrays();
        float[] srcData = srcDataArrays[numBands - 1];
        int srcScanlineOffset = srcBandOffsets[numBands - 1];
        int srcScanlineDataOffset = srcBandOffsets[srcOffsetsForBands[0]];
        int[] dstScanlineOffset = new int[numBands];
        float transparentValue = this.noData.floatValue();
        for (int i = 0; i < numBands; ++i) {
            dstScanlineOffset[i] = dstBandOffsets[i];
        }
        for (int j = 0; j < dheight; ++j) {
            int i;
            int srcAlphaCentralPixelOffset = srcScanlineOffset + srcScanlineStride + srcPixelStride;
            int srcDataLeftPixelOffset = srcScanlineDataOffset + srcScanlineStride;
            int srcDataPixelOffset = srcDataLeftPixelOffset + srcPixelStride;
            int dstPixelOffset = dstScanlineOffset[dstOffsetsForBands[0]];
            int imageOffset = srcAlphaCentralPixelOffset;
            int imageDataOffset = srcDataPixelOffset;
            for (i = 0; i < dwidth; ++i) {
                int imageVerticalOffset = imageOffset;
                int imageDataVerticalOffset = imageDataOffset;
                float centralPixel = srcData[imageVerticalOffset];
                boolean copySource = true;
                if (centralPixel == transparentValue) {
                    int elementAt;
                    int elementAt2;
                    int widthI;
                    int leftPixelStride = srcPixelStride;
                    float leftPixel = srcData[imageVerticalOffset - srcPixelStride];
                    for (widthI = 1; leftPixel == transparentValue && widthI < this.width && (elementAt2 = imageVerticalOffset - (leftPixelStride += srcPixelStride)) < srcData.length && elementAt2 >= 0; ++widthI) {
                        leftPixel = srcData[elementAt2];
                    }
                    int rightPixelStride = srcPixelStride;
                    float rightPixel = srcData[imageVerticalOffset + rightPixelStride];
                    for (widthI = 1; rightPixel == transparentValue && widthI < this.width && (elementAt = imageVerticalOffset + (rightPixelStride += srcPixelStride)) < srcData.length && elementAt >= 0; ++widthI) {
                        rightPixel = srcData[elementAt];
                    }
                    if (rightPixel != transparentValue && leftPixel != transparentValue) {
                        this.fillAlgorithm.fillPixel(numBands, srcDataArrays, dstDataArrays, imageDataVerticalOffset, leftPixelStride, rightPixelStride, dstPixelOffset);
                        copySource = false;
                    } else {
                        int elementAt3;
                        int upperScanlineStride = srcScanlineStride;
                        float upperPixel = srcData[imageVerticalOffset - upperScanlineStride];
                        for (widthI = 1; upperPixel == transparentValue && widthI < this.width && (elementAt3 = imageVerticalOffset - (upperScanlineStride += srcScanlineStride)) < srcData.length && elementAt3 >= 0; ++widthI) {
                            upperPixel = srcData[elementAt3];
                        }
                        if (upperPixel != transparentValue) {
                            int elementAt4;
                            int lowerScanlineStride = srcScanlineStride;
                            float lowerPixel = srcData[imageVerticalOffset + lowerScanlineStride];
                            for (widthI = 1; lowerPixel == transparentValue && widthI < this.width && (elementAt4 = imageVerticalOffset + (lowerScanlineStride += srcScanlineStride)) < srcData.length && elementAt4 >= 0; ++widthI) {
                                lowerPixel = srcData[imageVerticalOffset + lowerScanlineStride];
                            }
                            if (lowerPixel != transparentValue) {
                                this.fillAlgorithm.fillPixel(numBands, srcDataArrays, dstDataArrays, imageDataVerticalOffset, upperScanlineStride, lowerScanlineStride, dstPixelOffset);
                                copySource = false;
                            }
                        }
                    }
                }
                if (copySource) {
                    for (int k = 0; k < numBands; ++k) {
                        dstDataArrays[k][dstPixelOffset + k] = srcDataArrays[k][imageDataVerticalOffset + k];
                    }
                }
                imageOffset += srcPixelStride;
                imageDataOffset += srcPixelStride;
                dstPixelOffset += dstPixelStride;
            }
            srcScanlineOffset += srcScanlineStride;
            srcScanlineDataOffset += srcScanlineStride;
            i = 0;
            while (i < numBands) {
                int n = i++;
                dstScanlineOffset[n] = dstScanlineOffset[n] + dstScanlineStride;
            }
        }
    }

    private void doubleLoop(RasterAccessor src, RasterAccessor dst) {
        int dwidth = dst.getWidth();
        int dheight = dst.getHeight();
        int numBands = dst.getNumBands();
        int[] dstOffsetsForBands = dst.getOffsetsForBands();
        int[] dstBandOffsets = dst.getBandOffsets();
        int dstPixelStride = dst.getPixelStride();
        int dstScanlineStride = dst.getScanlineStride();
        int[] srcOffsetsForBands = src.getOffsetsForBands();
        int[] srcBandOffsets = src.getBandOffsets();
        int srcPixelStride = src.getPixelStride();
        int srcScanlineStride = src.getScanlineStride();
        double[][] dstDataArrays = dst.getDoubleDataArrays();
        double[][] srcDataArrays = src.getDoubleDataArrays();
        double[] srcData = srcDataArrays[numBands - 1];
        int srcScanlineOffset = srcBandOffsets[numBands - 1];
        int srcScanlineDataOffset = srcBandOffsets[srcOffsetsForBands[0]];
        int[] dstScanlineOffset = new int[numBands];
        double transparentValue = this.noData.doubleValue();
        for (int i = 0; i < numBands; ++i) {
            dstScanlineOffset[i] = dstBandOffsets[i];
        }
        for (int j = 0; j < dheight; ++j) {
            int i;
            int srcAlphaCentralPixelOffset = srcScanlineOffset + srcScanlineStride + srcPixelStride;
            int srcDataLeftPixelOffset = srcScanlineDataOffset + srcScanlineStride;
            int srcDataPixelOffset = srcDataLeftPixelOffset + srcPixelStride;
            int dstPixelOffset = dstScanlineOffset[dstOffsetsForBands[0]];
            int imageOffset = srcAlphaCentralPixelOffset;
            int imageDataOffset = srcDataPixelOffset;
            for (i = 0; i < dwidth; ++i) {
                int imageVerticalOffset = imageOffset;
                int imageDataVerticalOffset = imageDataOffset;
                double centralPixel = srcData[imageVerticalOffset];
                boolean copySource = true;
                if (centralPixel == transparentValue) {
                    int elementAt;
                    int elementAt2;
                    int widthI;
                    int leftPixelStride = srcPixelStride;
                    double leftPixel = srcData[imageVerticalOffset - srcPixelStride];
                    for (widthI = 1; leftPixel == transparentValue && widthI < this.width && (elementAt2 = imageVerticalOffset - (leftPixelStride += srcPixelStride)) < srcData.length && elementAt2 >= 0; ++widthI) {
                        leftPixel = srcData[elementAt2];
                    }
                    int rightPixelStride = srcPixelStride;
                    double rightPixel = srcData[imageVerticalOffset + rightPixelStride];
                    for (widthI = 1; rightPixel == transparentValue && widthI < this.width && (elementAt = imageVerticalOffset + (rightPixelStride += srcPixelStride)) < srcData.length && elementAt >= 0; ++widthI) {
                        rightPixel = srcData[elementAt];
                    }
                    if (rightPixel != transparentValue && leftPixel != transparentValue) {
                        this.fillAlgorithm.fillPixel(numBands, srcDataArrays, dstDataArrays, imageDataVerticalOffset, leftPixelStride, rightPixelStride, dstPixelOffset);
                        copySource = false;
                    } else {
                        int elementAt3;
                        int upperScanlineStride = srcScanlineStride;
                        double upperPixel = srcData[imageVerticalOffset - upperScanlineStride];
                        for (widthI = 1; upperPixel == transparentValue && widthI < this.width && (elementAt3 = imageVerticalOffset - (upperScanlineStride += srcScanlineStride)) < srcData.length && elementAt3 >= 0; ++widthI) {
                            upperPixel = srcData[elementAt3];
                        }
                        if (upperPixel != transparentValue) {
                            int elementAt4;
                            int lowerScanlineStride = srcScanlineStride;
                            double lowerPixel = srcData[imageVerticalOffset + lowerScanlineStride];
                            for (widthI = 1; lowerPixel == transparentValue && widthI < this.width && (elementAt4 = imageVerticalOffset + (lowerScanlineStride += srcScanlineStride)) < srcData.length && elementAt4 >= 0; ++widthI) {
                                lowerPixel = srcData[imageVerticalOffset + lowerScanlineStride];
                            }
                            if (lowerPixel != transparentValue) {
                                this.fillAlgorithm.fillPixel(numBands, srcDataArrays, dstDataArrays, imageDataVerticalOffset, upperScanlineStride, lowerScanlineStride, dstPixelOffset);
                                copySource = false;
                            }
                        }
                    }
                }
                if (copySource) {
                    for (int k = 0; k < numBands; ++k) {
                        dstDataArrays[k][dstPixelOffset + k] = srcDataArrays[k][imageDataVerticalOffset + k];
                    }
                }
                imageOffset += srcPixelStride;
                imageDataOffset += srcPixelStride;
                dstPixelOffset += dstPixelStride;
            }
            srcScanlineOffset += srcScanlineStride;
            srcScanlineDataOffset += srcScanlineStride;
            i = 0;
            while (i < numBands) {
                int n = i++;
                dstScanlineOffset[n] = dstScanlineOffset[n] + dstScanlineStride;
            }
        }
    }

    public Vector<RenderedImage> getSources() {
        return super.getSources();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static enum TransparencyFillAlgorithm {
        FILL_AVERAGE{

            @Override
            public void fillPixel(int numBands, byte[][] srcData, byte[][] dstData, int srcOffset, int srcStride1, int srcStride2, int dstOffset) {
                for (int k = 0; k < numBands; ++k) {
                    if (k != numBands - 1) {
                        int left = srcData[k][srcOffset - srcStride1 + k] & 0xFF;
                        int right = srcData[k][srcOffset + srcStride2 + k] & 0xFF;
                        dstData[k][dstOffset + k] = (byte)((left + right) / 2);
                        continue;
                    }
                    dstData[k][dstOffset + k] = srcData[k][srcOffset - srcStride1 + k];
                }
            }

            @Override
            public void fillPixel(int numBands, int[][] srcData, int[][] dstData, int srcOffset, int srcStride1, int srcStride2, int dstOffset) {
                for (int k = 0; k < numBands; ++k) {
                    if (k != numBands - 1) {
                        int left = srcData[k][srcOffset - srcStride1 + k];
                        int right = srcData[k][srcOffset + srcStride2 + k];
                        dstData[k][dstOffset + k] = (left + right) / 2;
                        continue;
                    }
                    dstData[k][dstOffset + k] = srcData[k][srcOffset - srcStride1 + k];
                }
            }

            @Override
            public void fillPixel(int numBands, short[][] srcData, short[][] dstData, int srcOffset, int srcStride1, int srcStride2, int dstOffset) {
                for (int k = 0; k < numBands; ++k) {
                    if (k != numBands - 1) {
                        float left = srcData[k][srcOffset - srcStride1 + k];
                        float right = srcData[k][srcOffset + srcStride2 + k];
                        dstData[k][dstOffset + k] = (short)((left + right) / 2.0f);
                        continue;
                    }
                    dstData[k][dstOffset + k] = srcData[k][srcOffset - srcStride1 + k];
                }
            }

            @Override
            public void fillPixel(int numBands, float[][] srcData, float[][] dstData, int srcOffset, int srcStride1, int srcStride2, int dstOffset) {
                for (int k = 0; k < numBands; ++k) {
                    if (k != numBands - 1) {
                        float left = srcData[k][srcOffset - srcStride1 + k];
                        float right = srcData[k][srcOffset + srcStride2 + k];
                        dstData[k][dstOffset + k] = (left + right) / 2.0f;
                        continue;
                    }
                    dstData[k][dstOffset + k] = srcData[k][srcOffset - srcStride1 + k];
                }
            }

            @Override
            public void fillPixel(int numBands, double[][] srcData, double[][] dstData, int srcOffset, int srcStride1, int srcStride2, int dstOffset) {
                for (int k = 0; k < numBands; ++k) {
                    if (k != numBands - 1) {
                        double left = srcData[k][srcOffset - srcStride1 + k];
                        double right = srcData[k][srcOffset + srcStride2 + k];
                        dstData[k][dstOffset + k] = (left + right) / 2.0;
                        continue;
                    }
                    dstData[k][dstOffset + k] = srcData[k][srcOffset - srcStride1 + k];
                }
            }
        }
        ,
        FILL_CLONE_FIRST{

            @Override
            public void fillPixel(int numBands, byte[][] srcData, byte[][] dstData, int srcOffset, int srcStride1, int srcStride2, int dstOffset) {
                for (int k = 0; k < numBands; ++k) {
                    dstData[k][dstOffset + k] = srcData[k][srcOffset - srcStride1 + k];
                }
            }

            @Override
            public void fillPixel(int numBands, int[][] srcData, int[][] dstData, int srcOffset, int srcStride1, int srcStride2, int dstOffset) {
                for (int k = 0; k < numBands; ++k) {
                    dstData[k][dstOffset + k] = srcData[k][srcOffset - srcStride1 + k];
                }
            }

            @Override
            public void fillPixel(int numBands, short[][] srcData, short[][] dstData, int srcOffset, int srcStride1, int srcStride2, int dstOffset) {
                for (int k = 0; k < numBands; ++k) {
                    dstData[k][dstOffset + k] = srcData[k][srcOffset - srcStride1 + k];
                }
            }

            @Override
            public void fillPixel(int numBands, float[][] srcData, float[][] dstData, int srcOffset, int srcStride1, int srcStride2, int dstOffset) {
                for (int k = 0; k < numBands; ++k) {
                    dstData[k][dstOffset + k] = srcData[k][srcOffset - srcStride1 + k];
                }
            }

            @Override
            public void fillPixel(int numBands, double[][] srcData, double[][] dstData, int srcOffset, int srcStride1, int srcStride2, int dstOffset) {
                for (int k = 0; k < numBands; ++k) {
                    dstData[k][dstOffset + k] = (float)srcData[k][srcOffset - srcStride1 + k];
                }
            }
        }
        ,
        FILL_CLONE_SECOND{

            @Override
            public void fillPixel(int numBands, byte[][] srcData, byte[][] dstData, int srcOffset, int srcStride1, int srcStride2, int dstOffset) {
                for (int k = 0; k < numBands; ++k) {
                    dstData[k][dstOffset + k] = srcData[k][srcOffset + srcStride2 + k];
                }
            }

            @Override
            public void fillPixel(int numBands, short[][] srcData, short[][] dstData, int srcOffset, int srcStride1, int srcStride2, int dstOffset) {
                for (int k = 0; k < numBands; ++k) {
                    dstData[k][dstOffset + k] = srcData[k][srcOffset + srcStride2 + k];
                }
            }

            @Override
            public void fillPixel(int numBands, int[][] srcData, int[][] dstData, int srcOffset, int srcStride1, int srcStride2, int dstOffset) {
                for (int k = 0; k < numBands; ++k) {
                    dstData[k][dstOffset + k] = srcData[k][srcOffset + srcStride2 + k];
                }
            }

            @Override
            public void fillPixel(int numBands, float[][] srcData, float[][] dstData, int srcOffset, int srcStride1, int srcStride2, int dstOffset) {
                for (int k = 0; k < numBands; ++k) {
                    dstData[k][dstOffset + k] = srcData[k][srcOffset + srcStride2 + k];
                }
            }

            @Override
            public void fillPixel(int numBands, double[][] srcData, double[][] dstData, int srcOffset, int srcStride1, int srcStride2, int dstOffset) {
                for (int k = 0; k < numBands; ++k) {
                    dstData[k][dstOffset + k] = srcData[k][srcOffset + srcStride2 + k];
                }
            }
        };


        public abstract void fillPixel(int var1, byte[][] var2, byte[][] var3, int var4, int var5, int var6, int var7);

        public abstract void fillPixel(int var1, float[][] var2, float[][] var3, int var4, int var5, int var6, int var7);

        public abstract void fillPixel(int var1, double[][] var2, double[][] var3, int var4, int var5, int var6, int var7);

        public abstract void fillPixel(int var1, int[][] var2, int[][] var3, int var4, int var5, int var6, int var7);

        public abstract void fillPixel(int var1, short[][] var2, short[][] var3, int var4, int var5, int var6, int var7);
    }
}

