/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import it.geosolutions.imageio.core.BasicAuthURI;
import it.geosolutions.imageio.core.SourceSPIProvider;
import it.geosolutions.imageioimpl.plugins.cog.CogImageInputStreamSpi;
import it.geosolutions.imageioimpl.plugins.cog.CogImageReaderSpi;
import it.geosolutions.imageioimpl.plugins.cog.CogSourceSPIProvider;
import java.awt.RenderingHints;
import java.io.IOException;
import javax.imageio.spi.ImageInputStreamSpi;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.imageio.MaskOverviewProvider;
import org.geotools.gce.geotiff.GeoTiffFormat;
import org.geotools.gce.imagemosaic.DefaultGranuleAccessProvider;
import org.geotools.gce.imagemosaic.GranuleAccessProvider;
import org.geotools.gce.imagemosaic.GranuleDescriptor;
import org.geotools.gce.imagemosaic.SourceSPIProviderFactory;
import org.geotools.gce.imagemosaic.catalog.CatalogConfigurationBean;
import org.geotools.gce.imagemosaic.catalog.CogConfiguration;
import org.geotools.util.Utilities;
import org.geotools.util.factory.Hints;

public class CogGranuleAccessProvider
extends DefaultGranuleAccessProvider
implements GranuleAccessProvider {
    private static final ImageReaderSpi DEFAULT_COG_IMAGE_READER_SPI = new CogImageReaderSpi();
    private static final ImageInputStreamSpi DEFAULT_COG_IMAGE_INPUT_STREAM_SPI = new CogImageInputStreamSpi();
    private static final AbstractGridFormat DEFAULT_COG_FORMAT = new GeoTiffFormat();
    private static final String DEFAULT_RANGE_READER = "it.geosolutions.imageioimpl.plugins.cog.HttpRangeReader";
    private CogConfiguration cogConfig;

    public CogGranuleAccessProvider(CatalogConfigurationBean bean) {
        this(CogGranuleAccessProvider.getHints(bean));
        CogConfiguration configuration;
        SourceSPIProviderFactory urlSourceSpiProvider = bean.getUrlSourceSPIProvider();
        if (!(urlSourceSpiProvider instanceof CogConfiguration)) {
            throw new RuntimeException("This access provider needs a URL Source SPI Provider of type CogConfiguration whilst " + String.valueOf(urlSourceSpiProvider) + " has been found.");
        }
        this.cogConfig = configuration = (CogConfiguration)urlSourceSpiProvider;
        this.skipExternalOverviews = bean.isSkipExternalOverviews();
    }

    private static Hints getHints(CatalogConfigurationBean bean) {
        Utilities.ensureNonNull((String)"CatalogConfigurationBean", (Object)bean);
        Hints hints = new Hints();
        ImageReaderSpi readerSpi = CogGranuleAccessProvider.createImageReaderSpiInstance(bean.getSuggestedSPI());
        if (readerSpi == null) {
            readerSpi = DEFAULT_COG_IMAGE_READER_SPI;
        }
        hints.put((Object)GranuleAccessProvider.SUGGESTED_READER_SPI, (Object)readerSpi);
        ImageInputStreamSpi imageInputStreamSpi = CogGranuleAccessProvider.createImageInputStreamSpiInstance(bean.getSuggestedIsSPI());
        if (imageInputStreamSpi == null) {
            imageInputStreamSpi = DEFAULT_COG_IMAGE_INPUT_STREAM_SPI;
        }
        hints.put((Object)GranuleAccessProvider.SUGGESTED_STREAM_SPI, (Object)imageInputStreamSpi);
        AbstractGridFormat format = CogGranuleAccessProvider.createFormatInstance(bean.getSuggestedFormat());
        if (format == null) {
            format = DEFAULT_COG_FORMAT;
        }
        hints.put((Object)GranuleAccessProvider.SUGGESTED_FORMAT, (Object)format);
        if (bean.isSkipExternalOverviews()) {
            hints.put((Object)Hints.SKIP_EXTERNAL_OVERVIEWS, (Object)true);
        }
        hints.add((RenderingHints)GranuleDescriptor.EXCLUDE_MOSAIC);
        return hints;
    }

    public CogGranuleAccessProvider(Hints hints) {
        super(hints);
    }

    @Override
    public void setGranuleInput(Object input) throws IOException {
        BasicAuthURI cogUri = this.cogConfig.createUri(input.toString());
        String rangeReader = this.cogConfig.getRangeReader();
        if (rangeReader == null) {
            rangeReader = DEFAULT_RANGE_READER;
        }
        CogSourceSPIProvider sourceSPIProvider = new CogSourceSPIProvider(cogUri, this.imageReaderSpi, this.imageInputStreamSpi, rangeReader);
        this.input = sourceSPIProvider;
        this.inputURL = sourceSPIProvider.getSourceUrl();
    }

    @Override
    public MaskOverviewProvider getMaskOverviewsProvider() throws IOException {
        if (this.ovrProvider == null) {
            SourceSPIProvider inputProvider = (SourceSPIProvider)this.input;
            this.spiHelper = new MaskOverviewProvider.SpiHelper(inputProvider);
            AbstractGridCoverage2DReader reader = this.getGridCoverageReader();
            this.ovrProvider = new MaskOverviewProvider(reader.getDatasetLayout(), inputProvider.getSourceUrl(), this.spiHelper, this.skipExternalOverviews);
        }
        if (this.ovrProvider == null) {
            throw new IOException("Unable to find a MaskOverviewProvider for the specified input: " + String.valueOf(this.input));
        }
        return this.ovrProvider;
    }

    @Override
    public ImageInputStreamSpi getInputStreamSpi() throws IOException {
        return this.imageInputStreamSpi;
    }

    @Override
    public ImageReaderSpi getImageReaderSpi() throws IOException {
        return this.imageReaderSpi;
    }

    @Override
    public ImageInputStream getImageInputStream() throws IOException {
        return ((CogSourceSPIProvider)this.input).getStream();
    }

    @Override
    public GranuleAccessProvider copyProviders() {
        CogGranuleAccessProvider provider = new CogGranuleAccessProvider(this.hints);
        provider.cogConfig = this.cogConfig;
        provider.skipExternalOverviews = this.skipExternalOverviews;
        return provider;
    }
}

