/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import it.geosolutions.imageio.maskband.DatasetLayout;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageInputStreamSpi;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridFormatFinder;
import org.geotools.coverage.grid.io.imageio.MaskOverviewProvider;
import org.geotools.gce.imagemosaic.GranuleAccessProvider;
import org.geotools.gce.imagemosaic.GranuleDescriptor;
import org.geotools.gce.imagemosaic.GranuleDescriptorModifier;
import org.geotools.gce.imagemosaic.Utils;
import org.geotools.util.URLs;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;

public class DefaultGranuleAccessProvider
implements GranuleAccessProvider,
GranuleDescriptorModifier {
    private static final Logger LOGGER = Logging.getLogger(DefaultGranuleAccessProvider.class);
    protected ImageInputStreamSpi imageInputStreamSpi;
    protected AbstractGridFormat suggestedFormat;
    protected AbstractGridFormat format;
    protected ImageReaderSpi imageReaderSpi;
    protected AbstractGridCoverage2DReader gcReader;
    protected MaskOverviewProvider ovrProvider;
    protected MaskOverviewProvider.SpiHelper spiHelper;
    protected Object input;
    protected URL inputURL;
    protected Hints hints;
    protected boolean skipExternalOverviews;

    public DefaultGranuleAccessProvider(Hints hints) {
        this.hints = hints;
        if (hints != null && !hints.isEmpty()) {
            if (hints.containsKey((Object)SUGGESTED_FORMAT)) {
                this.suggestedFormat = (AbstractGridFormat)hints.get((Object)SUGGESTED_FORMAT);
            }
            if (hints.containsKey((Object)SUGGESTED_READER_SPI)) {
                this.imageReaderSpi = (ImageReaderSpi)hints.get((Object)SUGGESTED_READER_SPI);
            }
            if (hints.containsKey((Object)SUGGESTED_STREAM_SPI)) {
                this.imageInputStreamSpi = (ImageInputStreamSpi)hints.get((Object)SUGGESTED_STREAM_SPI);
            }
            if (hints.containsKey((Object)Hints.SKIP_EXTERNAL_OVERVIEWS)) {
                this.skipExternalOverviews = (Boolean)hints.get((Object)Hints.SKIP_EXTERNAL_OVERVIEWS);
            }
        }
    }

    @Override
    public void setGranuleInput(Object input) throws IOException {
        if (input == null || !(input instanceof URL)) {
            throw new IllegalArgumentException("Only URL type is supported by this provider: " + String.valueOf(input));
        }
        this.input = input;
        this.inputURL = (URL)input;
    }

    public URL getInputURL() {
        return this.inputURL;
    }

    @Override
    public AbstractGridFormat getFormat() throws IOException {
        if (this.format == null) {
            this.format = this.suggestedFormat != null && this.suggestedFormat.accepts(this.input, this.hints) ? this.suggestedFormat : GridFormatFinder.findFormat((Object)this.input, (Hints)this.hints);
        }
        if (this.format == null) {
            throw new IOException("Unable to find a format for the specified input: " + String.valueOf(this.input));
        }
        return this.format;
    }

    @Override
    public MaskOverviewProvider getMaskOverviewsProvider() throws IOException {
        if (this.ovrProvider == null) {
            AbstractGridCoverage2DReader reader = this.getGridCoverageReader();
            DatasetLayout layout = reader.getDatasetLayout();
            this.spiHelper = new MaskOverviewProvider.SpiHelper(this.inputURL, this.imageReaderSpi, this.imageInputStreamSpi);
            this.ovrProvider = new MaskOverviewProvider(layout, this.inputURL, this.spiHelper, this.skipExternalOverviews);
        }
        if (this.ovrProvider == null) {
            throw new IOException("Unable to find a MaskOverviewProvider for the specified input: " + String.valueOf(this.inputURL));
        }
        return this.ovrProvider;
    }

    @Override
    public AbstractGridCoverage2DReader getGridCoverageReader() throws IOException {
        if (this.gcReader == null) {
            this.gcReader = this.getFormat().getReader(this.input, this.hints);
        }
        if (this.gcReader == null) {
            throw new IOException("Unable to get a reader for the specified input: " + String.valueOf(this.input));
        }
        return this.gcReader;
    }

    @Override
    public ImageInputStreamSpi getInputStreamSpi() throws IOException {
        return this.getMaskOverviewsProvider().getInputStreamSpi();
    }

    @Override
    public ImageReaderSpi getImageReaderSpi() throws IOException {
        return this.getMaskOverviewsProvider().getImageReaderSpi();
    }

    @Override
    public ImageInputStream getImageInputStream() throws IOException {
        ImageInputStreamSpi streamSpi = this.getInputStreamSpi();
        ImageInputStream inStream = streamSpi.createInputStreamInstance(this.inputURL, ImageIO.getUseCache(), ImageIO.getCacheDirectory());
        if (inStream == null) {
            File file = URLs.urlToFile((URL)this.inputURL);
            if (file != null && LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, Utils.getFileInfo(file));
            }
            throw new IllegalArgumentException("Unable to get an input stream for the provided file " + this.inputURL.toString());
        }
        return inStream;
    }

    @Override
    public ImageReader getImageReader() throws IOException {
        ImageReaderSpi imageReaderSpi = this.getImageReaderSpi();
        if (imageReaderSpi == null) {
            throw new IllegalArgumentException("No ReaderSPI has been found for input: " + this.inputURL.toString());
        }
        ImageReader imageReader = imageReaderSpi.createReaderInstance();
        if (imageReader == null) {
            throw new IllegalArgumentException("Unable to get an ImageReader for the provided file " + this.inputURL.toString());
        }
        return imageReader;
    }

    public static ImageReaderSpi createImageReaderSpiInstance(String spiClass) {
        ImageReaderSpi spi = null;
        if (spiClass != null) {
            try {
                ImageReaderSpi readerSpi;
                Class<?> clazz = Class.forName(spiClass);
                Object spiInstance = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                spi = spiInstance instanceof ImageReaderSpi ? (readerSpi = (ImageReaderSpi)spiInstance) : null;
            }
            catch (Exception e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                }
                spi = null;
            }
        }
        return spi;
    }

    public static ImageInputStreamSpi createImageInputStreamSpiInstance(String spiClass) {
        ImageInputStreamSpi spi = null;
        if (spiClass != null) {
            try {
                ImageInputStreamSpi streamSpi;
                Class<?> clazz = Class.forName(spiClass);
                Object spiInstance = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                spi = spiInstance instanceof ImageInputStreamSpi ? (streamSpi = (ImageInputStreamSpi)spiInstance) : null;
            }
            catch (Exception e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                }
                spi = null;
            }
        }
        return spi;
    }

    public static AbstractGridFormat createFormatInstance(String formatClass) {
        AbstractGridFormat format = null;
        if (formatClass != null) {
            try {
                AbstractGridFormat gridFormat;
                Class<?> clazz = Class.forName(formatClass);
                Object formatInstance = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                format = formatInstance instanceof AbstractGridFormat ? (gridFormat = (AbstractGridFormat)formatInstance) : null;
            }
            catch (Exception e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                }
                format = null;
            }
        }
        return format;
    }

    @Override
    public void update(GranuleDescriptor granuleDescriptor, Hints hints) {
        if (!this.spiHelper.isMultidim()) {
            granuleDescriptor.setGranuleEnvelope(this.gcReader.getOriginalEnvelope());
        }
    }

    @Override
    public GranuleAccessProvider copyProviders() {
        DefaultGranuleAccessProvider provider = new DefaultGranuleAccessProvider(this.hints);
        return provider;
    }
}

