/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.PropertyIsGreaterThanOrEqualTo;
import org.geotools.api.filter.PropertyIsLessThanOrEqualTo;
import org.geotools.api.filter.expression.Expression;
import org.geotools.coverage.util.FeatureUtilities;
import org.geotools.util.Range;
import org.geotools.util.logging.Logging;

public class DomainFilterBuilder {
    static final Logger LOGGER = Logging.getLogger(DomainFilterBuilder.class);
    private final String identifier;
    private final String property;
    private final String endProperty;

    public DomainFilterBuilder(String identifier, String property) {
        this.identifier = identifier;
        this.property = property;
        this.endProperty = null;
    }

    public DomainFilterBuilder(String identifier, String property, String endProperty) {
        this.identifier = identifier;
        this.property = property;
        this.endProperty = endProperty;
    }

    public Filter createFilter(List values) {
        ArrayList<Object> filters = new ArrayList<Object>();
        FilterFactory ff = FeatureUtilities.DEFAULT_FILTER_FACTORY;
        for (Object value : values) {
            Range range;
            if (value == null) {
                if (!LOGGER.isLoggable(Level.INFO)) continue;
                LOGGER.info("Ignoring null date for the filter:" + this.identifier);
                continue;
            }
            if (this.endProperty == null) {
                if (value instanceof Range) {
                    range = (Range)value;
                    filters.add(ff.and((Filter)ff.lessOrEqual((Expression)ff.property(this.property), (Expression)ff.literal((Object)range.getMaxValue())), (Filter)ff.greaterOrEqual((Expression)ff.property(this.property), (Expression)ff.literal((Object)range.getMinValue()))));
                    continue;
                }
                filters.add(ff.equal((Expression)ff.property(this.property), (Expression)ff.literal(value), true));
                continue;
            }
            if (value instanceof Range) {
                Comparable minValue;
                range = (Range)value;
                Comparable maxValue = range.getMaxValue();
                if (maxValue.compareTo(minValue = range.getMinValue()) != 0) {
                    PropertyIsGreaterThanOrEqualTo maxCondition = ff.greaterOrEqual((Expression)ff.literal((Object)maxValue), (Expression)ff.property(this.property));
                    PropertyIsLessThanOrEqualTo minCondition = ff.lessOrEqual((Expression)ff.literal((Object)minValue), (Expression)ff.property(this.endProperty));
                    filters.add(ff.and(Arrays.asList(maxCondition, minCondition)));
                    continue;
                }
                value = maxValue;
            }
            filters.add(ff.and((Filter)ff.lessOrEqual((Expression)ff.property(this.property), (Expression)ff.literal(value)), (Filter)ff.greaterOrEqual((Expression)ff.property(this.endProperty), (Expression)ff.literal(value))));
        }
        if (filters.size() == 1) {
            return (Filter)filters.get(0);
        }
        return ff.or(filters);
    }
}

