/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import java.awt.RenderingHints;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.geotools.coverage.grid.io.DefaultHarvestedSource;
import org.geotools.coverage.grid.io.HarvestedSource;
import org.geotools.gce.imagemosaic.ImageMosaicConfigHandler;
import org.geotools.gce.imagemosaic.ImageMosaicDirectoryWalker;
import org.geotools.gce.imagemosaic.ImageMosaicEventHandlers;
import org.geotools.gce.imagemosaic.ImageMosaicReader;
import org.geotools.gce.imagemosaic.MosaicConfigurationBean;
import org.geotools.gce.imagemosaic.RasterManager;
import org.geotools.gce.imagemosaic.SourceSPIProviderFactory;
import org.geotools.gce.imagemosaic.Utils;
import org.geotools.gce.imagemosaic.catalog.GranuleCatalog;
import org.geotools.gce.imagemosaic.catalog.index.Indexer;
import org.geotools.gce.imagemosaic.catalog.index.IndexerUtils;
import org.geotools.gce.imagemosaic.catalogbuilder.CatalogBuilderConfiguration;
import org.geotools.util.URLs;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
enum HarvestedResource {
    FILE((Class)File.class){

        @Override
        public void harvest(String defaultCoverage, Object source, Hints hints, List<HarvestedSource> result, ImageMosaicReader reader) {
            File file;
            if (source instanceof Collection) {
                Collection collection = (Collection)source;
                file = (File)collection.iterator().next();
            } else {
                file = (File)source;
            }
            HarvestedResource.harvestCollection(defaultCoverage, result, reader, Collections.singletonList(file));
        }
    }
    ,
    DIRECTORY((Class)File.class){

        @Override
        public void harvest(String defaultCoverage, Object source, Hints hints, List<HarvestedSource> result, ImageMosaicReader reader) {
            File directory;
            if (source instanceof Collection) {
                Collection collection = (Collection)source;
                directory = (File)collection.iterator().next();
            } else {
                directory = (File)source;
            }
            HarvestedResource.harvestCalculation(defaultCoverage, result, reader, directory, null);
        }
    }
    ,
    FILE_COLLECTION((Class)File.class){

        @Override
        public void harvest(String defaultCoverage, Object source, Hints hints, List<HarvestedSource> result, ImageMosaicReader reader) {
            Collection files = (Collection)source;
            HarvestedResource.harvestCollection(defaultCoverage, result, reader, files);
        }
    }
    ,
    URL((Class)URL.class){

        @Override
        public void harvest(String defaultCoverage, Object source, Hints hints, List<HarvestedSource> result, ImageMosaicReader reader) {
            HarvestedResource.harvestURLCollection(defaultCoverage, result, reader, Collections.singletonList((URL)source));
        }
    }
    ,
    URL_COLLECTION((Class)URL.class){

        @Override
        public void harvest(String defaultCoverage, Object source, Hints hints, List<HarvestedSource> result, ImageMosaicReader reader) {
            Collection<URL> urls = null;
            if (source instanceof Collection) {
                try {
                    Collection cast = (Collection)source;
                    urls = cast;
                }
                catch (ClassCastException e) {
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.log(Level.WARNING, e.getMessage(), e);
                    }
                }
            } else {
                urls = Collections.singletonList((URL)source);
            }
            HarvestedResource.harvestURLCollection(defaultCoverage, result, reader, urls);
        }
    }
    ,
    URI((Class)URI.class){

        @Override
        public void harvest(String defaultCoverage, Object source, Hints hints, List<HarvestedSource> result, ImageMosaicReader reader) {
            HarvestedResource.harvestURICollection(defaultCoverage, result, reader, Collections.singletonList((URI)source));
        }
    }
    ,
    URI_COLLECTION((Class)URI.class){

        @Override
        public void harvest(String defaultCoverage, Object source, Hints hints, List<HarvestedSource> result, ImageMosaicReader reader) {
            Collection<URI> uris = null;
            if (source instanceof Collection) {
                try {
                    Collection cast = (Collection)source;
                    uris = cast;
                }
                catch (ClassCastException e) {
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.log(Level.WARNING, e.getMessage(), e);
                    }
                }
            } else {
                uris = Collections.singletonList((URI)source);
            }
            HarvestedResource.harvestURICollection(defaultCoverage, result, reader, uris);
        }
    };

    private static final Logger LOGGER;
    Class<?> elementType;

    public abstract void harvest(String var1, Object var2, Hints var3, List<HarvestedSource> var4, ImageMosaicReader var5);

    public static HarvestedResource getResourceFromObject(Object source) {
        if (source instanceof File) {
            File file = (File)source;
            return HarvestedResource.getResourceFromFile(file);
        }
        if (source instanceof URL) {
            return URL;
        }
        if (source instanceof URI) {
            return URI;
        }
        if (source instanceof String) {
            String string = (String)source;
            return HarvestedResource.getResourceFromString(string);
        }
        if (source instanceof Collection) {
            Collection collection = (Collection)source;
            Object sample = collection.iterator().next();
            if (sample instanceof File) {
                Collection files;
                block19: {
                    files = null;
                    try {
                        Collection cast;
                        files = cast = (Collection)source;
                    }
                    catch (ClassCastException e) {
                        if (!LOGGER.isLoggable(Level.WARNING)) break block19;
                        LOGGER.log(Level.WARNING, e.getMessage(), e);
                    }
                }
                if (files != null) {
                    int fileSize = files.size();
                    if (fileSize < 1) {
                        return null;
                    }
                    if (fileSize == 1) {
                        return HarvestedResource.getResourceFromFile((File)files.iterator().next());
                    }
                    return FILE_COLLECTION;
                }
            } else {
                if (sample instanceof URL) {
                    return URL_COLLECTION;
                }
                if (sample instanceof String) {
                    String string = (String)sample;
                    HarvestedResource resource = HarvestedResource.getResourceFromString(string);
                    switch (resource) {
                        case FILE: {
                            return FILE_COLLECTION;
                        }
                        case URL: {
                            return URL_COLLECTION;
                        }
                        case URI: {
                            return URI_COLLECTION;
                        }
                    }
                    throw new RuntimeException("Unexepected collection content: " + String.valueOf((Object)resource));
                }
            }
        }
        return null;
    }

    private static HarvestedResource getResourceFromString(String source) {
        URL url = null;
        try {
            url = new URL(source);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        String protocol = null;
        if (url != null && (protocol = url.getProtocol()) != null && !"file".equalsIgnoreCase(protocol)) {
            return URL;
        }
        try {
            URI uri = new URI(source);
            if (uri.getScheme() != null && !"file".equals(uri.getScheme())) {
                return URI;
            }
        }
        catch (URISyntaxException uri) {
            // empty catch block
        }
        File file = new File(source);
        return HarvestedResource.getResourceFromFile(file);
    }

    private static HarvestedResource getResourceFromFile(File file) {
        if (file != null) {
            if (file.isDirectory()) {
                return DIRECTORY;
            }
            return FILE;
        }
        return null;
    }

    private static void harvestCollection(String defaultCoverage, final List<HarvestedSource> result, final ImageMosaicReader reader, Collection<File> files) {
        CatalogBuilderConfiguration configuration = new CatalogBuilderConfiguration();
        configuration.setParameter("AbsolutePath", Boolean.toString(false));
        Iterator<File> it = files.iterator();
        String indexingPath = it.next().getAbsolutePath();
        configuration.setParameter("HarvestingDirectory", indexingPath);
        if (defaultCoverage == null) {
            String[] coverageNames = reader.getGridCoverageNames();
            defaultCoverage = coverageNames != null && coverageNames.length > 0 ? coverageNames[0] : "index";
        }
        configuration.setParameter("Name", defaultCoverage);
        configuration.setHints(new Hints((RenderingHints.Key)Utils.MOSAIC_READER, (Object)reader));
        File mosaicSource = URLs.urlToFile((URL)reader.sourceURL);
        if (!mosaicSource.isDirectory()) {
            mosaicSource = mosaicSource.getParentFile();
        }
        configuration.setParameter("RootMosaicDirectory", mosaicSource.getAbsolutePath());
        ImageMosaicEventHandlers eventHandler = new ImageMosaicEventHandlers();
        ImageMosaicConfigHandler catalogHandler = new ImageMosaicConfigHandler(configuration, eventHandler){

            @Override
            protected GranuleCatalog buildCatalog() throws IOException {
                return reader.granuleCatalog;
            }
        };
        ImageMosaicReader.ImageMosaicFileCollectionWalker walker = new ImageMosaicReader.ImageMosaicFileCollectionWalker(catalogHandler, eventHandler, files);
        eventHandler.addProcessingEventListener(new ImageMosaicEventHandlers.ProcessingEventListener(){

            @Override
            public void getNotification(ImageMosaicEventHandlers.ProcessingEvent event) {
                if (event instanceof ImageMosaicEventHandlers.FileProcessingEvent) {
                    ImageMosaicEventHandlers.FileProcessingEvent fileEvent = (ImageMosaicEventHandlers.FileProcessingEvent)event;
                    result.add(new DefaultHarvestedSource((Object)fileEvent.getFile(), fileEvent.isIngested(), fileEvent.getMessage()));
                }
            }

            @Override
            public void exceptionOccurred(ImageMosaicEventHandlers.ExceptionEvent event) {
            }
        });
        walker.run();
    }

    private static void harvestURLCollection(String defaultCoverage, final List<HarvestedSource> result, final ImageMosaicReader reader, Collection<URL> urls) {
        CatalogBuilderConfiguration configuration = new CatalogBuilderConfiguration();
        if (defaultCoverage == null) {
            String[] coverageNames = reader.getGridCoverageNames();
            defaultCoverage = coverageNames != null && coverageNames.length > 0 ? coverageNames[0] : "index";
        }
        configuration.setParameter("Name", defaultCoverage);
        configuration.setHints(new Hints((RenderingHints.Key)Utils.MOSAIC_READER, (Object)reader));
        File mosaicSource = URLs.urlToFile((URL)reader.sourceURL);
        if (!mosaicSource.isDirectory()) {
            mosaicSource = mosaicSource.getParentFile();
        }
        String mosaicRootPath = mosaicSource.getAbsolutePath();
        configuration.setParameter("HarvestingDirectory", mosaicRootPath);
        configuration.setParameter("RootMosaicDirectory", mosaicRootPath);
        ImageMosaicEventHandlers eventHandler = new ImageMosaicEventHandlers();
        ImageMosaicConfigHandler catalogHandler = new ImageMosaicConfigHandler(configuration, eventHandler){

            @Override
            protected GranuleCatalog buildCatalog() throws IOException {
                return reader.granuleCatalog;
            }
        };
        SourceSPIProviderFactory urlSourceSPIProvider = null;
        RasterManager rasterManager = reader.getRasterManager(defaultCoverage);
        if (rasterManager == null) {
            Indexer indexer = IndexerUtils.initializeIndexer(null, mosaicSource);
            boolean canBeEmpty = IndexerUtils.getParameterAsBoolean("CanBeEmpty", indexer);
            if (!canBeEmpty) {
                eventHandler.fireException(new IOException("The specified mosaic can't be empty but no default granules have been found"));
                return;
            }
            urlSourceSPIProvider = IndexerUtils.getSourceSPIProviderFactory(indexer);
        } else {
            MosaicConfigurationBean config = rasterManager.getConfiguration();
            urlSourceSPIProvider = config.getCatalogConfigurationBean().getUrlSourceSPIProvider();
        }
        if (urlSourceSPIProvider == null) {
            eventHandler.fireException(new IOException("Unable to harvest the provided URL collection. No source SPI provider has been found"));
            return;
        }
        ImageMosaicReader.ImageMosaicURLCollectionWalker walker = new ImageMosaicReader.ImageMosaicURLCollectionWalker(catalogHandler, eventHandler, urlSourceSPIProvider, urls);
        eventHandler.addProcessingEventListener(new ImageMosaicEventHandlers.ProcessingEventListener(){

            @Override
            public void getNotification(ImageMosaicEventHandlers.ProcessingEvent event) {
                if (event instanceof ImageMosaicEventHandlers.URLProcessingEvent) {
                    ImageMosaicEventHandlers.URLProcessingEvent urlEvent = (ImageMosaicEventHandlers.URLProcessingEvent)event;
                    result.add(new DefaultHarvestedSource((Object)urlEvent.getUrl(), urlEvent.isIngested(), urlEvent.getMessage()));
                }
            }

            @Override
            public void exceptionOccurred(ImageMosaicEventHandlers.ExceptionEvent event) {
            }
        });
        walker.run();
    }

    private static void harvestURICollection(String defaultCoverage, final List<HarvestedSource> result, final ImageMosaicReader reader, Collection<URI> urls) {
        CatalogBuilderConfiguration configuration = new CatalogBuilderConfiguration();
        if (defaultCoverage == null) {
            String[] coverageNames = reader.getGridCoverageNames();
            defaultCoverage = coverageNames != null && coverageNames.length > 0 ? coverageNames[0] : "index";
        }
        configuration.setParameter("Name", defaultCoverage);
        configuration.setHints(new Hints((RenderingHints.Key)Utils.MOSAIC_READER, (Object)reader));
        File mosaicSource = URLs.urlToFile((URL)reader.sourceURL);
        if (!mosaicSource.isDirectory()) {
            mosaicSource = mosaicSource.getParentFile();
        }
        String mosaicRootPath = mosaicSource.getAbsolutePath();
        configuration.setParameter("HarvestingDirectory", mosaicRootPath);
        configuration.setParameter("RootMosaicDirectory", mosaicRootPath);
        ImageMosaicEventHandlers eventHandler = new ImageMosaicEventHandlers();
        ImageMosaicConfigHandler catalogHandler = new ImageMosaicConfigHandler(configuration, eventHandler){

            @Override
            protected GranuleCatalog buildCatalog() throws IOException {
                return reader.granuleCatalog;
            }
        };
        SourceSPIProviderFactory sspFactory = null;
        RasterManager rasterManager = reader.getRasterManager(defaultCoverage);
        if (rasterManager == null) {
            Indexer indexer = IndexerUtils.initializeIndexer(null, mosaicSource);
            boolean canBeEmpty = IndexerUtils.getParameterAsBoolean("CanBeEmpty", indexer);
            if (!canBeEmpty) {
                eventHandler.fireException(new IOException("The specified mosaic can't be empty but no default granules have been found"));
                return;
            }
            sspFactory = IndexerUtils.getSourceSPIProviderFactory(indexer);
        } else {
            MosaicConfigurationBean config = rasterManager.getConfiguration();
            sspFactory = config.getCatalogConfigurationBean().getUrlSourceSPIProvider();
        }
        if (sspFactory == null) {
            eventHandler.fireException(new IOException("Unable to harvest the provided URI collection. No source SPI provider has been found"));
            return;
        }
        ImageMosaicReader.ImageMosaicURICollectionWalker walker = new ImageMosaicReader.ImageMosaicURICollectionWalker(catalogHandler, eventHandler, sspFactory, urls);
        eventHandler.addProcessingEventListener(new ImageMosaicEventHandlers.ProcessingEventListener(){

            @Override
            public void getNotification(ImageMosaicEventHandlers.ProcessingEvent event) {
                if (event instanceof ImageMosaicEventHandlers.URIProcessingEvent) {
                    ImageMosaicEventHandlers.URIProcessingEvent uriEvent = (ImageMosaicEventHandlers.URIProcessingEvent)event;
                    result.add(new DefaultHarvestedSource((Object)uriEvent.getURI(), uriEvent.isIngested(), uriEvent.getMessage()));
                }
            }

            @Override
            public void exceptionOccurred(ImageMosaicEventHandlers.ExceptionEvent event) {
            }
        });
        walker.run();
    }

    private static void harvestCalculation(String defaultCoverage, final List<HarvestedSource> result, ImageMosaicReader reader, File directory, IOFileFilter filter) {
        CatalogBuilderConfiguration configuration = new CatalogBuilderConfiguration();
        configuration.setParameter("AbsolutePath", Boolean.toString(false));
        String indexingPath = directory.getAbsolutePath();
        configuration.setParameter("HarvestingDirectory", indexingPath);
        if (defaultCoverage == null) {
            String[] coverageNames = reader.getGridCoverageNames();
            defaultCoverage = coverageNames != null && coverageNames.length > 0 ? coverageNames[0] : "index";
        }
        configuration.setParameter("Name", defaultCoverage);
        configuration.setHints(new Hints((RenderingHints.Key)Utils.MOSAIC_READER, (Object)reader));
        File mosaicSource = URLs.urlToFile((URL)reader.sourceURL);
        if (!mosaicSource.isDirectory()) {
            mosaicSource = mosaicSource.getParentFile();
        }
        configuration.setParameter("RootMosaicDirectory", mosaicSource.getAbsolutePath());
        ImageMosaicEventHandlers eventHandler = new ImageMosaicEventHandlers();
        HarvestMosaicConfigHandler catalogHandler = new HarvestMosaicConfigHandler(configuration, eventHandler, reader);
        ImageMosaicDirectoryWalker walker = new ImageMosaicDirectoryWalker(catalogHandler, eventHandler, filter);
        eventHandler.addProcessingEventListener(new ImageMosaicEventHandlers.ProcessingEventListener(){

            @Override
            public void getNotification(ImageMosaicEventHandlers.ProcessingEvent event) {
                if (event instanceof ImageMosaicEventHandlers.FileProcessingEvent) {
                    ImageMosaicEventHandlers.FileProcessingEvent fileEvent = (ImageMosaicEventHandlers.FileProcessingEvent)event;
                    result.add(new DefaultHarvestedSource((Object)fileEvent.getFile(), fileEvent.isIngested(), fileEvent.getMessage()));
                }
            }

            @Override
            public void exceptionOccurred(ImageMosaicEventHandlers.ExceptionEvent event) {
            }
        });
        walker.run();
    }

    private HarvestedResource(Class<?> elementType) {
        this.elementType = elementType;
    }

    public Class<?> getElementType() {
        return this.elementType;
    }

    static {
        LOGGER = Logging.getLogger(HarvestedResource.class);
    }

    private static class HarvestMosaicConfigHandler
    extends ImageMosaicConfigHandler {
        private final ImageMosaicReader reader;

        public HarvestMosaicConfigHandler(CatalogBuilderConfiguration configuration, ImageMosaicEventHandlers eventHandler, ImageMosaicReader reader) {
            super(configuration, eventHandler);
            this.reader = reader;
        }

        @Override
        protected GranuleCatalog buildCatalog() throws IOException {
            return this.reader.granuleCatalog;
        }

        @Override
        public Map<String, MosaicConfigurationBean> getConfigurations() {
            Map<String, MosaicConfigurationBean> configurations = super.getConfigurations();
            if (configurations.isEmpty()) {
                for (String coverage : this.reader.getGridCoverageNames()) {
                    MosaicConfigurationBean base = this.reader.getRasterManager(coverage).getConfiguration();
                    configurations.put(coverage, new MosaicConfigurationBean(base));
                }
            }
            return configurations;
        }
    }
}

