/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import it.geosolutions.imageio.core.SourceSPIProvider;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.spi.ImageInputStreamSpi;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.coverage.grid.io.GridFormatFinder;
import org.geotools.coverage.grid.io.UnknownFormat;
import org.geotools.gce.imagemosaic.ImageMosaicConfigHandler;
import org.geotools.gce.imagemosaic.ImageMosaicElementConsumer;
import org.geotools.gce.imagemosaic.ImageMosaicEventHandlers;
import org.geotools.gce.imagemosaic.ImageMosaicSourceElement;
import org.geotools.gce.imagemosaic.ImageMosaicWalker;
import org.geotools.gce.imagemosaic.SourceSPIProviderFactory;
import org.geotools.gce.imagemosaic.Utils;
import org.geotools.gce.imagemosaic.catalogbuilder.CatalogBuilderConfiguration;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;

public class ImageMosaicURIFeatureConsumer
implements ImageMosaicElementConsumer<SimpleFeature> {
    private ImageMosaicURIConsumer imageMosaicURIConsumer;
    static final Logger LOGGER = Logging.getLogger(ImageMosaicURIFeatureConsumer.class);

    public ImageMosaicURIFeatureConsumer(ImageMosaicURIConsumer imageMosaicURIConsumer) {
        this.imageMosaicURIConsumer = imageMosaicURIConsumer;
    }

    @Override
    public boolean checkElement(SimpleFeature feature, ImageMosaicWalker walker) {
        return true;
    }

    @Override
    public void handleElement(SimpleFeature feature, ImageMosaicWalker walker) throws IOException {
        ImageMosaicConfigHandler configHandler = walker.getConfigHandler();
        CatalogBuilderConfiguration runConfiguration = configHandler.getRunConfiguration();
        String locationAttrName = runConfiguration.getParameter("LocationAttribute");
        String location = (String)Utils.getAttribute(feature, locationAttrName);
        if (location == null) {
            throw new IllegalArgumentException("Could not find the location using attribute name: " + locationAttrName);
        }
        try {
            this.imageMosaicURIConsumer.handleElement(new URI(location), walker);
        }
        catch (URISyntaxException e) {
            throw new IOException("Failed to parse location into a URI", e);
        }
    }

    static class ImageMosaicURIConsumer
    implements ImageMosaicElementConsumer<URI> {
        private SourceSPIProviderFactory sourceSPIProvider;

        public ImageMosaicURIConsumer(SourceSPIProviderFactory sourceSPIProvider) {
            this.sourceSPIProvider = sourceSPIProvider;
        }

        @Override
        public boolean checkElement(URI uri, ImageMosaicWalker walker) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleElement(URI uri, ImageMosaicWalker walker) throws IOException {
            int elementIndex = walker.getElementIndex() + 1;
            walker.setElementIndex(elementIndex);
            int numElements = walker.getNumElements();
            ImageMosaicEventHandlers eventHandler = walker.getEventHandler();
            ImageMosaicConfigHandler configHandler = walker.getConfigHandler();
            eventHandler.fireEvent(Level.INFO, "Now indexing uri " + String.valueOf(uri), (double)elementIndex * 100.0 / (double)numElements);
            AbstractGridCoverage2DReader coverageReader = null;
            try {
                String[] coverageNames;
                AbstractGridFormat cachedFormat = configHandler.getCachedFormat();
                SourceSPIProvider readerInputObject = this.sourceSPIProvider.getSourceSPIProvider(uri);
                AbstractGridFormat format = cachedFormat == null ? GridFormatFinder.findFormat((Object)readerInputObject, (Hints)Utils.EXCLUDE_MOSAIC_HINTS) : (cachedFormat.accepts((Object)readerInputObject) ? cachedFormat : GridFormatFinder.findFormat((Object)readerInputObject, (Hints)Utils.EXCLUDE_MOSAIC_HINTS));
                if (format instanceof UnknownFormat || format == null) {
                    eventHandler.fireURIEvent(Level.INFO, uri, false, "Skipped granule " + String.valueOf(uri) + ": format is not supported.", (double)elementIndex * 99.0 / (double)numElements);
                    return;
                }
                Hints configurationHints = configHandler.getRunConfiguration().getHints();
                coverageReader = format.getReader((Object)readerInputObject, configurationHints);
                if (configHandler.getCachedReaderSPI() == null) {
                    ImageInputStreamSpi inStreamSpi = readerInputObject.getStreamSpi();
                    if (inStreamSpi == null) {
                        throw new IllegalArgumentException("no inputStreamSPI available!");
                    }
                    try (ImageInputStream inStream = readerInputObject.getStream();){
                        if (inStream == null) {
                            if (LOGGER.isLoggable(Level.WARNING)) {
                                LOGGER.log(Level.WARNING, "Unable to open a stream on " + String.valueOf(uri));
                            }
                            throw new IllegalArgumentException("Unable to get an input stream for the provided file granule" + String.valueOf(uri));
                        }
                        ImageReaderSpi spi = readerInputObject.getReaderSpi();
                        configHandler.setCachedReaderSPI(spi);
                    }
                }
                for (String cvName : coverageNames = coverageReader.getGridCoverageNames()) {
                    try {
                        configHandler.setCachedFormat(format);
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.FINE, "Failure during potential granule evaluation, skipping it: " + String.valueOf(uri), e);
                    }
                    ImageMosaicSourceElement.URIElement element = new ImageMosaicSourceElement.URIElement(uri);
                    configHandler.updateConfiguration((GridCoverage2DReader)coverageReader, cvName, new ImageMosaicSourceElement.URIElement(uri), elementIndex, (double)numElements, walker.getTransaction());
                    ((ImageMosaicSourceElement)element).fireHarvestingEvent(eventHandler, elementIndex, numElements, "Done with granule " + String.valueOf(uri));
                }
            }
            catch (Exception e) {
                eventHandler.fireException(e);
                walker.stop();
            }
            finally {
                block31: {
                    try {
                        if (coverageReader != null) {
                            coverageReader.dispose();
                        }
                    }
                    catch (Throwable e) {
                        if (!LOGGER.isLoggable(Level.FINEST)) break block31;
                        LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                    }
                }
            }
        }
    }
}

