/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.util.Arrays;
import org.eclipse.imagen.ImageLayout;
import org.eclipse.imagen.ImageN;
import org.eclipse.imagen.PlanarImage;
import org.eclipse.imagen.ROI;
import org.eclipse.imagen.media.mosaic.MosaicDescriptor;
import org.eclipse.imagen.media.mosaic.MosaicType;
import org.eclipse.imagen.media.utilities.ImageLayout2;
import org.geotools.image.ImageWorker;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum MergeBehavior {
    STACK{

        @Override
        public RenderedImage process(RenderedImage[] sources, double[] backgroundValues, double[][] inputThreshold, PlanarImage[] sourceAlpha, ROI[] sourceROI, MosaicType mosaicType, RenderingHints hints) {
            if (sources.length == 1) {
                return FLAT.process(sources, backgroundValues, inputThreshold, sourceAlpha, sourceROI, mosaicType, hints);
            }
            sources = MergeBehavior.harmonizeSources(sources, backgroundValues, inputThreshold, sourceAlpha, sourceROI, hints);
            ImageWorker worker = new ImageWorker(sources[0]);
            worker.setRenderingHints(hints);
            for (int i = 1; i < sources.length; ++i) {
                worker.addBand(sources[i], false);
            }
            return worker.getRenderedImage();
        }
    }
    ,
    FLAT{

        @Override
        public RenderedImage process(RenderedImage[] sources, double[] backgroundValues, double[][] inputThreshold, PlanarImage[] sourceAlpha, ROI[] sourceROI, MosaicType mosaicType, RenderingHints localHints) {
            return new ImageWorker(localHints).setBackground(backgroundValues).mosaic(sources, mosaicType, sourceAlpha, sourceROI, inputThreshold, null).getRenderedImage();
        }
    }
    ,
    MAX{

        @Override
        public RenderedImage process(RenderedImage[] sources, double[] backgroundValues, double[][] inputThreshold, PlanarImage[] sourceAlpha, ROI[] sourceROI, MosaicType mosaicType, RenderingHints localHints) {
            if (sources.length == 1) {
                return FLAT.process(sources, backgroundValues, inputThreshold, sourceAlpha, sourceROI, mosaicType, localHints);
            }
            sources = MergeBehavior.harmonizeSources(sources, backgroundValues, inputThreshold, sourceAlpha, sourceROI, localHints);
            return new ImageWorker(localHints).setImage(sources[0]).max(sources).getRenderedImage();
        }
    }
    ,
    MIN{

        @Override
        public RenderedImage process(RenderedImage[] sources, double[] backgroundValues, double[][] inputThreshold, PlanarImage[] sourceAlpha, ROI[] sourceROI, MosaicType mosaicType, RenderingHints localHints) {
            if (sources.length == 1) {
                return FLAT.process(sources, backgroundValues, inputThreshold, sourceAlpha, sourceROI, mosaicType, localHints);
            }
            sources = MergeBehavior.harmonizeSources(sources, backgroundValues, inputThreshold, sourceAlpha, sourceROI, localHints);
            return new ImageWorker(localHints).setImage(sources[0]).min(sources).getRenderedImage();
        }
    };


    private static RenderedImage[] harmonizeSources(RenderedImage[] sources, double[] backgroundValues, double[][] inputThreshold, PlanarImage[] sourceAlpha, ROI[] sourceROI, RenderingHints hints) {
        RenderingHints localHints;
        RenderedImage[] result = Arrays.copyOf(sources, sources.length);
        Rectangle union = new Rectangle(PlanarImage.wrapRenderedImage((RenderedImage)sources[0]).getBounds());
        boolean performMosaic = false;
        for (int i = 1; i < sources.length; ++i) {
            Rectangle currentExtent = PlanarImage.wrapRenderedImage((RenderedImage)sources[i]).getBounds();
            if (currentExtent.equals(union)) continue;
            performMosaic = true;
            union = union.union(currentExtent);
        }
        if (!performMosaic) {
            return result;
        }
        ImageLayout layout = (ImageLayout)(hints != null ? hints.get(ImageN.KEY_IMAGE_LAYOUT) : new ImageLayout2());
        layout.setWidth(union.width).setHeight(union.height).setMinX(union.x).setMinY(union.y);
        if (hints != null) {
            localHints = (RenderingHints)hints.clone();
            localHints.add(new RenderingHints(ImageN.KEY_IMAGE_LAYOUT, layout));
        } else {
            localHints = new RenderingHints(ImageN.KEY_IMAGE_LAYOUT, layout);
        }
        for (int i = 0; i < sources.length; ++i) {
            ROI[] rOIArray;
            PlanarImage[] planarImageArray;
            if (sourceAlpha == null) {
                planarImageArray = null;
            } else {
                PlanarImage[] planarImageArray2 = new PlanarImage[1];
                planarImageArray = planarImageArray2;
                planarImageArray2[0] = sourceAlpha[i];
            }
            PlanarImage[] sourceAlphas = planarImageArray;
            if (sourceROI == null) {
                rOIArray = null;
            } else {
                ROI[] rOIArray2 = new ROI[1];
                rOIArray = rOIArray2;
                rOIArray2[0] = sourceROI[i];
            }
            ROI[] sourceROIs = rOIArray;
            ImageWorker worker = new ImageWorker(localHints);
            worker.setBackground(backgroundValues);
            result[i] = worker.mosaic(new RenderedImage[]{sources[i]}, MosaicDescriptor.MOSAIC_TYPE_OVERLAY, sourceAlphas, sourceROIs, inputThreshold, null).getRenderedImage();
        }
        return result;
    }

    public abstract RenderedImage process(RenderedImage[] var1, double[] var2, double[][] var3, PlanarImage[] var4, ROI[] var5, MosaicType var6, RenderingHints var7);

    public static MergeBehavior getDefault() {
        return FLAT;
    }

    public static String[] valuesAsStrings() {
        MergeBehavior[] values = MergeBehavior.values();
        String[] valuesS = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            valuesS[i] = values[i].toString();
        }
        return valuesS;
    }
}

