/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import it.geosolutions.imageio.imageioimpl.EnhancedImageReadParam;
import it.geosolutions.imageio.pam.PAMDataset;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageReadParam;
import javax.measure.Unit;
import org.eclipse.imagen.ImageN;
import org.eclipse.imagen.Interpolation;
import org.eclipse.imagen.NotAColorSpace;
import org.eclipse.imagen.PlanarImage;
import org.eclipse.imagen.ROI;
import org.eclipse.imagen.RenderedOp;
import org.eclipse.imagen.media.mosaic.MosaicDescriptor;
import org.eclipse.imagen.media.range.NoDataContainer;
import org.eclipse.imagen.media.range.Range;
import org.eclipse.imagen.media.range.RangeFactory;
import org.eclipse.imagen.media.utilities.ImageLayout2;
import org.eclipse.imagen.operator.ConstantDescriptor;
import org.geotools.api.coverage.ColorInterpretation;
import org.geotools.api.coverage.SampleDimension;
import org.geotools.api.coverage.SampleDimensionType;
import org.geotools.api.coverage.grid.GridEnvelope;
import org.geotools.api.data.DataSourceException;
import org.geotools.api.data.Query;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.filter.And;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.PropertyIsEqualTo;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.geometry.BoundingBox;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.geometry.MismatchedDimensionException;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.datum.PixelInCell;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.api.referencing.operation.MathTransform2D;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.api.util.CodeList;
import org.geotools.api.util.InternationalString;
import org.geotools.coverage.Category;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.TypeMap;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.GranuleSource;
import org.geotools.coverage.grid.io.footprint.FootprintBehavior;
import org.geotools.coverage.util.CoverageUtilities;
import org.geotools.coverage.util.FeatureUtilities;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.gce.imagemosaic.ExcessGranulePolicy;
import org.geotools.gce.imagemosaic.GranuleDescriptor;
import org.geotools.gce.imagemosaic.MergeBehavior;
import org.geotools.gce.imagemosaic.MosaicElement;
import org.geotools.gce.imagemosaic.MosaicInputs;
import org.geotools.gce.imagemosaic.MosaicQueryBuilder;
import org.geotools.gce.imagemosaic.Mosaicker;
import org.geotools.gce.imagemosaic.OverviewsController;
import org.geotools.gce.imagemosaic.RasterLayerRequest;
import org.geotools.gce.imagemosaic.RasterManager;
import org.geotools.gce.imagemosaic.ReadParamsController;
import org.geotools.gce.imagemosaic.SpatialRequestHelper;
import org.geotools.gce.imagemosaic.Utils;
import org.geotools.gce.imagemosaic.catalog.GranuleCatalogVisitor;
import org.geotools.gce.imagemosaic.egr.ROIExcessGranuleRemover;
import org.geotools.gce.imagemosaic.granulecollector.DefaultSubmosaicProducerFactory;
import org.geotools.gce.imagemosaic.granulecollector.SubmosaicProducer;
import org.geotools.gce.imagemosaic.granulecollector.SubmosaicProducerFactory;
import org.geotools.geometry.GeneralBounds;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.geometry.util.XRectangle2D;
import org.geotools.image.ImageWorker;
import org.geotools.image.util.ImageUtilities;
import org.geotools.metadata.i18n.Vocabulary;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.renderer.crs.ProjectionHandler;
import org.geotools.renderer.crs.ProjectionHandlerFinder;
import org.geotools.util.NumberRange;
import org.geotools.util.SimpleInternationalString;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.util.Assert;

public class RasterLayerResponse {
    private final SubmosaicProducerFactory submosaicProducerFactory;
    private static final Logger LOGGER = Logging.getLogger(RasterLayerResponse.class);
    private GridCoverage2D gridCoverage;
    private RasterLayerRequest request;
    private GridCoverageFactory coverageFactory;
    private GeneralBounds coverageEnvelope;
    private RasterManager rasterManager;
    private Color finalTransparentColor;
    private ReferencedEnvelope mosaicBBox;
    private ReferencedEnvelope queryBBox;
    private Rectangle rasterBounds;
    private MathTransform2D finalGridToWorldCorner;
    private MathTransform2D finalWorldToGridCorner;
    private int imageChoice = 0;
    private EnhancedImageReadParam baseReadParameters = new EnhancedImageReadParam();
    private boolean multithreadingAllowed;
    private FootprintBehavior footprintBehavior = FootprintBehavior.None;
    private int defaultArtifactsFilterThreshold = Integer.MIN_VALUE;
    private double artifactsFilterPTileThreshold = 0.1;
    private boolean oversampledRequest;
    private MathTransform baseGridToWorld;
    private double[] virtualNativeResolution;
    private Geometry geometryMask;
    private double maskingBufferPixels;
    private boolean setRoiProperty;
    private boolean heterogeneousCRS;
    private double[] backgroundValues;
    private Hints hints;
    private String granulesPaths;
    private URL sourceUrl;
    private ROIExcessGranuleRemover excessGranuleRemover;

    public RasterLayerResponse(RasterLayerRequest request, RasterManager rasterManager, SubmosaicProducerFactory collectorsFactory) {
        this.request = request;
        this.coverageEnvelope = rasterManager.spatialDomainManager.coverageEnvelope;
        this.coverageFactory = rasterManager.getCoverageFactory();
        this.rasterManager = rasterManager;
        this.hints = rasterManager.getHints();
        this.submosaicProducerFactory = collectorsFactory;
        this.baseGridToWorld = rasterManager.spatialDomainManager.coverageGridToWorld2D;
        this.finalTransparentColor = request.getOutputTransparentColor();
        this.multithreadingAllowed = request.isMultithreadingAllowed();
        this.footprintBehavior = request.getFootprintBehavior();
        this.backgroundValues = request.getBackgroundValues();
        this.defaultArtifactsFilterThreshold = request.getDefaultArtifactsFilterThreshold();
        this.artifactsFilterPTileThreshold = request.getArtifactsFilterPTileThreshold();
        this.virtualNativeResolution = request.getVirtualNativeResolution();
        this.geometryMask = request.getGeometryMask();
        this.maskingBufferPixels = request.getMaskingBufferPixels();
        this.setRoiProperty = request.isSetRoiProperty();
    }

    public GridCoverage2D createResponse() throws IOException {
        this.processRequest();
        return this.gridCoverage;
    }

    public RasterLayerRequest getOriginatingCoverageRequest() {
        return this.request;
    }

    private void processRequest() throws IOException {
        if (this.request.isEmpty()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Request is empty: " + this.request.toString());
            }
            this.gridCoverage = null;
            return;
        }
        MosaicOutput mosaic = this.prepareResponse();
        if (mosaic == null || mosaic.image == null) {
            this.gridCoverage = null;
            return;
        }
        MosaicOutput finalMosaic = this.postProcessRaster(mosaic);
        this.gridCoverage = this.prepareCoverage(finalMosaic);
    }

    private MosaicOutput postProcessRaster(MosaicOutput mosaickedImage) {
        if (this.finalTransparentColor != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Support for alpha on final mosaic");
            }
            ImageWorker imageWorker = new ImageWorker(mosaickedImage.image);
            imageWorker.makeColorTransparent(this.finalTransparentColor);
            RenderedOp image = imageWorker.getRenderedOperation();
            if (imageWorker.getROI() != null) {
                image.setProperty("ROI", (Object)imageWorker.getROI());
            }
            return new MosaicOutput((RenderedImage)image, mosaickedImage.pamDataset);
        }
        return mosaickedImage;
    }

    private MosaicOutput prepareResponse() throws DataSourceException {
        try {
            this.chooseOverview();
            this.initBBOX();
            this.initTransformations();
            this.initRasterBounds();
            this.initBands();
            this.initExcessGranuleRemover();
            MosaicQueryBuilder queryBuilder = new MosaicQueryBuilder(this.request, this.queryBBox);
            Query query = queryBuilder.build();
            List<SubmosaicProducer> producers = this.submosaicProducerFactory.createProducers(this.getRequest(), this.getRasterManager(), this, false);
            for (SubmosaicProducer producer : producers) {
                producer.init(query);
            }
            MosaicProducer visitor = new MosaicProducer(producers);
            this.rasterManager.getGranuleDescriptors(query, visitor);
            this.heterogeneousCRS = visitor.heterogeneousCRS;
            MosaicOutput returnValue = visitor.produce();
            if (returnValue != null) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Loaded bbox " + this.queryBBox.toString() + " while crop bbox " + this.request.spatialRequestHelper.getComputedBBox().toString());
                }
                return returnValue;
            }
            if (visitor.granulesNumber == 0) {
                LOGGER.fine("We got no granules, let's do a dry run with no filters");
                List<SubmosaicProducer> collectors = this.submosaicProducerFactory.createProducers(this.getRequest(), this.getRasterManager(), this, true);
                for (SubmosaicProducer producer : collectors) {
                    producer.init(query);
                }
                MosaicProducer dryRunVisitor = new MosaicProducer(true, collectors);
                Utils.BBOXFilterExtractor bboxExtractor = new Utils.BBOXFilterExtractor();
                query.getFilter().accept((FilterVisitor)bboxExtractor, null);
                query.setFilter((Filter)FeatureUtilities.DEFAULT_FILTER_FACTORY.bbox((Expression)FeatureUtilities.DEFAULT_FILTER_FACTORY.property(this.rasterManager.getGranuleCatalog().getType(this.rasterManager.getTypeName()).getGeometryDescriptor().getName()), (BoundingBox)bboxExtractor.getBBox()));
                query.setMaxFeatures(1);
                query.setSortBy(null);
                this.rasterManager.getGranuleDescriptors(query, dryRunVisitor);
                if (dryRunVisitor.granulesNumber > 0) {
                    LOGGER.fine("Dry run got a target granule, returning null as the additional filters did filter all the granules out");
                    return null;
                }
            }
            if (!this.queryBBox.intersects(ReferencedEnvelope.reference((Bounds)this.coverageEnvelope)) && !this.queryBBox.intersects(ReferencedEnvelope.reference(this.rasterManager.spatialDomainManager.coverageBBox))) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Could not locate any granule in the requested bbox, returning null as it does not match the cached bbox of the mosaic");
                }
                return null;
            }
            return this.createBlankResponse();
        }
        catch (Exception e) {
            throw new DataSourceException("Unable to create this mosaic", e);
        }
    }

    private void initBands() {
        this.baseReadParameters.setBands(this.request.getBands());
    }

    private void initExcessGranuleRemover() {
        if (this.request.getExcessGranuleRemovalPolicy() == ExcessGranulePolicy.ROI) {
            int tileHeight;
            int tileWidth;
            Dimension tileDimensions = this.request.getTileDimensions();
            if (tileDimensions != null) {
                tileWidth = (int)tileDimensions.getWidth();
                tileHeight = (int)tileDimensions.getHeight();
            } else {
                tileHeight = 256;
                tileWidth = 256;
            }
            this.excessGranuleRemover = new ROIExcessGranuleRemover(this.rasterBounds, tileWidth, tileHeight, this.rasterManager.getConfiguration().getCrs());
        }
    }

    private void initRasterBounds() throws TransformException {
        GeneralBounds tempRasterBounds = CRS.transform((MathTransform)this.finalWorldToGridCorner, (Bounds)this.mosaicBBox);
        this.rasterBounds = tempRasterBounds.toRectangle2D().getBounds();
        this.rasterBounds = new GridEnvelope2D(new ReferencedEnvelope((Bounds)tempRasterBounds), PixelInCell.CELL_CORNER);
        if (this.rasterBounds.width == 0) {
            ++this.rasterBounds.width;
        }
        if (this.rasterBounds.height == 0) {
            ++this.rasterBounds.height;
        }
        if (this.oversampledRequest) {
            this.rasterBounds.grow(2, 2);
        }
        if (!this.request.spatialRequestHelper.isSupportingAlternativeCRSOutput()) {
            GeneralBounds levelRasterArea_ = CRS.transform((MathTransform)this.finalWorldToGridCorner, (Bounds)this.request.spatialRequestHelper.getCoverageBBox());
            GridEnvelope2D levelRasterArea = new GridEnvelope2D(new ReferencedEnvelope((Bounds)levelRasterArea_), PixelInCell.CELL_CORNER);
            XRectangle2D.intersect((Rectangle2D)levelRasterArea, (Rectangle2D)this.rasterBounds, (Rectangle2D)this.rasterBounds);
        }
    }

    private void initTransformations() throws Exception {
        AffineTransform g2w;
        SpatialRequestHelper spatialRequestHelper = this.request.spatialRequestHelper;
        if (!this.request.isHeterogeneousGranules()) {
            OverviewsController.OverviewLevel baseLevel = this.rasterManager.overviewsController.resolutionsLevels.get(0);
            OverviewsController.OverviewLevel selectedLevel = this.rasterManager.overviewsController.resolutionsLevels.get(this.imageChoice);
            double resX = baseLevel.resolutionX;
            double resY = baseLevel.resolutionY;
            double[] requestRes = spatialRequestHelper.getComputedResolution();
            BoundingBox computedBBox = spatialRequestHelper.getComputedBBox();
            GeneralBounds requestedRasterArea = CRS.transform((MathTransform)this.baseGridToWorld.inverse(), (Bounds)computedBBox);
            double minxRaster = Math.round(requestedRasterArea.getMinimum(0));
            double minyRaster = Math.round(requestedRasterArea.getMinimum(1));
            AffineTransform at = (AffineTransform)this.baseGridToWorld;
            Point2D.Double src = new Point2D.Double(minxRaster, minyRaster);
            Point2D.Double dst = new Point2D.Double();
            at.transform(src, dst);
            g2w = new AffineTransform(at.getScaleX(), at.getShearX(), at.getShearY(), at.getScaleY(), ((Point2D)dst).getX(), ((Point2D)dst).getY());
            g2w.concatenate(CoverageUtilities.CENTER_TO_CORNER);
            if (requestRes[0] < resX || requestRes[1] < resY) {
                this.oversampledRequest = true;
            }
            if (this.virtualNativeResolution != null && !Double.isNaN(this.virtualNativeResolution[0]) && !Double.isNaN(this.virtualNativeResolution[1])) {
                this.oversampledRequest = this.virtualNativeResolution[0] < resX || this.virtualNativeResolution[1] < resY;
            }
            if (!this.oversampledRequest) {
                g2w.concatenate(AffineTransform.getScaleInstance(selectedLevel.scaleFactor, selectedLevel.scaleFactor));
                g2w.concatenate(AffineTransform.getScaleInstance(this.baseReadParameters.getSourceXSubsampling(), this.baseReadParameters.getSourceYSubsampling()));
            }
        } else {
            g2w = new AffineTransform(spatialRequestHelper.getComputedGridToWorld());
            g2w.concatenate(CoverageUtilities.CENTER_TO_CORNER);
        }
        this.finalGridToWorldCorner = new AffineTransform2D(g2w);
        this.finalWorldToGridCorner = this.finalGridToWorldCorner.inverse();
    }

    private void initBBOX() {
        BoundingBox cropBBOX = this.request.spatialRequestHelper.getComputedBBox();
        if (cropBBOX != null) {
            this.mosaicBBox = this.queryBBox = ReferencedEnvelope.reference((Bounds)cropBBOX);
            if (this.request.spatialRequestHelper.isSupportingAlternativeCRSOutput()) {
                this.mosaicBBox = ReferencedEnvelope.reference((Bounds)this.request.spatialRequestHelper.getComputedBBox(true));
            }
        } else {
            this.mosaicBBox = this.queryBBox = new ReferencedEnvelope((Bounds)this.coverageEnvelope);
        }
    }

    private void chooseOverview() throws IOException, TransformException {
        this.imageChoice = this.request.spatialRequestHelper.getComputedBBox() != null && this.request.spatialRequestHelper.getComputedRasterArea() != null && !this.request.isHeterogeneousGranules() ? ReadParamsController.setReadParams(this.request.spatialRequestHelper.getComputedResolution(), this.request.getOverviewPolicy(), this.request.getDecimationPolicy(), (ImageReadParam)this.baseReadParameters, this.request.rasterManager, this.request.rasterManager.overviewsController, this.virtualNativeResolution) : 0;
        assert (this.imageChoice >= 0);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Loading level " + this.imageChoice + " with subsampling factors " + this.baseReadParameters.getSourceXSubsampling() + " " + this.baseReadParameters.getSourceYSubsampling());
        }
    }

    private MosaicOutput createBlankResponse() {
        Color inputTransparentColor;
        Object finalImage;
        LOGGER.fine("Creating constant image for area with no data");
        ImageLayout2 il = new ImageLayout2();
        ColorModel cm = this.rasterManager.defaultCM;
        SampleModel sm = this.rasterManager.defaultSM;
        int[] bands = this.baseReadParameters.getBands();
        if (bands != null && cm != null && bands.length != cm.getNumComponents()) {
            int nBands = bands.length;
            ColorSpace cs = null;
            switch (nBands) {
                case 1: {
                    cs = ColorSpace.getInstance(1003);
                    break;
                }
                case 3: {
                    cs = ColorSpace.getInstance(1000);
                    break;
                }
                default: {
                    cs = new NotAColorSpace(nBands);
                }
            }
            cm = new ComponentColorModel(cs, cm.hasAlpha(), cm.isAlphaPremultiplied(), cm.getTransparency(), cm.getTransferType());
            sm = cm.createCompatibleSampleModel(sm.getWidth(), sm.getHeight());
        }
        il.setColorModel(cm);
        Dimension tileSize = this.request.getTileDimensions();
        if (tileSize == null) {
            tileSize = ImageN.getDefaultTileSize();
        }
        il.setTileGridXOffset(0).setTileGridYOffset(0).setTileWidth((int)tileSize.getWidth()).setTileHeight((int)tileSize.getHeight());
        RenderingHints renderingHints = new RenderingHints(ImageN.KEY_IMAGE_LAYOUT, il);
        Double noData = this.rasterManager.getConfiguration().getNoData();
        if (this.backgroundValues == null && noData != null) {
            this.backgroundValues = new double[]{noData};
        }
        Number[] values = ImageUtilities.getBackgroundValues((SampleModel)this.rasterManager.defaultSM, (double[])this.backgroundValues);
        if (ImageUtilities.isMediaLibAvailable()) {
            finalImage = ConstantDescriptor.create((Float)Float.valueOf(this.rasterBounds.width), (Float)Float.valueOf(this.rasterBounds.height), (Number[])values, (RenderingHints)renderingHints);
            if (this.rasterBounds.x != 0 || this.rasterBounds.y != 0) {
                ImageWorker w = new ImageWorker((RenderedImage)finalImage);
                w.translate((float)this.rasterBounds.x, (float)this.rasterBounds.y, Interpolation.getInstance((int)0));
                finalImage = w.getRenderedImage();
            }
            if (cm != null) {
                il.setColorModel(cm);
                il.setSampleModel(cm.createCompatibleSampleModel(tileSize.width, tileSize.height));
                finalImage = new ImageWorker((RenderedImage)finalImage).setRenderingHints(renderingHints).format(il.getSampleModel(null).getDataType()).getRenderedImage();
            }
        } else {
            double[] bkgValues;
            il.setWidth(this.rasterBounds.width).setHeight(this.rasterBounds.height);
            if (this.rasterBounds.x != 0 || this.rasterBounds.y != 0) {
                il.setMinX(this.rasterBounds.x).setMinY(this.rasterBounds.y);
            }
            if (cm == null) {
                byte[] arr = new byte[]{0, -1};
                cm = new IndexColorModel(1, 2, arr, arr, arr);
            }
            il.setColorModel(cm);
            il.setSampleModel(cm.createCompatibleSampleModel(tileSize.width, tileSize.height));
            if (bands != null && bands.length != 0) {
                bkgValues = new double[bands.length];
                for (int k = 0; k < bands.length; ++k) {
                    int index = k > values.length ? 0 : bands[k];
                    bkgValues[k] = values[index].doubleValue();
                }
            } else {
                bkgValues = new double[values.length];
                for (int i = 0; i < values.length; ++i) {
                    bkgValues[i] = values[i].doubleValue();
                }
            }
            Assert.isTrue((boolean)il.isValid(268));
            ImageWorker w = new ImageWorker(renderingHints);
            w.setBackground(bkgValues);
            w.mosaic(new RenderedImage[0], MosaicDescriptor.MOSAIC_TYPE_OVERLAY, null, null, (double[][])new double[][]{{CoverageUtilities.getMosaicThreshold((int)il.getSampleModel(null).getDataType())}}, new Range[]{RangeFactory.create((int)0, (int)0)});
            if (noData != null) {
                w.setNoData((Range)RangeFactory.create((double)noData, (double)noData));
            }
            finalImage = w.getRenderedImage();
        }
        if (!((inputTransparentColor = this.request.getInputTransparentColor()) == null || this.footprintBehavior != null && this.footprintBehavior.handleFootprints())) {
            boolean hasAlpha;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Support for alpha on blank image");
            }
            if (!(hasAlpha = (finalImage = new ImageWorker((RenderedImage)finalImage).makeColorTransparent(inputTransparentColor).getRenderedImage()).getColorModel().hasAlpha())) {
                finalImage = new ImageWorker((RenderedImage)finalImage).forceComponentColorModel(true).makeColorTransparent(inputTransparentColor).getRenderedImage();
                hasAlpha = finalImage.getColorModel().hasAlpha();
            }
            assert (hasAlpha);
        } else if (this.footprintBehavior != null) {
            finalImage = this.footprintBehavior.postProcessBlankResponse((RenderedImage)finalImage, renderingHints);
        }
        return new MosaicOutput((RenderedImage)finalImage, null);
    }

    private GridCoverage2D prepareCoverage(MosaicOutput mosaicOutput) throws IOException {
        int numBands;
        RenderedImage image = mosaicOutput.image;
        SampleModel sm = image.getSampleModel();
        ColorModel cm = image.getColorModel();
        int n = numBands = this.request.getBands() == null ? sm.getNumBands() : this.request.getBands().length;
        if (this.rasterManager.providedBandsNames != null && this.rasterManager.providedBandsNames.length != numBands && this.request.getBands() == null) {
            throw new IllegalArgumentException("The number of provided bands names is different from the number of bands.");
        }
        GridSampleDimension[] bands = new GridSampleDimension[numBands];
        HashSet bandNames = new HashSet();
        for (int i = 0; i < numBands; ++i) {
            double noData;
            ColorInterpretation colorInterpretation = null;
            Object bandName = null;
            if (this.rasterManager.providedBandsNames != null) {
                bandName = this.request.getBands() == null ? this.rasterManager.providedBandsNames[i] : this.rasterManager.providedBandsNames[this.request.getBands()[i]];
            }
            if (cm != null) {
                colorInterpretation = TypeMap.getColorInterpretation((ColorModel)cm, (int)i);
                if (colorInterpretation == null) {
                    throw new IOException("Unrecognized sample dimension type");
                }
                if (bandName == null) {
                    bandName = colorInterpretation.name();
                    if (colorInterpretation == ColorInterpretation.UNDEFINED || bandNames.contains(bandName)) {
                        bandName = "Band" + (i + 1);
                    }
                }
            } else {
                if (bandName == null) {
                    bandName = "Band" + (i + 1);
                }
                colorInterpretation = ColorInterpretation.UNDEFINED;
            }
            SampleDimensionType st = TypeMap.getSampleDimensionType((SampleModel)sm, (int)i);
            double min = -1.7976931348623157E308;
            double max = Double.MAX_VALUE;
            Double noDataAsProperty = this.getNoDataProperty(image);
            if (noDataAsProperty != null) {
                noData = noDataAsProperty;
            } else if (this.backgroundValues != null) {
                noData = this.backgroundValues[this.backgroundValues.length > i ? i : 0];
            } else if (st.compareTo((CodeList)SampleDimensionType.REAL_32BITS) == 0) {
                noData = Double.NaN;
            } else if (st.compareTo((CodeList)SampleDimensionType.REAL_64BITS) == 0) {
                noData = Double.NaN;
            } else if (st.compareTo((CodeList)SampleDimensionType.SIGNED_16BITS) == 0) {
                noData = -32768.0;
                min = -32768.0;
                max = 32767.0;
            } else if (st.compareTo((CodeList)SampleDimensionType.SIGNED_32BITS) == 0) {
                noData = -2.147483648E9;
                min = -2.147483648E9;
                max = 2.147483647E9;
            } else if (st.compareTo((CodeList)SampleDimensionType.SIGNED_8BITS) == 0) {
                noData = -128.0;
                min = -128.0;
                max = 127.0;
            } else {
                noData = 0.0;
                min = 0.0;
                if (st.compareTo((CodeList)SampleDimensionType.UNSIGNED_1BIT) == 0) {
                    max = 1.0;
                } else if (st.compareTo((CodeList)SampleDimensionType.UNSIGNED_2BITS) == 0) {
                    max = 3.0;
                } else if (st.compareTo((CodeList)SampleDimensionType.UNSIGNED_4BITS) == 0) {
                    max = 7.0;
                } else if (st.compareTo((CodeList)SampleDimensionType.UNSIGNED_8BITS) == 0) {
                    max = 255.0;
                } else if (st.compareTo((CodeList)SampleDimensionType.UNSIGNED_16BITS) == 0) {
                    max = 65535.0;
                } else if (st.compareTo((CodeList)SampleDimensionType.UNSIGNED_32BITS) == 0) {
                    max = Math.pow(2.0, 32.0) - 1.0;
                }
            }
            bands[i] = new SimplifiedGridSampleDimension((CharSequence)bandName, st, colorInterpretation, noData, min, max, 1.0, 0.0, null);
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (this.granulesPaths != null) {
            properties.put("OriginalFileSource", this.granulesPaths);
        }
        if (this.sourceUrl != null) {
            properties.put("SourceUrl", this.sourceUrl);
        }
        if (mosaicOutput.pamDataset != null) {
            properties.put("PamDataset", mosaicOutput.pamDataset);
        }
        ImageWorker w = new ImageWorker(image);
        CoverageUtilities.setNoDataProperty(properties, (Object)w.getNoData());
        Object property = image.getProperty("ROI");
        if (property != null && property instanceof ROI) {
            ROI oI = (ROI)property;
            CoverageUtilities.setROIProperty(properties, (ROI)oI);
        }
        return this.coverageFactory.create((CharSequence)this.rasterManager.getCoverageIdentifier(), image, new GridGeometry2D((GridEnvelope)new GridEnvelope2D(PlanarImage.wrapRenderedImage((RenderedImage)image).getBounds()), PixelInCell.CELL_CORNER, (MathTransform)this.finalGridToWorldCorner, this.mosaicBBox.getCoordinateReferenceSystem(), this.hints), bands, null, properties);
    }

    private Double getNoDataProperty(RenderedImage image) {
        Object obj;
        if (image != null && (obj = image.getProperty("GC_NODATA")) != null) {
            if (obj instanceof NoDataContainer) {
                NoDataContainer container = (NoDataContainer)obj;
                return container.getAsSingleValue();
            }
            if (obj instanceof Double) {
                Double double1 = (Double)obj;
                return double1;
            }
        }
        return null;
    }

    public RasterLayerRequest getRequest() {
        return this.request;
    }

    public FootprintBehavior getFootprintBehavior() {
        return this.footprintBehavior;
    }

    public ImageReadParam getBaseReadParameters() {
        return this.baseReadParameters;
    }

    public MathTransform2D getFinalGridToWorldCorner() {
        return this.finalGridToWorldCorner;
    }

    public MathTransform2D getFinalWorldToGridCorner() {
        return this.finalWorldToGridCorner;
    }

    public ReferencedEnvelope getMosaicBBox() {
        return this.mosaicBBox;
    }

    public Color getFinalTransparentColor() {
        return this.finalTransparentColor;
    }

    public Rectangle getRasterBounds() {
        return this.rasterBounds;
    }

    public MathTransform getBaseGridToWorld() {
        return this.baseGridToWorld;
    }

    public int getImageChoice() {
        return this.imageChoice;
    }

    public void setImageChoice(int imageChoice) {
        this.imageChoice = imageChoice;
    }

    public boolean isMultithreadingAllowed() {
        return this.multithreadingAllowed;
    }

    public RasterManager getRasterManager() {
        return this.rasterManager;
    }

    public Hints getHints() {
        return this.hints;
    }

    public void setGranulesPaths(String granulesPaths) {
        this.granulesPaths = granulesPaths;
    }

    public void addGranulePaths(String granulesPaths) {
        if (granulesPaths == null) {
            return;
        }
        if (this.granulesPaths == null || this.granulesPaths.isEmpty()) {
            this.granulesPaths = granulesPaths;
        } else if (!granulesPaths.isEmpty()) {
            this.granulesPaths = this.granulesPaths + "," + granulesPaths;
        }
    }

    public void setSourceUrl(URL sourceUrl) {
        this.sourceUrl = sourceUrl;
    }

    public int getDefaultArtifactsFilterThreshold() {
        return this.defaultArtifactsFilterThreshold;
    }

    public double getArtifactsFilterPTileThreshold() {
        return this.artifactsFilterPTileThreshold;
    }

    public double[] getBackgroundValues() {
        return this.backgroundValues;
    }

    public ROIExcessGranuleRemover getExcessGranuleRemover() {
        return this.excessGranuleRemover;
    }

    public Geometry getGeometryMask() {
        return this.geometryMask;
    }

    public double getMaskingBufferPixels() {
        return this.maskingBufferPixels;
    }

    public boolean isSetRoiProperty() {
        return this.setRoiProperty;
    }

    public boolean isHeterogeneousCRS() {
        return this.heterogeneousCRS;
    }

    public RasterLayerResponse reprojectTo(final GranuleDescriptor templateDescriptor) throws Exception {
        final CoordinateReferenceSystem granuleCRS = templateDescriptor.getGranuleEnvelope().getCoordinateReferenceSystem();
        RasterLayerRequest originalRequest = this.getRequest();
        CoordinateReferenceSystem referenceCRS = originalRequest.spatialRequestHelper.getReferenceCRS(true);
        if (CRS.equalsIgnoreMetadata((Object)referenceCRS, (Object)granuleCRS)) {
            return this;
        }
        RasterManager originalRasterManager = originalRequest.getRasterManager();
        final RasterManager manager = originalRasterManager.getForGranuleCRS(this.request, templateDescriptor, this.mosaicBBox, originalRequest.spatialRequestHelper.isSupportingAlternativeCRSOutput() ? this.queryBBox : this.mosaicBBox);
        RasterLayerRequest request = new RasterLayerRequest(originalRequest.getParams(), manager){

            @Override
            protected ReferencedEnvelope computeCoverageBoundingBox(RasterManager rasterManager) throws IOException {
                if (this.filter != null && !Filter.INCLUDE.equals(this.filter)) {
                    SimpleFeatureCollection features;
                    ReferencedEnvelope envelope;
                    GranuleSource granules = rasterManager.getGranuleSource(true, null);
                    String crsAttribute = manager.getCrsAttribute();
                    String granuleCRSCode = (String)Utils.getAttribute(templateDescriptor.getOriginator(), crsAttribute);
                    FilterFactory ff = FeatureUtilities.DEFAULT_FILTER_FACTORY;
                    PropertyIsEqualTo crsFilter = ff.equal((Expression)ff.property(crsAttribute), (Expression)ff.literal((Object)granuleCRSCode), false);
                    And composite = ff.and((Filter)crsFilter, this.filter);
                    Query query = new Query(granules.getSchema().getTypeName(), (Filter)composite);
                    GeometryDescriptor gd = granules.getSchema().getGeometryDescriptor();
                    if (gd != null) {
                        query.setPropertyNames(gd.getLocalName());
                    }
                    if ((envelope = DataUtilities.bounds(features = granules.getGranules(query))) != null && !envelope.isEmpty()) {
                        try {
                            return envelope.transform(granuleCRS, true);
                        }
                        catch (FactoryException | TransformException e) {
                            LOGGER.log(Level.FINE, "Could not transform filtered envelope into target granule CRS, falling back on mosaic");
                        }
                    }
                }
                return rasterManager.spatialDomainManager.coverageBBox;
            }
        };
        if (request.getFootprintBehavior() == FootprintBehavior.Transparent) {
            request.setFootprintBehavior(FootprintBehavior.Cut);
        }
        if (request.spatialRequestHelper.isEmpty()) {
            return null;
        }
        RasterLayerResponse response = new RasterLayerResponse(request, manager, this.submosaicProducerFactory){

            @Override
            public void addGranulePaths(String granulesPaths) {
                RasterLayerResponse.this.addGranulePaths(granulesPaths);
            }
        };
        response.chooseOverview();
        response.initBBOX();
        response.initTransformations();
        response.initRasterBounds();
        response.initBands();
        return response;
    }

    static class MosaicOutput {
        RenderedImage image;
        PAMDataset pamDataset;

        public MosaicOutput(MosaicElement element) {
            this.image = element.source;
            this.pamDataset = element.pamDataset;
        }

        public MosaicOutput(RenderedImage image, PAMDataset pamDataset) {
            this.image = image;
            this.pamDataset = pamDataset;
        }

        public RenderedImage getImage() {
            return this.image;
        }

        public void setImage(RenderedImage image) {
            this.image = image;
        }

        public PAMDataset getPamDataset() {
            return this.pamDataset;
        }

        public void setPamDataset(PAMDataset pamDataset) {
            this.pamDataset = pamDataset;
        }
    }

    private class MosaicProducer
    implements GranuleCatalogVisitor {
        private int granulesNumber;
        private MergeBehavior mergeBehavior;
        private List<SubmosaicProducer> granuleCollectors = new ArrayList<SubmosaicProducer>();
        private boolean heterogeneousCRS;
        private Set<String> visitedGranules;

        private MosaicProducer(List<SubmosaicProducer> collectors) {
            this(false, collectors);
        }

        private MosaicProducer(boolean dryRun, List<SubmosaicProducer> collectors) {
            this.granuleCollectors = collectors;
            this.mergeBehavior = RasterLayerResponse.this.request.getMergeBehavior();
            this.heterogeneousCRS = collectors.stream().anyMatch(c -> c.isReprojecting());
            this.visitedGranules = RasterLayerResponse.this.request.isSkipDuplicates() ? new HashSet() : null;
        }

        @Override
        public void visit(GranuleDescriptor granuleDescriptor, SimpleFeature sf) {
            Polygon bb = JTS.toGeometry((BoundingBox)RasterLayerResponse.this.queryBBox);
            Geometry inclusionGeometry = granuleDescriptor.getFootprint();
            String granuleUrl = granuleDescriptor.getGranuleUrl().toExternalForm();
            boolean intersects = false;
            if (inclusionGeometry != null) {
                CoordinateReferenceSystem granuleCRS = granuleDescriptor.getGranuleEnvelope().getCoordinateReferenceSystem();
                CoordinateReferenceSystem mosaicCRS = RasterLayerResponse.this.queryBBox.getCoordinateReferenceSystem();
                try {
                    if (!CRS.equalsIgnoreMetadata((Object)granuleCRS, (Object)mosaicCRS)) {
                        ProjectionHandler handler = ProjectionHandlerFinder.getHandler(RasterLayerResponse.this.queryBBox, granuleCRS, true);
                        MathTransform mt = CRS.findMathTransform((CoordinateReferenceSystem)granuleCRS, (CoordinateReferenceSystem)mosaicCRS);
                        if (handler != null) {
                            Geometry preProcessed = handler.preProcess(inclusionGeometry);
                            if (preProcessed != null) {
                                Geometry transformed = JTS.transform(inclusionGeometry, mt);
                                inclusionGeometry = handler.postProcess(mt.inverse(), transformed);
                            }
                        } else {
                            inclusionGeometry = JTS.transform(inclusionGeometry, mt);
                        }
                    }
                    intersects = inclusionGeometry.intersects((Geometry)bb);
                }
                catch (MismatchedDimensionException | FactoryException | TransformException e) {
                    intersects = true;
                }
                intersects = inclusionGeometry.intersects((Geometry)bb);
            }
            if (!RasterLayerResponse.this.footprintBehavior.handleFootprints() || inclusionGeometry == null || RasterLayerResponse.this.footprintBehavior.handleFootprints() && intersects) {
                boolean found = false;
                if (this.visitedGranules != null && this.visitedGranules.contains(granuleUrl)) {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("We already have this granule, skipping it: " + String.valueOf(granuleDescriptor));
                    }
                    return;
                }
                for (SubmosaicProducer submosaicProducer : this.granuleCollectors) {
                    if (!submosaicProducer.accept(granuleDescriptor)) continue;
                    ++this.granulesNumber;
                    if (this.visitedGranules != null) {
                        this.visitedGranules.add(granuleUrl);
                    }
                    found = true;
                    break;
                }
                if (!found && RasterLayerResponse.this.getExcessGranuleRemover() == null && !this.heterogeneousCRS) {
                    throw new IllegalStateException("Unable to locate a granule collector accepting this granule:\n" + granuleDescriptor.toString());
                }
            } else if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("We rejected for non ROI inclusion the granule " + granuleDescriptor.toString());
            }
        }

        @Override
        public boolean isVisitComplete() {
            ROIExcessGranuleRemover remover = RasterLayerResponse.this.getExcessGranuleRemover();
            return remover != null && remover.isRenderingAreaComplete();
        }

        private MosaicOutput produce() throws IOException {
            if (this.granulesNumber == 0) {
                LOGGER.log(Level.FINE, "Unable to load any granuleDescriptor");
                return null;
            }
            LOGGER.fine("Producing the final mosaic, step 1, loop through granule collectors");
            ArrayList<MosaicElement> mosaicInputs = new ArrayList<MosaicElement>();
            SubmosaicProducer first = null;
            int size = 0;
            for (SubmosaicProducer collector : this.granuleCollectors) {
                List<MosaicElement> preparedMosaic;
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.fine("Submosaic producer being called: " + collector.toString());
                }
                if ((preparedMosaic = collector.createMosaic()).isEmpty() || preparedMosaic.stream().allMatch(p -> p == null)) continue;
                size += preparedMosaic.size();
                mosaicInputs.addAll(preparedMosaic);
                if (first != null) continue;
                first = collector;
            }
            LOGGER.fine("Producing the final mosaic, step 2, final mosaicking");
            if (size == 1) {
                return new MosaicOutput((MosaicElement)mosaicInputs.get(0));
            }
            if (size == 0) {
                return null;
            }
            MosaicInputs mosaickingInputs = new MosaicInputs(first.doInputTransparency(), first.hasAlpha(), mosaicInputs, first.getSourceThreshold());
            return new MosaicOutput(new Mosaicker(RasterLayerResponse.this, mosaickingInputs, this.mergeBehavior).createMosaic());
        }

        public SubmosaicProducerFactory getGranuleCollectorsFactory() {
            return new DefaultSubmosaicProducerFactory();
        }
    }

    private static final class SimplifiedGridSampleDimension
    extends GridSampleDimension
    implements SampleDimension {
        private static final long serialVersionUID = 2227219522016820587L;
        private double nodata;
        private double minimum;
        private double maximum;
        private double scale;
        private double offset;
        private Unit<?> unit;
        private SampleDimensionType type;
        private ColorInterpretation color;

        public SimplifiedGridSampleDimension(CharSequence description, SampleDimensionType type, ColorInterpretation color, double nodata, double minimum, double maximum, double scale, double offset, Unit<?> unit) {
            Category[] categoryArray;
            if (!Double.isInfinite(nodata)) {
                Category[] categoryArray2 = new Category[1];
                categoryArray = categoryArray2;
                categoryArray2[0] = new Category((CharSequence)Vocabulary.formatInternational((int)147), new Color[]{new Color(0, 0, 0, 0)}, NumberRange.create((double)nodata, (double)nodata));
            } else {
                categoryArray = null;
            }
            super(description, categoryArray, unit);
            this.nodata = nodata;
            this.minimum = minimum;
            this.maximum = maximum;
            this.scale = scale;
            this.offset = offset;
            this.unit = unit;
            this.type = type;
            this.color = color;
        }

        public double getMaximumValue() {
            return this.maximum;
        }

        public double getMinimumValue() {
            return this.minimum;
        }

        public double[] getNoDataValues() throws IllegalStateException {
            return new double[]{this.nodata};
        }

        public double getOffset() throws IllegalStateException {
            return this.offset;
        }

        public NumberRange<? extends Number> getRange() {
            return super.getRange();
        }

        public SampleDimensionType getSampleDimensionType() {
            return this.type;
        }

        public Unit<?> getUnits() {
            return this.unit;
        }

        public double getScale() {
            return this.scale;
        }

        public ColorInterpretation getColorInterpretation() {
            return this.color;
        }

        public InternationalString[] getCategoryNames() throws IllegalStateException {
            return new InternationalString[]{SimpleInternationalString.wrap((CharSequence)"Background")};
        }
    }
}

