/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputFilter;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public final class RemappingFilteringObjectInputStream
extends ObjectInputStream {
    private final List<PackageRule> pkgRules;
    private final Predicate<String> validator;
    private final ClassLoader loader;

    private RemappingFilteringObjectInputStream(InputStream in, List<PackageRule> pkgRules, Predicate<String> validator, ObjectInputFilter jep290Filter) throws IOException {
        super(in);
        this.pkgRules = List.copyOf(pkgRules);
        this.validator = validator != null ? validator : name -> true;
        this.loader = Thread.currentThread().getContextClassLoader();
        if (jep290Filter != null) {
            this.setObjectInputFilter(info -> {
                ObjectInputFilter.Status s = jep290Filter.checkInput(info);
                return s == ObjectInputFilter.Status.UNDECIDED ? ObjectInputFilter.Status.UNDECIDED : s;
            });
        }
    }

    private void requireValid(String original) throws InvalidClassException {
        if (!this.validator.test(original)) {
            throw new InvalidClassException("Rejected by validation: " + original);
        }
    }

    private Class<?> load(String fqcn) throws ClassNotFoundException {
        try {
            return Class.forName(fqcn, false, this.loader);
        }
        catch (ClassNotFoundException e) {
            return Class.forName(fqcn, false, ClassLoader.getSystemClassLoader());
        }
    }

    private String mapNonArray(String name) {
        for (PackageRule r : this.pkgRules) {
            String op = r.oldPrefix;
            if (!name.equals(op) && !name.startsWith(op + ".")) continue;
            return r.newPrefix + name.substring(op.length());
        }
        return name;
    }

    private String mapAny(String original) {
        int i;
        if (!original.startsWith("[")) {
            return this.mapNonArray(original);
        }
        if (original.matches("^\\[+[BCDFIJSZV]$")) {
            return original;
        }
        for (i = 0; i < original.length() && original.charAt(i) == '['; ++i) {
        }
        String elem = original.substring(i + 1, original.endsWith(";") ? original.length() - 1 : original.length());
        String mappedElem = this.mapNonArray(elem);
        StringBuilder sb = new StringBuilder(i + 2 + mappedElem.length());
        for (int k = 0; k < i; ++k) {
            sb.append('[');
        }
        sb.append('L').append(mappedElem).append(';');
        return sb.toString();
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        String original = desc.getName();
        this.requireValid(original);
        String mapped = this.mapAny(original);
        return this.load(mapped);
    }

    @Override
    protected Class<?> resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        Class[] ifaces = new Class[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            String original = interfaces[i];
            this.requireValid(original);
            String mapped = this.mapAny(original);
            ifaces[i] = this.load(mapped);
        }
        try {
            return Proxy.getProxyClass(this.loader, ifaces);
        }
        catch (IllegalArgumentException e) {
            return Proxy.getProxyClass(ClassLoader.getSystemClassLoader(), ifaces);
        }
    }

    private boolean isRemappedNonArray(String name) {
        if (name.startsWith("[")) {
            return false;
        }
        for (PackageRule r : this.pkgRules) {
            String op = r.oldPrefix;
            if (!name.equals(op) && !name.startsWith(op + ".")) continue;
            return true;
        }
        return false;
    }

    @Override
    protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
        ObjectStreamClass streamDesc = super.readClassDescriptor();
        String original = streamDesc.getName();
        this.requireValid(original);
        if (this.isRemappedNonArray(original)) {
            String mapped = this.mapAny(original);
            try {
                Class<?> target = this.load(mapped);
                ObjectStreamClass localDesc = ObjectStreamClass.lookup(target);
                if (localDesc != null) {
                    return localDesc;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return streamDesc;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static final class PackageRule {
        final String oldPrefix;
        final String newPrefix;

        PackageRule(String o, String n) {
            this.oldPrefix = o;
            this.newPrefix = n;
        }
    }

    public static final class Builder {
        private InputStream in;
        private final Set<String> allowedNames = new HashSet<String>();
        private final List<Pattern> allowedPatterns = new ArrayList<Pattern>();
        private final Set<String> allowedPrimitives = new HashSet<String>(Set.of("boolean", "byte", "short", "char", "int", "long", "float", "double", "void"));
        private final List<PackageRule> pkgRules = new ArrayList<PackageRule>();
        private ObjectInputFilter jep290Filter;

        public Builder input(InputStream in) {
            this.in = in;
            return this;
        }

        public Builder accept(String ... names) {
            if (names == null || names.length == 0) {
                return this;
            }
            Collections.addAll(this.allowedNames, names);
            return this;
        }

        public Builder accept(Class<?> ... classes) {
            if (classes == null || classes.length == 0) {
                return this;
            }
            for (Class<?> c : classes) {
                if (c.isPrimitive()) {
                    this.allowedPrimitives.add(c.getName());
                }
                this.allowedNames.add(c.getName());
            }
            return this;
        }

        public Builder accept(Pattern pattern) {
            if (pattern == null) {
                return this;
            }
            this.allowedPatterns.add(pattern);
            return this;
        }

        public Builder acceptPattern(String ... regexes) {
            if (regexes == null || regexes.length == 0) {
                return this;
            }
            for (String r : regexes) {
                this.allowedPatterns.add(Pattern.compile(r));
            }
            return this;
        }

        public Builder acceptPrimitives(String ... prims) {
            Collections.addAll(this.allowedPrimitives, prims);
            return this;
        }

        public Builder remapPackage(String oldPkg, String newPkg) {
            this.pkgRules.add(new PackageRule(oldPkg, newPkg));
            return this;
        }

        public Builder objectInputFilter(ObjectInputFilter f) {
            this.jep290Filter = f;
            return this;
        }

        private Predicate<String> buildValidator() {
            Predicate<String> p = this.allowedNames::contains;
            p = p.or(this.allowedPrimitives::contains);
            if (!this.allowedPatterns.isEmpty()) {
                p = p.or(name -> {
                    for (Pattern pat : this.allowedPatterns) {
                        if (!pat.matcher((CharSequence)name).matches()) continue;
                        return true;
                    }
                    return false;
                });
            }
            p = p.or(name -> {
                if (!name.startsWith("[")) {
                    return false;
                }
                if (name.matches("^\\[+[BCDFIJSZV]$")) {
                    return true;
                }
                if (name.matches("^\\[+L.+;+$")) {
                    String elem = name.replaceFirst("^\\[+L", "").replaceAll(";+$", "");
                    if (this.allowedNames.contains(elem) || this.allowedPrimitives.contains(elem)) {
                        return true;
                    }
                    for (Pattern pat : this.allowedPatterns) {
                        if (!pat.matcher(elem).matches()) continue;
                        return true;
                    }
                }
                return false;
            });
            return p;
        }

        public RemappingFilteringObjectInputStream build() throws IOException {
            if (this.in == null) {
                throw new IllegalStateException("input(InputStream) is required");
            }
            return new RemappingFilteringObjectInputStream(this.in, this.pkgRules, this.buildValidator(), this.jep290Filter);
        }
    }
}

