/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.eclipse.imagen.RasterFactory;
import org.eclipse.imagen.media.serialize.SerializableState;
import org.eclipse.imagen.media.serialize.SerializerFactory;

public class SampleImage
implements Serializable {
    private static final long serialVersionUID = 6324143924454724262L;
    transient SampleModel sampleModel;
    transient ColorModel colorModel;

    public SampleImage(SampleModel sampleModel, ColorModel colorModel) {
        this.sampleModel = sampleModel;
        this.colorModel = colorModel;
    }

    public BufferedImage toBufferedImage() {
        SampleModel sm = this.sampleModel.createCompatibleSampleModel(1, 1);
        WritableRaster raster = RasterFactory.createWritableRaster((SampleModel)sm, null);
        BufferedImage image = new BufferedImage(this.colorModel, raster, this.colorModel.isAlphaPremultiplied(), null);
        return image;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(SerializerFactory.getState((Object)this.sampleModel, null));
        out.writeObject(SerializerFactory.getState((Object)this.colorModel, null));
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        SerializableState smState = (SerializableState)in.readObject();
        this.sampleModel = (SampleModel)smState.getObject();
        SerializableState cmState = (SerializableState)in.readObject();
        this.colorModel = (ColorModel)cmState.getObject();
    }
}

