/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.catalog;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.DataStoreFactorySpi;
import org.geotools.api.data.Query;
import org.geotools.api.data.QueryCapabilities;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.data.SimpleFeatureStore;
import org.geotools.api.data.Transaction;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.identity.FeatureId;
import org.geotools.api.geometry.BoundingBox;
import org.geotools.coverage.grid.io.footprint.MultiLevelROI;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.SchemaException;
import org.geotools.feature.visitor.FeatureCalc;
import org.geotools.gce.imagemosaic.GranuleDescriptor;
import org.geotools.gce.imagemosaic.Utils;
import org.geotools.gce.imagemosaic.catalog.CatalogConfigurationBean;
import org.geotools.gce.imagemosaic.catalog.CatalogConfigurationBeans;
import org.geotools.gce.imagemosaic.catalog.GranuleCatalog;
import org.geotools.gce.imagemosaic.catalog.GranuleCatalogVisitor;
import org.geotools.util.Utilities;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;

abstract class AbstractGTDataStoreGranuleCatalog
extends GranuleCatalog {
    protected static final Boolean TRACE_ENABLED = "true".equalsIgnoreCase(System.getProperty("gt2.mosaic.index.trace"));
    static final Logger LOGGER = Logging.getLogger(AbstractGTDataStoreGranuleCatalog.class);
    static final FilterFactory ff = CommonFactoryFinder.getFilterFactory(GeoTools.getDefaultHints());
    protected final String parentLocation;
    private Throwable tracer;
    boolean wrapstore = false;
    protected Properties params;
    private DataStoreFactorySpi spi;

    public AbstractGTDataStoreGranuleCatalog(Properties params, CatalogConfigurationBeans configurations, boolean create, DataStoreFactorySpi spi, Hints hints) {
        super(hints, configurations);
        Utilities.ensureNonNull((String)"params", (Object)params);
        this.spi = spi;
        this.params = params;
        try {
            this.parentLocation = (String)params.get("ParentLocation");
            this.wrapstore = configurations.first().isWrapStore();
            this.initTileIndexStore(params, create, spi);
        }
        catch (Throwable e) {
            this.handleInitializationException(e);
            throw new IllegalArgumentException(e);
        }
        if (TRACE_ENABLED.booleanValue()) {
            this.tracer = new Throwable();
            this.tracer.fillInStackTrace();
        }
    }

    protected void initializeTypeNames(Properties params) throws IOException {
        String typeName = null;
        if (params.containsKey("TypeName")) {
            typeName = (String)params.get("TypeName");
        }
        if (typeName != null) {
            this.checkMosaicSchema(typeName);
            this.addTypeName(typeName, false);
        } else if (!this.configurations.getTypeNames().isEmpty()) {
            for (String string : this.configurations.getTypeNames()) {
                if (!this.isValidMosaicSchema(string)) continue;
                this.getValidTypeNames().add(string);
            }
        } else {
            String[] typeNames = this.getTileIndexStore().getTypeNames();
            if (typeNames != null) {
                for (String tn : typeNames) {
                    if (!this.isValidMosaicSchema(tn)) continue;
                    this.addTypeName(tn, false);
                    break;
                }
            }
        }
        if (this.getValidTypeNames().isEmpty()) {
            throw new IllegalArgumentException("Could not find a suitable mosaic type in the store");
        }
        for (String string : this.getValidTypeNames()) {
            if (!this.isValidMosaicSchema(string)) continue;
            this.extractBasicProperties(string);
            break;
        }
    }

    protected abstract void handleInitializationException(Throwable var1);

    protected abstract void initTileIndexStore(Properties var1, boolean var2, DataStoreFactorySpi var3) throws IOException, MalformedURLException;

    private boolean isValidMosaicSchema(String typeName) throws IOException {
        SimpleFeatureType schema = this.getTileIndexStore().getSchema(typeName);
        return Utils.isValidMosaicSchema(schema, this.getLocationAttributeName(typeName));
    }

    private String getLocationAttributeName(String typeName) {
        return Optional.ofNullable(this.configurations.getByTypeName(typeName)).map(c -> c.getLocationAttribute()).orElse("location");
    }

    private void checkMosaicSchema(String typeName) throws IOException {
        SimpleFeatureType schema = this.getTileIndexStore().getSchema(typeName);
        if (schema == null) {
            throw new IllegalArgumentException("Could not find typename " + String.valueOf(schema));
        }
        this.checkMosaicSchema(schema);
    }

    private void checkMosaicSchema(SimpleFeatureType schema) {
        String locationAttribute = this.getLocationAttributeName(schema.getTypeName());
        if (!Utils.isValidMosaicSchema(schema, locationAttribute)) {
            throw new IllegalArgumentException("Invalid mosaic schema " + String.valueOf(schema) + ", it should have a geometry and a location property of name " + locationAttribute);
        }
    }

    private void checkStore() throws IllegalStateException {
        if (this.getTileIndexStore() == null) {
            throw new IllegalStateException("The index store has been disposed already.");
        }
    }

    private void extractBasicProperties(String typeName) throws IOException {
        SimpleFeatureSource featureSource;
        if (typeName == null) {
            String[] typeNames = this.getTileIndexStore().getTypeNames();
            if (typeNames == null || typeNames.length <= 0) {
                throw new IllegalArgumentException("BBOXFilterExtractor::extractBasicProperties(): Problems when opening the index, no typenames for the schema are defined");
            }
            if (typeName == null) {
                typeName = typeNames[0];
                this.addTypeName(typeName, false);
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.warning("BBOXFilterExtractor::extractBasicProperties(): passed typename is null, using: " + typeName);
                }
            }
            for (String type : typeNames) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("BBOXFilterExtractor::extractBasicProperties(): Looking for type '" + typeName + "' in DataStore:getTypeNames(). Testing: '" + type + "'.");
                }
                if (!type.equalsIgnoreCase(typeName)) continue;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("BBOXFilterExtractor::extractBasicProperties(): SUCCESS -> type '" + typeName + "' is equalsIgnoreCase() to '" + type + "'.");
                }
                typeName = type;
                this.addTypeName(typeName, false);
                break;
            }
        }
        if ((featureSource = this.getTileIndexStore().getFeatureSource(typeName)) == null) {
            throw new IOException("BBOXFilterExtractor::extractBasicProperties(): unable to get a featureSource for the qualified name" + typeName);
        }
        Object schema = featureSource.getSchema();
        if (schema != null && schema.getGeometryDescriptor() != null) {
            String geometryPropertyName = schema.getGeometryDescriptor().getLocalName();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("BBOXFilterExtractor::extractBasicProperties(): geometryPropertyName is set to '" + geometryPropertyName + "'.");
            }
        } else {
            throw new IOException("BBOXFilterExtractor::extractBasicProperties(): unable to get a schema from the featureSource");
        }
    }

    @Override
    public void dispose() {
        try {
            if (this.multiScaleROIProvider != null) {
                this.multiScaleROIProvider.dispose();
            }
        }
        catch (Throwable e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
            }
        }
        finally {
            this.multiScaleROIProvider = null;
            this.disposeTileIndexStore();
        }
    }

    protected abstract void disposeTileIndexStore();

    @Override
    public int removeGranules(Query query) {
        return this.removeGranules(query, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeGranules(Query query, Transaction transaction) {
        int n;
        block9: {
            Transaction t;
            block10: {
                Utilities.ensureNonNull((String)"query", (Object)query);
                query = this.mergeHints(query);
                this.checkStore();
                String typeName = query.getTypeName();
                SimpleFeatureStore fs = null;
                fs = (SimpleFeatureStore)this.getTileIndexStore().getFeatureSource(typeName);
                boolean rollback = true;
                t = transaction == null || transaction == Transaction.AUTO_COMMIT ? new DefaultTransaction() : transaction;
                try {
                    fs.setTransaction(t);
                    int retVal = fs.getFeatures(query).size();
                    if (retVal > 0) {
                        fs.removeFeatures(query.getFilter());
                        t.commit();
                    }
                    rollback = false;
                    n = retVal;
                    if (t == transaction) break block9;
                    if (!rollback) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (t != transaction) {
                            if (rollback) {
                                t.rollback();
                            }
                            t.close();
                        }
                        throw throwable;
                    }
                    catch (Throwable e) {
                        if (LOGGER.isLoggable(Level.SEVERE)) {
                            LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
                        }
                        return -1;
                    }
                }
                t.rollback();
            }
            t.close();
        }
        return n;
    }

    @Override
    public void addGranules(String typeName, Collection<SimpleFeature> granules, Transaction transaction) throws IOException {
        Utilities.ensureNonNull((String)"granuleMetadata", granules);
        this.checkStore();
        SimpleFeatureStore store = (SimpleFeatureStore)this.getTileIndexStore().getFeatureSource(typeName);
        store.setTransaction(transaction);
        ListFeatureCollection featureCollection = new ListFeatureCollection(this.getTileIndexStore().getSchema(typeName));
        HashSet<FeatureId> fids = new HashSet<FeatureId>();
        for (SimpleFeature f : granules) {
            featureCollection.add(f);
            fids.add(ff.featureId(f.getID()));
        }
        store.addFeatures(featureCollection);
        store.setTransaction(null);
    }

    @Override
    public void getGranuleDescriptors(Query query, GranuleCatalogVisitor visitor) throws IOException {
        block13: {
            Utilities.ensureNonNull((String)"query", (Object)query);
            Query q = this.mergeHints(query);
            String typeName = q.getTypeName();
            this.checkStore();
            SimpleFeatureSource featureSource = this.getTileIndexStore().getFeatureSource(typeName);
            if (featureSource == null) {
                throw new NullPointerException("The provided SimpleFeatureSource is null, it's impossible to create an index!");
            }
            SimpleFeatureCollection features = featureSource.getFeatures(q);
            if (features == null) {
                throw new NullPointerException("The provided SimpleFeatureCollection is null, it's impossible to create an index!");
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Index Loaded");
            }
            CatalogConfigurationBean configuration = this.configurations.getByTypeQuery(query);
            SimpleFeatureIterator fi = features.features();
            block7: while (true) {
                while (fi.hasNext() && !visitor.isVisitComplete()) {
                    SimpleFeature sf = (SimpleFeature)fi.next();
                    MultiLevelROI footprint = this.getGranuleFootprint(sf);
                    if (footprint != null && footprint.isEmpty()) continue;
                    try {
                        GranuleDescriptor granule = new GranuleDescriptor(sf, configuration.suggestedFormat(), configuration.suggestedSPI(), configuration.suggestedIsSPI(), configuration.getPathType(), configuration.getLocationAttribute(), this.parentLocation, footprint, configuration.isHeterogeneous(), q.getHints());
                        visitor.visit(granule, sf);
                        continue block7;
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.FINE, "Skipping invalid granule", e);
                    }
                }
                break block13;
                {
                    continue block7;
                    break;
                }
                break;
            }
            finally {
                if (fi != null) {
                    fi.close();
                }
            }
        }
    }

    @Override
    public SimpleFeatureCollection getGranules(Query q) throws IOException {
        return this.getGranules(q, Transaction.AUTO_COMMIT);
    }

    @Override
    public SimpleFeatureCollection getGranules(Query q, Transaction t) throws IOException {
        Utilities.ensureNonNull((String)"query", (Object)q);
        q = this.mergeHints(q);
        String typeName = q.getTypeName();
        this.checkStore();
        SimpleFeatureSource featureSource = this.getTileIndexStore().getFeatureSource(typeName);
        if (featureSource == null) {
            throw new NullPointerException("The provided SimpleFeatureSource is null, it's impossible to create an index!");
        }
        if (t != null && t != Transaction.AUTO_COMMIT) {
            if (featureSource instanceof SimpleFeatureStore) {
                SimpleFeatureStore store = (SimpleFeatureStore)featureSource;
                store.setTransaction(t);
            } else {
                throw new IllegalArgumentException("A transaction has been specified, but the delegate tile index store is not writable");
            }
        }
        return featureSource.getFeatures(q);
    }

    @Override
    public BoundingBox getBounds(String typeName) {
        try {
            this.checkStore();
            return this.getTileIndexStore().getFeatureSource(typeName).getBounds();
        }
        catch (IOException e) {
            LOGGER.log(Level.FINER, e.getMessage(), e);
            return null;
        }
    }

    @Override
    public BoundingBox getBounds(String typeName, Transaction t) {
        try {
            this.checkStore();
            SimpleFeatureSource fs = this.getTileIndexStore().getFeatureSource(typeName);
            if (t != null && t != Transaction.AUTO_COMMIT) {
                if (fs instanceof SimpleFeatureStore) {
                    SimpleFeatureStore store = (SimpleFeatureStore)fs;
                    store.setTransaction(t);
                } else {
                    throw new IllegalArgumentException("A transaction has been specified, but the delegate tile index store is not writable");
                }
            }
            return fs.getBounds();
        }
        catch (IOException e) {
            LOGGER.log(Level.FINER, e.getMessage(), e);
            return null;
        }
    }

    @Override
    public void createType(String namespace, String typeName, String typeSpec) throws IOException, SchemaException {
        Utilities.ensureNonNull((String)"typeName", (Object)typeName);
        Utilities.ensureNonNull((String)"typeSpec", (Object)typeSpec);
        this.checkStore();
        SimpleFeatureType featureType = DataUtilities.createType(namespace, typeName, typeSpec);
        this.checkMosaicSchema(featureType);
        this.getTileIndexStore().createSchema(featureType);
        String type = featureType.getTypeName();
        if (typeName != null) {
            this.addTypeName(typeName, true);
        }
        this.extractBasicProperties(type);
    }

    private void addTypeName(String typeName, boolean check) {
        if (check && this.getValidTypeNames().contains(typeName)) {
            throw new IllegalArgumentException("This typeName already exists: " + typeName);
        }
        this.getValidTypeNames().add(typeName);
    }

    private void removeTypeName(String typeName) {
        if (this.getValidTypeNames().contains(typeName)) {
            this.getValidTypeNames().remove(typeName);
        }
    }

    @Override
    public String[] getTypeNames() {
        Set<String> validTypeNames = this.getValidTypeNames();
        if (validTypeNames != null && !validTypeNames.isEmpty()) {
            return validTypeNames.toArray(new String[0]);
        }
        return null;
    }

    @Override
    public void createType(SimpleFeatureType featureType) throws IOException {
        Utilities.ensureNonNull((String)"featureType", (Object)featureType);
        this.checkMosaicSchema(featureType);
        this.checkStore();
        this.getTileIndexStore().createSchema(featureType);
        String typeName = featureType.getTypeName();
        if (typeName != null) {
            this.addTypeName(typeName, true);
        }
        this.extractBasicProperties(typeName);
    }

    @Override
    public void removeType(String typeName) throws IOException {
        Utilities.ensureNonNull((String)"featureType", (Object)typeName);
        this.checkStore();
        this.getTileIndexStore().removeSchema(typeName);
        this.removeTypeName(typeName);
    }

    @Override
    public void createType(String identification, String typeSpec) throws SchemaException, IOException {
        Utilities.ensureNonNull((String)"typeSpec", (Object)typeSpec);
        Utilities.ensureNonNull((String)"identification", (Object)identification);
        this.checkStore();
        SimpleFeatureType featureType = DataUtilities.createType(identification, typeSpec);
        this.checkMosaicSchema(featureType);
        this.getTileIndexStore().createSchema(featureType);
        String typeName = featureType.getTypeName();
        if (typeName != null) {
            this.addTypeName(typeName, true);
        }
        this.extractBasicProperties(typeName);
    }

    @Override
    public SimpleFeatureType getType(String typeName) throws IOException {
        this.checkStore();
        if (this.getValidTypeNames().isEmpty() || !this.getValidTypeNames().contains(typeName)) {
            return null;
        }
        return this.getTileIndexStore().getSchema(typeName);
    }

    @Override
    public void computeAggregateFunction(Query query, FeatureCalc function) throws IOException {
        query = this.mergeHints(query);
        this.checkStore();
        SimpleFeatureSource fs = this.getTileIndexStore().getFeatureSource(query.getTypeName());
        if (fs instanceof ContentFeatureSource) {
            ContentFeatureSource source = (ContentFeatureSource)fs;
            source.accepts(query, function, null);
        } else {
            SimpleFeatureCollection collection = fs.getFeatures(query);
            collection.accepts(function, null);
        }
    }

    @Override
    public QueryCapabilities getQueryCapabilities(String typeName) {
        try {
            this.checkStore();
            return this.getTileIndexStore().getFeatureSource(typeName).getQueryCapabilities();
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, "Unable to collect QueryCapabilities", e);
            }
            return null;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.getTileIndexStore() != null) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.warning("This granule catalog was not properly dispose as it still points to:" + this.getTileIndexStore().getInfo().toString());
                if (TRACE_ENABLED.booleanValue()) {
                    LOGGER.log(Level.WARNING, "The un-disposed granule catalog originated on this stack trace", this.tracer);
                }
            }
            this.dispose();
        }
    }

    @Override
    public int getGranulesCount(Query q) throws IOException {
        Utilities.ensureNonNull((String)"query", (Object)q);
        q = this.mergeHints(q);
        String typeName = q.getTypeName();
        this.checkStore();
        SimpleFeatureSource featureSource = this.getTileIndexStore().getFeatureSource(typeName);
        if (featureSource == null) {
            throw new NullPointerException("The provided SimpleFeatureSource is null, it's impossible to create an index!");
        }
        int count = featureSource.getCount(q);
        if (count == -1) {
            return featureSource.getFeatures(q).size();
        }
        return count;
    }

    @Override
    public void drop() throws IOException {
        Map<String, Serializable> params = Utils.filterDataStoreParams(this.params, this.spi);
        Method[] methods = this.spi.getClass().getMethods();
        boolean dropped = false;
        for (Method method : methods) {
            if (!method.getName().equalsIgnoreCase("dropDatabase")) continue;
            try {
                method.invoke((Object)this.spi, params);
            }
            catch (Exception e) {
                throw new IOException("Unable to drop the database: ", e);
            }
            dropped = true;
            break;
        }
        if (!dropped && LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, "Unable to drop catalog for SPI " + this.spi.getDisplayName());
        }
    }

    protected abstract DataStore getTileIndexStore();

    protected abstract Set<String> getValidTypeNames();

    @Override
    protected CatalogConfigurationBeans getConfigurations() {
        return this.configurations;
    }

    @Override
    protected String getParentLocation() {
        return this.parentLocation;
    }
}

