/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.catalog;

import it.geosolutions.imageio.utilities.ImageIOUtilities;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.Objects;
import java.util.logging.Logger;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageInputStreamSpi;
import javax.imageio.spi.ImageReaderSpi;
import org.apache.commons.beanutils.BeanUtils;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.gce.imagemosaic.PathType;
import org.geotools.gce.imagemosaic.SourceSPIProviderFactory;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;

public class CatalogConfigurationBean {
    private static final Logger LOGGER = Logging.getLogger(CatalogConfigurationBean.class);
    private String typeName;
    private String locationAttribute = "location";
    private String suggestedSPI;
    private String suggestedFormat;
    private String suggestedIsSPI;
    private boolean caching = false;
    private boolean heterogeneous;
    private boolean heterogeneousCRS;
    private SourceSPIProviderFactory urlSourceSPIProvider;
    private Boolean skipExternalOverviews;
    private boolean wrapStore = false;
    private PathType pathType;
    private String name;
    private transient AbstractGridFormat resolvedFormat;
    private transient ImageReaderSpi resolvedSuggestedSPI;
    private transient ImageInputStreamSpi resolvedIsSPI;
    private boolean propertySelectionEnabled;

    public CatalogConfigurationBean() {
    }

    public CatalogConfigurationBean(CatalogConfigurationBean that) {
        Utilities.ensureNonNull((String)"CatalogConfigurationBean", (Object)that);
        try {
            BeanUtils.copyProperties((Object)this, (Object)that);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            IllegalArgumentException iae = new IllegalArgumentException(e);
            throw iae;
        }
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public String getLocationAttribute() {
        return this.locationAttribute;
    }

    public void setLocationAttribute(String locationAttribute) {
        this.locationAttribute = locationAttribute;
    }

    public boolean isCaching() {
        return this.caching;
    }

    public void setCaching(boolean caching) {
        this.caching = caching;
    }

    public String getSuggestedSPI() {
        return this.suggestedSPI;
    }

    public ImageReaderSpi suggestedSPI() {
        if (this.suggestedSPI == null) {
            return null;
        }
        if (this.resolvedSuggestedSPI == null) {
            this.resolvedSuggestedSPI = CatalogConfigurationBean.lookupImageReaderSpi(this.suggestedSPI);
            if (this.resolvedSuggestedSPI == null) {
                LOGGER.info("The suggested imageReaderSPI: " + this.suggestedSPI + " wasn't found at the classpath.");
            }
        }
        return this.resolvedSuggestedSPI;
    }

    static ImageReaderSpi lookupImageReaderSpi(String className) {
        Objects.requireNonNull(className);
        Iterator<ImageReaderSpi> serviceProviders = IIORegistry.lookupProviders(ImageReaderSpi.class);
        while (serviceProviders.hasNext()) {
            ImageReaderSpi serviceProvider = serviceProviders.next();
            if (!className.equals(serviceProvider.getClass().getName())) continue;
            return serviceProvider;
        }
        return null;
    }

    public void setSuggestedSPI(String suggestedSPI) {
        this.suggestedSPI = suggestedSPI;
    }

    public boolean isHeterogeneous() {
        return this.heterogeneous;
    }

    public void setHeterogeneous(boolean heterogeneous) {
        this.heterogeneous = heterogeneous;
    }

    public boolean isHeterogeneousCRS() {
        return this.heterogeneousCRS;
    }

    public void setHeterogeneousCRS(boolean heterogeneousCRS) {
        this.heterogeneousCRS = heterogeneousCRS;
    }

    public PathType getPathType() {
        return this.pathType == null ? PathType.RELATIVE : this.pathType;
    }

    public void setPathType(PathType pathType) {
        this.pathType = pathType;
    }

    public boolean isWrapStore() {
        return this.wrapStore;
    }

    public void setWrapStore(boolean wrapStore) {
        this.wrapStore = wrapStore;
    }

    public String getSuggestedFormat() {
        return this.suggestedFormat;
    }

    public void setSuggestedFormat(String suggestedFormat) {
        this.suggestedFormat = suggestedFormat;
    }

    public AbstractGridFormat suggestedFormat() throws ReflectiveOperationException {
        if (this.suggestedFormat == null) {
            return null;
        }
        if (this.resolvedFormat == null) {
            this.resolvedFormat = Class.forName(this.suggestedFormat).asSubclass(AbstractGridFormat.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        return this.resolvedFormat;
    }

    public String getSuggestedIsSPI() {
        return this.suggestedIsSPI;
    }

    public ImageInputStreamSpi suggestedIsSPI() throws ReflectiveOperationException {
        if (this.suggestedIsSPI == null) {
            return null;
        }
        if (this.resolvedIsSPI == null) {
            this.resolvedIsSPI = Class.forName(this.suggestedIsSPI).asSubclass(ImageInputStreamSpi.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        return this.resolvedIsSPI;
    }

    public void setSuggestedIsSPI(String suggestedIsSPI) {
        this.suggestedIsSPI = suggestedIsSPI;
    }

    public SourceSPIProviderFactory getUrlSourceSPIProvider() {
        return this.urlSourceSPIProvider;
    }

    public void setUrlSourceSPIProvider(SourceSPIProviderFactory urlSourceSPIProvider) {
        this.urlSourceSPIProvider = urlSourceSPIProvider;
    }

    public Boolean getSkipExternalOverviews() {
        return this.skipExternalOverviews;
    }

    public boolean isSkipExternalOverviews() {
        return this.skipExternalOverviews == null ? ImageIOUtilities.isSkipExternalFilesLookup() : this.skipExternalOverviews;
    }

    public void setSkipExternalOverviews(Boolean skipExternalOverviews) {
        this.skipExternalOverviews = skipExternalOverviews;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean isPropertySelectionEnabled() {
        return this.propertySelectionEnabled;
    }

    public void setPropertySelectionEnabled(boolean propertySelectionEnabled) {
        this.propertySelectionEnabled = propertySelectionEnabled;
    }
}

