/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.catalog;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.geotools.api.data.DataAccess;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.FeatureReader;
import org.geotools.api.data.FeatureWriter;
import org.geotools.api.data.LockingManager;
import org.geotools.api.data.Query;
import org.geotools.api.data.ServiceInfo;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.data.SimpleFeatureStore;
import org.geotools.api.data.Transaction;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.Filter;
import org.geotools.data.DataUtilities;
import org.geotools.data.collection.DelegateFeatureReader;
import org.geotools.util.SoftValueHashMap;

class DataAccessStoreWrapper
implements DataStore {
    DataAccess delegate;
    SoftValueHashMap<String, Name> NAME_CACHE = new SoftValueHashMap();

    public DataAccessStoreWrapper(DataAccess<FeatureType, Feature> delegate) {
        this.delegate = delegate;
    }

    @Override
    public ServiceInfo getInfo() {
        return this.delegate.getInfo();
    }

    @Override
    public void createSchema(SimpleFeatureType featureType) throws IOException {
        this.delegate.createSchema(featureType);
    }

    @Override
    public void updateSchema(Name typeName, SimpleFeatureType featureType) throws IOException {
        this.delegate.updateSchema(typeName, featureType);
    }

    @Override
    public void removeSchema(Name typeName) throws IOException {
        this.delegate.removeSchema(typeName);
    }

    @Override
    public List getNames() throws IOException {
        return this.delegate.getNames();
    }

    @Override
    public SimpleFeatureType getSchema(Name name) throws IOException {
        Object schema = this.delegate.getSchema(name);
        if (schema instanceof SimpleFeatureType) {
            SimpleFeatureType type = (SimpleFeatureType)schema;
            return type;
        }
        return null;
    }

    @Override
    public SimpleFeatureSource getFeatureSource(Name typeName) throws IOException {
        return DataUtilities.simple(this.delegate.getFeatureSource(typeName));
    }

    @Override
    public void dispose() {
        this.delegate.dispose();
    }

    @Override
    public void updateSchema(String typeName, SimpleFeatureType featureType) throws IOException {
        Name name = this.getNameFromLocal(typeName);
        this.delegate.updateSchema(name, featureType);
    }

    @Override
    public void removeSchema(String typeName) throws IOException {
        Name name = this.getNameFromLocal(typeName);
        this.delegate.removeSchema(name);
    }

    @Override
    public String[] getTypeNames() throws IOException {
        List<Name> names = this.delegate.getNames();
        String[] typeNames = (String[])names.stream().map(name -> name.getLocalPart()).distinct().sorted().toArray(String[]::new);
        return typeNames;
    }

    @Override
    public SimpleFeatureType getSchema(String typeName) throws IOException {
        Name name = this.getNameFromLocal(typeName);
        Object schema = this.delegate.getSchema(name);
        if (schema instanceof SimpleFeatureType) {
            SimpleFeatureType type = (SimpleFeatureType)schema;
            return type;
        }
        return null;
    }

    @Override
    public SimpleFeatureSource getFeatureSource(String typeName) throws IOException {
        DataAccess dataAccess = this.delegate;
        if (dataAccess instanceof DataStore) {
            DataStore store = (DataStore)dataAccess;
            return store.getFeatureSource(typeName);
        }
        Name name = this.getNameFromLocal(typeName);
        return DataUtilities.simple(this.delegate.getFeatureSource(name));
    }

    private Name getNameFromLocal(String typeName) throws IOException {
        Name result = (Name)this.NAME_CACHE.get((Object)typeName);
        if (result == null) {
            Stream stream = this.delegate.getNames().stream();
            Set names = stream.filter(name -> typeName.equals(name.getLocalPart())).collect(Collectors.toSet());
            if (names.isEmpty()) {
                throw new IOException("Could not find a type name '" + typeName + "'");
            }
            if (names.size() > 1) {
                throw new IOException("Found multiple matches for '" + typeName + "': " + String.valueOf(names));
            }
            result = (Name)names.iterator().next();
            this.NAME_CACHE.put((Object)typeName, (Object)result);
        }
        return result;
    }

    @Override
    public FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(Query query, Transaction transaction) throws IOException {
        SimpleFeatureSource fs = this.getFeatureSource(query.getTypeName());
        if (fs == null) {
            throw new IOException("Could not find feature type mentioned in query: '" + query.getTypeName() + "'");
        }
        if (fs instanceof SimpleFeatureStore) {
            SimpleFeatureStore store = (SimpleFeatureStore)fs;
            store.setTransaction(transaction);
        }
        return new DelegateFeatureReader<SimpleFeatureType, SimpleFeature>((SimpleFeatureType)fs.getSchema(), fs.getFeatures().features());
    }

    @Override
    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(String typeName, Filter filter, Transaction transaction) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(String typeName, Transaction transaction) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriterAppend(String typeName, Transaction transaction) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public LockingManager getLockingManager() {
        return null;
    }

    public boolean wraps(DataAccess access) {
        return this.delegate == access;
    }
}

