/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.catalog;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import org.geotools.api.data.Query;
import org.geotools.api.data.QueryCapabilities;
import org.geotools.api.data.Transaction;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.geometry.BoundingBox;
import org.geotools.coverage.grid.io.footprint.MultiLevelROI;
import org.geotools.coverage.grid.io.footprint.MultiLevelROIProvider;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.SchemaException;
import org.geotools.feature.visitor.FeatureCalc;
import org.geotools.gce.imagemosaic.catalog.GranuleCatalog;
import org.geotools.gce.imagemosaic.catalog.GranuleCatalogVisitor;
import org.geotools.util.factory.Hints;

public class LockingGranuleCatalog
extends GranuleCatalog {
    GranuleCatalog delegate;
    ReadWriteLock rwLock = new ReentrantReadWriteLock(true);

    public LockingGranuleCatalog(GranuleCatalog delegate, Hints hints) {
        super(hints, delegate.getConfigurations());
        this.delegate = delegate;
    }

    private void guard(Runnable operation, Lock lock) {
        lock.lock();
        try {
            operation.run();
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <V> V guard(Supplier<V> supplier, Lock lock) {
        lock.lock();
        try {
            V v = supplier.get();
            return v;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <V> V guardIO(IOCallable<V> operation, Lock lock) throws IOException {
        lock.lock();
        try {
            V v = operation.call();
            return v;
        }
        finally {
            lock.unlock();
        }
    }

    private void guardIO(IORunnable operation, Lock lock) throws IOException {
        lock.lock();
        try {
            operation.run();
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void addGranule(String typeName, SimpleFeature granule, Transaction transaction) throws IOException {
        this.guardIO(() -> this.delegate.addGranule(typeName, granule, transaction), this.rwLock.writeLock());
    }

    @Override
    public void addGranules(String typeName, Collection<SimpleFeature> granules, Transaction transaction) throws IOException {
        this.guardIO(() -> this.delegate.addGranules(typeName, granules, transaction), this.rwLock.writeLock());
    }

    @Override
    public void computeAggregateFunction(Query q, FeatureCalc function) throws IOException {
        this.guardIO(() -> this.delegate.computeAggregateFunction(q, function), this.rwLock.readLock());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createType(String namespace, String typeName, String typeSpec) throws IOException, SchemaException {
        Lock lock = this.rwLock.writeLock();
        lock.lock();
        try {
            this.delegate.createType(namespace, typeName, typeSpec);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void createType(SimpleFeatureType featureType) throws IOException {
        this.guardIO(() -> this.delegate.createType(featureType), this.rwLock.writeLock());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createType(String identification, String typeSpec) throws SchemaException, IOException {
        Lock lock = this.rwLock.writeLock();
        lock.lock();
        try {
            this.delegate.createType(identification, typeSpec);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void dispose() {
        Lock lock = this.rwLock.writeLock();
        lock.lock();
        try {
            this.delegate.dispose();
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BoundingBox getBounds(String typeName) {
        Lock lock = this.rwLock.readLock();
        lock.lock();
        try {
            BoundingBox boundingBox = this.delegate.getBounds(typeName);
            return boundingBox;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BoundingBox getBounds(String typeName, Transaction t) {
        Lock lock = this.rwLock.readLock();
        lock.lock();
        try {
            BoundingBox boundingBox = this.delegate.getBounds(typeName, t);
            return boundingBox;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public SimpleFeatureCollection getGranules(Query q) throws IOException {
        return this.guardIO(() -> this.delegate.getGranules(q), this.rwLock.readLock());
    }

    @Override
    public SimpleFeatureCollection getGranules(Query q, Transaction t) throws IOException {
        return this.guardIO(() -> this.delegate.getGranules(q, t), this.rwLock.readLock());
    }

    @Override
    public int getGranulesCount(Query q) throws IOException {
        return this.guardIO(() -> this.delegate.getGranulesCount(q), this.rwLock.readLock());
    }

    @Override
    public void getGranuleDescriptors(Query q, GranuleCatalogVisitor visitor) throws IOException {
        this.guardIO(() -> this.delegate.getGranuleDescriptors(q, visitor), this.rwLock.readLock());
    }

    @Override
    public QueryCapabilities getQueryCapabilities(String typeName) {
        return this.guard(() -> this.delegate.getQueryCapabilities(typeName), this.rwLock.readLock());
    }

    @Override
    public SimpleFeatureType getType(String typeName) throws IOException {
        return this.guardIO(() -> this.delegate.getType(typeName), this.rwLock.readLock());
    }

    @Override
    public void removeType(String typeName) throws IOException {
        this.guardIO(() -> this.delegate.removeType(typeName), this.rwLock.writeLock());
    }

    @Override
    public int removeGranules(Query query) {
        return this.guard(() -> this.delegate.removeGranules(query), this.rwLock.writeLock());
    }

    @Override
    public int removeGranules(Query query, Transaction transaction) {
        return this.guard(() -> this.delegate.removeGranules(query, transaction), this.rwLock.writeLock());
    }

    @Override
    public String[] getTypeNames() {
        Lock lock = this.rwLock.readLock();
        lock.lock();
        try {
            String[] stringArray = this.delegate.getTypeNames();
            return stringArray;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public Query mergeHints(Query q) {
        return this.guard(() -> this.delegate.mergeHints(q), this.rwLock.readLock());
    }

    @Override
    public void setMultiScaleROIProvider(MultiLevelROIProvider footprintProvider) {
        this.guard(() -> this.delegate.setMultiScaleROIProvider(footprintProvider), this.rwLock.writeLock());
    }

    @Override
    public MultiLevelROI getGranuleFootprint(SimpleFeature sf) {
        return this.guard(() -> this.delegate.getGranuleFootprint(sf), this.rwLock.readLock());
    }

    @Override
    public List<File> getFootprintFiles(SimpleFeature sf) throws IOException {
        return this.guardIO(() -> this.delegate.getFootprintFiles(sf), this.rwLock.readLock());
    }

    @Override
    public void drop() throws IOException {
        this.guardIO(() -> this.delegate.drop(), this.rwLock.writeLock());
    }

    @Override
    protected String getParentLocation() {
        return this.delegate.getParentLocation();
    }

    public GranuleCatalog getAdaptee() {
        return this.delegate;
    }

    static interface IOCallable<V> {
        public V call() throws IOException;
    }

    static interface IORunnable {
        public void run() throws IOException;
    }
}

