/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.catalog;

import java.io.File;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Properties;
import org.geotools.api.filter.Filter;
import org.geotools.coverage.grid.io.footprint.FootprintGeometryProvider;
import org.geotools.coverage.grid.io.footprint.FootprintLoader;
import org.geotools.coverage.grid.io.footprint.FootprintLoaderSpi;
import org.geotools.coverage.grid.io.footprint.MultiLevelROIProvider;
import org.geotools.coverage.grid.io.footprint.MultiLevelROIProviderFactory;
import org.geotools.coverage.grid.io.footprint.SidecarFootprintProvider;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.gce.imagemosaic.catalog.GTDataStoreFootprintProvider;
import org.geotools.gce.imagemosaic.catalog.MultiLevelROIGeometryOverviewsProvider;
import org.geotools.gce.imagemosaic.catalog.MultiLevelROIRasterProvider;
import org.geotools.util.URLs;
import org.geotools.util.factory.Hints;

public class MultiLevelROIProviderMosaicFactory
extends MultiLevelROIProviderFactory {
    public static final String FILTER_PROPERTY = "footprint_filter";

    private MultiLevelROIProviderMosaicFactory() {
    }

    public static MultiLevelROIProvider createFootprintProvider(File mosaicFolder) {
        return MultiLevelROIProviderMosaicFactory.createFootprintProvider(mosaicFolder, null);
    }

    public static MultiLevelROIProvider createFootprintProvider(File mosaicFolder, Hints hints) {
        File configFile = new File(mosaicFolder, "footprints.properties");
        Properties properties = MultiLevelROIProviderMosaicFactory.initProperties((File)configFile);
        String source = (String)properties.get("footprint_source");
        Object provider = null;
        if (source == null) {
            File defaultShapefileFootprint = new File(mosaicFolder, "footprints.shp");
            provider = defaultShapefileFootprint.exists() ? MultiLevelROIProviderMosaicFactory.buildShapefileSource(mosaicFolder, defaultShapefileFootprint.getName(), properties) : new SidecarFootprintProvider(mosaicFolder);
        } else if ("sidecar".equals(source)) {
            provider = new SidecarFootprintProvider(mosaicFolder);
        } else if (source.toLowerCase().endsWith(".shp")) {
            provider = MultiLevelROIProviderMosaicFactory.buildShapefileSource(mosaicFolder, source, properties);
        } else {
            if ("raster".equals(source)) {
                return new MultiLevelROIRasterProvider(mosaicFolder, hints);
            }
            if ("multisidecar".equals(source)) {
                return MultiLevelROIProviderMosaicFactory.createMultiLevelROIOverviewsProvider(mosaicFolder, properties, hints);
            }
            throw new IllegalArgumentException("Invalid source type, it should be a reference to a shapefile or 'sidecar', but was '" + source + "' instead");
        }
        return MultiLevelROIProviderMosaicFactory.createProvider((FootprintGeometryProvider)provider, (Properties)properties, null);
    }

    private static MultiLevelROIProvider createMultiLevelROIOverviewsProvider(File mosaicFolder, Properties properties, Hints hints) {
        String footprintLoaderSpi = (String)properties.get("footprintLoaderSPI");
        String overviewsFootprintLoaderSpi = (String)properties.get("overviewsFootprintLoaderSPI");
        String overviewsSuffixFormat = properties.getProperty("overviewsSuffixFormat", "_%d");
        String overviewsRoiInRasterSpaceString = properties.getProperty("overviewsRoiInRasterSpace");
        boolean overviewsRoiInRasterSpace = overviewsRoiInRasterSpaceString != null ? Boolean.parseBoolean(overviewsRoiInRasterSpaceString) : false;
        FootprintLoaderSpi spi = null;
        FootprintLoader footprintLoader = null;
        FootprintLoader overviewsFootprintLoader = null;
        try {
            if (footprintLoaderSpi != null) {
                spi = Class.forName(footprintLoaderSpi).asSubclass(FootprintLoaderSpi.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                overviewsFootprintLoader = footprintLoader = spi.createLoader();
                if (overviewsFootprintLoaderSpi != null) {
                    spi = Class.forName(overviewsFootprintLoaderSpi).asSubclass(FootprintLoaderSpi.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    overviewsFootprintLoader = spi.createLoader();
                }
            }
            return new MultiLevelROIGeometryOverviewsProvider(mosaicFolder, overviewsSuffixFormat, Integer.MIN_VALUE, footprintLoader, overviewsFootprintLoader, overviewsRoiInRasterSpace, hints);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException("Exception occurred while creating FootprintLoader", e);
        }
    }

    private static FootprintGeometryProvider buildShapefileSource(File mosaicFolder, String location, Properties properties) {
        File shapefile = new File(location);
        if (!shapefile.isAbsolute()) {
            shapefile = new File(mosaicFolder, location);
        }
        try {
            if (!shapefile.exists()) {
                throw new IllegalArgumentException("Tried to load the footprints from " + shapefile.getCanonicalPath() + " but the file was not found");
            }
            HashMap<String, Serializable> params = new HashMap<String, Serializable>();
            params.put("url", URLs.fileToUrl((File)shapefile));
            String cql = (String)properties.get(FILTER_PROPERTY);
            Filter filter = null;
            filter = cql != null ? ECQL.toFilter((String)cql) : ECQL.toFilter((String)"location = granule.location");
            String typeName = shapefile.getName();
            typeName = typeName.substring(0, typeName.lastIndexOf(46));
            return new GTDataStoreFootprintProvider(params, typeName, filter);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to create a shapefile based footprint provider", e);
        }
    }
}

