/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.catalog;

import it.geosolutions.imageio.maskband.DatasetLayout;
import java.awt.RenderingHints;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.footprint.MultiLevelROI;
import org.geotools.coverage.grid.io.footprint.MultiLevelROIProvider;
import org.geotools.coverage.grid.io.footprint.MultiLevelROIRaster;
import org.geotools.coverage.grid.io.footprint.SidecarFootprintProvider;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.gce.imagemosaic.DefaultGranuleAccessProvider;
import org.geotools.gce.imagemosaic.GranuleAccessProvider;
import org.geotools.gce.imagemosaic.Utils;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.util.URLs;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Polygon;

public class MultiLevelROIRasterProvider
implements MultiLevelROIProvider {
    static final Logger LOGGER = Logging.getLogger(SidecarFootprintProvider.class);
    private final Hints hints;
    private File mosaicFolder;

    public MultiLevelROIRasterProvider(File mosaicFolder, Hints hints) {
        this.mosaicFolder = mosaicFolder;
        this.hints = hints;
    }

    public MultiLevelROI getMultiScaleROI(SimpleFeature sf) throws IOException {
        if (sf == null) {
            return null;
        }
        Object value = sf.getAttribute("location");
        if (value != null && value instanceof String) {
            String strValue = (String)value;
            GranuleAccessProvider granuleProvider = this.getGranuleAccessProvider(strValue);
            MultiLevelROI result = null;
            if (granuleProvider != null) {
                try {
                    int numExternalMaskOverviews;
                    int numInternalMasks;
                    int numExternalMasks;
                    int totalMasks;
                    AbstractGridCoverage2DReader reader = granuleProvider.getGridCoverageReader();
                    DatasetLayout layout = reader.getDatasetLayout();
                    if (layout != null && (totalMasks = (numExternalMasks = layout.getNumExternalMasks() > 0 ? layout.getNumExternalMasks() : 0) + (numInternalMasks = layout.getNumInternalMasks() > 0 ? layout.getNumInternalMasks() : 0) + (numExternalMaskOverviews = layout.getNumExternalMaskOverviews() > 0 ? layout.getNumExternalMaskOverviews() : 0)) > 0) {
                        CoordinateReferenceSystem crs = reader.getCoordinateReferenceSystem();
                        SimpleFeatureType indexSchema = sf.getFeatureType();
                        SimpleFeature nativeFeature = sf;
                        if (crs != null && indexSchema != null && indexSchema.getCoordinateReferenceSystem() != null && !CRS.equalsIgnoreMetadata((Object)crs, (Object)indexSchema.getCoordinateReferenceSystem())) {
                            ReferencedEnvelope envelope = ReferencedEnvelope.reference((Bounds)reader.getOriginalEnvelope());
                            Polygon nativeFootprint = JTS.toGeometry(envelope);
                            SimpleFeatureType ftNative = FeatureTypes.transform(indexSchema, reader.getCoordinateReferenceSystem());
                            SimpleFeatureBuilder fb = new SimpleFeatureBuilder(ftNative);
                            fb.init(sf);
                            fb.set(indexSchema.getGeometryDescriptor().getLocalName(), (Object)nativeFootprint);
                            nativeFeature = fb.buildFeature(sf.getID());
                        }
                        return new MultiLevelROIRaster(layout, granuleProvider.getMaskOverviewsProvider(), nativeFeature);
                    }
                }
                catch (Exception e) {
                    throw new IOException("Failed to load the footprint for granule " + strValue, e);
                }
            }
            return result;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Could not use the location attribute value to search for the file, the value was: " + String.valueOf(value));
        }
        return null;
    }

    private GranuleAccessProvider getGranuleAccessProvider(String location) throws IOException {
        GranuleAccessProvider provider;
        Object providerHint = Utils.getHintIfAvailable((RenderingHints)this.hints, (RenderingHints.Key)GranuleAccessProvider.GRANULE_ACCESS_PROVIDER);
        if (providerHint != null) {
            provider = ((GranuleAccessProvider)providerHint).copyProviders();
            provider.setGranuleInput(location);
        } else {
            File file = Utils.getFile(location, this.mosaicFolder);
            if (file == null) {
                return null;
            }
            provider = new DefaultGranuleAccessProvider(this.hints);
            provider.setGranuleInput(URLs.fileToUrl((File)file));
        }
        return provider;
    }

    public void dispose() {
    }
}

