/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.catalog.sqlserver;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.logging.Level;
import org.apache.commons.beanutils.BeanUtils;
import org.geotools.api.data.DataStore;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.data.SimpleFeatureStore;
import org.geotools.api.data.Transaction;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.gce.imagemosaic.catalog.oracle.DataStoreWrapper;
import org.geotools.gce.imagemosaic.catalog.oracle.FeatureTypeMapper;
import org.geotools.gce.imagemosaic.catalog.sqlserver.SQLServerTransformFeatureStore;
import org.geotools.gce.imagemosaic.catalog.sqlserver.SQLServerTypeMapper;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.SQLDialect;

public class SQLServerDatastoreWrapper
extends DataStoreWrapper {
    public static final String DEFAULT_METADATA_TABLE = "mosaic_geometry_metadata";
    private static final String METADATA_TABLE_PROPERTY = "geometryMetadataTable";
    private static final String CREATE_METADATA_TABLE = "CREATE TABLE %s(\n   F_TABLE_SCHEMA VARCHAR(128),\n   F_TABLE_NAME VARCHAR(128) NOT NULL,\n   F_GEOMETRY_COLUMN VARCHAR(128) NOT NULL,\n   COORD_DIMENSION INTEGER,\n   SRID INTEGER NOT NULL,\n   TYPE VARCHAR(30) NOT NULL,\n   UNIQUE(F_TABLE_SCHEMA, F_TABLE_NAME, F_GEOMETRY_COLUMN),\n   CHECK(TYPE IN ('POINT','LINE', 'POLYGON', 'COLLECTION', 'MULTIPOINT', 'MULTILINE', 'MULTIPOLYGON', 'GEOMETRY') ))";

    public SQLServerDatastoreWrapper(DataStore datastore, String location) {
        block23: {
            super(datastore, location);
            try {
                if (!(datastore instanceof JDBCDataStore)) break block23;
                JDBCDataStore jdbcDataStore = (JDBCDataStore)this.datastore;
                SQLDialect dialect = jdbcDataStore.getSQLDialect();
                String metadataTable = BeanUtils.getProperty((Object)dialect, (String)METADATA_TABLE_PROPERTY);
                if (metadataTable == null) {
                    metadataTable = DEFAULT_METADATA_TABLE;
                    BeanUtils.setProperty((Object)dialect, (String)METADATA_TABLE_PROPERTY, (Object)DEFAULT_METADATA_TABLE);
                }
                String databaseSchema = jdbcDataStore.getDatabaseSchema();
                try (Connection cx = jdbcDataStore.getConnection(Transaction.AUTO_COMMIT);
                     Statement st = cx.createStatement();){
                    boolean createMetadataTable = true;
                    DatabaseMetaData metaData = cx.getMetaData();
                    StringBuffer qualifiedTableName = new StringBuffer();
                    if (databaseSchema != null) {
                        dialect.encodeTableName(databaseSchema, qualifiedTableName);
                        qualifiedTableName.append(".");
                    }
                    dialect.encodeTableName(metadataTable, qualifiedTableName);
                    try (ResultSet res = metaData.getTables(null, databaseSchema, metadataTable, new String[]{"TABLE"});){
                        createMetadataTable = !res.next();
                    }
                    if (createMetadataTable) {
                        st.executeUpdate(CREATE_METADATA_TABLE.formatted(qualifiedTableName));
                    }
                }
            }
            catch (IOException | IllegalAccessException | NoSuchMethodException | InvocationTargetException | SQLException e) {
                LOGGER.log(Level.FINE, "Failed to assess/create the metadata geometry table, this could lead to lost geometry SRIDs on table creation", e);
            }
        }
    }

    @Override
    protected FeatureTypeMapper getFeatureTypeMapper(Properties props) throws Exception {
        FeatureTypeMapper mapper = super.getFeatureTypeMapper(props);
        return mapper;
    }

    @Override
    protected FeatureTypeMapper getFeatureTypeMapper(SimpleFeatureType featureType) throws Exception {
        return new SQLServerTypeMapper(featureType);
    }

    @Override
    protected SimpleFeatureSource transformFeatureStore(SimpleFeatureStore store, FeatureTypeMapper mapper) throws IOException {
        Object transformedSource = mapper.getSimpleFeatureSource();
        if (transformedSource != null) {
            return transformedSource;
        }
        transformedSource = new SQLServerTransformFeatureStore(store, mapper.getName(), mapper.getDefinitions(), this.datastore);
        ((SQLServerTypeMapper)mapper).setSimpleFeatureSource((SimpleFeatureSource)transformedSource);
        return transformedSource;
    }
}

