/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.granulecollector;

import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.imagen.ImageN;
import org.eclipse.imagen.Interpolation;
import org.eclipse.imagen.InterpolationNearest;
import org.eclipse.imagen.PlanarImage;
import org.eclipse.imagen.ROI;
import org.eclipse.imagen.media.range.NoDataContainer;
import org.eclipse.imagen.media.vectorbin.ROIGeometry;
import org.geotools.api.coverage.Coverage;
import org.geotools.api.coverage.grid.GridCoverage;
import org.geotools.api.data.Query;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.MathTransform2D;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.processing.Operations;
import org.geotools.coverage.util.CoverageUtilities;
import org.geotools.gce.imagemosaic.GranuleDescriptor;
import org.geotools.gce.imagemosaic.MergeBehavior;
import org.geotools.gce.imagemosaic.MosaicElement;
import org.geotools.gce.imagemosaic.Mosaicker;
import org.geotools.gce.imagemosaic.RasterLayerRequest;
import org.geotools.gce.imagemosaic.RasterLayerResponse;
import org.geotools.gce.imagemosaic.RasterManager;
import org.geotools.gce.imagemosaic.Utils;
import org.geotools.gce.imagemosaic.catalog.GranuleCatalog;
import org.geotools.gce.imagemosaic.catalog.GranuleCatalogVisitor;
import org.geotools.gce.imagemosaic.granulecollector.BaseSubmosaicProducer;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.ImageWorker;
import org.geotools.image.util.ImageUtilities;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;

class ReprojectingSubmosaicProducer
extends BaseSubmosaicProducer {
    private final boolean dryRun;
    private final RenderingHints renderingHints;
    private final Operations operations;
    private CoordinateReferenceSystem targetCRS;
    private List<CRSBoundMosaicProducer> perMosaicProducers;
    private CRSBoundMosaicProducer currentSubmosaicProducer;
    private Map<CoordinateReferenceSystem, RasterLayerResponse> crsResponses;

    ReprojectingSubmosaicProducer(RasterLayerRequest request, RasterLayerResponse response, RasterManager rasterManager, boolean dryRun) {
        block4: {
            super(response, dryRun);
            this.perMosaicProducers = new ArrayList<CRSBoundMosaicProducer>();
            this.targetCRS = rasterManager.getConfiguration().getCrs();
            ReferencedEnvelope requestedBounds = request.getRequestedBounds();
            if (rasterManager.getConfiguration().getCatalogConfigurationBean().isHeterogeneousCRS() && requestedBounds != null) {
                CoordinateReferenceSystem crs = requestedBounds.getCoordinateReferenceSystem();
                Integer code = null;
                try {
                    code = CRS.lookupEpsgCode((CoordinateReferenceSystem)crs, (boolean)false);
                    if (request.isUseAlternativeCRS() && rasterManager.hasAlternativeCRS(code)) {
                        this.targetCRS = crs;
                    }
                }
                catch (IOException | FactoryException e) {
                    if (!LOGGER.isLoggable(Level.WARNING)) break block4;
                    LOGGER.warning("Unable to check for alternative CRS: " + code + " Proceeding with default target CRS");
                }
            }
        }
        this.dryRun = dryRun;
        Hints hints = rasterManager.getHints();
        this.renderingHints = ReprojectingSubmosaicProducer.createRenderingHints(hints, request);
        this.operations = new Operations(this.renderingHints);
    }

    @Override
    public void init(Query query) throws Exception {
        GranuleCatalog catalog = this.rasterLayerResponse.getRasterManager().getGranuleCatalog();
        ReprojectedResponseCollector collector = new ReprojectedResponseCollector();
        catalog.getGranuleDescriptors(query, collector);
        this.crsResponses = collector.getResponses();
    }

    @Override
    public boolean isReprojecting() {
        return true;
    }

    private static RenderingHints createRenderingHints(Hints hints, RasterLayerRequest request) {
        RenderingHints renderHints = new RenderingHints(null);
        if (request.getInterpolation() != null) {
            renderHints.put(ImageN.KEY_INTERPOLATION, request.getInterpolation());
        }
        return renderHints;
    }

    @Override
    public boolean accept(GranuleDescriptor granuleDescriptor) {
        boolean accepted;
        boolean bl = accepted = this.currentSubmosaicProducer != null && this.currentSubmosaicProducer.accept(granuleDescriptor);
        if (!accepted) {
            CoordinateReferenceSystem targetCRS = granuleDescriptor.getGranuleEnvelope().getCoordinateReferenceSystem();
            RasterLayerResponse response = this.crsResponses.get(targetCRS);
            if (response == null) {
                return false;
            }
            try {
                this.currentSubmosaicProducer = new CRSBoundMosaicProducer(response, this.dryRun, targetCRS, granuleDescriptor);
                this.perMosaicProducers.add(this.currentSubmosaicProducer);
                accepted = true;
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Failed to setup CRS specific sub-mosaic", e);
            }
        }
        return accepted;
    }

    protected static CoordinateReferenceSystem getCRS(String granuleCRSCode) throws FactoryException {
        return CRS.decode((String)granuleCRSCode);
    }

    @Override
    public List<MosaicElement> createMosaic() throws IOException {
        ArrayList<MosaicElement> mosaicInputs = new ArrayList<MosaicElement>();
        for (CRSBoundMosaicProducer mosaicProducer : this.perMosaicProducers) {
            List<MosaicElement> mosaicElement = mosaicProducer.createMosaic();
            this.hasAlpha = mosaicProducer.hasAlpha();
            try {
                for (MosaicElement e : mosaicElement) {
                    MosaicElement reprojectedMosaicElement = this.reprojectMosaicElement(e, mosaicProducer);
                    mosaicInputs.add(reprojectedMosaicElement);
                }
            }
            catch (FactoryException | TransformException e) {
                throw new IllegalStateException(e);
            }
        }
        return mosaicInputs;
    }

    private MosaicElement reprojectMosaicElement(MosaicElement mosaicElement, CRSBoundMosaicProducer mosaicProducer) throws FactoryException, TransformException {
        CoordinateReferenceSystem finalCrs = mosaicProducer.getCrs();
        if (!CRS.equalsIgnoreMetadata((Object)this.targetCRS, (Object)finalCrs)) {
            ROI roi;
            GridCoverageFactory factory = new GridCoverageFactory(null);
            MathTransform2D finalGridToWorld = mosaicProducer.rasterLayerResponse.getFinalGridToWorldCorner();
            ReferencedEnvelope submosaicBBOX = this.computeSubmosaicBoundingBox(finalGridToWorld, mosaicElement.getSource(), finalCrs);
            GridCoverage2D submosaicCoverage = this.createCoverageFromElement(mosaicElement, factory, submosaicBBOX);
            GridCoverage2D resampledCoverage = (GridCoverage2D)this.operations.resample((GridCoverage)submosaicCoverage, (Bounds)this.rasterLayerResponse.getMosaicBBox(), this.rasterLayerResponse.getRequest().getInterpolation());
            RenderedImage image = this.positionInOutputMosaic(resampledCoverage);
            Geometry geometry = Utils.reprojectEnvelopeToGeometry(submosaicBBOX, this.targetCRS, this.rasterLayerResponse.getMosaicBBox());
            if (geometry != null && geometry.getNumGeometries() > 1) {
                ReferencedEnvelope resampledImageEnvelope = this.computeSubmosaicBoundingBox(this.rasterLayerResponse.getFinalGridToWorldCorner(), image, finalCrs);
                GridCoverage2D repositionedCoverage = factory.create((CharSequence)"repositioned", image, (Bounds)resampledImageEnvelope);
                GridCoverage2D croppedCoverage = (GridCoverage2D)this.operations.crop((Coverage)repositionedCoverage, geometry);
                image = croppedCoverage.getRenderedImage();
            }
            PlanarImage alphaBand = image.getColorModel().hasAlpha() ? new ImageWorker(image).retainLastBand().getPlanarImage() : null;
            Object property = image.getProperty("ROI");
            ROI overallROI = property instanceof ROI ? (roi = (ROI)property) : null;
            return new MosaicElement(alphaBand, overallROI, image, mosaicElement.getPamDataset());
        }
        return mosaicElement;
    }

    private GridCoverage2D createCoverageFromElement(MosaicElement mosaicElement, GridCoverageFactory factory, ReferencedEnvelope submosaicBBOX) {
        RenderedImage image = mosaicElement.getSource();
        Object roiProperty = image.getProperty("ROI");
        if (!(roiProperty instanceof ROI)) {
            ROIGeometry roi = new ROIGeometry((Geometry)JTS.toGeometry(new Envelope((double)image.getMinX(), (double)(image.getMinX() + image.getWidth()), (double)image.getMinY(), (double)(image.getMinY() + image.getHeight()))));
            ImageWorker iw = new ImageWorker(image);
            iw.setROI((ROI)roi);
            image = iw.getRenderedImage();
            roiProperty = roi;
        }
        HashMap properties = new HashMap();
        CoverageUtilities.setROIProperty(properties, (ROI)((ROI)roiProperty));
        return factory.create((CharSequence)"submosaic", image, (Bounds)submosaicBBOX, null, null, properties);
    }

    private ReferencedEnvelope computeSubmosaicBoundingBox(MathTransform2D tx, RenderedImage image, CoordinateReferenceSystem crs) throws FactoryException {
        double[] mosaicked = new double[]{image.getMinX(), image.getMinY(), image.getMinX() + image.getWidth(), image.getMinY() + image.getHeight()};
        try {
            tx.transform(mosaicked, 0, mosaicked, 0, 2);
        }
        catch (TransformException e) {
            throw new FactoryException((Exception)((Object)e));
        }
        ReferencedEnvelope submosaicBBOX = new ReferencedEnvelope(mosaicked[0], mosaicked[2], mosaicked[1], mosaicked[3], crs);
        return submosaicBBOX;
    }

    private RenderedImage positionInOutputMosaic(GridCoverage2D resampledCoverage) {
        RenderedImage image = resampledCoverage.getRenderedImage();
        AffineTransform finalRaster2Model = new AffineTransform((AffineTransform)((AffineTransform2D)resampledCoverage.getGridGeometry().getGridToCRS()));
        finalRaster2Model.concatenate(CoverageUtilities.CENTER_TO_CORNER);
        AffineTransform finalWorldToGridCorner = (AffineTransform)this.rasterLayerResponse.getFinalWorldToGridCorner();
        finalRaster2Model.preConcatenate(finalWorldToGridCorner);
        RasterLayerRequest request = this.rasterLayerResponse.getRequest();
        Interpolation interpolation = request.getInterpolation();
        Rectangle2D finalLayout = ImageUtilities.layoutHelper((RenderedImage)image, (float)((float)finalRaster2Model.getScaleX()), (float)((float)finalRaster2Model.getScaleY()), (float)((float)finalRaster2Model.getTranslateX()), (float)((float)finalRaster2Model.getTranslateY()), (Interpolation)interpolation);
        if (finalLayout.isEmpty()) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("Unable to create a granuleDescriptor " + this.toString() + " due to jai scale bug creating a null source area");
            }
            return null;
        }
        RenderingHints localHints = new RenderingHints(ImageN.KEY_REPLACE_INDEX_COLOR_MODEL, interpolation instanceof InterpolationNearest ? Boolean.FALSE : Boolean.TRUE);
        if (XAffineTransform.isIdentity((AffineTransform)finalRaster2Model, (double)1.0E-6)) {
            return image;
        }
        ImageWorker iw = new ImageWorker(image);
        Object roi = image.getProperty("ROI");
        if (roi instanceof ROI) {
            ROI oI = (ROI)roi;
            iw.setROI(oI);
        }
        iw.setRenderingHints(localHints);
        iw.affine(finalRaster2Model, interpolation, request.getBackgroundValues());
        RenderedImage renderedImage = iw.getRenderedImage();
        if (iw.getNoData() != null) {
            PlanarImage t = PlanarImage.wrapRenderedImage((RenderedImage)renderedImage);
            t.setProperty("GC_NODATA", (Object)new NoDataContainer(iw.getNoData()));
            renderedImage = t;
        }
        return renderedImage;
    }

    private class ReprojectedResponseCollector
    implements GranuleCatalogVisitor {
        Map<CoordinateReferenceSystem, GranuleDescriptor> granules = new HashMap<CoordinateReferenceSystem, GranuleDescriptor>();

        private ReprojectedResponseCollector() {
        }

        @Override
        public void visit(GranuleDescriptor granule, SimpleFeature feature) {
            try {
                this.granules.putIfAbsent(granule.getGranuleEnvelope().getCoordinateReferenceSystem(), granule);
            }
            catch (Exception e) {
                BaseSubmosaicProducer.LOGGER.log(Level.WARNING, "Failed to setup CRS specific sub-mosaic", e);
            }
        }

        public Map<CoordinateReferenceSystem, RasterLayerResponse> getResponses() throws Exception {
            HashMap<CoordinateReferenceSystem, RasterLayerResponse> result = new HashMap<CoordinateReferenceSystem, RasterLayerResponse>();
            for (Map.Entry<CoordinateReferenceSystem, GranuleDescriptor> entry : this.granules.entrySet()) {
                result.put(entry.getKey(), ReprojectingSubmosaicProducer.this.rasterLayerResponse.reprojectTo(entry.getValue()));
            }
            return result;
        }
    }

    private static class CRSBoundMosaicProducer
    extends BaseSubmosaicProducer {
        private final CoordinateReferenceSystem crs;

        public CRSBoundMosaicProducer(RasterLayerResponse rasterLayerResponse, boolean dryRun, CoordinateReferenceSystem targetCRS, GranuleDescriptor templateDescriptor) {
            super(rasterLayerResponse, dryRun);
            this.crs = targetCRS;
            super.accept(templateDescriptor);
        }

        @Override
        public List<MosaicElement> createMosaic() throws IOException {
            MosaicElement mosaic = new Mosaicker(this.rasterLayerResponse, this.collectGranules(), MergeBehavior.FLAT).createMosaic(false, true);
            if (mosaic == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(mosaic);
        }

        @Override
        public boolean accept(GranuleDescriptor granuleDescriptor) {
            CoordinateReferenceSystem granuleCRS = granuleDescriptor.getGranuleEnvelope().getCoordinateReferenceSystem();
            boolean shouldAccept = CRS.equalsIgnoreMetadata((Object)granuleCRS, (Object)this.crs);
            return shouldAccept && super.accept(granuleDescriptor);
        }

        public CoordinateReferenceSystem getCrs() {
            return this.crs;
        }
    }
}

