/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.properties.time;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.gce.imagemosaic.properties.PropertiesCollectorSPI;
import org.geotools.gce.imagemosaic.properties.RegExPropertiesCollector;
import org.geotools.util.DateRange;
import org.geotools.util.DateTimeParser;
import org.geotools.util.logging.Logging;

class TimestampFileNameExtractor
extends RegExPropertiesCollector {
    private static final Logger LOGGER = Logging.getLogger(TimestampFileNameExtractor.class);
    private static final int DEFAULT_TIME_PARSER_FLAGS = 263;
    private static final DateTimeParser PARSER = new DateTimeParser(-1, 65799);
    private DateFormat customFormat;
    private String format;
    private boolean useHighTime = false;

    public TimestampFileNameExtractor(PropertiesCollectorSPI spi, List<String> propertyNames, String regex, String format, boolean fullPath, boolean useHighTime) {
        super(spi, propertyNames, regex, fullPath);
        if (format != null) {
            this.format = format;
            this.customFormat = new SimpleDateFormat(format);
            this.customFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
        this.useHighTime = useHighTime;
    }

    @Override
    public void setProperties(SimpleFeature feature) {
        ArrayList<Object> dates = new ArrayList<Object>();
        for (String match : this.getMatches()) {
            try {
                Object parsed;
                if (this.customFormat != null) {
                    parsed = this.customFormat.parse(match);
                    if (this.useHighTime) {
                        this.format = this.format.replace("t", "T").replace("z", "Z");
                        parsed = DateTimeParser.FormatAndPrecision.expandFromCustomFormat((Date)parsed, (String)this.format).getMaxValue();
                    }
                    dates.add(parsed);
                    continue;
                }
                parsed = PARSER.parse(match);
                parsed.stream().forEach(d -> {
                    DateRange range = (DateRange)d;
                    Date date = this.useHighTime ? range.getMaxValue() : range.getMinValue();
                    dates.add(date);
                });
            }
            catch (ParseException e) {
                if (!LOGGER.isLoggable(Level.FINE)) continue;
                LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
            }
        }
        if (dates.isEmpty()) {
            throw new IllegalArgumentException("No matches found for: " + String.valueOf(this));
        }
        int index = 0;
        for (String propertyName : this.getPropertyNames()) {
            feature.setAttribute(propertyName, dates.get(index++));
            if (index < dates.size()) continue;
            return;
        }
    }

    @Override
    public String toString() {
        return "TimestampFileNameExtractor{customFormat=" + String.valueOf(this.customFormat) + ", format='" + this.format + "', useHighTime=" + this.useHighTime + ", fullPath=" + this.fullPath + ", pattern=" + String.valueOf(this.pattern) + "}";
    }
}

