/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ows.wmts;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.geotools.data.ows.AbstractGetCapabilitiesRequest;
import org.geotools.data.ows.GetCapabilitiesRequest;
import org.geotools.data.ows.Specification;
import org.geotools.http.HTTPClient;
import org.geotools.http.HTTPClientFinder;
import org.geotools.http.HTTPResponse;
import org.geotools.ows.ServiceException;
import org.geotools.ows.wmts.WMTSHelper;
import org.geotools.ows.wmts.model.WMTSCapabilities;
import org.geotools.ows.wmts.model.WMTSServiceType;
import org.geotools.ows.wmts.request.AbstractGetTileRequest;
import org.geotools.ows.wmts.response.GetTileResponse;
import org.geotools.ows.wmts.response.WMTSGetCapabilitiesResponse;
import org.geotools.util.logging.Logging;

public class WMTSSpecification
extends Specification {
    public static final String WMTS_VERSION = "1.0.0";
    static Set<String> keywords = new TreeSet<String>();

    @Override
    public String getVersion() {
        return WMTS_VERSION;
    }

    @Override
    public GetCapabilitiesRequest createGetCapabilitiesRequest(URL server) {
        return new GetCapsRequest(server);
    }

    GetMultiTileRequest createGetMultiTileRequest(URL server, Properties props, WMTSCapabilities caps, HTTPClient client) {
        return new GetMultiTileRequest(server, props, caps, client);
    }

    public static String processKey(String key) {
        if (keywords.contains(key.toLowerCase())) {
            return key.trim().toUpperCase();
        }
        return key;
    }

    static {
        String[] words = new String[]{"request", "version", "layer", "acceptversions", "sections", "updatesequence", "acceptformats", "style", "format", "tilematrixset", "tilematrix", "tilerow", "tilecol", "j", "i", "infoformat", "service", "time", "elevation", "band"};
        keywords.addAll(Arrays.asList(words));
    }

    public static class GetCapsRequest
    extends AbstractGetCapabilitiesRequest {
        public GetCapsRequest(URL urlGetCapabilities) {
            super(urlGetCapabilities);
        }

        @Override
        protected void initService() {
            this.setProperty(this.processKey("SERVICE"), "WMTS");
        }

        @Override
        protected void initVersion() {
            this.setProperty(this.processKey("VERSION"), WMTSSpecification.WMTS_VERSION);
        }

        @Override
        protected String processKey(String key) {
            return WMTSSpecification.processKey(key);
        }

        @Override
        public WMTSGetCapabilitiesResponse createResponse(HTTPResponse httpResponse) throws ServiceException, IOException {
            return new WMTSGetCapabilitiesResponse(httpResponse, this.hints);
        }
    }

    public static class GetMultiTileRequest
    extends AbstractGetTileRequest {
        private static Logger LOGGER = Logging.getLogger(GetMultiTileRequest.class);
        public static final String DIMENSION_TIME = "time";
        public static final String DIMENSION_ELEVATION = "elevation";

        public GetMultiTileRequest(URL onlineResource, Properties properties, WMTSCapabilities capabilities) {
            this(onlineResource, properties, capabilities, HTTPClientFinder.createClient());
        }

        public GetMultiTileRequest(URL onlineResource, Properties properties, WMTSCapabilities capabilities, HTTPClient client) {
            super(onlineResource, properties, client);
            if (properties.containsKey("type")) {
                String t = (String)properties.get("type");
                if ("REST".equalsIgnoreCase(t)) {
                    this.type = WMTSServiceType.REST;
                } else if ("KVP".equalsIgnoreCase(t)) {
                    this.type = WMTSServiceType.KVP;
                }
            } else {
                this.type = capabilities.getType();
            }
            this.capabilities = capabilities;
        }

        @Override
        protected void initVersion() {
            this.setProperty("VERSION", WMTSSpecification.WMTS_VERSION);
        }

        public WMTSServiceType getType() {
            return this.type;
        }

        public void setType(WMTSServiceType type) {
            this.type = type;
        }

        @Override
        protected String createTemplateUrl(String tileMatrixSetName) {
            String format = this.getFormat();
            if (StringUtils.isEmpty((CharSequence)format) && !this.layer.getFormats().isEmpty()) {
                format = this.layer.getFormats().get(0);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Format is not set, available formats: " + String.valueOf(this.layer.getFormats()) + " -- Selecting " + format);
                }
            }
            if (StringUtils.isEmpty((CharSequence)format)) {
                format = "image/png";
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Format not set, trying with " + format);
                }
            }
            this.setFormat(format);
            String layerString = WMTSHelper.encodeParameter(this.layer.getName());
            String styleString = WMTSHelper.encodeParameter(this.styleName);
            String tileMatrixSetString = WMTSHelper.encodeParameter(this.getTileMatrixSet());
            switch (this.type) {
                case KVP: {
                    return WMTSHelper.appendQueryString(this.getFinalURL().toExternalForm(), GetMultiTileRequest.getKVPparams(this.layer.getName(), this.styleName, tileMatrixSetName, format));
                }
                case REST: {
                    return this.getRESTurl(this.getTemplateUrl(), layerString, styleString, tileMatrixSetString);
                }
            }
            throw new IllegalArgumentException("Unexpected WMTS Service type " + String.valueOf((Object)this.type));
        }

        private String getRESTurl(String baseUrl, String layerString, String styleString, String tileMatrixSetNameString) {
            baseUrl = WMTSHelper.replaceToken(baseUrl, "layer", layerString);
            baseUrl = WMTSHelper.replaceToken(baseUrl, "style", styleString);
            baseUrl = WMTSHelper.replaceToken(baseUrl, "tilematrixset", tileMatrixSetNameString);
            return baseUrl;
        }

        public static HashMap<String, String> getKVPparams(String layerString, String styleString, String tileMatrixSetName, String format) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("service", "WMTS");
            params.put("version", WMTSSpecification.WMTS_VERSION);
            params.put("request", "GetTile");
            params.put("layer", layerString);
            params.put("style", styleString);
            params.put("format", format);
            params.put("tilematrixset", tileMatrixSetName);
            params.put("TileMatrix", "{TileMatrix}");
            params.put("TileCol", "{TileCol}");
            params.put("TileRow", "{TileRow}");
            return params;
        }
    }

    public static class GetRestTileRequest
    extends GetSingleTileRequest {
        GetRestTileRequest(URL onlineResource, Properties properties, HTTPClient client) {
            super(onlineResource, properties, client);
        }

        @Override
        public URL getFinalURL() {
            if (this.layer == null || this.styleName == null || this.getFormat() == null || this.getTileMatrixSet() == null || this.getTileMatrix() == null || this.getTileCol() == null || this.getTileRow() == null) {
                throw new IllegalStateException("Missing some properties for a proper GetTile-request.");
            }
            String baseUrl = this.getTemplateUrl();
            if (baseUrl == null) {
                throw new IllegalStateException("ResourceUrl wasn't given for layer {%s} and format {%s}".formatted(new Object[]{this.layer, this.getFormat()}));
            }
            String layerString = WMTSHelper.encodeParameter(this.layer.getName());
            String styleString = WMTSHelper.encodeParameter(this.styleName);
            String tileMatrixSetString = WMTSHelper.encodeParameter(this.getTileMatrixSet());
            baseUrl = WMTSHelper.replaceToken(baseUrl, "layer", layerString);
            baseUrl = WMTSHelper.replaceToken(baseUrl, "style", styleString);
            baseUrl = WMTSHelper.replaceToken(baseUrl, "tilematrixset", tileMatrixSetString);
            baseUrl = WMTSHelper.replaceToken(baseUrl, "tilematrix", this.getTileMatrix());
            baseUrl = WMTSHelper.replaceToken(baseUrl, "tilerow", this.getTileRow().toString());
            baseUrl = WMTSHelper.replaceToken(baseUrl, "tilecol", this.getTileCol().toString());
            try {
                return new URL(baseUrl);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Error creating URL for GetTile request", e);
            }
        }

        @Override
        public GetTileResponse createResponse(HTTPResponse httpResponse) throws ServiceException, IOException {
            return new GetTileResponse(httpResponse, WMTSServiceType.REST);
        }
    }

    public static class GetKVPTileRequest
    extends GetSingleTileRequest {
        GetKVPTileRequest(URL onlineResource, Properties properties, HTTPClient client) {
            super(onlineResource, properties, client);
            properties.setProperty("type", "KVP");
        }

        @Override
        public URL getFinalURL() {
            if (this.layer == null || this.styleName == null || this.getFormat() == null || this.getTileMatrixSet() == null || this.getTileMatrix() == null || this.getTileCol() == null || this.getTileRow() == null) {
                throw new IllegalStateException("Missing some properties for a proper GetTile-request.");
            }
            String layerString = WMTSHelper.encodeParameter(this.layer.getName());
            String styleString = WMTSHelper.encodeParameter(this.styleName);
            String tileMatrixSetString = WMTSHelper.encodeParameter(this.getTileMatrixSet());
            this.setProperty("layer", layerString);
            this.setProperty("style", styleString);
            this.setProperty("format", this.getFormat());
            this.setProperty("tilematrixset", tileMatrixSetString);
            this.setProperty("TileMatrix", this.getTileMatrix());
            this.setProperty("TileCol", this.getTileCol().toString());
            this.setProperty("TileRow", this.getTileRow().toString());
            this.setProperty("time", this.getRequestedTime());
            return super.getFinalURL();
        }

        @Override
        public GetTileResponse createResponse(HTTPResponse httpResponse) throws ServiceException, IOException {
            return new GetTileResponse(httpResponse, WMTSServiceType.KVP);
        }
    }

    public static abstract class GetSingleTileRequest
    extends AbstractGetTileRequest {
        GetSingleTileRequest(URL onlineResource, Properties properties, HTTPClient client) {
            super(onlineResource, properties, client);
        }

        @Override
        protected void initVersion() {
            this.setProperty("VERSION", WMTSSpecification.WMTS_VERSION);
        }

        @Override
        protected String createTemplateUrl(String tileMatrixSetName) {
            throw new UnsupportedOperationException("Single tile request's shouldn't use a template url.");
        }
    }
}

