/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ows.wmts.map;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.imagen.ImageN;
import org.eclipse.imagen.Interpolation;
import org.geotools.api.coverage.grid.Format;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.parameter.GeneralParameterValue;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.IdentifiedObject;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.cs.AxisDirection;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.geometry.GeneralBounds;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.ows.ServiceException;
import org.geotools.ows.wms.Layer;
import org.geotools.ows.wms.xml.Dimension;
import org.geotools.ows.wmts.WebMapTileServer;
import org.geotools.ows.wmts.map.WMTSReadParameters;
import org.geotools.ows.wmts.model.WMTSLayer;
import org.geotools.ows.wmts.request.GetTileRequest;
import org.geotools.referencing.CRS;
import org.geotools.renderer.lite.RendererUtilities;
import org.geotools.renderer.lite.gridcoverage2d.GridCoverageRendererUtilities;
import org.geotools.tile.Tile;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;

public class WMTSCoverageReader
extends AbstractGridCoverage2DReader {
    public static final Logger LOGGER = Logging.getLogger(WMTSCoverageReader.class);
    static GridCoverageFactory gcf = new GridCoverageFactory();
    final WebMapTileServer wmts;
    private final WMTSLayer layer;
    String srsName;
    String format;
    Set<String> validSRS;
    ReferencedEnvelope bounds;
    private String requestedTime;
    public final boolean debug = System.getProperty("wmts.debug") != null;

    public WMTSCoverageReader(WebMapTileServer server, Layer layer) {
        this.wmts = server;
        this.layer = (WMTSLayer)layer;
        this.updateLayerBounds();
        List<String> formats = ((WMTSLayer)layer).getFormats();
        this.format = formats.iterator().next();
        for (String f : formats) {
            if (!"image/png".equals(f) && !"image/png24".equals(f) && !"png".equals(f) && !"png24".equals(f) && !"image/png; mode=24bit".equals(f)) continue;
            this.format = f;
            break;
        }
    }

    final void updateLayerBounds() {
        if (this.srsName == null) {
            for (String preferred : new String[]{"EPSG:4326", "WGS84", "CRS:84", "WGS 84", "WGS84(DD)"}) {
                if (!this.layer.getSrs().contains(preferred)) continue;
                this.srsName = preferred;
                LOGGER.info(() -> "defaulting CRS to: " + this.srsName);
            }
            if (this.srsName == null) {
                for (String srs : this.layer.getSrs()) {
                    try {
                        CRS.decode(srs);
                        this.srsName = srs;
                        LOGGER.info(() -> "setting CRS: " + this.srsName);
                        break;
                    }
                    catch (Exception exception) {
                    }
                }
            }
            if (this.srsName == null) {
                if (this.layer.getSrs().isEmpty()) {
                    LOGGER.info(() -> "adding default CRS to: " + this.srsName);
                    this.srsName = "EPSG:4326";
                    this.layer.getSrs().add(this.srsName);
                } else {
                    this.srsName = (String)this.layer.getSrs().iterator().next();
                    LOGGER.info(() -> "guessing CRS to: " + this.srsName);
                }
            }
            this.validSRS = this.layer.getSrs();
        } else {
            LOGGER.fine("Update validSRS and SrsName based on changes within layer.");
            HashSet<String> intersection = new HashSet<String>(this.validSRS);
            intersection.retainAll(this.layer.getSrs());
            if (!intersection.contains(this.srsName)) {
                if (intersection.isEmpty()) {
                    throw new IllegalArgumentException("The layer being appended does not have any SRS in common with the ones already included in the  request, cannot be merged");
                }
                this.srsName = intersection.contains("EPSG:4326") ? "EPSG:4326" : (String)intersection.iterator().next();
                this.validSRS = intersection;
            }
        }
        CoordinateReferenceSystem crs = null;
        try {
            crs = CRS.decode(this.srsName);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Default crs (" + this.srsName + ") for layer (" + String.valueOf((Object)this.layer) + ") couldn't be set.", e);
        }
        this.crs = crs;
        this.updateBounds();
    }

    public GridCoverage2D read(GeneralParameterValue ... parameters) throws IllegalArgumentException, IOException {
        String time = null;
        for (Dimension dim : this.layer.getLayerDimensions()) {
            if (!"time".equalsIgnoreCase(dim.getName())) continue;
            time = dim.getExtent().getDefaultValue();
            if (!LOGGER.isLoggable(Level.FINE)) break;
            LOGGER.fine("TIME dimension found, default is " + time);
            break;
        }
        if (this.requestedTime != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("TIME dimension requested: " + this.requestedTime);
            }
            time = this.requestedTime;
        }
        Bounds requestedEnvelope = null;
        WMTSReadParameters readParameters = new WMTSReadParameters(parameters, this.getOriginalEnvelope());
        requestedEnvelope = readParameters.getRequestedEnvelope();
        return this.getMap(this.reference(requestedEnvelope), time, readParameters);
    }

    GridCoverage2D getMap(ReferencedEnvelope requestedEnvelope, String time, WMTSReadParameters readParameters) throws IOException {
        GridCoverage2D result;
        if (this.isNativelySupported(requestedEnvelope.getCoordinateReferenceSystem())) {
            TileRequest request = this.initTileRequest(requestedEnvelope, readParameters.getWidth(), readParameters.getHeight(), time);
            result = this.createTileMap(request, requestedEnvelope, time);
        } else {
            result = this.getMapReproject(requestedEnvelope, time, readParameters);
        }
        return result;
    }

    GridCoverage2D createTileMap(TileRequest request, ReferencedEnvelope tileEnvelope, String time) throws IOException {
        try {
            GetTileRequest tileRequest = request.createTileRequest();
            Set<Tile> responses = tileRequest.getTiles();
            if (responses.isEmpty()) {
                LOGGER.fine(() -> "Found 0 tiles in " + String.valueOf((Object)tileEnvelope));
                throw new RuntimeException("No tiles were found in requested extent");
            }
            AffineTransform at = null;
            ReferencedEnvelope global = null;
            for (Tile tile : responses) {
                ReferencedEnvelope extent = tile.getExtent();
                extent = this.toEastNorthAxisOrder(extent);
                if (global == null) {
                    global = new ReferencedEnvelope(extent);
                } else {
                    global.expandToInclude(extent);
                }
                BufferedImage bi = tile.getBufferedImage();
                if (at != null) continue;
                at = RendererUtilities.worldToScreenTransform((ReferencedEnvelope)extent, (Rectangle)new Rectangle(bi.getWidth(), bi.getHeight()));
            }
            int imageWidth = (int)Math.round(global.getWidth() * at.getScaleX());
            int imageHeight = (int)Math.abs(Math.round(global.getHeight() * at.getScaleY()));
            BufferedImage image = new BufferedImage(imageWidth, imageHeight, 2);
            AffineTransform targetTransform = RendererUtilities.worldToScreenTransform((ReferencedEnvelope)global, (Rectangle)new Rectangle(0, 0, imageWidth, imageHeight));
            this.renderTiles(responses, image.createGraphics(), this.toEastNorthAxisOrder(tileEnvelope), targetTransform);
            return gcf.create((CharSequence)this.layer.getTitle(), (RenderedImage)image, (Bounds)global);
        }
        catch (FactoryException | ServiceException e) {
            throw new IOException("GetMap failed", e);
        }
    }

    private ReferencedEnvelope toEastNorthAxisOrder(ReferencedEnvelope envelope) throws FactoryException {
        CoordinateReferenceSystem crs = envelope.getCoordinateReferenceSystem();
        if (CRS.getAxisOrder(crs) != CRS.AxisOrder.NORTH_EAST) {
            return envelope;
        }
        Integer epsg = CRS.lookupEpsgCode(crs, false);
        if (epsg == null) {
            return envelope;
        }
        CoordinateReferenceSystem eastNorthCrs = CRS.decode("EPSG:" + epsg, true);
        return new ReferencedEnvelope(envelope.getMinY(), envelope.getMaxY(), envelope.getMinX(), envelope.getMaxX(), eastNorthCrs);
    }

    protected void renderTiles(Collection<Tile> tiles, Graphics2D g2d, ReferencedEnvelope viewportExtent, AffineTransform worldToImageTransform) {
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        double[] inPoints = new double[4];
        double[] outPoints = new double[4];
        for (Tile tile : tiles) {
            ReferencedEnvelope tileEnvViewport;
            ReferencedEnvelope nativeTileEnvelope = tile.getExtent();
            try {
                tileEnvViewport = nativeTileEnvelope.transform(viewportExtent.getCoordinateReferenceSystem(), true);
            }
            catch (FactoryException | TransformException e) {
                throw new RuntimeException(e);
            }
            inPoints[0] = tileEnvViewport.getMinX();
            inPoints[3] = tileEnvViewport.getMinY();
            inPoints[2] = tileEnvViewport.getMaxX();
            inPoints[1] = tileEnvViewport.getMaxY();
            worldToImageTransform.transform(inPoints, 0, outPoints, 0, 2);
            this.renderTile(tile, g2d, outPoints);
            if (!this.debug) continue;
            g2d.setColor(Color.RED);
            g2d.drawRect((int)outPoints[0], (int)outPoints[1], (int)Math.ceil(outPoints[2] - outPoints[0]), (int)Math.ceil(outPoints[3] - outPoints[1]));
            int x = (int)outPoints[0] + (int)(Math.ceil(outPoints[2] - outPoints[0]) / 2.0);
            int y = (int)outPoints[1] + (int)(Math.ceil(outPoints[3] - outPoints[1]) / 2.0);
            g2d.drawString(tile.getId(), x, y);
        }
    }

    protected void renderTile(Tile tile, Graphics2D g2d, double[] points) {
        BufferedImage img = this.getTileImage(tile);
        if (img == null) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("couldn't draw " + tile.getId());
            }
            return;
        }
        int width = (int)Math.round(points[2] - points[0]);
        int height = (int)Math.round(points[3] - points[1]);
        if (width < 1) {
            width = 1;
        }
        if (height < 1) {
            height = 1;
        }
        g2d.drawImage(img, (int)Math.round(points[0]), (int)Math.round(points[1]), width, height, null);
    }

    protected BufferedImage getTileImage(Tile tile) {
        return tile.getBufferedImage();
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    TileRequest initTileRequest(ReferencedEnvelope bbox, int width, int height, String time) throws IOException {
        ReferencedEnvelope gridEnvelope = bbox;
        Object requestSrs = this.srsName;
        try {
            Object code = null;
            Integer epsgCode = CRS.lookupEpsgCode(bbox.getCoordinateReferenceSystem(), false);
            code = epsgCode != null ? "EPSG:" + epsgCode : CRS.lookupIdentifier((IdentifiedObject)bbox.getCoordinateReferenceSystem(), false);
            if (code != null && this.validSRS.contains(code)) {
                requestSrs = code;
            } else {
                gridEnvelope = bbox.transform(this.getCoordinateReferenceSystem(), true);
                if (gridEnvelope.getWidth() < gridEnvelope.getHeight()) {
                    height = (int)Math.round((double)width * gridEnvelope.getHeight() / gridEnvelope.getWidth());
                } else {
                    width = (int)Math.round((double)height * gridEnvelope.getWidth() / gridEnvelope.getHeight());
                }
            }
        }
        catch (Exception e) {
            throw new IOException("Could not reproject the request envelope", e);
        }
        return new TileRequest(width, height, gridEnvelope, (String)requestSrs, time);
    }

    public Format getFormat() {
        return null;
    }

    public void updateBounds() {
        if (this.crs == null) {
            this.bounds = null;
            this.originalEnvelope = null;
            return;
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.entering("WMTSCoverage", "updatingBounds");
        }
        GeneralBounds envelope = this.layer.getEnvelope(this.crs);
        ReferencedEnvelope result = this.reference(envelope);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("setting bounds to " + String.valueOf((Object)result));
        }
        this.bounds = result;
        this.originalEnvelope = new GeneralBounds(result);
    }

    ReferencedEnvelope reference(Bounds envelope) {
        ReferencedEnvelope env = new ReferencedEnvelope(envelope.getCoordinateReferenceSystem());
        env.expandToInclude(envelope.getMinimum(0), envelope.getMinimum(1));
        env.expandToInclude(envelope.getMaximum(0), envelope.getMaximum(1));
        return env;
    }

    ReferencedEnvelope reference(GeneralBounds ge) {
        return new ReferencedEnvelope(ge.getMinimum(0), ge.getMaximum(0), ge.getMinimum(1), ge.getMaximum(1), ge.getCoordinateReferenceSystem());
    }

    public String[] getMetadataNames() {
        return new String[]{"ReprojectingReader"};
    }

    public String getMetadataValue(String name) {
        if ("ReprojectingReader".equals(name)) {
            return "true";
        }
        return super.getMetadataValue(name);
    }

    public String getRequestedTime() {
        return this.requestedTime;
    }

    public void setRequestedTime(String requestedTime) {
        this.requestedTime = requestedTime;
    }

    boolean isNativelySupported(CoordinateReferenceSystem crs) {
        boolean isXY = crs.getCoordinateSystem().getAxis(0).getDirection() == AxisDirection.EAST;
        for (String srs : this.validSRS) {
            try {
                CoordinateReferenceSystem validCrs = CRS.decode(srs, isXY);
                if (CRS.isTransformationRequired(validCrs, crs)) continue;
                return true;
            }
            catch (FactoryException e) {
                LOGGER.log(Level.WARNING, "Error with following srs:" + srs, e);
            }
        }
        return false;
    }

    private String switchDefinition(CoordinateReferenceSystem crs) {
        String srs = CRS.toSRS(crs);
        String result = !srs.startsWith("urn:ogc:def:crs:EPSG::") ? srs.replace("EPSG:", "urn:ogc:def:crs:EPSG::") : srs.replace("urn:ogc:def:crs:EPSG::", "EPSG");
        if (!this.validSRS.contains(result)) {
            result = this.switchPseudoMercatorDefinition(srs);
        }
        if (result != null && this.validSRS.contains(result)) {
            return result;
        }
        return null;
    }

    private String switchPseudoMercatorDefinition(String srs) {
        String switched = null;
        if (srs.equals("EPSG:3857") || srs.equals("urn:ogc:def:crs:EPSG::3857")) {
            if (this.validSRS.contains("EPSG:900913")) {
                switched = "EPSG:900913";
            } else if (this.validSRS.contains("urn:ogc:def:crs:EPSG::900913")) {
                switched = "urn:ogc:def:crs:EPSG::900913";
            }
        }
        if (srs.equals("EPSG:90013") || srs.equals("urn:ogc:def:crs:EPSG::900913")) {
            if (this.validSRS.contains("EPSG:3857")) {
                switched = "EPSG:3857";
            } else if (this.validSRS.contains("urn:ogc:def:crs:EPSG::3857")) {
                switched = "urn:ogc:def:crs:EPSG::3857";
            }
        }
        return switched;
    }

    private GridCoverage2D reproject(GridCoverage2D coverage2D, GeneralBounds destEnvelope, WMTSReadParameters readParameters) {
        try {
            Hints newHints = this.hints.clone();
            Interpolation interpolation = readParameters.getInterpolation();
            newHints.add(new RenderingHints(ImageN.KEY_INTERPOLATION, interpolation));
            GridCoverageFactory factory = CoverageFactoryFinder.getGridCoverageFactory((Hints)this.hints);
            return GridCoverageRendererUtilities.reproject((GridCoverage2D)coverage2D, (CoordinateReferenceSystem)destEnvelope.getCoordinateReferenceSystem(), (Interpolation)interpolation, (GeneralBounds)destEnvelope, (double[])readParameters.getBKGArray(), (GridCoverageFactory)factory, (Hints)newHints);
        }
        catch (FactoryException factoryException) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, this.errorMessage(destEnvelope.getCoordinateReferenceSystem()), factoryException);
            }
            throw new RuntimeException(factoryException);
        }
    }

    private String errorMessage(CoordinateReferenceSystem targetCrs) {
        StringBuilder msg = new StringBuilder("Something wrong happended while trying to reproject ");
        if (this.coverageName != null) {
            msg.append(this.coverageName).append(" ");
        }
        msg.append("WMTS coverage to ");
        if (this.crs != null) {
            msg.append(CRS.toSRS(targetCrs));
        } else {
            msg.append(" null srs.");
        }
        return msg.toString();
    }

    private GridCoverage2D getMapReproject(ReferencedEnvelope requestedEnvelope, String time, WMTSReadParameters readParameters) throws IOException {
        try {
            CoordinateReferenceSystem targetCRS = requestedEnvelope.getCoordinateReferenceSystem();
            CoordinateReferenceSystem sourceCRS = this.getBestSourceCRS(targetCRS, readParameters);
            ReferencedEnvelope nativeEnvelope = requestedEnvelope.transform(sourceCRS, false);
            TileRequest request = this.initTileRequest(nativeEnvelope, readParameters.getWidth(), readParameters.getHeight(), time);
            GridCoverage2D result = this.createTileMap(request, nativeEnvelope, time);
            if (!CRS.equalsIgnoreMetadata(result.getCoordinateReferenceSystem(), targetCRS)) {
                result = this.reproject(result, new GeneralBounds(requestedEnvelope), readParameters);
            }
            return result;
        }
        catch (FactoryException | TransformException e) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, "Error while reprojecting the requested envelope to the selected native crs.", e);
            }
            throw new IOException(e);
        }
    }

    CoordinateReferenceSystem getBestSourceCRS(CoordinateReferenceSystem targetCRS, WMTSReadParameters readParameters) throws IOException {
        String switched = this.switchDefinition(targetCRS);
        if (switched != null) {
            LOGGER.fine(() -> "Will request tiles with server supported srs " + switched);
            try {
                return CRS.decode(switched);
            }
            catch (FactoryException e) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.log(Level.SEVERE, "Error while retrieving the source CRS to perform reprojection. ", e);
                }
                throw new IOException(e);
            }
        }
        if (readParameters.getSourceCRS() != null) {
            return readParameters.getSourceCRS();
        }
        if (this.crs == null) {
            throw new IllegalStateException("Layer " + String.valueOf((Object)this.layer) + " isn't set up with a default CRS.");
        }
        return this.crs;
    }

    class TileRequest {
        int width;
        int height;
        ReferencedEnvelope envelope;
        String time;
        String tileSRS;

        TileRequest(int width, int height, ReferencedEnvelope envelope, String tileSRS, String time) {
            this.width = width;
            this.height = height;
            this.envelope = envelope;
            this.tileSRS = tileSRS;
            this.time = time;
        }

        GetTileRequest createTileRequest() {
            try {
                GetTileRequest tileRequest = WMTSCoverageReader.this.wmts.createGetTileRequest();
                tileRequest.setCRS(CRS.decode(this.tileSRS));
                tileRequest.setLayer(WMTSCoverageReader.this.layer);
                tileRequest.setRequestedHeight(this.height);
                tileRequest.setRequestedWidth(this.width);
                tileRequest.setRequestedBBox(this.envelope);
                tileRequest.setRequestedTime(this.time);
                tileRequest.setFormat(WMTSCoverageReader.this.format);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Issuing request: " + String.valueOf(tileRequest.getFinalURL()));
                }
                return tileRequest;
            }
            catch (FactoryException e) {
                throw new RuntimeException("Something misfit by application.", e);
            }
        }
    }
}

