/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ows.wmts.map;

import java.awt.Color;
import org.eclipse.imagen.Interpolation;
import org.eclipse.imagen.InterpolationNearest;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.parameter.GeneralParameterDescriptor;
import org.geotools.api.parameter.GeneralParameterValue;
import org.geotools.api.parameter.ParameterValue;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.geometry.GeneralBounds;
import org.geotools.ows.wmts.map.WMTSMapLayer;
import org.geotools.renderer.lite.gridcoverage2d.GridCoverageRendererUtilities;

class WMTSReadParameters {
    private GridGeometry2D gridGeom;
    private Color backGround;
    private Interpolation interpolation;
    private GeneralBounds originalEnvelope;
    private CoordinateReferenceSystem sourceCRS;
    private static final int DEF_WIDTH = 640;

    WMTSReadParameters(GeneralParameterValue[] parameters, GeneralBounds originalEnvelope) {
        if (parameters != null) {
            this.initFromGeneralParams(parameters);
        }
        this.originalEnvelope = originalEnvelope;
    }

    private void initFromGeneralParams(GeneralParameterValue[] parameters) {
        for (GeneralParameterValue param : parameters) {
            GeneralParameterDescriptor descriptor = param.getDescriptor();
            if (descriptor.getName().equals(AbstractGridFormat.READ_GRIDGEOMETRY2D.getName())) {
                this.gridGeom = (GridGeometry2D)((ParameterValue)param).getValue();
                continue;
            }
            if (descriptor.getName().equals(AbstractGridFormat.BACKGROUND_COLOR.getName())) {
                this.backGround = (Color)((ParameterValue)param).getValue();
                continue;
            }
            if (descriptor.getName().equals(AbstractGridFormat.INTERPOLATION.getName())) {
                this.interpolation = (Interpolation)((ParameterValue)param).getValue();
                continue;
            }
            if (!descriptor.getName().equals(WMTSMapLayer.SOURCE_CRS.getName())) continue;
            this.sourceCRS = (CoordinateReferenceSystem)((ParameterValue)param).getValue();
        }
    }

    Interpolation getInterpolation() {
        if (this.interpolation == null) {
            this.interpolation = new InterpolationNearest();
        }
        return this.interpolation;
    }

    double[] getBKGArray() {
        Color color = this.backGround == null ? Color.BLACK : this.backGround;
        return GridCoverageRendererUtilities.colorToArray((Color)color);
    }

    Bounds getRequestedEnvelope() {
        Bounds result = this.gridGeom.getEnvelope();
        if (result == null) {
            result = this.originalEnvelope;
        }
        return result;
    }

    int getWidth() {
        int result = 640;
        if (this.gridGeom.getEnvelope() != null) {
            result = this.gridGeom.getGridRange().getHigh(0) + 1;
        }
        return result;
    }

    int getHeight() {
        int height;
        if (this.gridGeom.getEnvelope() == null) {
            double ySpanRatio = this.originalEnvelope.getSpan(1) / this.originalEnvelope.getSpan(0);
            height = (int)Math.round(ySpanRatio * 640.0);
        } else {
            height = this.gridGeom.getGridRange().getHigh(1) + 1;
        }
        return height;
    }

    CoordinateReferenceSystem getSourceCRS() {
        return this.sourceCRS;
    }
}

