/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ows.wmts.model;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.opengis.ows11.AllowedValuesType;
import net.opengis.ows11.BoundingBoxType;
import net.opengis.ows11.CodeType;
import net.opengis.ows11.DCPType;
import net.opengis.ows11.DomainMetadataType;
import net.opengis.ows11.DomainType;
import net.opengis.ows11.LanguageStringType;
import net.opengis.ows11.OperationType;
import net.opengis.ows11.OperationsMetadataType;
import net.opengis.ows11.RequestMethodType;
import net.opengis.ows11.ValueType;
import net.opengis.ows11.WGS84BoundingBoxType;
import net.opengis.wmts.v_1.CapabilitiesType;
import net.opengis.wmts.v_1.ContentsType;
import net.opengis.wmts.v_1.DimensionType;
import net.opengis.wmts.v_1.LayerType;
import net.opengis.wmts.v_1.LegendURLType;
import net.opengis.wmts.v_1.StyleType;
import net.opengis.wmts.v_1.TileMatrixLimitsType;
import net.opengis.wmts.v_1.TileMatrixSetLimitsType;
import net.opengis.wmts.v_1.TileMatrixSetLinkType;
import net.opengis.wmts.v_1.TileMatrixSetType;
import net.opengis.wmts.v_1.TileMatrixType;
import net.opengis.wmts.v_1.URLTemplateType;
import org.eclipse.emf.common.util.EList;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.TransformException;
import org.geotools.api.util.InternationalString;
import org.geotools.data.ows.Capabilities;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.ows.ServiceException;
import org.geotools.ows.wms.CRSEnvelope;
import org.geotools.ows.wms.StyleImpl;
import org.geotools.ows.wms.xml.Dimension;
import org.geotools.ows.wms.xml.Extent;
import org.geotools.ows.wmts.model.TileMatrix;
import org.geotools.ows.wmts.model.TileMatrixLimits;
import org.geotools.ows.wmts.model.TileMatrixSet;
import org.geotools.ows.wmts.model.TileMatrixSetLink;
import org.geotools.ows.wmts.model.WMTSLayer;
import org.geotools.ows.wmts.model.WMTSRequest;
import org.geotools.ows.wmts.model.WMTSService;
import org.geotools.ows.wmts.model.WMTSServiceType;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.util.SimpleInternationalString;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;

public class WMTSCapabilities
extends Capabilities {
    public static final Logger LOGGER = Logging.getLogger(WMTSCapabilities.class);
    private WMTSRequest request;
    private GeometryFactory gf = new GeometryFactory();
    CapabilitiesType caps;
    private final Map<String, WMTSLayer> layerMap = new HashMap<String, WMTSLayer>();
    private final List<WMTSLayer> layers = new ArrayList<WMTSLayer>();
    private final Map<String, TileMatrixSet> matrixSetMap = new HashMap<String, TileMatrixSet>();
    private final List<TileMatrixSet> matrixes = new ArrayList<TileMatrixSet>();
    private String[] exceptions = new String[0];
    private WMTSServiceType type;

    public WMTSCapabilities(CapabilitiesType capabilities) throws ServiceException {
        this.caps = capabilities;
        this.setService(new WMTSService(this.caps.getServiceIdentification(), this.caps.getServiceProvider()));
        this.setVersion(this.caps.getServiceIdentification().getServiceTypeVersion().toString());
        ContentsType contents = this.caps.getContents();
        for (Object l : contents.getDatasetDescriptionSummary()) {
            if (l instanceof LayerType) {
                LayerType layerType = (LayerType)l;
                WMTSLayer layer = this.parseLayer(layerType);
                this.layers.add(layer);
                this.layerMap.put(layer.getName(), layer);
                continue;
            }
            if (!LOGGER.isLoggable(Level.INFO)) continue;
            LOGGER.info("Unknown object " + String.valueOf(l));
        }
        for (TileMatrixSetType tm : contents.getTileMatrixSet()) {
            TileMatrixSet matrixSet = this.parseMatrixSet(tm);
            this.matrixes.add(matrixSet);
            this.matrixSetMap.put(matrixSet.getIdentifier(), matrixSet);
        }
        for (WMTSLayer wmtsLayer : this.layers) {
            this.fillTileMatrixSet(wmtsLayer);
        }
        this.request = new WMTSRequest();
        this.parseOperations();
    }

    private void parseOperations() throws ServiceException {
        org.geotools.data.ows.OperationType operationType = new org.geotools.data.ows.OperationType();
        operationType.setGet(null);
        this.request.setGetCapabilities(operationType);
        OperationsMetadataType operationsMetadata = this.caps.getOperationsMetadata();
        this.setType(WMTSServiceType.REST);
        boolean isKVP = false;
        boolean isREST = false;
        if (operationsMetadata != null) {
            for (Object op : operationsMetadata.getOperation()) {
                org.geotools.data.ows.OperationType opt = operationType;
                OperationType opx = (OperationType)op;
                EList dcps = opx.getDCP();
                for (Object item : dcps) {
                    DCPType dcp = (DCPType)item;
                    EList gets = dcp.getHTTP().getGet();
                    for (Object value : gets) {
                        RequestMethodType get = (RequestMethodType)value;
                        try {
                            opt.setGet(new URL(get.getHref()));
                            if (get.getConstraint().isEmpty()) continue;
                            for (Object con : get.getConstraint()) {
                                DomainType dt = (DomainType)con;
                                AllowedValuesType t = dt.getAllowedValues();
                                for (Object v : t.getValue()) {
                                    ValueType vt = (ValueType)v;
                                    if (vt.getValue().equalsIgnoreCase("KVP")) {
                                        isKVP = true;
                                        continue;
                                    }
                                    if (!vt.getValue().equalsIgnoreCase("REST") && !vt.getValue().equalsIgnoreCase("RESTful")) continue;
                                    isREST = true;
                                }
                            }
                        }
                        catch (MalformedURLException e) {
                            throw new ServiceException("Error parsing WMTS operation URL: " + e.getMessage());
                        }
                    }
                    EList posts = dcp.getHTTP().getPost();
                    for (Object o : posts) {
                        RequestMethodType post = (RequestMethodType)o;
                        try {
                            Object con;
                            opt.setPost(new URL(post.getHref()));
                            if (post.getConstraint().isEmpty()) continue;
                            con = post.getConstraint().iterator();
                            while (con.hasNext()) {
                                Object con2 = con.next();
                                DomainType dt = (DomainType)con2;
                                AllowedValuesType t = dt.getAllowedValues();
                                for (Object v : t.getValue()) {
                                    ValueType vt = (ValueType)v;
                                    if (vt.getValue().equalsIgnoreCase("KVP")) {
                                        isKVP = true;
                                        continue;
                                    }
                                    if (!vt.getValue().equalsIgnoreCase("REST") && !vt.getValue().equalsIgnoreCase("RESTful")) continue;
                                    isREST = true;
                                }
                            }
                        }
                        catch (MalformedURLException e) {
                            throw new ServiceException("Error parsing WMTS operation URL: " + e.getMessage());
                        }
                    }
                }
                if (isREST) {
                    this.setType(WMTSServiceType.REST);
                } else if (isKVP) {
                    this.setType(WMTSServiceType.KVP);
                }
                if (opx.getName().equalsIgnoreCase("GetCapabilities")) {
                    this.request.setGetCapabilities(opt);
                    continue;
                }
                if (!opx.getName().equalsIgnoreCase("GetTile")) continue;
                this.request.setGetTile(opt);
            }
        }
    }

    private void fillTileMatrixSet(WMTSLayer wmtsLayer) {
        if (wmtsLayer.getLatLonBoundingBox() == null) {
            this.setLatLonBBox(wmtsLayer);
        }
        ReferencedEnvelope wgs84Env = new ReferencedEnvelope((Bounds)wmtsLayer.getLatLonBoundingBox());
        Map<String, TileMatrixSetLink> tileMatrixLinks = wmtsLayer.getTileMatrixLinks();
        Iterator<Map.Entry<String, TileMatrixSetLink>> iterator = tileMatrixLinks.entrySet().iterator();
        while (iterator.hasNext()) {
            TileMatrixSetLink tmsLink = iterator.next().getValue();
            String tmsIdentifier = tmsLink.getIdentifier();
            TileMatrixSet tms = this.matrixSetMap.get(tmsIdentifier);
            if (tms == null) {
                LOGGER.info("WMTS capabilities for layer %s specified a TileMatrixSet link %s that doesn't exist.".formatted(wmtsLayer.getName(), tmsIdentifier));
                iterator.remove();
                continue;
            }
            CoordinateReferenceSystem tmsCRS = tms.getCoordinateReferenceSystem();
            wmtsLayer.addSRS(tmsCRS);
            String srs = CRS.toSRS(tmsCRS);
            if (tms.getBbox() != null) {
                wmtsLayer.getBoundingBoxes().put(srs, tms.getBbox());
                continue;
            }
            try {
                wmtsLayer.getBoundingBoxes().put(srs, new CRSEnvelope((Bounds)wgs84Env.transform(tmsCRS, true)));
            }
            catch (FactoryException | TransformException e) {
                if (!LOGGER.isLoggable(Level.INFO)) continue;
                LOGGER.log(Level.INFO, "Not adding CRS " + srs + " for layer " + wmtsLayer.getName(), e);
            }
        }
    }

    private void setLatLonBBox(WMTSLayer wmtsLayer) {
        for (TileMatrixSetLink tmsLink : wmtsLayer.getTileMatrixLinks().values()) {
            TileMatrixSet tms = this.matrixSetMap.get(tmsLink.getIdentifier());
            if (tms.getBbox() == null) continue;
            ReferencedEnvelope re = new ReferencedEnvelope((Bounds)tms.getBbox());
            try {
                ReferencedEnvelope wgs84re = re.transform(DefaultGeographicCRS.WGS84, true);
                wmtsLayer.setLatLonBoundingBox(new CRSEnvelope((Bounds)wgs84re));
                break;
            }
            catch (Exception ex) {
                if (!LOGGER.isLoggable(Level.FINE)) continue;
                LOGGER.fine("Can't use " + tms.getIdentifier() + " for bbox: " + ex.getMessage());
            }
        }
        if (wmtsLayer.getLatLonBoundingBox() == null) {
            LOGGER.warning("No good Bbox found for layer " + wmtsLayer.getName());
            CRSEnvelope latLonBoundingBox = new CRSEnvelope("CRS:84", -180.0, -90.0, 180.0, 90.0);
            wmtsLayer.setLatLonBoundingBox(latLonBoundingBox);
            wmtsLayer.setBoundingBoxes(latLonBoundingBox);
        }
    }

    private TileMatrixSet parseMatrixSet(TileMatrixSetType tm) throws RuntimeException, IllegalArgumentException, ServiceException {
        TileMatrixSet matrixSet = new TileMatrixSet();
        matrixSet.setCRS(tm.getSupportedCRS());
        matrixSet.setWellKnownScaleSet(tm.getWellKnownScaleSet());
        matrixSet.setIdentifier(tm.getIdentifier().getValue());
        if (tm.getBoundingBox() != null) {
            matrixSet.setBbox(WMTSCapabilities.bbox2bbox(tm.getBoundingBox()));
        }
        for (TileMatrixType mat : tm.getTileMatrix()) {
            TileMatrix matrix = new TileMatrix();
            matrix.setIdentifier(mat.getIdentifier().getValue());
            matrix.setDenominator(mat.getScaleDenominator());
            matrix.setMatrixHeight(mat.getMatrixHeight().intValue());
            matrix.setMatrixWidth(mat.getMatrixWidth().intValue());
            matrix.setTileHeight(mat.getTileHeight().intValue());
            matrix.setTileWidth(mat.getTileWidth().intValue());
            matrix.setParent(matrixSet);
            if (matrix.getCrs() == null) {
                throw new ServiceException("MatrixSet " + tm.getIdentifier().getValue() + ": unable to create CRS " + matrixSet.getCrs());
            }
            List c = mat.getTopLeftCorner();
            matrix.setTopLeft(this.gf.createPoint(new Coordinate(((Double)c.get(0)).doubleValue(), ((Double)c.get(1)).doubleValue())));
            matrixSet.addMatrix(matrix);
        }
        return matrixSet;
    }

    private WMTSLayer parseLayer(LayerType layerType) {
        EList dimensionList;
        String name = layerType.getIdentifier().getValue();
        String title = !layerType.getTitle().isEmpty() ? ((LanguageStringType)layerType.getTitle().get(0)).getValue() : name;
        WMTSLayer layer = new WMTSLayer(title);
        layer.setName(name);
        if (!layerType.getAbstract().isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (Object line : layerType.getAbstract()) {
                if (line instanceof LanguageStringType) {
                    LanguageStringType stringType = (LanguageStringType)line;
                    sb.append(stringType.getValue());
                    break;
                }
                sb.append(line);
            }
            layer.set_abstract(sb.toString());
        }
        EList tmsLinks = layerType.getTileMatrixSetLink();
        for (TileMatrixSetLinkType linkType : tmsLinks) {
            TileMatrixSetLink link = new TileMatrixSetLink();
            link.setIdentifier(linkType.getTileMatrixSet());
            TileMatrixSetLimitsType limits = linkType.getTileMatrixSetLimits();
            if (limits != null) {
                for (TileMatrixLimitsType tmlt : limits.getTileMatrixLimits()) {
                    TileMatrixLimits tml = new TileMatrixLimits();
                    tml.setTileMatix(tmlt.getTileMatrix());
                    tml.setMinCol(tmlt.getMinTileCol().longValue());
                    tml.setMaxCol(tmlt.getMaxTileCol().longValue());
                    tml.setMinRow(tmlt.getMinTileRow().longValue());
                    tml.setMaxRow(tmlt.getMaxTileRow().longValue());
                    link.addLimit(tml);
                }
            }
            layer.addTileMatrixLink(link);
        }
        layer.getFormats().addAll((Collection<String>)layerType.getFormat());
        layer.getInfoFormats().addAll((Collection<String>)layerType.getInfoFormat());
        EList styles = layerType.getStyle();
        ArrayList<Object> sList = new ArrayList<Object>();
        for (StyleType styleType : styles) {
            Object title12;
            StyleImpl style = new StyleImpl();
            style.setName(styleType.getIdentifier().getValue());
            StringBuilder t = new StringBuilder();
            for (Object title12 : styleType.getTitle()) {
                if (title12 instanceof LanguageStringType) {
                    t.append(((LanguageStringType)title12).getValue());
                    continue;
                }
                t.append(title12.toString());
            }
            if (!t.isEmpty()) {
                style.setTitle((InternationalString)new SimpleInternationalString(t.toString()));
            }
            style.setDefault(styleType.isIsDefault());
            if (styleType.isIsDefault()) {
                layer.setDefaultStyle(style);
            }
            ArrayList<String> legendURLS = new ArrayList<String>();
            title12 = styleType.getLegendURL().iterator();
            while (title12.hasNext()) {
                LegendURLType legendURLType = (LegendURLType)title12.next();
                legendURLS.add(legendURLType.getHref());
            }
            style.setLegendURLs(legendURLS);
            sList.add(style);
        }
        layer.setStyles(sList);
        EList bboxes = layerType.getBoundingBox();
        HashMap<String, CRSEnvelope> boundingBoxes = new HashMap<String, CRSEnvelope>();
        for (BoundingBoxType bbox : bboxes) {
            boundingBoxes.put(bbox.getCrs(), WMTSCapabilities.bbox2bbox(bbox));
        }
        WGS84BoundingBoxType wgsBBox = null;
        if (!layerType.getWGS84BoundingBox().isEmpty()) {
            wgsBBox = (WGS84BoundingBoxType)layerType.getWGS84BoundingBox().get(0);
        }
        if (wgsBBox != null) {
            int y;
            int x;
            if (CRS.getAxisOrder(DefaultGeographicCRS.WGS84).equals((Object)CRS.AxisOrder.NORTH_EAST)) {
                x = 1;
                y = 0;
            } else {
                x = 0;
                y = 1;
            }
            boundingBoxes.put("CRS:84", new CRSEnvelope("CRS:84", ((Double)wgsBBox.getLowerCorner().get(x)).doubleValue(), ((Double)wgsBBox.getLowerCorner().get(y)).doubleValue(), ((Double)wgsBBox.getUpperCorner().get(x)).doubleValue(), ((Double)wgsBBox.getUpperCorner().get(y)).doubleValue()));
            layer.setLatLonBoundingBox((CRSEnvelope)boundingBoxes.get("CRS:84"));
        }
        layer.setBoundingBoxes(boundingBoxes);
        EList resourceURL = layerType.getResourceURL();
        if (resourceURL != null && !resourceURL.isEmpty()) {
            for (URLTemplateType resource : resourceURL) {
                String template = resource.getTemplate();
                String format = resource.getFormat();
                layer.putResourceURL(format, template);
            }
        }
        if ((dimensionList = layerType.getDimension()) != null && !dimensionList.isEmpty()) {
            for (DimensionType dimensionType : dimensionList) {
                CodeType identifierType = dimensionType.getIdentifier();
                String dimIdentifier = identifierType.getValue();
                String dimDefault = dimensionType.getDefault();
                DomainMetadataType uom = dimensionType.getUOM();
                String dimUom = uom == null ? "N/A" : uom.getValue();
                Dimension d = new Dimension(dimIdentifier, dimUom);
                d.setUnitSymbol(dimensionType.getUnitSymbol());
                d.setCurrent(dimensionType.isCurrent());
                String dimValues = String.join((CharSequence)",", (Iterable<? extends CharSequence>)dimensionType.getValue());
                Extent e = new Extent(dimIdentifier, dimDefault, Boolean.valueOf(false), Boolean.valueOf(false), dimValues);
                d.setExtent(e);
                layer.getLayerDimensions().add(d);
            }
        }
        return layer;
    }

    private void setType(WMTSServiceType type) {
        this.type = type;
    }

    public WMTSServiceType getType() {
        return this.type;
    }

    public List<WMTSLayer> getLayerList() {
        return Collections.unmodifiableList(this.layers);
    }

    public WMTSRequest getRequest() {
        return this.request;
    }

    public void setRequest(WMTSRequest request) {
        this.request = request;
    }

    public String[] getExceptions() {
        return this.exceptions;
    }

    public void setExceptions(String[] exceptions) {
        this.exceptions = exceptions;
    }

    public List<TileMatrixSet> getMatrixSets() {
        return Collections.unmodifiableList(this.matrixes);
    }

    public void setMatrixSets(List<TileMatrixSet> matrixes) {
        this.matrixSetMap.clear();
        this.matrixes.clear();
        for (TileMatrixSet tms : matrixes) {
            this.matrixSetMap.put(tms.getIdentifier(), tms);
            this.matrixes.add(tms);
        }
    }

    public TileMatrixSet getMatrixSet(String identifier) {
        return this.matrixSetMap.get(identifier);
    }

    public WMTSLayer getLayer(String name) {
        return this.layerMap.get(name);
    }

    public static CRSEnvelope bbox2bbox(BoundingBoxType bbox) {
        return new CRSEnvelope(bbox.getCrs(), ((Double)bbox.getLowerCorner().get(0)).doubleValue(), ((Double)bbox.getLowerCorner().get(1)).doubleValue(), ((Double)bbox.getUpperCorner().get(0)).doubleValue(), ((Double)bbox.getUpperCorner().get(1)).doubleValue());
    }
}

