/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ows.wmts.model;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.opengis.ows11.LanguageStringType;
import net.opengis.ows11.ServiceIdentificationType;
import net.opengis.ows11.ServiceProviderType;
import net.opengis.ows11.impl.KeywordsTypeImpl;
import net.opengis.ows11.impl.LanguageStringTypeImpl;
import org.geotools.api.metadata.citation.ResponsibleParty;
import org.geotools.api.util.InternationalString;
import org.geotools.data.ows.Service;
import org.geotools.metadata.iso.citation.ResponsiblePartyImpl;
import org.geotools.util.SimpleInternationalString;
import org.geotools.util.logging.Logging;

public class WMTSService
extends Service {
    static final Logger LOGGER = Logging.getLogger(WMTSService.class);

    public WMTSService(ServiceIdentificationType serviceType, ServiceProviderType serviceProvider) {
        this(serviceType);
        if (serviceProvider == null) {
            return;
        }
        ResponsiblePartyImpl contactInfo = new ResponsiblePartyImpl(serviceProvider.getServiceContact());
        if (serviceProvider.getProviderName() != null) {
            contactInfo.setOrganisationName((InternationalString)new SimpleInternationalString(serviceProvider.getProviderName()));
        }
        this.setContactInformation((ResponsibleParty)contactInfo);
        if (serviceProvider.getProviderSite() != null) {
            try {
                URL providerSite = new URL(serviceProvider.getProviderSite().getHref());
                this.setOnlineResource(providerSite);
            }
            catch (MalformedURLException e) {
                LOGGER.log(Level.SEVERE, "", e);
            }
        }
    }

    public WMTSService(ServiceIdentificationType serviceType) {
        this.setName("");
        this.setTitle("");
        if (serviceType == null) {
            return;
        }
        String title = serviceType.getTitle().isEmpty() ? "N/A" : ((LanguageStringType)serviceType.getTitle().get(0)).getValue();
        this.setTitle(title);
        this.setName(serviceType.getServiceType().getValue());
        StringBuilder sb = new StringBuilder();
        for (Object line : serviceType.getAbstract()) {
            if (line instanceof LanguageStringType) {
                LanguageStringType type = (LanguageStringType)line;
                sb.append(type.getValue());
                continue;
            }
            sb.append(line);
        }
        this.set_abstract(sb.toString());
        ArrayList<String> retList = new ArrayList<String>();
        for (Object okti : serviceType.getKeywords()) {
            KeywordsTypeImpl kti = (KeywordsTypeImpl)okti;
            for (Object olsti : kti.getKeyword()) {
                LanguageStringTypeImpl lsti = (LanguageStringTypeImpl)olsti;
                retList.add(lsti.getValue());
            }
        }
        this.setKeywordList(retList.toArray(new String[retList.size()]));
    }
}

