/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ows.wmts.request;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.http.HTTPClient;
import org.geotools.http.HTTPClientFinder;
import org.geotools.ows.ServiceException;
import org.geotools.ows.wms.StyleImpl;
import org.geotools.ows.wmts.WMTSHelper;
import org.geotools.ows.wmts.client.WMTSTileFactory;
import org.geotools.ows.wmts.client.WMTSTileService;
import org.geotools.ows.wmts.model.TileMatrixSet;
import org.geotools.ows.wmts.model.TileMatrixSetLink;
import org.geotools.ows.wmts.model.WMTSCapabilities;
import org.geotools.ows.wmts.model.WMTSLayer;
import org.geotools.ows.wmts.model.WMTSServiceType;
import org.geotools.ows.wmts.request.AbstractWMTSRequest;
import org.geotools.ows.wmts.request.GetTileRequest;
import org.geotools.referencing.CRS;
import org.geotools.renderer.lite.RendererUtilities;
import org.geotools.tile.Tile;
import org.geotools.util.logging.Logging;

public abstract class AbstractGetTileRequest
extends AbstractWMTSRequest
implements GetTileRequest {
    private static final int MAXTILES = 256;
    static WMTSTileFactory factory = new WMTSTileFactory();
    public static final String LAYER = "Layer";
    public static final String STYLE = "Style";
    public static final String FORMAT = "Format";
    private final HTTPClient client;
    protected WMTSLayer layer = null;
    protected String styleName = "";
    private String srs;
    static final Logger LOGGER = Logging.getLogger(AbstractGetTileRequest.class);
    protected WMTSServiceType type;
    protected WMTSCapabilities capabilities;
    private ReferencedEnvelope requestedBBox;
    private int requestedHeight;
    private int requestedWidth;
    private String requestedTime;
    private CoordinateReferenceSystem crs;
    private final Map<String, String> headers = new HashMap<String, String>();
    private String format = null;
    private String tileMatrixSet = null;
    private String tileMatrix = null;
    private Integer tileRow = null;
    private Integer tileCol = null;

    public AbstractGetTileRequest(URL onlineResource, Properties properties) {
        this(onlineResource, properties, HTTPClientFinder.createClient());
    }

    public AbstractGetTileRequest(URL onlineResource, Properties properties, HTTPClient client) {
        super(onlineResource, properties);
        Objects.requireNonNull(client, "client");
        this.client = client;
    }

    @Override
    protected abstract void initVersion();

    @Override
    protected void initRequest() {
        this.setProperty("REQUEST", "GetTile");
    }

    @Override
    public void setLayer(WMTSLayer layer) {
        if (layer == null) {
            throw new IllegalArgumentException("Attempt to add a NULL layer to WMTS");
        }
        this.layer = layer;
        if (this.styleName.isEmpty()) {
            StyleImpl defaultStyle = layer.getDefaultStyle();
            if (defaultStyle != null && defaultStyle.getName() != null) {
                this.setStyle(defaultStyle.getName());
            } else {
                for (int i = 0; i < layer.getStyles().size(); ++i) {
                    StyleImpl aStyle = (StyleImpl)layer.getStyles().get(i);
                    if (aStyle.getName() == null) continue;
                    this.setStyle(aStyle.getName());
                    break;
                }
            }
        }
    }

    @Override
    public void setStyle(String styleName) {
        this.styleName = styleName;
    }

    public String getFormat() {
        return this.format;
    }

    @Override
    public void setFormat(String format) {
        this.format = format;
    }

    @Override
    public void setTileMatrixSet(String tileMatrixSet) {
        this.tileMatrixSet = tileMatrixSet;
    }

    protected String getTileMatrixSet() {
        return this.tileMatrixSet;
    }

    @Override
    public void setTileMatrix(String tileMatrix) {
        this.tileMatrix = tileMatrix;
    }

    public String getTileMatrix() {
        return this.tileMatrix;
    }

    @Override
    public void setTileRow(Integer tileRow) {
        this.tileRow = tileRow;
    }

    protected Integer getTileRow() {
        return this.tileRow;
    }

    @Override
    public void setTileCol(Integer tileCol) {
        this.tileCol = tileCol;
    }

    protected Integer getTileCol() {
        return this.tileCol;
    }

    @Override
    public void setRequestedHeight(int height) {
        this.requestedHeight = height;
    }

    @Override
    public void setRequestedWidth(int width) {
        this.requestedWidth = width;
    }

    @Override
    public void setRequestedBBox(ReferencedEnvelope requestedBBox) {
        this.requestedBBox = requestedBBox;
    }

    protected String getRequestedTime() {
        return this.requestedTime;
    }

    @Override
    public void setRequestedTime(String requestedTime) {
        this.requestedTime = requestedTime;
    }

    @Override
    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public CoordinateReferenceSystem getCrs() {
        return this.crs;
    }

    @Override
    public void setCRS(CoordinateReferenceSystem coordinateReferenceSystem) {
        this.crs = coordinateReferenceSystem;
    }

    @Override
    public Set<Tile> getTiles() throws ServiceException {
        if (this.layer == null) {
            throw new ServiceException("GetTiles called with no layer set");
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("getTiles:  layer:" + String.valueOf((Object)this.layer) + " w:" + this.requestedWidth + " x h:" + this.requestedHeight);
        }
        TileMatrixSet matrixSet = this.selectMatrixSet();
        String templateUrl = this.createTemplateUrl(matrixSet.getIdentifier());
        templateUrl = WMTSHelper.replaceToken(templateUrl, "time", this.requestedTime);
        WMTSTileService wmtsService = new WMTSTileService(templateUrl, this.layer, matrixSet, this.client);
        Map extraHeaders = (Map)wmtsService.getExtrainfo().computeIfAbsent("HEADERS", extra -> new HashMap());
        extraHeaders.putAll(this.headers);
        double scale = Math.round(RendererUtilities.calculateOGCScale((ReferencedEnvelope)this.requestedBBox, (int)this.requestedWidth, null));
        return wmtsService.findTilesInExtent(this.requestedBBox, (int)scale, false, 256);
    }

    protected abstract String createTemplateUrl(String var1);

    public String getTemplateUrl() {
        if (this.layer.getTemplate(this.format) == null) {
            throw new IllegalStateException("Template URL not available for GetTile request with format  " + this.format);
        }
        return this.layer.getTemplate(this.format);
    }

    private TileMatrixSet selectMatrixSet() throws ServiceException, RuntimeException {
        TileMatrixSet retMatrixSet = null;
        Map<String, TileMatrixSetLink> links = this.layer.getTileMatrixLinks();
        CoordinateReferenceSystem requestCRS = this.getCrs();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("request CRS " + String.valueOf(requestCRS == null ? "NULL" : requestCRS.getName()));
        }
        if (requestCRS == null && this.srs != null) {
            try {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("request CRS decoding" + this.srs);
                }
                requestCRS = CRS.decode(this.srs);
            }
            catch (FactoryException e) {
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.log(Level.FINER, e.getMessage(), e);
                }
                throw new RuntimeException(e);
            }
        }
        if (requestCRS == null && this.requestedBBox != null) {
            requestCRS = this.requestedBBox.getCoordinateReferenceSystem();
        }
        if (requestCRS == null) {
            throw new ServiceException("CRS or SRS wasn't set for this GetTileRequest.");
        }
        String requestSRS = CRS.toSRS(requestCRS);
        for (TileMatrixSet matrixSet : this.capabilities.getMatrixSets()) {
            CoordinateReferenceSystem matrixCRS = matrixSet.getCoordinateReferenceSystem();
            String matrixSRS = CRS.toSRS(matrixCRS);
            if (!requestSRS.equals(matrixSRS) || !links.containsKey(matrixSet.getIdentifier())) continue;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("selected matrix set:" + matrixSet.getIdentifier());
            }
            this.setTileMatrixSet(matrixSet.getIdentifier());
            retMatrixSet = matrixSet;
            break;
        }
        if (retMatrixSet == null) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("Failed to match the requested CRS (" + String.valueOf(requestCRS.getName()) + ") with any of the tile matrices!");
            }
            for (TileMatrixSet matrix : this.capabilities.getMatrixSets()) {
                if (!links.containsKey(matrix.getIdentifier())) continue;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("defaulting matrix set:" + matrix.getIdentifier());
                }
                this.setTileMatrixSet(matrix.getIdentifier());
                retMatrixSet = matrix;
                break;
            }
        }
        if (retMatrixSet == null) {
            throw new ServiceException("Unable to find a matching TileMatrixSet for layer " + this.layer.getName() + " and SRS: " + String.valueOf(requestCRS.getName()));
        }
        return retMatrixSet;
    }
}

