/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.ows.wmts.response;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import net.opengis.wmts.v_1.CapabilitiesType;
import org.geotools.data.ows.GetCapabilitiesResponse;
import org.geotools.data.ows.ServiceExceptionParser;
import org.geotools.http.HTTPResponse;
import org.geotools.ows.ServiceException;
import org.geotools.ows.wmts.model.WMTSCapabilities;
import org.geotools.util.logging.Logging;
import org.geotools.wmts.WMTSConfiguration;
import org.geotools.xsd.Configuration;
import org.geotools.xsd.Parser;
import org.xml.sax.SAXException;

public class WMTSGetCapabilitiesResponse
extends GetCapabilitiesResponse {
    private static final Logger LOGGER = Logging.getLogger(WMTSGetCapabilitiesResponse.class);
    private static WMTSConfiguration WMTS_CONFIGURATION = new WMTSConfiguration();
    private static final int MAX_BUFFER_SIZE = 2048;

    public WMTSGetCapabilitiesResponse(HTTPResponse response) throws ServiceException, IOException {
        this(response, null);
    }

    public WMTSGetCapabilitiesResponse(HTTPResponse response, Map<String, Object> hints) throws ServiceException, IOException {
        block16: {
            super(response);
            byte[] buffer = new byte[2048];
            try (BufferedInputStream inputStream = new BufferedInputStream(response.getResponseStream(), 2048);){
                Object object;
                ((InputStream)inputStream).mark(2048);
                int bytesRead = ((InputStream)inputStream).read(buffer, 0, 2048);
                ((InputStream)inputStream).reset();
                try {
                    Parser parser = new Parser((Configuration)WMTS_CONFIGURATION);
                    object = parser.parse((InputStream)inputStream);
                }
                catch (ParserConfigurationException | SAXException e) {
                    throw new IOException("Error while parsing XML.", e);
                }
                if (object instanceof CapabilitiesType) {
                    CapabilitiesType type = (CapabilitiesType)object;
                    this.capabilities = new WMTSCapabilities(type);
                    break block16;
                }
                try (ByteArrayInputStream bufferedStream = new ByteArrayInputStream(buffer, 0, bytesRead);){
                    object = ServiceExceptionParser.parse(bufferedStream);
                    if (object instanceof ServiceException) {
                        LOGGER.log(Level.SEVERE, "Server returned ServiceException.", (Throwable)object);
                        throw (ServiceException)object;
                    }
                }
                catch (IOException e) {
                    LOGGER.log(Level.SEVERE, "Server returned xml that couldn't be parsed by ServiceExceptionParser.", e);
                }
                throw new IOException("Server returned wrong xml.");
            }
        }
    }
}

