/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.appschema.resolver.xml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.geotools.xml.resolver.SchemaCatalog;
import org.geotools.xml.resolver.SchemaResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.EntityResolver2;

public class AppSchemaValidator {
    private static final Pattern XML_ENCODING_PATTERN = Pattern.compile("<\\?xml.*?encoding=[\"'](.+?)[\"'].*?\\?>.*");
    private final SchemaResolver resolver;
    private final List<String> failures = new ArrayList<String>();
    private boolean failOnWarning = true;

    private AppSchemaValidator() {
        this(new SchemaResolver());
    }

    private AppSchemaValidator(SchemaResolver resolver) {
        this.resolver = resolver;
    }

    private AppSchemaValidator(SchemaCatalog catalog) {
        this(new SchemaResolver(catalog));
    }

    public List<String> getFailures() {
        return Collections.unmodifiableList(this.failures);
    }

    public boolean isFailOnWarning() {
        return this.failOnWarning;
    }

    public void setFailOnWarning(boolean failOnWarning) {
        this.failOnWarning = failOnWarning;
    }

    public void parse(InputStream input) {
        XMLReader xmlReader;
        SAXParserFactory parserFactory = SAXParserFactory.newInstance();
        parserFactory.setNamespaceAware(true);
        parserFactory.setValidating(true);
        try {
            SAXParser parser = parserFactory.newSAXParser();
            parser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            xmlReader = parser.getXMLReader();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        xmlReader.setEntityResolver(new AppSchemaEntityResolver());
        xmlReader.setErrorHandler(new AppSchemaValidatorErrorHandler());
        try {
            xmlReader.parse(new InputSource(input));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void checkForFailures() {
        if (!this.failures.isEmpty()) {
            throw new RuntimeException(this.buildFailureMessage());
        }
    }

    private String buildFailureMessage() {
        String newline = System.getProperty("line.separator");
        StringBuilder builder = new StringBuilder();
        builder.append("Schema validation failures: " + this.failures.size());
        for (String failure : this.failures) {
            builder.append(newline);
            builder.append(failure);
        }
        return builder.toString();
    }

    public static AppSchemaValidator buildValidator() {
        return new AppSchemaValidator();
    }

    public static AppSchemaValidator buildValidator(SchemaResolver resolver) {
        return new AppSchemaValidator(resolver);
    }

    public static AppSchemaValidator buildValidator(SchemaCatalog catalog) {
        return new AppSchemaValidator(catalog);
    }

    public static void validateResource(String name, SchemaCatalog catalog) throws IOException {
        try (InputStream input = AppSchemaValidator.class.getResourceAsStream(name);){
            AppSchemaValidator.validate(input, catalog);
        }
    }

    public static void validate(String xml, SchemaCatalog catalog) {
        byte[] bytes = null;
        String encoding = AppSchemaValidator.getEncoding(xml);
        if (encoding != null) {
            try {
                bytes = xml.getBytes(encoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        if (bytes == null) {
            bytes = xml.getBytes(StandardCharsets.UTF_8);
        }
        try (ByteArrayInputStream input = new ByteArrayInputStream(bytes);){
            AppSchemaValidator.validate(input, catalog);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static String getEncoding(String xml) {
        Matcher m = XML_ENCODING_PATTERN.matcher(xml);
        if (m.matches()) {
            return m.group(1);
        }
        return null;
    }

    public static void validate(InputStream input, SchemaCatalog catalog) {
        AppSchemaValidator validator = AppSchemaValidator.buildValidator(catalog);
        validator.parse(input);
        validator.checkForFailures();
    }

    private class AppSchemaEntityResolver
    implements EntityResolver2 {
        private AppSchemaEntityResolver() {
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            throw new UnsupportedOperationException("Misconfigured parser: EntityResolver2 interface must be used so that relative URLs are resolved correctly");
        }

        @Override
        public InputSource getExternalSubset(String name, String baseURI) {
            return null;
        }

        @Override
        public InputSource resolveEntity(String name, String publicId, String baseURI, String systemId) throws SAXException, IOException {
            return new InputSource(AppSchemaValidator.this.resolver.resolve(systemId, baseURI));
        }
    }

    private class AppSchemaValidatorErrorHandler
    implements ErrorHandler {
        private AppSchemaValidatorErrorHandler() {
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            AppSchemaValidator.this.failures.add("ERROR: " + exception.getMessage());
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            AppSchemaValidator.this.failures.add("FATAL ERROR: " + exception.getMessage());
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            if (AppSchemaValidator.this.failOnWarning) {
                AppSchemaValidator.this.failures.add("WARNING: " + exception.getMessage());
            }
        }
    }
}

