/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.cache;

import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.lang.ref.WeakReference;
import java.math.BigInteger;
import org.eclipse.imagen.CachedTile;
import org.eclipse.imagen.PlanarImage;
import org.eclipse.imagen.media.cache.ConcurrentTileCache;

public final class CachedTileImpl
implements CachedTile {
    private static final long CACHED_TILE_OVERHEAD = 288L;
    final Raster tile;
    final WeakReference owner;
    final int tileX;
    final int tileY;
    final Object tileCacheMetric;
    private long timeStamp;
    final Object key;
    private final Object imageKey;
    final long tileSize;
    private ConcurrentTileCache.Actions action;

    public CachedTileImpl(RenderedImage owner, int tileX, int tileY, Raster tile, Object tileCacheMetric) {
        this.owner = new WeakReference<RenderedImage>(owner);
        this.tile = tile;
        this.tileX = tileX;
        this.tileY = tileY;
        this.tileCacheMetric = tileCacheMetric;
        this.key = CachedTileImpl.hashKey(owner, tileX, tileY);
        this.imageKey = CachedTileImpl.hashKey(owner);
        DataBuffer db = tile.getDataBuffer();
        this.tileSize = (long)DataBuffer.getDataTypeSize(db.getDataType()) / 8L * (long)db.getSize() * (long)db.getNumBanks() + 288L;
        this.updateTileTimeStamp();
    }

    public Object getKey() {
        return this.key;
    }

    public Object getImageKey() {
        return this.imageKey;
    }

    public static Object hashKey(RenderedImage owner, int tileX, int tileY) {
        long idx = (long)tileY * (long)owner.getNumXTiles() + (long)tileX;
        return (long)owner.hashCode() << 32 | (idx &= 0xFFFFFFFFL);
    }

    public static Object hashKey(RenderedImage owner) {
        BigInteger imageID = null;
        if (owner instanceof PlanarImage) {
            imageID = (BigInteger)((PlanarImage)owner).getImageID();
        }
        if (imageID != null) {
            byte[] buf = imageID.toByteArray();
            return new BigInteger(buf);
        }
        return owner.hashCode();
    }

    public Raster getTile() {
        return this.tile;
    }

    public RenderedImage getOwner() {
        return (RenderedImage)this.owner.get();
    }

    public long getTileTimeStamp() {
        return this.timeStamp;
    }

    public Object getTileCacheMetric() {
        return this.tileCacheMetric;
    }

    public long getTileSize() {
        return this.tileSize;
    }

    public int getAction() {
        return this.action.valueAction();
    }

    public void setAction(ConcurrentTileCache.Actions newAction) {
        this.action = newAction;
    }

    public void updateTileTimeStamp() {
        this.timeStamp = System.currentTimeMillis();
    }
}

