/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalCause;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.cache.Weigher;
import java.awt.Point;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Observable;
import java.util.Vector;
import org.eclipse.imagen.TileCache;
import org.eclipse.imagen.media.cache.CachedTileImpl;
import org.eclipse.imagen.media.util.CacheDiagnostics;

public class ConcurrentTileCache
extends Observable
implements TileCache,
CacheDiagnostics {
    public static final float DEFAULT_MEMORY_THRESHOLD = 0.75f;
    public static final long DEFAULT_MEMORY_CACHE = 0x1000000L;
    public static final boolean DEFAULT_DIAGNOSTIC = false;
    public static final int DEFAULT_CONCURRENCY_LEVEL = 4;
    private Cache<Object, CachedTileImpl> cacheObject;
    private long memoryCacheCapacity;
    private int concurrencyLevel;
    private float memoryCacheThreshold = 0.75f;
    private volatile boolean diagnosticEnabled = false;
    private final RemovalListener<Object, CachedTileImpl> listener = new RemovalListener<Object, CachedTileImpl>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onRemoval(RemovalNotification<Object, CachedTileImpl> n) {
            if (ConcurrentTileCache.this.diagnosticEnabled) {
                1 var2_2 = this;
                synchronized (var2_2) {
                    if (n.wasEvicted() && n.getCause() == RemovalCause.SIZE) {
                        CachedTileImpl cti = (CachedTileImpl)n.getValue();
                        cti.setAction(Actions.REMOVAL_FROM_EVICTION);
                        ConcurrentTileCache.this.setChanged();
                        ConcurrentTileCache.this.notifyObservers(cti);
                    }
                }
            }
        }
    };

    private Cache<Object, CachedTileImpl> buildCache() {
        CacheBuilder builder = CacheBuilder.newBuilder();
        builder.maximumWeight((long)((float)this.memoryCacheCapacity * this.memoryCacheThreshold)).concurrencyLevel(this.concurrencyLevel).weigher((Weigher)new Weigher<Object, CachedTileImpl>(){

            public int weigh(Object o, CachedTileImpl cti) {
                return (int)cti.getTileSize();
            }
        });
        return builder.build();
    }

    public ConcurrentTileCache() {
        this(0x1000000L, false, 0.75f, 4);
    }

    public ConcurrentTileCache(long memoryCacheCapacity, boolean diagnostic, float mem_threshold, int concurrencyLevel) {
        if (memoryCacheCapacity < 0L) {
            throw new IllegalArgumentException("Memory capacity too small");
        }
        this.memoryCacheThreshold = mem_threshold;
        this.diagnosticEnabled = diagnostic;
        this.memoryCacheCapacity = memoryCacheCapacity;
        this.concurrencyLevel = concurrencyLevel;
        this.cacheObject = this.buildCache();
    }

    public void add(RenderedImage owner, int tileX, int tileY, Raster data) {
        this.add(owner, tileX, tileY, data, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(RenderedImage owner, int tileX, int tileY, Raster data, Object tileCacheMetric) {
        if (data == null) {
            return;
        }
        Object key = CachedTileImpl.hashKey(owner, tileX, tileY);
        CachedTileImpl cti_new = new CachedTileImpl(owner, tileX, tileY, data, tileCacheMetric);
        if (this.diagnosticEnabled) {
            CachedTileImpl cti = this.cacheObject.asMap().put(key, cti_new);
            ConcurrentTileCache concurrentTileCache = this;
            synchronized (concurrentTileCache) {
                if (cti != null) {
                    cti.updateTileTimeStamp();
                    cti.setAction(Actions.SUBSTITUTION_FROM_ADD);
                    this.setChanged();
                    this.notifyObservers(cti);
                    return;
                }
                cti_new.setAction(Actions.ADDITION);
                this.setChanged();
                this.notifyObservers(cti_new);
            }
        } else {
            this.cacheObject.put(key, (Object)cti_new);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(RenderedImage owner, int tileX, int tileY) {
        Object key = CachedTileImpl.hashKey(owner, tileX, tileY);
        CachedTileImpl cti = (CachedTileImpl)this.cacheObject.getIfPresent(key);
        if (cti != null) {
            if (this.diagnosticEnabled) {
                ConcurrentTileCache concurrentTileCache = this;
                synchronized (concurrentTileCache) {
                    cti.setAction(Actions.ABOUT_TO_REMOVAL);
                    this.setChanged();
                    this.notifyObservers(cti);
                    cti = (CachedTileImpl)this.cacheObject.asMap().remove(key);
                    if (cti != null) {
                        cti.setAction(Actions.MANUAL_REMOVAL);
                        this.setChanged();
                        this.notifyObservers(cti);
                    }
                }
            } else {
                this.cacheObject.invalidate(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Raster getTile(RenderedImage owner, int tileX, int tileY) {
        Raster tileData = null;
        Object key = CachedTileImpl.hashKey(owner, tileX, tileY);
        CachedTileImpl cti = (CachedTileImpl)this.cacheObject.getIfPresent(key);
        if (cti == null) {
            return null;
        }
        if (this.diagnosticEnabled) {
            ConcurrentTileCache concurrentTileCache = this;
            synchronized (concurrentTileCache) {
                cti.updateTileTimeStamp();
                cti.setAction(Actions.UPDATING_TILE_FROM_GETTILE);
                this.setChanged();
                this.notifyObservers(cti);
            }
        }
        tileData = cti.getTile();
        return tileData;
    }

    public Raster[] getTiles(RenderedImage owner) {
        Raster[] tilesData = null;
        int tileCount = (int)this.cacheObject.size();
        int size = Math.min(owner.getNumXTiles() * owner.getNumYTiles(), tileCount);
        if (size > 0) {
            int minTx = owner.getMinTileX();
            int minTy = owner.getMinTileY();
            int maxTx = minTx + owner.getNumXTiles();
            int maxTy = minTy + owner.getNumYTiles();
            Vector<Raster> tempData = new Vector<Raster>(10, 20);
            for (int y = minTy; y < maxTy; ++y) {
                for (int x = minTx; x < maxTx; ++x) {
                    Raster rasterTile = this.getTile(owner, x, y);
                    if (rasterTile == null) continue;
                    tempData.add(rasterTile);
                }
            }
            int tmpsize = tempData.size();
            if (tmpsize > 0) {
                tilesData = tempData.toArray(new Raster[tmpsize]);
            }
        }
        return tilesData;
    }

    public void removeTiles(RenderedImage owner) {
        if (this.diagnosticEnabled) {
            int minTx = owner.getMinTileX();
            int minTy = owner.getMinTileY();
            int maxTx = minTx + owner.getNumXTiles();
            int maxTy = minTy + owner.getNumYTiles();
            for (int y = minTy; y < maxTy; ++y) {
                for (int x = minTx; x < maxTx; ++x) {
                    this.remove(owner, x, y);
                }
            }
        } else {
            int minTx = owner.getMinTileX();
            int minTy = owner.getMinTileY();
            int maxTx = minTx + owner.getNumXTiles();
            int maxTy = minTy + owner.getNumYTiles();
            for (int y = minTy; y < maxTy; ++y) {
                for (int x = minTx; x < maxTx; ++x) {
                    this.remove(owner, x, y);
                }
            }
        }
    }

    public void addTiles(RenderedImage owner, Point[] tileIndices, Raster[] tiles, Object tileCacheMetric) {
        for (int i = 0; i < tileIndices.length; ++i) {
            int tileX = tileIndices[i].x;
            int tileY = tileIndices[i].y;
            Raster tile = tiles[i];
            this.add(owner, tileX, tileY, tile, tileCacheMetric);
        }
    }

    public Raster[] getTiles(RenderedImage owner, Point[] tileIndices) {
        Raster[] tilesData = new Raster[tileIndices.length];
        for (int i = 0; i < tilesData.length; ++i) {
            int tileX = tileIndices[i].x;
            int tileY = tileIndices[i].y;
            Raster rasterData = this.getTile(owner, tileX, tileY);
            tilesData[i] = rasterData == null ? null : rasterData;
        }
        return tilesData;
    }

    public synchronized void flush() {
        if (this.diagnosticEnabled) {
            for (Object key : this.cacheObject.asMap().keySet()) {
                CachedTileImpl cti = (CachedTileImpl)this.cacheObject.asMap().remove(key);
                cti.setAction(Actions.REMOVAL_FROM_FLUSH);
                this.setChanged();
                this.notifyObservers(cti);
            }
        } else {
            this.cacheObject.invalidateAll();
        }
        this.cacheObject = this.buildCache();
    }

    public void memoryControl() {
        throw new UnsupportedOperationException("Memory Control not supported");
    }

    public void setTileCapacity(int tileCapacity) {
        throw new UnsupportedOperationException("Deprecated Operation");
    }

    public int getTileCapacity() {
        throw new UnsupportedOperationException("Deprecated Operation");
    }

    public synchronized void setMemoryCapacity(long memoryCacheCapacity) {
        if (memoryCacheCapacity < 0L) {
            throw new IllegalArgumentException("Memory capacity too small");
        }
        this.memoryCacheCapacity = memoryCacheCapacity;
        this.flush();
    }

    public long getMemoryCapacity() {
        return this.memoryCacheCapacity;
    }

    public synchronized void setMemoryThreshold(float mt) {
        if (mt < 0.0f || mt > 1.0f) {
            throw new IllegalArgumentException("Memory threshold should be between 0 and 1");
        }
        this.memoryCacheThreshold = mt;
        this.flush();
    }

    public float getMemoryThreshold() {
        return this.memoryCacheThreshold;
    }

    public synchronized void setConcurrencyLevel(int concurrency) {
        if (concurrency < 1) {
            throw new IllegalArgumentException("ConcurrencyLevel must be at least 1");
        }
        this.concurrencyLevel = concurrency;
        this.flush();
    }

    public int getConcurrencyLevel() {
        return this.concurrencyLevel;
    }

    public void setTileComparator(Comparator comparator) {
        throw new UnsupportedOperationException("Comparator not supported");
    }

    public Comparator getTileComparator() {
        throw new UnsupportedOperationException("Comparator not supported");
    }

    public synchronized void disableDiagnostics() {
        this.diagnosticEnabled = false;
        this.flush();
    }

    public synchronized void enableDiagnostics() {
        this.diagnosticEnabled = true;
        this.flush();
    }

    public long getCacheHitCount() {
        if (this.diagnosticEnabled) {
            return this.cacheObject.stats().hitCount();
        }
        return 0L;
    }

    public synchronized long getCacheMemoryUsed() {
        Iterator keys = this.cacheObject.asMap().keySet().iterator();
        long memoryUsed = 0L;
        while (keys.hasNext()) {
            Object key = keys.next();
            CachedTileImpl cti = (CachedTileImpl)this.cacheObject.getIfPresent(key);
            memoryUsed += cti.getTileSize();
        }
        return memoryUsed;
    }

    public long getCacheMissCount() {
        if (this.diagnosticEnabled) {
            return this.cacheObject.stats().missCount();
        }
        return 0L;
    }

    public long getCacheTileCount() {
        return this.cacheObject.size();
    }

    public void resetCounts() {
        throw new UnsupportedOperationException("Operation not supported");
    }

    public static enum Actions {
        ADDITION(0),
        MANUAL_REMOVAL(1),
        REMOVAL_FROM_FLUSH(2),
        REMOVAL_FROM_EVICTION(3),
        SUBSTITUTION_FROM_ADD(4),
        UPDATING_TILE_FROM_GETTILE(5),
        ABOUT_TO_REMOVAL(6);

        private final int action;

        private Actions(int value) {
            this.action = value;
        }

        public int valueAction() {
            return this.action;
        }
    }
}

