/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imagen.media.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalCause;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.cache.Weigher;
import java.awt.Point;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Observable;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.imagen.TileCache;
import org.eclipse.imagen.media.cache.CachedTileImpl;
import org.eclipse.imagen.media.cache.ConcurrentTileCache;
import org.eclipse.imagen.media.util.CacheDiagnostics;

public class ConcurrentTileCacheMultiMap
extends Observable
implements TileCache,
CacheDiagnostics {
    public static final float DEFAULT_MEMORY_THRESHOLD = 0.75f;
    public static final long DEFAULT_MEMORY_CACHE = 0x1000000L;
    public static final boolean DEFAULT_DIAGNOSTIC = false;
    public static final int DEFAULT_CONCURRENCY_LEVEL = 4;
    private Cache<Object, CachedTileImpl> cacheObject;
    private ConcurrentHashMap<Object, Set<Object>> multimap;
    private long memoryCacheCapacity;
    private int concurrencyLevel;
    private float memoryCacheThreshold = 0.75f;
    private volatile boolean diagnosticEnabled = false;
    private static final Logger LOGGER = Logger.getLogger(ConcurrentTileCacheMultiMap.class.toString());
    private static final long TILE_TRACKING_OVERHEAD = 50L;

    public ConcurrentTileCacheMultiMap() {
        this(0x1000000L, false, 0.75f, 4);
    }

    public ConcurrentTileCacheMultiMap(long memoryCacheCapacity, boolean diagnostic, float mem_threshold, int concurrencyLevel) {
        if (memoryCacheCapacity < 0L) {
            throw new IllegalArgumentException("Memory capacity too small");
        }
        this.memoryCacheThreshold = mem_threshold;
        this.diagnosticEnabled = diagnostic;
        this.memoryCacheCapacity = memoryCacheCapacity;
        this.concurrencyLevel = concurrencyLevel;
        this.cacheObject = this.buildCache();
        this.multimap = new ConcurrentHashMap();
    }

    public void add(RenderedImage owner, int tileX, int tileY, Raster data) {
        this.add(owner, tileX, tileY, data, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(RenderedImage owner, int tileX, int tileY, Raster data, Object tileCacheMetric) {
        if (data == null) {
            return;
        }
        Object imageKey = CachedTileImpl.hashKey(owner);
        CachedTileImpl cti_new = new CachedTileImpl(owner, tileX, tileY, data, tileCacheMetric);
        if (this.diagnosticEnabled) {
            CachedTileImpl cti = this.cacheObject.asMap().putIfAbsent(cti_new.key, cti_new);
            Cache<Object, CachedTileImpl> cache = this.cacheObject;
            synchronized (cache) {
                if (cti != null) {
                    cti.updateTileTimeStamp();
                    cti.setAction(ConcurrentTileCache.Actions.SUBSTITUTION_FROM_ADD);
                    this.setChanged();
                    this.notifyObservers(cti);
                }
                cti_new.setAction(ConcurrentTileCache.Actions.ADDITION);
                this.setChanged();
                this.notifyObservers(cti_new);
                this.updateMultiMap(cti_new.key, imageKey);
            }
        } else {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Added new Tile Image key " + String.valueOf(imageKey));
            }
            this.cacheObject.asMap().putIfAbsent(cti_new.key, cti_new);
            this.updateMultiMap(cti_new.key, imageKey);
        }
    }

    private long getTileSize(CachedTileImpl cti) {
        return cti.getTileSize() + 50L;
    }

    public void remove(RenderedImage owner, int tileX, int tileY) {
        Object key = CachedTileImpl.hashKey(owner, tileX, tileY);
        this.removeTileByKey(key);
    }

    public Raster getTile(RenderedImage owner, int tileX, int tileY) {
        Object key = CachedTileImpl.hashKey(owner, tileX, tileY);
        return this.getTileFromKey(key);
    }

    public Raster[] getTiles(RenderedImage owner) {
        Set<Object> keys;
        Raster[] tilesData = null;
        Object imageKey = CachedTileImpl.hashKey(owner);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Getting image Tiles Image key " + String.valueOf(imageKey));
        }
        if ((keys = this.multimap.get(imageKey)) == null || keys.isEmpty()) {
            return tilesData;
        }
        Iterator<Object> it = keys.iterator();
        if (it.hasNext()) {
            Vector<Raster> tempData = new Vector<Raster>(10, 20);
            while (it.hasNext()) {
                Object key = it.next();
                Raster rasterTile = this.getTileFromKey(key);
                if (rasterTile == null) continue;
                tempData.add(rasterTile);
            }
            int tmpsize = tempData.size();
            if (tmpsize > 0) {
                tilesData = tempData.toArray(new Raster[tmpsize]);
            }
        }
        return tilesData;
    }

    public void removeTiles(RenderedImage owner) {
        Object imageKey = CachedTileImpl.hashKey(owner);
        if (this.diagnosticEnabled) {
            Set<Object> keys = this.multimap.remove(imageKey);
            if (keys != null) {
                for (Object key : keys) {
                    this.removeTileByKey(key);
                }
            }
        } else {
            Set<Object> keys = this.multimap.remove(imageKey);
            if (keys != null) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Removing image Tiles Image key " + String.valueOf(imageKey));
                }
                this.cacheObject.invalidateAll(keys);
            }
        }
    }

    public void addTiles(RenderedImage owner, Point[] tileIndices, Raster[] tiles, Object tileCacheMetric) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Addeding Tiles");
        }
        for (int i = 0; i < tileIndices.length; ++i) {
            int tileX = tileIndices[i].x;
            int tileY = tileIndices[i].y;
            Raster tile = tiles[i];
            this.add(owner, tileX, tileY, tile, tileCacheMetric);
        }
    }

    public Raster[] getTiles(RenderedImage owner, Point[] tileIndices) {
        Raster[] tilesData = new Raster[tileIndices.length];
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Getting Tiles at the selected positions");
        }
        for (int i = 0; i < tilesData.length; ++i) {
            int tileX = tileIndices[i].x;
            int tileY = tileIndices[i].y;
            Raster rasterData = this.getTile(owner, tileX, tileY);
            tilesData[i] = rasterData == null ? null : rasterData;
        }
        return tilesData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        Cache<Object, CachedTileImpl> cache = this.cacheObject;
        synchronized (cache) {
            if (this.diagnosticEnabled) {
                for (Object key : this.cacheObject.asMap().keySet()) {
                    CachedTileImpl cti = (CachedTileImpl)this.cacheObject.asMap().remove(key);
                    cti.setAction(ConcurrentTileCache.Actions.REMOVAL_FROM_FLUSH);
                    this.setChanged();
                    this.notifyObservers(cti);
                }
            } else {
                this.cacheObject.invalidateAll();
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Flushing cache");
            }
            this.cacheObject = this.buildCache();
            this.multimap = new ConcurrentHashMap();
        }
    }

    public void memoryControl() {
        throw new UnsupportedOperationException("Memory Control not supported");
    }

    public void setTileCapacity(int tileCapacity) {
        throw new UnsupportedOperationException("Deprecated Operation");
    }

    public int getTileCapacity() {
        throw new UnsupportedOperationException("Deprecated Operation");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMemoryCapacity(long memoryCacheCapacity) {
        Cache<Object, CachedTileImpl> cache = this.cacheObject;
        synchronized (cache) {
            if (memoryCacheCapacity < 0L) {
                throw new IllegalArgumentException("Memory capacity too small");
            }
            this.memoryCacheCapacity = memoryCacheCapacity;
            this.flush();
        }
    }

    public long getMemoryCapacity() {
        return this.memoryCacheCapacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMemoryThreshold(float mt) {
        Cache<Object, CachedTileImpl> cache = this.cacheObject;
        synchronized (cache) {
            if (mt < 0.0f || mt > 1.0f) {
                throw new IllegalArgumentException("Memory threshold should be between 0 and 1");
            }
            this.memoryCacheThreshold = mt;
            this.flush();
        }
    }

    public float getMemoryThreshold() {
        return this.memoryCacheThreshold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConcurrencyLevel(int concurrency) {
        Cache<Object, CachedTileImpl> cache = this.cacheObject;
        synchronized (cache) {
            if (concurrency < 1) {
                throw new IllegalArgumentException("ConcurrencyLevel must be at least 1");
            }
            this.concurrencyLevel = concurrency;
            this.flush();
        }
    }

    public int getConcurrencyLevel() {
        return this.concurrencyLevel;
    }

    public void setTileComparator(Comparator comparator) {
        throw new UnsupportedOperationException("Comparator not supported");
    }

    public Comparator getTileComparator() {
        throw new UnsupportedOperationException("Comparator not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableDiagnostics() {
        Cache<Object, CachedTileImpl> cache = this.cacheObject;
        synchronized (cache) {
            this.diagnosticEnabled = false;
            this.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableDiagnostics() {
        Cache<Object, CachedTileImpl> cache = this.cacheObject;
        synchronized (cache) {
            this.diagnosticEnabled = true;
            this.flush();
        }
    }

    public long getCacheHitCount() {
        if (this.diagnosticEnabled) {
            return this.cacheObject.stats().hitCount();
        }
        return 0L;
    }

    public long getCacheMemoryUsed() {
        long memoryUsed = 0L;
        for (Object object : this.cacheObject.asMap().values()) {
            CachedTileImpl cti = (CachedTileImpl)object;
            memoryUsed += this.getTileSize(cti);
        }
        return memoryUsed;
    }

    public long getCacheMissCount() {
        if (this.diagnosticEnabled) {
            return this.cacheObject.stats().missCount();
        }
        return 0L;
    }

    public long getCacheTileCount() {
        return this.cacheObject.size();
    }

    public void resetCounts() {
        throw new UnsupportedOperationException("Operation not supported");
    }

    private RemovalListener<Object, CachedTileImpl> createListener(final boolean diagnostic) {
        return new RemovalListener<Object, CachedTileImpl>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onRemoval(RemovalNotification<Object, CachedTileImpl> n) {
                if (diagnostic) {
                    Cache<Object, CachedTileImpl> cache = ConcurrentTileCacheMultiMap.this.cacheObject;
                    synchronized (cache) {
                        CachedTileImpl cti = (CachedTileImpl)n.getValue();
                        if (n.wasEvicted()) {
                            cti.setAction(ConcurrentTileCache.Actions.REMOVAL_FROM_EVICTION);
                        } else {
                            cti.setAction(ConcurrentTileCache.Actions.MANUAL_REMOVAL);
                        }
                        ConcurrentTileCacheMultiMap.this.removeTileFromMultiMap(cti);
                        ConcurrentTileCacheMultiMap.this.setChanged();
                        ConcurrentTileCacheMultiMap.this.notifyObservers(cti);
                    }
                } else {
                    CachedTileImpl cti = (CachedTileImpl)n.getValue();
                    if (n.getCause() == RemovalCause.SIZE && LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Removing from MultiMap for size");
                    }
                    ConcurrentTileCacheMultiMap.this.removeTileFromMultiMap(cti);
                }
            }
        };
    }

    private void removeTileFromMultiMap(CachedTileImpl cti) {
        Object key = cti.getKey();
        Object imageKey = cti.getImageKey();
        Set<Object> tileKeys = this.multimap.get(imageKey);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Removing tile from MultiMap Image key " + String.valueOf(imageKey));
        }
        if (tileKeys != null) {
            tileKeys.remove(key);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Removed Tile Image key " + String.valueOf(imageKey));
            }
            if (tileKeys.isEmpty()) {
                this.multimap.remove(imageKey);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Removed image SET Image key " + String.valueOf(imageKey));
                }
            }
        }
    }

    private Cache<Object, CachedTileImpl> buildCache() {
        CacheBuilder builder = CacheBuilder.newBuilder();
        builder.maximumWeight((long)((float)this.memoryCacheCapacity * this.memoryCacheThreshold)).concurrencyLevel(this.concurrencyLevel).weigher((Weigher)new Weigher<Object, CachedTileImpl>(){

            public int weigh(Object o, CachedTileImpl cti) {
                return (int)ConcurrentTileCacheMultiMap.this.getTileSize(cti);
            }
        });
        builder.removalListener(this.createListener(this.diagnosticEnabled));
        if (this.diagnosticEnabled) {
            builder.recordStats();
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Building Cache");
        }
        return builder.build();
    }

    private void updateMultiMap(Object key, Object imageKey) {
        Set<Object> tileKeys = null;
        tileKeys = this.multimap.get(imageKey);
        if (tileKeys == null) {
            tileKeys = new ConcurrentSkipListSet<Object>();
            Set<Object> previousTileKeys = this.multimap.putIfAbsent(imageKey, tileKeys);
            if (previousTileKeys != null) {
                tileKeys = previousTileKeys;
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Created new Set for the image Image key " + String.valueOf(imageKey));
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Added Tile to the set Image key " + String.valueOf(imageKey));
        }
        tileKeys.add(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTileByKey(Object key) {
        CachedTileImpl cti = (CachedTileImpl)this.cacheObject.getIfPresent(key);
        if (cti != null) {
            if (this.diagnosticEnabled) {
                Cache<Object, CachedTileImpl> cache = this.cacheObject;
                synchronized (cache) {
                    cti.setAction(ConcurrentTileCache.Actions.ABOUT_TO_REMOVAL);
                    this.setChanged();
                    this.notifyObservers(cti);
                    cti = (CachedTileImpl)this.cacheObject.asMap().remove(key);
                    if (cti != null) {
                        cti.setAction(ConcurrentTileCache.Actions.MANUAL_REMOVAL);
                        this.setChanged();
                        this.notifyObservers(cti);
                    }
                }
            } else {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Removed Tile Image key " + String.valueOf(cti.getImageKey()));
                }
                this.cacheObject.invalidate(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Raster getTileFromKey(Object key) {
        Raster tileData = null;
        CachedTileImpl cti = (CachedTileImpl)this.cacheObject.getIfPresent(key);
        if (cti == null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Null Tile returned");
            }
            return null;
        }
        if (this.diagnosticEnabled) {
            Cache<Object, CachedTileImpl> cache = this.cacheObject;
            synchronized (cache) {
                cti.updateTileTimeStamp();
                cti.setAction(ConcurrentTileCache.Actions.UPDATING_TILE_FROM_GETTILE);
                this.setChanged();
                this.notifyObservers(cti);
            }
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Get the selected tile Image key " + String.valueOf(cti.getImageKey()));
        }
        tileData = cti.getTile();
        return tileData;
    }
}

