/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.text.commons;

import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.geotools.api.filter.BinaryComparisonOperator;
import org.geotools.api.filter.BinaryLogicOperator;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.Not;
import org.geotools.api.filter.PropertyIsBetween;
import org.geotools.api.filter.PropertyIsLike;
import org.geotools.api.filter.PropertyIsNull;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.api.filter.expression.Literal;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.api.filter.spatial.BBOX;
import org.geotools.api.filter.spatial.BinarySpatialOperator;
import org.geotools.api.filter.spatial.DWithin;
import org.geotools.api.filter.spatial.DistanceBufferOperator;
import org.geotools.api.filter.temporal.BinaryTemporalOperator;
import org.geotools.api.filter.temporal.During;
import org.geotools.api.geometry.BoundingBox;
import org.geotools.filter.text.commons.ExpressionToText;

public final class FilterToTextUtil {
    private static final Logger LOGGER = Logger.getLogger(FilterToTextUtil.class.getName());

    private FilterToTextUtil() {
    }

    public static StringBuilder asStringBuilder(Object extraData) {
        if (extraData instanceof StringBuilder) {
            StringBuilder builder = (StringBuilder)extraData;
            return builder;
        }
        return new StringBuilder();
    }

    public static Object buildInclude(Object extraData) {
        StringBuilder output = FilterToTextUtil.asStringBuilder(extraData);
        output.append("INCLUDE");
        return output;
    }

    public static Object buildExclude(Object extraData) {
        StringBuilder output = FilterToTextUtil.asStringBuilder(extraData);
        output.append("EXCLUDE");
        return output;
    }

    public static Object buildBinaryLogicalOperator(String operator, FilterVisitor visitor, BinaryLogicOperator filter, Object extraData) {
        LOGGER.finer("exporting binary logic filter");
        StringBuilder output = FilterToTextUtil.asStringBuilder(extraData);
        List children = filter.getChildren();
        if (children != null) {
            Iterator i = children.iterator();
            while (i.hasNext()) {
                Filter child = (Filter)i.next();
                if (child instanceof BinaryLogicOperator) {
                    output.append("(");
                }
                child.accept(visitor, (Object)output);
                if (child instanceof BinaryLogicOperator) {
                    output.append(")");
                }
                if (!i.hasNext()) continue;
                output.append(" ").append(operator).append(" ");
            }
        }
        return output;
    }

    public static Object buildBetween(PropertyIsBetween filter, Object extraData) {
        LOGGER.finer("exporting PropertyIsBetween");
        ExpressionToText exprVisitor = new ExpressionToText();
        StringBuilder output = FilterToTextUtil.asStringBuilder(extraData);
        PropertyName propertyName = (PropertyName)filter.getExpression();
        propertyName.accept((ExpressionVisitor)exprVisitor, (Object)output);
        output.append(" BETWEEN ");
        filter.getLowerBoundary().accept((ExpressionVisitor)exprVisitor, (Object)output);
        output.append(" AND ");
        filter.getUpperBoundary().accept((ExpressionVisitor)exprVisitor, (Object)output);
        return output;
    }

    public static Object buildNot(FilterVisitor filterToCQL, Not filter, Object extraData) {
        StringBuilder output = FilterToTextUtil.asStringBuilder(extraData);
        output.append("NOT (");
        filter.getFilter().accept(filterToCQL, (Object)output);
        output.append(")");
        return output;
    }

    public static Object buildComparison(BinaryComparisonOperator filter, Object extraData, String operator) {
        StringBuilder output = FilterToTextUtil.asStringBuilder(extraData);
        ExpressionToText visitor = new ExpressionToText();
        Expression expr = filter.getExpression1();
        expr.accept((ExpressionVisitor)visitor, (Object)output);
        output.append(" ").append(operator).append(" ");
        filter.getExpression2().accept((ExpressionVisitor)visitor, (Object)output);
        return output;
    }

    public static Object buildIsLike(PropertyIsLike filter, Object extraData) {
        StringBuilder output = FilterToTextUtil.asStringBuilder(extraData);
        String pattern = filter.getLiteral();
        Expression expr = filter.getExpression();
        expr.accept((ExpressionVisitor)new ExpressionToText(), (Object)output);
        if (filter.isMatchingCase()) {
            output.append(" LIKE ");
        } else {
            output.append(" ILIKE ");
        }
        output.append("'");
        output.append(pattern);
        output.append("'");
        return output;
    }

    public static Object buildIsNull(PropertyIsNull filter, Object extraData) {
        StringBuilder output = FilterToTextUtil.asStringBuilder(extraData);
        filter.getExpression().accept((ExpressionVisitor)new ExpressionToText(), (Object)output);
        output.append(" IS NULL");
        return output;
    }

    public static Object buildBBOX(BBOX filter, Object extraData) {
        StringBuilder output = FilterToTextUtil.asStringBuilder(extraData);
        BoundingBox bounds = filter.getBounds();
        output.append("BBOX(");
        output.append(((PropertyName)filter.getExpression1()).getPropertyName());
        output.append(", ");
        output.append(bounds.getMinX());
        output.append(",");
        output.append(bounds.getMinY());
        output.append(",");
        output.append(bounds.getMaxX());
        output.append(",");
        output.append(bounds.getMaxY());
        output.append(")");
        return output;
    }

    public static Object buildDistanceBufferOperation(String geoOperation, DistanceBufferOperator filter, Object extraData) {
        ExpressionToText visitor = new ExpressionToText();
        return FilterToTextUtil.buildDistanceBufferOperation(geoOperation, filter, extraData, visitor);
    }

    public static Object buildDistanceBufferOperation(String geoOperation, DistanceBufferOperator filter, Object extraData, ExpressionToText visitor) {
        LOGGER.finer("exporting " + geoOperation);
        StringBuilder output = FilterToTextUtil.asStringBuilder(extraData);
        output.append(geoOperation).append("(");
        Expression expr = filter.getExpression1();
        expr.accept((ExpressionVisitor)visitor, (Object)output);
        output.append(", ");
        filter.getExpression2().accept((ExpressionVisitor)visitor, (Object)output);
        output.append(", ");
        output.append(filter.getDistance());
        output.append(", ");
        output.append(filter.getDistanceUnits());
        output.append(")");
        return output;
    }

    public static Object buildDWithin(DWithin filter, Object extraData) {
        ExpressionToText visitor = new ExpressionToText();
        return FilterToTextUtil.buildDWithin(filter, extraData, visitor);
    }

    public static Object buildDWithin(DWithin filter, Object extraData, ExpressionToText visitor) {
        LOGGER.finer("exporting DWITHIN");
        StringBuilder output = FilterToTextUtil.asStringBuilder(extraData);
        output.append("DWITHIN(");
        filter.getExpression1().accept((ExpressionVisitor)visitor, (Object)output);
        output.append(", ");
        filter.getExpression2().accept((ExpressionVisitor)visitor, (Object)output);
        output.append(", ");
        output.append(filter.getDistance());
        output.append(", ");
        output.append(filter.getDistanceUnits());
        output.append(")");
        return output;
    }

    public static Object buildBinarySpatialOperator(String spatialOperator, BinarySpatialOperator filter, Object extraData) {
        ExpressionToText visitor = new ExpressionToText();
        return FilterToTextUtil.buildBinarySpatialOperator(spatialOperator, filter, extraData, visitor);
    }

    public static Object buildBinarySpatialOperator(String spatialOperator, BinarySpatialOperator filter, Object extraData, ExpressionToText visitor) {
        LOGGER.finer("exporting " + spatialOperator);
        StringBuilder output = FilterToTextUtil.asStringBuilder(extraData);
        output.append(spatialOperator).append("(");
        Expression expr = filter.getExpression1();
        expr.accept((ExpressionVisitor)visitor, (Object)output);
        output.append(", ");
        filter.getExpression2().accept((ExpressionVisitor)visitor, (Object)output);
        output.append(")");
        return output;
    }

    public static Object buildBinaryTemporalOperator(String temporalOperator, BinaryTemporalOperator filter, Object extraData) {
        LOGGER.finer("exporting " + temporalOperator);
        StringBuilder output = FilterToTextUtil.asStringBuilder(extraData);
        PropertyName propertyName = (PropertyName)filter.getExpression1();
        ExpressionToText visitor = new ExpressionToText();
        propertyName.accept((ExpressionVisitor)visitor, (Object)output);
        output.append(" ").append(temporalOperator).append(" ");
        Literal expr2 = (Literal)filter.getExpression2();
        expr2.accept((ExpressionVisitor)visitor, (Object)output);
        return output;
    }

    public static Object buildDuring(During during, Object extraData) {
        LOGGER.finer("exporting DURING");
        StringBuilder output = FilterToTextUtil.asStringBuilder(extraData);
        PropertyName propertyName = (PropertyName)during.getExpression1();
        ExpressionToText visitor = new ExpressionToText();
        propertyName.accept((ExpressionVisitor)visitor, (Object)output);
        output.append(" DURING ");
        Literal expr2 = (Literal)during.getExpression2();
        expr2.accept((ExpressionVisitor)visitor, (Object)output);
        return output;
    }
}

