/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.text.StringEscapeUtils;
import org.geotools.util.logging.Logging;
import org.geowebcache.ClientStreamAbortedException;
import org.geowebcache.DispatcherOutputStream;
import org.geowebcache.GeoWebCache;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.GeoWebCacheExtensions;
import org.geowebcache.config.BaseConfiguration;
import org.geowebcache.config.BlobStoreInfo;
import org.geowebcache.config.ConfigurationException;
import org.geowebcache.config.ServerConfiguration;
import org.geowebcache.config.XMLConfiguration;
import org.geowebcache.conveyor.Conveyor;
import org.geowebcache.conveyor.ConveyorTile;
import org.geowebcache.demo.Demo;
import org.geowebcache.filter.request.RequestFilterException;
import org.geowebcache.filter.security.SecurityDispatcher;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.io.ByteArrayResource;
import org.geowebcache.io.Resource;
import org.geowebcache.layer.BadTileException;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.service.HttpErrorCodeException;
import org.geowebcache.service.OWSException;
import org.geowebcache.service.Service;
import org.geowebcache.stats.RuntimeStats;
import org.geowebcache.storage.BlobStore;
import org.geowebcache.storage.BlobStoreAggregator;
import org.geowebcache.storage.CompositeBlobStore;
import org.geowebcache.storage.DefaultStorageBroker;
import org.geowebcache.storage.DefaultStorageFinder;
import org.geowebcache.storage.StorageBroker;
import org.geowebcache.storage.blobstore.memory.CacheStatistics;
import org.geowebcache.storage.blobstore.memory.MemoryBlobStore;
import org.geowebcache.util.ResponseUtils;
import org.geowebcache.util.ServletUtils;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;
import org.xml.sax.SAXException;

public class GeoWebCacheDispatcher
extends AbstractController {
    private static Logger LOG = Logging.getLogger((String)GeoWebCacheDispatcher.class.getName());
    public static final String TYPE_SERVICE = "service";
    public static final String TYPE_REST = "rest";
    public static final String TYPE_DEMO = "demo";
    public static final String TYPE_HOME = "home";
    private TileLayerDispatcher tileLayerDispatcher = null;
    private DefaultStorageFinder defaultStorageFinder = null;
    private GridSetBroker gridSetBroker = null;
    private StorageBroker storageBroker;
    private BlobStoreAggregator blobStoreAggregator;
    private RuntimeStats runtimeStats;
    private Map<String, Service> services = null;
    private Resource blankTile = null;
    private String servletPrefix = null;
    private BaseConfiguration mainConfiguration;
    private SecurityDispatcher securityDispatcher;

    public GeoWebCacheDispatcher(TileLayerDispatcher tileLayerDispatcher, GridSetBroker gridSetBroker, StorageBroker storageBroker, BlobStoreAggregator blobStoreAggregator, ServerConfiguration mainConfiguration, RuntimeStats runtimeStats) {
        this.tileLayerDispatcher = tileLayerDispatcher;
        this.gridSetBroker = gridSetBroker;
        this.runtimeStats = runtimeStats;
        this.storageBroker = storageBroker;
        this.blobStoreAggregator = blobStoreAggregator;
        this.mainConfiguration = mainConfiguration;
        if (mainConfiguration.isRuntimeStatsEnabled().booleanValue()) {
            this.runtimeStats.start();
        } else {
            runtimeStats = null;
        }
    }

    public void setStorageBroker() {
        LOG.fine("GeoWebCacheDispatcher received StorageBroker : " + this.storageBroker.toString());
    }

    public void setDefaultStorageFinder(DefaultStorageFinder defaultStorageFinder) {
        this.defaultStorageFinder = defaultStorageFinder;
    }

    public void setServletPrefix(String servletPrefix) {
        this.servletPrefix = !servletPrefix.startsWith("/") ? "/" + servletPrefix : servletPrefix;
        LOG.config("Invoked setServletPrefix(" + servletPrefix + ")");
    }

    public String getServletPrefix() {
        return this.servletPrefix;
    }

    private Map<String, Service> loadServices() {
        LOG.info("Loading GWC Service extensions...");
        List<Service> plugins = GeoWebCacheExtensions.extensions(Service.class);
        HashMap<String, Service> services = new HashMap<String, Service>();
        for (Service aService : plugins) {
            services.put(aService.getPathName(), aService);
        }
        LOG.info("Done loading GWC Service extensions. Found : " + String.valueOf(new ArrayList(services.keySet())));
        return services;
    }

    private void loadBlankTile() {
        String blankTilePath = this.defaultStorageFinder.findEnvVar("GWC_BLANK_TILE_PATH");
        if (blankTilePath != null) {
            File fh = new File(blankTilePath);
            if (fh.exists() && fh.canRead() && fh.isFile()) {
                long fileSize = fh.length();
                this.blankTile = new ByteArrayResource(new byte[(int)fileSize]);
                try {
                    this.loadBlankTile(this.blankTile, fh.toURI().toURL());
                }
                catch (IOException e) {
                    LOG.log(Level.FINE, "Failed to load the blank tile", e);
                }
                if (fileSize == this.blankTile.getSize()) {
                    LOG.info("Loaded blank tile from " + blankTilePath);
                } else {
                    LOG.severe("Failed to load blank tile from " + blankTilePath);
                }
                return;
            }
            LOG.severe(blankTilePath + " does not exist or is not readable.");
        }
        try {
            URL url = GeoWebCacheDispatcher.class.getResource("blank.png");
            this.blankTile = new ByteArrayResource();
            this.loadBlankTile(this.blankTile, url);
            int ret = (int)this.blankTile.getSize();
            LOG.info("Read " + ret + " from blank PNG file (expected 425).");
        }
        catch (IOException ioe) {
            LOG.log(Level.SEVERE, "Built-in blank.png unavailable", ioe);
        }
    }

    private void loadBlankTile(Resource blankTile, URL source) throws IOException {
        try (InputStream inputStream = source.openStream();
             ReadableByteChannel ch = Channels.newChannel(inputStream);){
            blankTile.transferFrom(ch);
        }
        catch (IOException e) {
            LOG.log(Level.SEVERE, "Failed to load blank tile", e);
        }
    }

    String normalizeURL(HttpServletRequest request) {
        String contextPath = request.getContextPath();
        String requestURI = request.getRequestURI();
        if (requestURI.contains(contextPath)) {
            requestURI = requestURI.replaceFirst(contextPath, "");
            if (this.servletPrefix != null) {
                requestURI = requestURI.replace(this.servletPrefix, "");
            }
            return requestURI;
        }
        if (request.getPathInfo() != null) {
            requestURI = request.getPathInfo();
        }
        if (this.servletPrefix != null) {
            requestURI = requestURI.replace(this.servletPrefix, "");
        }
        return requestURI;
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse originalResponse) throws Exception {
        block16: {
            HttpServletResponseWrapper response = new HttpServletResponseWrapper(originalResponse){

                public ServletOutputStream getOutputStream() throws IOException {
                    return new DispatcherOutputStream(super.getOutputStream());
                }
            };
            String[] requestComps = null;
            try {
                String normalizedURI = this.normalizeURL(request);
                requestComps = this.parseRequest(normalizedURI);
            }
            catch (GeoWebCacheException gwce) {
                ResponseUtils.writeErrorPage((HttpServletResponse)response, 400, gwce.getMessage(), this.runtimeStats);
                return null;
            }
            try {
                if (requestComps == null || requestComps[0].equalsIgnoreCase(TYPE_HOME)) {
                    this.handleFrontPage(request, (HttpServletResponse)response);
                } else if (requestComps[0].equalsIgnoreCase(TYPE_SERVICE)) {
                    this.handleServiceRequest(requestComps[1], request, (HttpServletResponse)response);
                } else if (requestComps[0].equalsIgnoreCase(TYPE_DEMO) || requestComps[0].equalsIgnoreCase("demos")) {
                    this.handleDemoRequest(requestComps[1], request, (HttpServletResponse)response);
                } else {
                    ResponseUtils.writeErrorPage((HttpServletResponse)response, 404, "Unknown path: " + requestComps[0], this.runtimeStats);
                }
            }
            catch (HttpErrorCodeException e) {
                ResponseUtils.writeFixedResponse((HttpServletResponse)response, e.getErrorCode(), "text/plain", new ByteArrayResource(e.getMessage().getBytes(StandardCharsets.UTF_8)), Conveyor.CacheResult.OTHER, this.runtimeStats);
            }
            catch (RequestFilterException e) {
                RequestFilterException reqE = e;
                reqE.setHttpInfoHeader((HttpServletResponse)response);
                ResponseUtils.writeFixedResponse((HttpServletResponse)response, reqE.getResponseCode(), reqE.getContentType(), reqE.getResponse(), Conveyor.CacheResult.OTHER, this.runtimeStats);
            }
            catch (OWSException e) {
                ResponseUtils.writeFixedResponse((HttpServletResponse)response, e.getResponseCode(), e.getContentType(), e.getResponse(), Conveyor.CacheResult.OTHER, this.runtimeStats);
            }
            catch (SecurityException e) {
                ResponseUtils.writeFixedResponse((HttpServletResponse)response, 403, "text/plain", new ByteArrayResource("Not Authorized".getBytes(StandardCharsets.UTF_8)), Conveyor.CacheResult.OTHER, this.runtimeStats);
                LOG.warning(e.getMessage());
            }
            catch (Exception e) {
                if (!(e instanceof BadTileException) || LOG.isLoggable(Level.FINE)) {
                    LOG.severe(e.getMessage() + " " + request.getRequestURL().toString());
                }
                ResponseUtils.writeErrorPage((HttpServletResponse)response, 400, e.getMessage(), this.runtimeStats);
                if (!this.isClientStreamAbortedException(e)) {
                    LOG.log(Level.SEVERE, "Request failed", e);
                }
                if (!LOG.isLoggable(Level.FINE)) break block16;
                LOG.log(Level.FINE, "Request failed, client closed connection", e);
            }
        }
        return null;
    }

    private boolean isClientStreamAbortedException(Throwable t) {
        Throwable current = t;
        while (current != null && !(current instanceof ClientStreamAbortedException) && !(current instanceof HttpErrorCodeException)) {
            if (current instanceof SAXException) {
                SAXException exception = (SAXException)current;
                current = exception.getException();
                continue;
            }
            current = current.getCause();
        }
        if (current instanceof ClientStreamAbortedException) {
            LOG.log(Level.FINE, "Client has closed stream", t);
            return true;
        }
        return false;
    }

    public void destroy() {
        LOG.fine("GeoWebCacheDispatcher.destroy() was invoked, shutting down.");
    }

    private String[] parseRequest(String servletPath) throws GeoWebCacheException {
        String[] retStrs = new String[2];
        String[] splitStr = servletPath.split("/");
        if (splitStr == null || splitStr.length < 2) {
            return null;
        }
        retStrs[0] = splitStr[1];
        if (splitStr.length > 2) {
            retStrs[1] = splitStr[2];
        }
        return retStrs;
    }

    private void handleServiceRequest(String serviceStr, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Service service = this.findService(serviceStr);
        Conveyor conv = service.getConveyor(request, response);
        String layerName = conv.getLayerId();
        if (Objects.nonNull(layerName)) {
            TileLayer layer = this.tileLayerDispatcher.getTileLayer(layerName);
            if (!layer.isEnabled()) {
                throw new OWSException(400, "InvalidParameterValue", "LAYERS", "Layer '" + layerName + "' is disabled");
            }
            if (conv instanceof ConveyorTile) {
                ConveyorTile tile = (ConveyorTile)conv;
                tile.setTileLayer(layer);
            }
        } else {
            Object layer = null;
        }
        if (conv.reqHandler == Conveyor.RequestHandler.SERVICE) {
            service.handleRequest(conv);
        } else {
            ResponseUtils.writeTile(this.getSecurityDispatcher(), conv, layerName, this.tileLayerDispatcher, this.defaultStorageFinder, this.runtimeStats);
        }
    }

    private void handleDemoRequest(String action, HttpServletRequest request, HttpServletResponse response) throws GeoWebCacheException {
        Demo.makeMap(this.tileLayerDispatcher, this.gridSetBroker, action, request, response);
    }

    private Service findService(String serviceStr) throws GeoWebCacheException {
        Service service;
        if (this.services == null) {
            this.services = this.loadServices();
            this.loadBlankTile();
        }
        if ((service = this.services.get(serviceStr)) == null) {
            serviceStr = serviceStr == null || ((String)serviceStr).length() == 0 ? ", try service/&lt;name of service&gt;" : " \"" + (String)serviceStr + "\"";
            throw new GeoWebCacheException("Unable to find handler for service" + (String)serviceStr);
        }
        return service;
    }

    private void handleFrontPage(HttpServletRequest request, HttpServletResponse response) {
        Object baseUrl = null;
        if (request.getRequestURL().toString().endsWith("/") || request.getRequestURL().toString().endsWith(TYPE_HOME)) {
            baseUrl = "";
        } else {
            String[] strs = request.getRequestURL().toString().split("/");
            baseUrl = StringEscapeUtils.escapeHtml4((String)strs[strs.length - 1]) + "/";
        }
        StringBuilder str = new StringBuilder();
        str.append("<html>\n" + ServletUtils.gwcHtmlHeader((String)baseUrl, "GWC Home") + "<body>\n" + ServletUtils.gwcHtmlLogoLink((String)baseUrl));
        str.append("<h3>Welcome to GeoWebCache");
        boolean isAdmin = this.securityDispatcher.isAdmin();
        if (isAdmin) {
            String version = GeoWebCache.getVersion();
            String commitId = GeoWebCache.getBuildRevision();
            if (version == null) {
                version = "{NO VERSION INFO IN MANIFEST}";
            }
            if (commitId == null) {
                commitId = "{NO BUILD INFO IN MANIFEST}";
            }
            str.append(" version ").append(version).append(", build ").append(commitId);
        }
        str.append("</h3>\n");
        str.append("<p><a href=\"https://geowebcache.osgeo.org\">GeoWebCache</a> is an advanced tile cache for WMS servers. ");
        str.append("It supports a large variety of protocols and formats, including WMS-C, WMTS, KML, Google Maps and Virtual Earth.</p>");
        str.append("<h3>Automatically Generated Demos:</h3>\n");
        str.append("<ul><li><a href=\"" + (String)baseUrl + "demo\">A list of all the layers and automatic demos</a></li></ul>\n");
        str.append("<h3>GetCapabilities:</h3>\n");
        str.append("<ul><li><a href=\"" + (String)baseUrl + "service/wmts?REQUEST=getcapabilities\">WMTS 1.0.0 GetCapabilities document</a></li>");
        str.append("<li><a href=\"" + (String)baseUrl + "service/tms/1.0.0\">TMS 1.0.0 document</a></li>");
        str.append("<li><a href=\"" + (String)baseUrl + "service/wms?SERVICE=WMS&VERSION=1.1.1&REQUEST=getcapabilities&TILED=true\">WMS 1.1.1 GetCapabilities document</a></li>");
        str.append("<li>Note that the latter (WMS) will only work with clients that are ");
        str.append("<a href=\"http://wiki.osgeo.org/wiki/WMS_Tiling_Client_Recommendation\">WMS-C capable</a>.</li>\n");
        str.append("<li>Omitting tiled=true from the URL will omit the TileSet elements.</li></ul>\n");
        if (isAdmin) {
            if (this.runtimeStats != null) {
                str.append("<h3>Runtime Statistics</h3>\n");
                str.append(this.runtimeStats.getHTMLStats());
                str.append("</table>\n");
            }
            if (!Boolean.parseBoolean(GeoWebCacheExtensions.getProperty("GEOWEBCACHE_HIDE_STORAGE_LOCATIONS"))) {
                this.appendStorageLocations(str);
            }
            if (this.storageBroker != null) {
                this.appendInternalCacheStats(str);
            }
        }
        str.append("</body></html>\n");
        ResponseUtils.writePage(response, 200, str.toString(), this.runtimeStats, "text/html");
    }

    private void appendStorageLocations(StringBuilder str) {
        String localStorageLoc;
        String configLoc;
        DefaultStorageBroker broker;
        BlobStore bStore;
        XMLConfiguration configuration;
        str.append("<h3>Storage Locations</h3>\n");
        str.append("<table class=\"stats\">\n");
        str.append("<tbody>");
        BaseConfiguration baseConfiguration = this.mainConfiguration;
        XMLConfiguration config = baseConfiguration instanceof XMLConfiguration ? (configuration = (XMLConfiguration)baseConfiguration) : GeoWebCacheExtensions.bean(XMLConfiguration.class);
        HashMap<String, String> blobStoreLocations = new HashMap<String, String>();
        StorageBroker storageBroker = this.storageBroker;
        if (storageBroker instanceof DefaultStorageBroker && (bStore = (broker = (DefaultStorageBroker)storageBroker).getBlobStore()) instanceof CompositeBlobStore) {
            for (BlobStoreInfo bsConfig : this.blobStoreAggregator.getBlobStores()) {
                blobStoreLocations.put(bsConfig.getName(), bsConfig.getLocation());
            }
        }
        try {
            configLoc = config.getConfigLocation();
        }
        catch (NullPointerException | ConfigurationException ex) {
            configLoc = "Error";
            LOG.log(Level.SEVERE, "Could not find config location", ex);
        }
        try {
            localStorageLoc = this.defaultStorageFinder.getDefaultPath();
        }
        catch (ConfigurationException ex) {
            localStorageLoc = "Error";
            LOG.log(Level.SEVERE, "Could not find local cache location", ex);
        }
        str.append("<tr><th scope=\"row\">Config file:</th><td><tt>").append(StringEscapeUtils.escapeHtml4((String)configLoc)).append("</tt></td></tr>");
        str.append("<tr><th scope=\"row\">Local Storage:</th><td><tt>").append(StringEscapeUtils.escapeHtml4((String)localStorageLoc)).append("</tt></td></tr>");
        str.append("</tbody>");
        if (!blobStoreLocations.isEmpty()) {
            str.append("<tbody>");
            str.append("<tr><th scope=\"rowgroup\" colspan=\"2\">Blob Stores</th></tr>");
            for (Map.Entry e : blobStoreLocations.entrySet()) {
                str.append("<tr><th scope=\"row\">").append(StringEscapeUtils.escapeHtml4((String)((String)e.getKey()))).append(":</th><td><tt>").append(StringEscapeUtils.escapeHtml4((String)((String)e.getValue()))).append("</tt></td></tr>");
            }
            str.append("</tbody>");
        }
        str.append("</tbody>");
        str.append("</table>\n");
    }

    private void appendInternalCacheStats(StringBuilder strGlobal) {
        CacheStatistics statistics;
        StorageBroker storageBroker;
        if (this.storageBroker == null) {
            return;
        }
        BlobStore blobStore = null;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Searching for the blobstore used");
        }
        if ((storageBroker = this.storageBroker) instanceof DefaultStorageBroker) {
            DefaultStorageBroker broker = (DefaultStorageBroker)storageBroker;
            blobStore = broker.getBlobStore();
        }
        if (blobStore == null || !(blobStore instanceof MemoryBlobStore)) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("No Memory BlobStore found");
            }
            return;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Memory BlobStore found");
        }
        MemoryBlobStore store = (MemoryBlobStore)blobStore;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Getting statistics");
        }
        if ((statistics = store.getCacheStatistics()) == null) {
            return;
        }
        long hitCount = statistics.getHitCount();
        long missCount = statistics.getMissCount();
        long evictionCount = statistics.getEvictionCount();
        long requestCount = statistics.getRequestCount();
        double hitRate = statistics.getHitRate();
        double missRate = statistics.getMissRate();
        double currentMemory = statistics.getCurrentMemoryOccupation();
        long byteToMb = 0x100000L;
        double actualSize = (double)((long)(100.0 * ((double)statistics.getActualSize() * 1.0) / (double)byteToMb)) / 100.0;
        double totalSize = (double)((long)(100.0 * ((double)statistics.getTotalSize() * 1.0) / (double)byteToMb)) / 100.0;
        StringBuilder str = new StringBuilder();
        str.append("<h3>In Memory Cache Statistics</h3>\n");
        str.append("<table border=\"0\" cellspacing=\"5\">");
        str.append("<tr><td colspan=\"2\">Total number of requests:</td><td colspan=\"3\">" + (String)(requestCount >= 0L ? "" + requestCount : "Unavailable"));
        str.append("</td></tr>\n");
        str.append("<tr><td colspan=\"5\"> </td></tr>");
        str.append("<tr><td colspan=\"2\">Internal Cache hit count:</td><td colspan=\"3\">");
        str.append((String)(hitCount >= 0L ? "" + hitCount : "Unavailable"));
        str.append("</td></tr>\n");
        str.append("<tr><td colspan=\"2\">Internal Cache miss count:</td><td colspan=\"3\">");
        str.append((String)(missCount >= 0L ? "" + missCount : "Unavailable"));
        str.append("</td></tr>\n");
        str.append("<tr><td colspan=\"2\">Internal Cache hit ratio:</td><td colspan=\"3\">");
        str.append((String)(hitRate >= 0.0 ? hitRate + " %" : "Unavailable"));
        str.append("</td></tr>\n");
        str.append("<tr><td colspan=\"2\">Internal Cache miss ratio:</td><td colspan=\"3\">");
        str.append((String)(missRate >= 0.0 ? missRate + " %" : "Unavailable"));
        str.append("</td></tr>\n");
        str.append("<tr><td colspan=\"5\"> </td></tr>");
        str.append("<tr><td colspan=\"2\">Total number of evicted tiles:</td><td colspan=\"3\">" + (String)(evictionCount >= 0L ? "" + evictionCount : "Unavailable"));
        str.append("</td></tr>\n");
        str.append("<tr><td colspan=\"5\"> </td></tr>");
        str.append("<tr><td colspan=\"2\">Cache Memory occupation:</td><td colspan=\"3\">" + (String)(currentMemory >= 0.0 ? currentMemory + " %" : "Unavailable"));
        str.append("</td></tr>\n");
        str.append("<tr><td colspan=\"5\"> </td></tr>");
        str.append("<tr><td colspan=\"2\">Cache Actual Size/ Total Size :</td><td colspan=\"3\">" + (String)(totalSize >= 0.0 && actualSize >= 0.0 ? actualSize + " / " + totalSize + " Mb" : "Unavailable"));
        str.append("</td></tr>\n");
        str.append("<tr><td colspan=\"5\"> </td></tr>");
        str.append("</table>\n");
        strGlobal.append((CharSequence)str);
    }

    protected SecurityDispatcher getSecurityDispatcher() {
        return this.securityDispatcher;
    }

    public void setSecurityDispatcher(SecurityDispatcher secDispatcher) {
        this.securityDispatcher = secDispatcher;
    }
}

