/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache;

import java.util.Optional;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.geotools.util.logging.Logging;
import org.geowebcache.GeoWebCacheExtensions;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.PlaceholderConfigurerSupport;
import org.springframework.core.Constants;
import org.springframework.util.PropertyPlaceholderHelper;

public class GeoWebCacheEnvironment {
    public static final Logger LOGGER = Logging.getLogger((String)GeoWebCacheEnvironment.class.getName());
    private static final Constants constants = new Constants(PlaceholderConfigurerSupport.class);
    @Deprecated(forRemoval=true)
    public static final boolean ALLOW_ENV_PARAMETRIZATION = Boolean.parseBoolean(GeoWebCacheExtensions.getProperty("ALLOW_ENV_PARAMETRIZATION"));
    private static final String nullValue = "null";
    private final PropertyPlaceholderHelper helper = new PropertyPlaceholderHelper(constants.asString("DEFAULT_PLACEHOLDER_PREFIX"), constants.asString("DEFAULT_PLACEHOLDER_SUFFIX"), constants.asString("DEFAULT_VALUE_SEPARATOR"), true);
    private Properties props;

    public boolean isAllowEnvParametrization() {
        return Boolean.parseBoolean(GeoWebCacheExtensions.getProperty("ALLOW_ENV_PARAMETRIZATION"));
    }

    public Properties getProps() {
        return this.props;
    }

    public void setProps(Properties props) {
        this.props = props;
    }

    protected String resolvePlaceholder(String placeholder) {
        String propVal = null;
        propVal = this.resolveSystemProperty(placeholder);
        if (this.props != null && propVal == null) {
            propVal = this.props.getProperty(placeholder);
        }
        return propVal;
    }

    protected String resolveSystemProperty(String key) {
        try {
            String value = GeoWebCacheExtensions.getProperty(key);
            if (value == null) {
                value = System.getenv(key);
            }
            return value;
        }
        catch (RuntimeException ex) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Could not access system property '" + key + "': " + String.valueOf(ex));
            }
            return null;
        }
    }

    protected String resolveStringValue(String strVal) throws BeansException {
        String resolved = this.helper.replacePlaceholders(strVal, this::resolvePlaceholder);
        return resolved.equals(nullValue) ? null : resolved;
    }

    public <T> T resolveValue(T value) {
        if (value instanceof String) {
            String string = (String)value;
            return (T)this.resolveStringValue(string);
        }
        return value;
    }

    private String resolveValueIfEnabled(String value) {
        return this.isAllowEnvParametrization() ? this.resolveValue(value) : value;
    }

    private boolean validateBoolean(String value) {
        return "true".equalsIgnoreCase(value = value.trim()) || "false".equalsIgnoreCase(value);
    }

    public <T> Optional<T> resolveValueIfEnabled(String value, Class<T> type) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return Optional.empty();
        }
        String resultValue = this.resolveValueIfEnabled(value);
        if (type.isAssignableFrom(String.class)) {
            return Optional.of(resultValue);
        }
        if (type.isAssignableFrom(Integer.class)) {
            try {
                Integer intValue = Integer.valueOf(resultValue);
                return Optional.of(intValue);
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("Illegal String parameter: Resolved value is not an integer.", ex);
            }
        }
        if (type.isAssignableFrom(Boolean.class)) {
            if (!this.validateBoolean(resultValue)) {
                throw new IllegalArgumentException("Illegal String parameter: Resolved value is not a boolean.");
            }
            Boolean boolValue = Boolean.valueOf(value);
            return Optional.of(boolValue);
        }
        throw new IllegalArgumentException("No type convertion available for " + String.valueOf(type));
    }
}

