/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.servlet.ServletContext;
import org.geotools.util.logging.Logging;
import org.geowebcache.GeoWebCacheExtensionPriority;
import org.geowebcache.ReinitializingBean;
import org.geowebcache.config.BaseConfiguration;
import org.geowebcache.util.GWCVars;
import org.geowebcache.util.SuppressFBWarnings;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

public class GeoWebCacheExtensions
implements ApplicationContextAware,
ApplicationListener {
    private static Logger LOGGER = Logging.getLogger((String)GeoWebCacheExtensions.class.getName());
    static WeakHashMap<Class<?>, String[]> extensionsCache = new WeakHashMap(40);
    static ApplicationContext context;

    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
    public void setApplicationContext(ApplicationContext context) throws BeansException {
        GeoWebCacheExtensions.context = context;
        extensionsCache.clear();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final <T> List<T> extensions(Class<T> extensionPoint, ApplicationContext context) {
        String[] names = GeoWebCacheExtensions.context == context ? extensionsCache.get(extensionPoint) : null;
        if (names == null) {
            GeoWebCacheExtensions.checkContext(context);
            if (context == null) return Collections.emptyList();
            try {
                names = GeoWebCacheExtensions.getBeansNamesOrderedByPriority(extensionPoint, context);
                if (GeoWebCacheExtensions.context == context) {
                    extensionsCache.put(extensionPoint, names);
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "bean lookup error", e);
                return Collections.emptyList();
            }
        }
        ArrayList<Object> result = new ArrayList<Object>(names.length);
        for (String name : names) {
            Object bean = context.getBean(name);
            result.add(bean);
        }
        return result;
    }

    public static <T> String[] getBeansNamesOrderedByPriority(Class<T> extensionType) {
        return GeoWebCacheExtensions.getBeansNamesOrderedByPriority(extensionType, context);
    }

    private static <T> String[] getBeansNamesOrderedByPriority(Class<T> extensionType, ApplicationContext context) {
        Map beans = context.getBeansOfType(extensionType);
        if (!GeoWebCacheExtensionPriority.class.isAssignableFrom(extensionType)) {
            return beans.keySet().toArray(new String[beans.size()]);
        }
        ArrayList beansEntries = new ArrayList(beans.entrySet());
        Collections.sort(beansEntries, (extensionA, extensionB) -> {
            GeoWebCacheExtensionPriority extensionPriorityA = (GeoWebCacheExtensionPriority)extensionA.getValue();
            GeoWebCacheExtensionPriority extensionPriorityB = (GeoWebCacheExtensionPriority)extensionB.getValue();
            if (extensionPriorityA.getPriority() < extensionPriorityB.getPriority()) {
                return -1;
            }
            return extensionPriorityA.getPriority() == extensionPriorityB.getPriority() ? 0 : 1;
        });
        return (String[])beansEntries.stream().map(Map.Entry::getKey).toArray(String[]::new);
    }

    public static final <T> List<T> extensions(Class<T> extensionPoint) {
        return GeoWebCacheExtensions.extensions(extensionPoint, context);
    }

    public static <T extends BaseConfiguration> List<T> configurations(Class<T> extensionPoint, ApplicationContext context) {
        return GeoWebCacheExtensions.extensions(extensionPoint, context).stream().sorted((x, y) -> Integer.signum(x.getPriority(extensionPoint) - y.getPriority(extensionPoint))).collect(Collectors.toList());
    }

    public static <T extends BaseConfiguration> List<T> configurations(Class<T> extensionPoint) {
        return GeoWebCacheExtensions.configurations(extensionPoint, context);
    }

    public static void reinitialize(ApplicationContext context) {
        BaseConfiguration configuration;
        List<ReinitializingBean> extensions = GeoWebCacheExtensions.extensions(ReinitializingBean.class, context);
        for (ReinitializingBean bean : extensions) {
            try {
                bean.deinitialize();
            }
            catch (Exception e) {
                if (bean instanceof BaseConfiguration) {
                    configuration = (BaseConfiguration)bean;
                    LOGGER.log(Level.SEVERE, "Error while preparing configuration to reinitialize " + configuration.getIdentifier() + " from " + configuration.getLocation(), e);
                    continue;
                }
                LOGGER.log(Level.SEVERE, "Error while preparing bean to reinitialize " + bean.toString(), e);
            }
        }
        for (ReinitializingBean bean : extensions) {
            try {
                bean.reinitialize();
            }
            catch (Exception e) {
                if (bean instanceof BaseConfiguration) {
                    configuration = (BaseConfiguration)bean;
                    LOGGER.log(Level.SEVERE, "Error while reinitializing configuration " + configuration.getIdentifier() + " from " + configuration.getLocation(), e);
                    continue;
                }
                LOGGER.log(Level.SEVERE, "Error while reinitializing bean " + bean.toString(), e);
            }
        }
    }

    public static final Object bean(String name) {
        return GeoWebCacheExtensions.bean(name, context);
    }

    public static final Object bean(String name, ApplicationContext context) {
        GeoWebCacheExtensions.checkContext(context);
        return context != null ? context.getBean(name) : null;
    }

    public static final <T> T bean(Class<T> type) throws IllegalArgumentException {
        GeoWebCacheExtensions.checkContext(context);
        return context != null ? (T)GeoWebCacheExtensions.bean(type, context) : null;
    }

    public static final <T> T bean(Class<T> type, ApplicationContext context) throws IllegalArgumentException {
        List<T> beans = GeoWebCacheExtensions.extensions(type, context);
        if (beans.isEmpty()) {
            return null;
        }
        if (beans.size() > 1) {
            throw new IllegalArgumentException("Multiple beans of type " + type.getName());
        }
        return beans.get(0);
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextRefreshedEvent) {
            extensionsCache.clear();
        }
    }

    static void checkContext(ApplicationContext context) {
        if (context == null) {
            LOGGER.fine("Extension lookup occured, but ApplicationContext is unset.");
        }
    }

    public static String getProperty(String propertyName) {
        return GeoWebCacheExtensions.getProperty(propertyName, context);
    }

    public static String getProperty(String propertyName, ApplicationContext context) {
        return GWCVars.findEnvVar(context, propertyName);
    }

    @Deprecated
    public static String getProperty(String propertyName, ServletContext context) {
        String[] typeStrs = new String[]{"Java environment variable ", "Servlet context parameter ", "System environment variable "};
        String result = null;
        for (int j = 0; j < typeStrs.length; ++j) {
            switch (j) {
                case 0: {
                    result = System.getProperty(propertyName);
                    break;
                }
                case 1: {
                    if (context == null) break;
                    result = context.getInitParameter(propertyName);
                    break;
                }
                case 2: {
                    result = System.getenv(propertyName);
                }
            }
            if (result != null && !result.equalsIgnoreCase("")) break;
            LOGGER.finer("Found " + typeStrs[j] + ": '" + propertyName + "' to be unset");
        }
        return result;
    }
}

