/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.config;

import java.util.Arrays;
import java.util.logging.Logger;
import org.geotools.util.logging.Logging;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.config.BaseConfiguration;
import org.geowebcache.config.SimpleGridSetConfiguration;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSetFactory;
import org.geowebcache.grid.SRS;

public class DefaultGridsets
extends SimpleGridSetConfiguration {
    private static Logger log = Logging.getLogger((String)DefaultGridsets.class.getName());
    private final GridSet WORLD_EPSG4326;
    private final GridSet WORLD_EPSG4326x2;
    private final GridSet WORLD_EPSG3857;
    private final GridSet WORLD_EPSG3857x2;
    private final GridSet WEB_MERCATOR_QUAD;
    private final GridSet WORLD_CRS84_QUAD;
    private final GridSet WORLD_MERCATOR_WGS84_QUAD;

    public GridSet worldEpsg4326() {
        return new GridSet(this.WORLD_EPSG4326);
    }

    public GridSet worldEpsg4326x2() {
        return new GridSet(this.WORLD_EPSG4326x2);
    }

    public GridSet worldEpsg3857() {
        return new GridSet(this.WORLD_EPSG3857);
    }

    public GridSet worldEpsg3857x2() {
        return new GridSet(this.WORLD_EPSG3857x2);
    }

    public GridSet webMercatorQuad() {
        return new GridSet(this.WEB_MERCATOR_QUAD);
    }

    public GridSet worldCRS84Quad() {
        return new GridSet(this.WORLD_CRS84_QUAD);
    }

    public GridSet worldMercatorWGS84Quad() {
        return new GridSet(this.WORLD_MERCATOR_WGS84_QUAD);
    }

    public DefaultGridsets(boolean useEPSG900913, boolean useGWC11xNames) {
        String unprojectedName = "GlobalCRS84Geometric";
        String mercatorName = "GoogleMapsCompatible";
        if (useGWC11xNames) {
            unprojectedName = "EPSG:4326";
            mercatorName = useEPSG900913 ? "EPSG:900913" : "EPSG:3857";
        }
        this.WORLD_EPSG4326 = GridSetFactory.createGridSet(unprojectedName, SRS.getEPSG4326(), BoundingBox.WORLD4326, false, GridSetFactory.DEFAULT_LEVELS, null, 2.8E-4, 256, 256, true);
        this.WORLD_EPSG4326.setDescription("A default WGS84 tile matrix set where the first zoom level covers the world with two tiles on the horizontal axis and one tile over the vertical axis and each subsequent zoom level is calculated by half the resolution of its previous one. Tiles are 256px wide.");
        this.addInternal(this.WORLD_EPSG4326);
        this.WORLD_EPSG4326x2 = GridSetFactory.createGridSet(unprojectedName + "x2", SRS.getEPSG4326(), BoundingBox.WORLD4326, false, GridSetFactory.DEFAULT_LEVELS, null, 2.8E-4, 512, 512, true);
        this.WORLD_EPSG4326x2.setDescription("A default WGS84 tile matrix set where the first zoom level covers the world with two tiles on the horizontal axis and one tile over the vertical axis and each subsequent zoom level is calculated by half the resolution of its previous one. Tiles are 512px wide.");
        this.addInternal(this.WORLD_EPSG4326x2);
        SRS googleMapsCompatibleSRS = useEPSG900913 ? SRS.getEPSG900913() : SRS.getEPSG3857();
        log.fine("Adding " + String.valueOf(googleMapsCompatibleSRS) + " grid set for Spherical Mercator / GoogleMapsCompatible");
        this.WORLD_EPSG3857 = GridSetFactory.createGridSet(mercatorName, googleMapsCompatibleSRS, BoundingBox.WORLD3857, false, this.commonPractice900913Resolutions(), null, 1.0, 2.8E-4, null, 256, 256, false);
        this.WORLD_EPSG3857.setDescription("This well-known scale set has been defined to be compatible with Google Maps and Microsoft Live Map projections and zoom levels. Level 0 allows representing the whole world in a single 256x256 pixels. The next level represents the whole world in 2x2 tiles of 256x256 pixels and so on in powers of 2. Scale denominator is only accurate near the equator.");
        this.addInternal(this.WORLD_EPSG3857);
        this.WORLD_EPSG3857x2 = GridSetFactory.createGridSet(mercatorName + "x2", googleMapsCompatibleSRS, BoundingBox.WORLD3857, false, this.halveResolutions(this.commonPractice900913Resolutions()), null, 1.0, 2.8E-4, null, 512, 512, false);
        this.WORLD_EPSG3857x2.setDescription("This well-known scale set has been defined to be compatible with Google Maps and Microsoft Live Map projections and zoom levels. Level 0 allows representing the whole world in a single 512x512 pixels. The next level represents the whole world in 2x2 tiles of 512x512 pixels and so on in powers of 2. Scale denominator is only accurate near the equator.");
        this.addInternal(this.WORLD_EPSG3857x2);
        log.fine("Adding GlobalCRS84Pixel");
        GridSet GlobalCRS84Pixel = GridSetFactory.createGridSet("GlobalCRS84Pixel", SRS.getEPSG4326(), BoundingBox.WORLD4326, true, this.scalesCRS84PixelResolutions(), null, null, 2.8E-4, null, 256, 256, true);
        GlobalCRS84Pixel.setDescription("This well-known scale set has been defined for global cartographic products. Rounded pixel sizes have been chosen for intuitive cartographic representation of raster data. Some values have been chosen to coincide with original pixel size of commonly used globalproducts like STRM (1\" and 3\"), GTOPO (30\") or ETOPO (2' and 5'). Scale denominatorand approximated pixel size in meters are only accurate near the equator.");
        this.addInternal(GlobalCRS84Pixel);
        log.fine("Adding GlobalCRS84Scale");
        GridSet GlobalCRS84Scale = GridSetFactory.createGridSet("GlobalCRS84Scale", SRS.getEPSG4326(), BoundingBox.WORLD4326, true, null, this.scalesCRS84ScaleDenominators(), null, 2.8E-4, null, 256, 256, true);
        GlobalCRS84Scale.setDescription("This well-known scale set has been defined for global cartographic products. Rounded scales have been chosen for intuitive cartographic representation of vector data. Scale denominator is only accurate near the equator.");
        this.addInternal(GlobalCRS84Scale);
        log.fine("Adding GoogleCRS84Quad");
        GridSet GoogleCRS84Quad = GridSetFactory.createGridSet("GoogleCRS84Quad", SRS.getEPSG4326(), BoundingBox.WORLD4326, true, null, this.scalesCRS84QuadScaleDenominators(), null, 2.8E-4, null, 256, 256, true);
        GoogleCRS84Quad.setDescription("This well-known scale set has been defined to allow quadtree pyramids in CRS84. Level 0 allows representing the whole world in a single 256x256 pixels (where the first 64 and last 64 lines of the tile are left blank). The next level represents the whole world in 2x2 tiles of 256x256 pixels and so on in powers of 2. Scale denominator is only accurate near the equator.");
        this.addInternal(GoogleCRS84Quad);
        log.fine("Adding OGC TMS WebMercatorQuad");
        this.WEB_MERCATOR_QUAD = GridSetFactory.createGridSet("WebMercatorQuad", SRS.getEPSG3857(), BoundingBox.WORLD3857, true, null, new double[]{5.59082264028717E8, 2.79541132014358E8, 1.39770566007179E8, 6.98852830035897E7, 3.49426415017948E7, 1.74713207508974E7, 8735660.37544871, 4367830.18772435, 2183915.09386217, 1091957.54693108, 545978.773465544, 272989.386732772, 136494.693366386, 68247.346683193, 34123.6733415964, 17061.8366707982, 8530.91833539913, 4265.45916769956, 2132.72958384978, 1066.36479192489, 533.182395962445, 266.591197981222, 133.295598990611, 66.6477994953056, 33.3238997476528}, 1.0, 2.8E-4, new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24"}, 256, 256, true);
        this.WEB_MERCATOR_QUAD.setDescription("This tile matrix set is the most used tile matrix set in the mass market: for example, by Google Maps, Microsoft Bing Maps and Open Street Map tiles. Nevertheless, it has been long criticized because it is a based on a spherical Mercator instead of an ellipsoid. The use of WebMercatorQuad should be limited to visualization. Any additional use (including distance measurements, routing etc.) needs to use the Mercator spherical expressions to transform the coordinate to an appropriate CRS first. The risks caused by imprecision in the use of Web Mercator is also emphasized by the US National Geospatial Agency (NGA). NGA has issued an Advisory Notice on web Mercator (http://earth-info.nga.mil/GandG/wgs84/web_mercator/index.html) that says that \u201cit may cause geo-location / geo-coordinate errors up to 40,000 meters. This erroneous geospatial positioning information poses an unacceptable risk to global safety of navigation activities, and department of defense, intelligence community, and allied partner systems, missions, and operations that require accurate and precise positioning and navigation information.\u201d The use of WorldMercatorWGS84Quad is recommended.");
        this.addInternal(this.WEB_MERCATOR_QUAD);
        this.addx2Gridset(this.WEB_MERCATOR_QUAD);
        log.fine("Adding OGC TMS WorldCRS84Quad");
        this.WORLD_CRS84_QUAD = GridSetFactory.createGridSet("WorldCRS84Quad", SRS.getEPSG4326(), BoundingBox.WORLD4326, true, null, new double[]{2.795411320143589E8, 1.397705660071794E8, 6.988528300358972E7, 3.494264150179486E7, 1.747132075089743E7, 8735660.375448715, 4367830.187724357, 2183915.093862179, 1091957.546931089, 545978.7734655447, 272989.3867327723, 136494.6933663862, 68247.34668319309, 34123.67334159654, 17061.83667079827, 8530.918335399136, 4265.459167699568, 2132.729583849784}, null, 2.8E-4, new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18"}, 256, 256, true);
        this.WORLD_CRS84_QUAD.setDescription("This Tile Matrix Set defines tiles in the Equirectangular Plate Carr\u00e9e projection in the CRS84 CRS for the whole world.");
        this.addInternal(this.WORLD_CRS84_QUAD);
        this.addx2Gridset(this.WORLD_CRS84_QUAD);
        log.fine("Adding OGC TMS WorldMercatorWGS84Quad");
        this.WORLD_MERCATOR_WGS84_QUAD = GridSetFactory.createGridSet("WorldMercatorWGS84Quad", SRS.getSRS(3395), new BoundingBox(-2.00375083427892E7, -2.00375083427892E7, 2.00375083427892E7, 2.00375083427892E7), true, null, new double[]{5.59082264028717E8, 2.79541132014358E8, 1.39770566007179E8, 6.98852830035897E7, 3.49426415017948E7, 1.74713207508974E7, 8735660.37544871, 4367830.18772435, 2183915.09386217, 1091957.54693108, 545978.773465544, 272989.386732772, 136494.693366386, 68247.346683193, 34123.6733415964, 17061.8366707982, 8530.91833539913, 4265.45916769956, 2132.72958384978, 1066.36479192489, 533.182395962445, 266.591197981222, 133.295598990611, 66.6477994953056, 33.3238997476528}, 1.0, 2.8E-4, new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24"}, 256, 256, true);
        this.WORLD_MERCATOR_WGS84_QUAD.setDescription("This Tile Matrix Set defines tiles in the Mercator projection in the WGS84 CRS for the whole world.");
        this.addInternal(this.WORLD_MERCATOR_WGS84_QUAD);
        this.addx2Gridset(this.WORLD_MERCATOR_WGS84_QUAD);
        double[] UTM_SCALES = new double[]{2.79072704500914E8, 1.39536352250457E8, 6.97681761252285E7, 3.48840880626143E7, 1.74420440313071E7, 8721022.01565356, 4360511.00782678, 2180255.50391339, 1090127.7519567, 545063.875978348, 272531.937989174, 136265.968994587, 68132.9844972935, 34066.4922486467, 17033.2461243234, 8516.62306216168, 4258.31153108084, 2129.15576554042, 1064.57788277021, 532.288941385105, 266.144470692553, 133.072235346276, 66.5361176731382, 33.2680588365691};
        for (int i = 1; i <= 60; ++i) {
            String id = "UTM" + (i < 10 ? "0" : "") + i + "WGS84Quad";
            GridSet utmGridset = GridSetFactory.createGridSet(id, SRS.getSRS(32600 + i), new BoundingBox(-9501965.72931276, -2.00039314586255E7, 1.05019657293128E7, 2.00039314586255E7), true, null, UTM_SCALES, 1.0, 2.8E-4, new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24"}, 256, 256, true);
            utmGridset.setDescription("This Tile Matrix Set defines tiles in the Universal Transverse Mercator, zone " + i);
            this.addInternal(utmGridset);
            this.addx2Gridset(utmGridset);
        }
        log.fine("Adding OGC TMS UPSArcticWGS84Quad");
        double[] upsScales = new double[]{4.587265444E8, 2.293632722E8, 1.146816361E8, 5.734081805E7, 2.867040902E7, 1.433520451E7, 7167602.256, 3583801.128, 1791900.564, 895950.282, 447975.141, 223987.5705, 111993.7852, 55996.89262, 27998.44631, 13999.22316, 6999.611578, 3499.805789, 1749.902894, 874.9514472, 437.4757236, 218.7378618, 109.3689309, 54.68446545, 27.34223273};
        BoundingBox upsBounds = new BoundingBox(-1.4440759350252E7, -1.4440759350252E7, 1.8440759350252E7, 1.8440759350252E7);
        GridSet upsArctic = GridSetFactory.createGridSet("UPSArcticWGS84Quad", SRS.getSRS(5041), upsBounds, true, null, upsScales, 1.0, 2.8E-4, new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24"}, 256, 256, true);
        upsArctic.setDescription("This Tile Matrix Set defines tiles in the Universal Polar Stereographics for the arctic");
        this.addInternal(upsArctic);
        this.addx2Gridset(upsArctic);
        log.fine("Adding OGC TMS UPSAntarcticWGS84Quad");
        GridSet upsAntarctic = GridSetFactory.createGridSet("UPSAntarcticWGS84Quad", SRS.getSRS(5042), upsBounds, true, null, upsScales, 1.0, 2.8E-4, new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24"}, 256, 256, true);
        upsAntarctic.setDescription("This Tile Matrix Set defines tiles in the Universal Polar Stereographics for the Antarctic");
        this.addInternal(upsAntarctic);
        this.addx2Gridset(upsAntarctic);
        log.fine("Adding OGC TMS EuropeanETRS89_LAEAQuad");
        GridSet euETRS89LaeaQuad = GridSetFactory.createGridSet("EuropeanETRS89_LAEAQuad", SRS.getSRS(3035), new BoundingBox(2000000.0, 1000000.0, 6500000.0, 5500000.0), true, null, new double[]{6.2779017857142866E7, 3.1389508928571433E7, 1.5694754464285716E7, 7847377.232142858, 3923688.616071429, 1961844.3080357146, 980922.1540178573, 490461.07700892864, 245230.53850446432, 122615.26925223216, 61307.63462611608, 30653.81731305804, 15326.90865652902, 7663.45432826451, 3831.727164132255, 1915.8635820661275}, 1.0, 2.8E-4, new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15"}, 256, 256, true);
        euETRS89LaeaQuad.setDescription("Lambert Azimuthal Equal Area ETRS89 for Europe");
        this.addInternal(euETRS89LaeaQuad);
        this.addx2Gridset(euETRS89LaeaQuad);
        log.fine("Adding OGC TMS CanadianNAD83_LCC");
        GridSet canadianNAD83Lcc = GridSetFactory.createGridSet("CanadianNAD83_LCC", SRS.getSRS(3978), new BoundingBox(-7786476.885838887, -5153821.09213678, 7148753.233541353, 7928343.534071138), true, null, new double[]{1.37016643080905E8, 8.03201011163925E7, 4.72471183037603E7, 2.83482709822562E7, 1.65364914063161E7, 9449423.66075207, 5669654.19645125, 3307298.28126323, 1889884.73215041, 1133930.83929025, 661459.656252643, 396875.793751586, 236235.591518802, 137016.643080905, 80320.1011163925, 47247.1183037603, 28348.2709822562, 16536.4914063161, 9449.42366075207, 5669.65419645125, 3307.29828126323, 1889.88473215041, 1133.93083929025, 661.459656252643, 396.875793751586, 236.235591518802}, 1.0, 2.8E-4, new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25"}, 256, 256, true);
        canadianNAD83Lcc.setDescription("Lambert Conformal Conic for Canada");
        this.addInternal(canadianNAD83Lcc);
        this.addx2Gridset(canadianNAD83Lcc);
    }

    private void addx2Gridset(GridSet base) {
        assert (base.getTileWidth() == 256 && base.getTileHeight() == 256);
        int levels = base.getNumLevels();
        double[] scales = new double[levels];
        String[] scaleNames = new String[levels];
        for (int i = 0; i < levels; ++i) {
            scales[i] = base.getGrid(i).getScaleDenominator() / 2.0;
            scaleNames[i] = base.getGrid(i).getName();
        }
        GridSet x2 = GridSetFactory.createGridSet(base.getName() + "x2", base.getSrs(), base.getOriginalExtent(), base.isTopLeftAligned(), null, scales, base.getMetersPerUnit(), base.getPixelSize(), scaleNames, 512, 512, base.isyCoordinateFirst());
        this.addInternal(x2);
    }

    private double[] halveResolutions(double[] resolutions) {
        return Arrays.stream(resolutions).map(r -> r / 2.0).toArray();
    }

    public void afterPropertiesSet() throws GeoWebCacheException {
    }

    @Override
    public String getIdentifier() {
        return "DefaultGridsets";
    }

    @Override
    public String getLocation() {
        return "Default";
    }

    private double[] scalesCRS84QuadScaleDenominators() {
        double[] scalesCRS84QuadScaleResolutions = new double[]{5.590822640287178E8, 2.795411320143589E8, 1.397705660071794E8, 6.988528300358972E7, 3.494264150179486E7, 1.747132075089743E7, 8735660.375448715, 4367830.187724357, 2183915.093862179, 1091957.546931089, 545978.7734655447, 272989.3867327723, 136494.6933663862, 68247.34668319309, 34123.67334159654, 17061.83667079827, 8530.918335399136, 4265.459167699568, 2132.729583849784};
        return scalesCRS84QuadScaleResolutions;
    }

    private double[] commonPractice900913Resolutions() {
        return new double[]{156543.03390625, 78271.516953125, 39135.7584765625, 19567.87923828125, 9783.939619140625, 4891.9698095703125, 2445.9849047851562, 1222.9924523925781, 611.4962261962891, 305.74811309814453, 152.87405654907226, 76.43702827453613, 38.218514137268066, 19.109257068634033, 9.554628534317017, 4.777314267158508, 2.388657133579254, 1.194328566789627, 0.5971642833948135, 0.29858214169740677, 0.14929107084870338, 0.07464553542435169, 0.037322767712175846, 0.018661383856087923, 0.009330691928043961, 0.004665345964021981, 0.0023326729820109904, 0.0011663364910054952, 5.831682455027476E-4, 2.915841227513738E-4, 1.457920613756869E-4};
    }

    private double[] scalesCRS84PixelResolutions() {
        double[] scalesCRS84Pixel;
        scalesCRS84Pixel = new double[]{2.0, 1.0, 0.5, scalesCRS84Pixel[2] * 0.6666666666666666, scalesCRS84Pixel[2] / 3.0, scalesCRS84Pixel[4] / 2.0, scalesCRS84Pixel[4] / 5.0, scalesCRS84Pixel[4] / 10.0, 0.008333333333333333, scalesCRS84Pixel[8] / 2.0, scalesCRS84Pixel[9] / 3.0, scalesCRS84Pixel[9] / 5.0, scalesCRS84Pixel[11] / 3.0, scalesCRS84Pixel[12] / 2.0, scalesCRS84Pixel[13] * 0.6, scalesCRS84Pixel[14] / 3.0, scalesCRS84Pixel[15] * 0.3, scalesCRS84Pixel[16] / 3.0};
        return scalesCRS84Pixel;
    }

    private double[] scalesCRS84ScaleDenominators() {
        double[] scalesCRS84Pixel = new double[]{5.0E8, 2.5E8, 1.0E8, 5.0E7, 2.5E7, 1.0E7, 5000000.0, 2500000.0, 1000000.0, 500000.0, 250000.0, 100000.0, 50000.0, 25000.0, 10000.0, 5000.0, 2500.0, 1000.0, 500.0, 250.0, 100.0};
        return scalesCRS84Pixel;
    }

    @Override
    public int getPriority(Class<? extends BaseConfiguration> clazz) {
        return 100;
    }

    @Override
    public void deinitialize() throws Exception {
    }

    @Override
    public int getPriority() {
        return 100;
    }
}

