/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.config;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.geowebcache.GeoWebCacheException;

public class ListenerCollection<Listener> {
    List<Listener> listeners = new LinkedList<Listener>();

    public synchronized void add(Listener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public synchronized void remove(Listener listener) {
        this.listeners.remove(listener);
    }

    public synchronized void safeForEach(HandlerMethod<Listener> method) throws GeoWebCacheException, IOException {
        LinkedList exceptions = this.listeners.stream().map(l -> {
            try {
                method.callOn(l);
                return Optional.empty();
            }
            catch (Exception ex) {
                return Optional.of(ex);
            }
        }).flatMap(Optional::stream).collect(Collectors.collectingAndThen(Collectors.toList(), LinkedList::new));
        if (!exceptions.isEmpty()) {
            Iterator it = exceptions.descendingIterator();
            Exception ex = (Exception)it.next();
            while (it.hasNext()) {
                ex.addSuppressed((Throwable)it.next());
            }
            if (ex instanceof GeoWebCacheException) {
                GeoWebCacheException exception1 = (GeoWebCacheException)ex;
                throw exception1;
            }
            if (ex instanceof IOException) {
                IOException exception = (IOException)ex;
                throw exception;
            }
            throw (RuntimeException)ex;
        }
    }

    @FunctionalInterface
    public static interface HandlerMethod<Listener> {
        public void callOn(Listener var1) throws GeoWebCacheException, IOException;
    }
}

