/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.demo;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.geotools.util.logging.Logging;
import org.geowebcache.GeoWebCacheException;
import org.geowebcache.filter.parameters.FloatParameterFilter;
import org.geowebcache.filter.parameters.ParameterFilter;
import org.geowebcache.filter.parameters.RegexParameterFilter;
import org.geowebcache.filter.parameters.StringParameterFilter;
import org.geowebcache.grid.BoundingBox;
import org.geowebcache.grid.GridSet;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.TileLayerDispatcher;
import org.geowebcache.mime.ApplicationMime;
import org.geowebcache.mime.ImageMime;
import org.geowebcache.mime.MimeType;
import org.geowebcache.mime.XMLMime;
import org.geowebcache.util.ServletUtils;
import org.springframework.util.Assert;

public class Demo {
    private static Logger LOGGER = Logging.getLogger((String)Demo.class.getName());

    public static void makeMap(TileLayerDispatcher tileLayerDispatcher, GridSetBroker gridSetBroker, String action, HttpServletRequest request, HttpServletResponse response) throws GeoWebCacheException {
        String page = null;
        if (action != null) {
            String formatStr;
            String layerName = ServletUtils.URLDecode(action, request.getCharacterEncoding());
            TileLayer layer = tileLayerDispatcher.getTileLayer(layerName);
            String rawGridSet = request.getParameter("gridSet");
            String gridSetStr = null;
            if (rawGridSet != null) {
                gridSetStr = ServletUtils.URLDecode(rawGridSet, request.getCharacterEncoding());
            }
            if (gridSetStr == null && (gridSetStr = request.getParameter("srs")) == null) {
                gridSetStr = layer.getGridSubsets().iterator().next();
            }
            if ((formatStr = request.getParameter("format")) != null) {
                if (!layer.supportsFormat(formatStr)) {
                    throw new GeoWebCacheException("Unknow or unsupported format " + formatStr);
                }
            } else {
                formatStr = layer.getDefaultMimeType().getFormat();
            }
            page = Demo.generateHTML(layer, gridSetStr, formatStr);
        } else {
            if (request.getRequestURI().endsWith("/")) {
                try {
                    String reqUri = request.getRequestURI();
                    response.sendRedirect(response.encodeRedirectURL(reqUri.substring(0, reqUri.length() - 1)));
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Error sending redirect response", e);
                }
                return;
            }
            page = Demo.generateHTML(tileLayerDispatcher, gridSetBroker);
        }
        response.setContentType("text/html");
        response.setCharacterEncoding("UTF-8");
        try {
            response.getOutputStream().write(page.getBytes());
        }
        catch (IOException ioe) {
            throw new GeoWebCacheException("failed to render HTML");
        }
    }

    private static String generateHTML(TileLayerDispatcher tileLayerDispatcher, GridSetBroker gridSetBroker) throws GeoWebCacheException {
        String reloadPath = "rest/reload";
        String truncatePath = "rest/masstruncate";
        StringBuffer buf = new StringBuffer();
        buf.append("<html>\n");
        buf.append(ServletUtils.gwcHtmlHeader("", "GWC Demos"));
        buf.append("<body>\n");
        buf.append(ServletUtils.gwcHtmlLogoLink(""));
        buf.append("<table cellspacing=\"10\" border=\"0\">\n<tr><td><strong>Layer name:</strong></td>\n<td><strong>Enabled:</strong></td>\n<td><strong>Grids Sets:</strong></td>\n");
        buf.append("</tr>\n");
        Demo.tableRows(buf, tileLayerDispatcher, gridSetBroker);
        buf.append("</table>\n");
        buf.append("<br />");
        buf.append("<strong>These are just quick demos. GeoWebCache also supports:</strong><br />\n<ul><li>WMTS, TMS, Virtual Earth and Google Maps</li>\n<li>Proxying GetFeatureInfo, GetLegend and other WMS requests</li>\n<li>Advanced request and parameter filters</li>\n<li>Output format adjustments, such as compression level</li>\n<li>Adjustable expiration headers and automatic cache expiration</li>\n<li>RESTful interface for seeding and configuration (beta)</li>\n</ul>\n<br />\n<strong>Reload TileLayerConfiguration:</strong><br />\n<p>You can reload the configuration by pressing the following button. The username / password is configured in WEB-INF/user.properties, or the admin  user in GeoServer if you are using the plugin.</p>\n<form form id=\"kill\" action=\"").append(reloadPath).append("\" method=\"post\"><input type=\"hidden\" name=\"reload_configuration\"  value=\"1\" /><span><input style=\"padding: 0; margin-bottom: -12px; border: 1;\"type=\"submit\" value=\"Reload TileLayerConfiguration\"></span></form><br /><strong>Truncate All Layers:</strong><br />\n<p>Truncate all layers<form form id=\"truncate\" action=\"").append(truncatePath).append("\" method=\"post\"><input type=\"hidden\" name=\"<truncateAll>\" value=\"</truncateAll>\"/><span><input style=\"padding: 0; margin-bottom: -12px; border: 1;background-color:LightCoral;\"type=\"submit\" value=\"Clear GWC\"></span></form><br /></body></html>");
        return buf.toString();
    }

    private static void tableRows(StringBuffer buf, TileLayerDispatcher tileLayerDispatcher, GridSetBroker gridSetBroker) throws GeoWebCacheException {
        TreeSet<String> layerList = new TreeSet<String>(tileLayerDispatcher.getLayerNames());
        for (String layerName : layerList) {
            TileLayer layer = tileLayerDispatcher.getTileLayer(layerName);
            if (!layer.isAdvertised()) continue;
            String escapedLayerName = StringEscapeUtils.escapeHtml4((String)layer.getName());
            buf.append("<tr><td style=\"min-width: 100px;\"><strong>").append(escapedLayerName).append("</strong><br />\n");
            buf.append("<a href=\"rest/seed/").append(escapedLayerName).append("\">Seed this layer</a>\n");
            buf.append("</td><td>").append(layer.isEnabled()).append("</td>");
            buf.append("<td><table width=\"100%\">");
            for (String gridSetId : layer.getGridSubsets()) {
                GridSubset gridSubset = layer.getGridSubset(gridSetId);
                Object gridSetName = gridSubset.getName();
                if (((String)gridSetName).length() > 20) {
                    gridSetName = ((String)gridSetName).substring(0, 20) + "...";
                }
                gridSetName = StringEscapeUtils.escapeHtml4((String)gridSetName);
                buf.append("<tr><td style=\"width: 170px;\">").append((String)gridSetName);
                buf.append("</td><td>OpenLayers: [");
                buf.append(layer.getMimeTypes().stream().filter(type -> type.supportsTiling() || type.isVector()).map(type -> Demo.generateDemoUrl(escapedLayerName, StringEscapeUtils.escapeHtml4((String)gridSubset.getName()), type)).collect(Collectors.joining(", ")));
                buf.append("]</td><td>\n");
                if (gridSubset.getName().equals(gridSetBroker.getWorldEpsg4326().getName())) {
                    Demo.outputKMLSupport(buf, layer);
                }
                buf.append("</td></tr>");
            }
            buf.append("</table></td>\n");
            buf.append("</tr>\n");
        }
    }

    private static void outputKMLSupport(StringBuffer buf, TileLayer layer) {
        buf.append(" &nbsp; KML: [");
        String prefix = "";
        buf.append(layer.getMimeTypes().stream().filter(type -> type instanceof ImageMime || XMLMime.kml.equals(type) || XMLMime.kmz.equals(type)).map(type -> {
            if (XMLMime.kmz.equals(type)) {
                return "<a href=\"%sservice/kml/%s.kml.kmz\">kmz</a>".formatted(prefix, StringEscapeUtils.escapeHtml4((String)layer.getName()));
            }
            return "<a href=\"%sservice/kml/%s.%s.kml\">%s</a>".formatted(prefix, StringEscapeUtils.escapeHtml4((String)layer.getName()), type.getFileExtension(), type.getFileExtension());
        }).collect(Collectors.joining(", ")));
        buf.append("]");
    }

    private static String generateDemoUrl(String layerName, String gridSetId, MimeType type) {
        return "<a href=\"demo/%s?gridSet=%s&format=%s\">%s</a>".formatted(layerName, gridSetId, type.getFormat(), type.getFileExtension());
    }

    private static String generateHTML(TileLayer layer, String gridSetStr, String formatStr) throws GeoWebCacheException {
        String layerName = layer.getName();
        GridSubset gridSubset = layer.getGridSubset(gridSetStr);
        GridSet gridSet = gridSubset.getGridSet();
        BoundingBox bbox = gridSubset.getGridSetBounds();
        BoundingBox zoomBounds = gridSubset.getOriginalExtent();
        MimeType formatMime = null;
        for (MimeType mime : layer.getMimeTypes()) {
            if (!formatStr.equalsIgnoreCase(mime.getFormat())) continue;
            formatMime = mime;
        }
        if (formatMime == null) {
            formatMime = layer.getDefaultMimeType();
        }
        StringBuilder buf = new StringBuilder();
        String openLayersPath = "../rest/web/openlayers3/";
        buf.append("<html xmlns=\"http://www.w3.org/1999/xhtml\"><head>\n");
        buf.append("<meta http-equiv=\"imagetoolbar\" content=\"no\">\n<title>").append(StringEscapeUtils.escapeHtml4((String)layerName));
        buf.append(" ").append(StringEscapeUtils.escapeHtml4((String)gridSubset.getName()));
        buf.append(" ").append(StringEscapeUtils.escapeHtml4((String)formatStr));
        buf.append("</title>\n");
        buf.append("<style type=\"text/css\">\nbody { font-family: sans-serif; font-weight: bold; font-size: .8em; }\nbody { border: 0px; margin: 0px; padding: 0px; }\n#map { width: 85%; height: 85%; border: 0px; padding: 0px; }\n#info iframe { width: 100%; height: 250px; border: none; }\n.ol-scale-value {top: 24px; right: 8px; position: absolute; }\n.ol-zoom-value {top: 40px; right: 8px; position: absolute; }\n.tooltip {position: absolute; background-color: white; border: 1px solid black; padding: 5px; border-radius: 3px; white-space: nowrap; max-height: 200px; overflow-y: auto; display: none;}\n.tooltip-header {display: flex; justify-content: space-between; align-items: center; padding: 5px; border-bottom: 1pxsolidblack; }\n.tooltip-content {padding: 5px; max-height: 150px; overflow-y: auto;}\n.close-button {cursor: pointer; background: none; border: none; font-size: 16px; font-weight: bold; }\n</style>\n");
        buf.append("<script src=\"").append(openLayersPath).append("ol.js\"></script>\n");
        buf.append("<link rel='stylesheet' href='").append(openLayersPath).append("ol.css' type='text/css'>\n");
        buf.append("<script src=\"../rest/web/demo.js\"></script>\n");
        buf.append("</head>\n<body>\n");
        buf.append("<div id=\"params\">").append(Demo.makeModifiableParameters(layer)).append("</div>\n");
        buf.append("<div id=\"map\"></div>\n<div id=\"info\"></div>\n");
        buf.append("<div id=\"tooltip\" class=\"tooltip\">\n      <div class=\"tooltip-header\">\n        <span>Attributes</span>\n        <button id=\"close-button\" class=\"close-button\">&times;</button>\n      </div>\n      <div id=\"tooltip-content\" class=\"tooltip-content\"></div>\n    </div>");
        Demo.makeHiddenInput(buf, "dpi", Double.toString(gridSubset.getDotsPerInch()));
        Demo.makeHiddenInput(buf, "gridsetName", gridSubset.getGridSet().getName());
        Demo.makeHiddenInput(buf, "gridNames", Arrays.stream(gridSubset.getGridNames()).map(s -> "\"%s\"".formatted(s)).collect(Collectors.joining(", ", "[", "]")));
        Demo.makeHiddenInput(buf, "gridNamesNumeric", String.valueOf(Arrays.stream(gridSubset.getGridNames()).allMatch(n -> StringUtils.isNumeric((CharSequence)n))));
        Demo.makeHiddenInput(buf, "format", formatStr);
        Demo.makeHiddenInput(buf, "layerName", layerName);
        Demo.makeHiddenInput(buf, "SRS", gridSubset.getSRS().toString());
        String unit = "";
        double mpu = gridSet.getMetersPerUnit();
        if (Demo.doubleEquals(mpu, 1.0)) {
            unit = "m";
        } else if (Demo.doubleEquals(mpu, 0.3048)) {
            unit = "ft";
        } else if (Demo.doubleEquals(mpu, 111132.87146300406, 186.6193302694937)) {
            unit = "degrees";
        }
        Demo.makeHiddenInput(buf, "unit", unit);
        Demo.makeHiddenInput(buf, "resolutions", Arrays.toString(gridSubset.getResolutions()));
        Demo.makeHiddenInput(buf, "tileWidth", Integer.toString(gridSubset.getTileWidth()));
        Demo.makeHiddenInput(buf, "tileHeight", Integer.toString(gridSubset.getTileHeight()));
        Demo.makeHiddenInput(buf, "minX", Double.toString(bbox.getMinX()));
        Demo.makeHiddenInput(buf, "maxY", Double.toString(bbox.getMaxY()));
        Demo.makeHiddenInput(buf, "isVector", Boolean.toString(formatMime.isVector()));
        if (formatMime.isVector()) {
            String vtName = formatMime.getInternalName();
            if (ApplicationMime.mapboxVector.getInternalName().equals(vtName)) {
                Demo.makeHiddenInput(buf, "vtFormatName", "MVT");
            } else if (ApplicationMime.topojson.getInternalName().equals(vtName)) {
                Demo.makeHiddenInput(buf, "vtFormatName", "TopoJSON");
            } else if (ApplicationMime.geojson.getInternalName().equals(vtName)) {
                Demo.makeHiddenInput(buf, "vtFormatName", "GeoJSON");
            }
        } else {
            Demo.makeHiddenInput(buf, "maxX", Double.toString(bbox.getMaxX()));
            Demo.makeHiddenInput(buf, "minY", Double.toString(bbox.getMinY()));
            Demo.makeHiddenInput(buf, "fullGrid", Boolean.toString(gridSubset.fullGridSetCoverage()));
            if (gridSubset.fullGridSetCoverage()) {
                StringBuilder origin = new StringBuilder().append("[");
                for (int i = 0; i < gridSubset.getResolutions().length; ++i) {
                    if (i != 0) {
                        origin.append(",");
                    }
                    BoundingBox subbox = gridSubset.getCoverageBounds(i);
                    origin.append("[").append(subbox.getMinX()).append(", ").append(subbox.getMaxY()).append("]");
                }
                Demo.makeHiddenInput(buf, "origins", origin.append("]").toString());
            } else {
                Demo.makeHiddenInput(buf, "origin", "[" + bbox.getMinX() + ", " + bbox.getMaxY() + "]");
            }
        }
        Demo.makeHiddenInput(buf, "bbox", "[" + String.valueOf(bbox) + "]");
        Demo.makeHiddenInput(buf, "zoomBounds", "[" + String.valueOf(zoomBounds) + "]");
        return buf.append("</body>\n</html>").toString();
    }

    private static String makeModifiableParameters(TileLayer tl) {
        List<ParameterFilter> parameterFilters = tl.getParameterFilters();
        if (parameterFilters == null || parameterFilters.isEmpty()) {
            return "";
        }
        parameterFilters = new ArrayList<ParameterFilter>(parameterFilters);
        Collections.sort(parameterFilters, (o1, o2) -> o1.getKey().compareTo(o2.getKey()));
        StringBuilder doc = new StringBuilder();
        doc.append("Modifiable Parameters:\n");
        doc.append("<table>\n");
        for (ParameterFilter pf : parameterFilters) {
            Assert.notNull((Object)pf, (String)"The parameter filter must be non null");
            String key = pf.getKey();
            String defaultValue = pf.getDefaultValue();
            List<String> legalValues = pf.getLegalValues();
            doc.append("<tr><td>").append(StringEscapeUtils.escapeHtml4((String)key.toUpperCase())).append(": ").append("</td><td>");
            String parameterId = key;
            if (pf instanceof StringParameterFilter) {
                keysValues = Demo.makeParametersMap(defaultValue, legalValues);
                Demo.makePullDown(doc, parameterId, keysValues, defaultValue);
            } else if (pf instanceof RegexParameterFilter) {
                Demo.makeTextInput(doc, parameterId, 25);
            } else if (pf instanceof FloatParameterFilter) {
                FloatParameterFilter floatParam = (FloatParameterFilter)pf;
                if (floatParam.getValues().isEmpty()) {
                    Demo.makeTextInput(doc, parameterId, 25);
                } else {
                    keysValues = Demo.makeParametersMap(defaultValue, legalValues);
                    Demo.makePullDown(doc, parameterId, keysValues, defaultValue);
                }
            } else if ("org.geowebcache.filter.parameters.NaiveWMSDimensionFilter".equals(pf.getClass().getName())) {
                Demo.makeTextInput(doc, parameterId, 25);
            } else if (legalValues == null) {
                Demo.makeTextInput(doc, parameterId, 25);
            } else {
                keysValues = Demo.makeParametersMap(defaultValue, legalValues);
                Demo.makePullDown(doc, parameterId, keysValues, defaultValue);
            }
            doc.append("</td></tr>\n");
        }
        doc.append("</table>\n");
        return doc.toString();
    }

    private static Map<String, String> makeParametersMap(String defaultValue, List<String> legalValues) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (String s : legalValues) {
            map.put(s, s);
        }
        map.put(defaultValue, defaultValue);
        return map;
    }

    private static void makeHiddenInput(StringBuilder doc, String id, String value) {
        doc.append("<input type=\"hidden\" id=\"hidden_").append(StringEscapeUtils.escapeHtml4((String)id)).append("\" value=\"").append(StringEscapeUtils.escapeHtml4((String)value)).append("\" />\n");
    }

    private static void makePullDown(StringBuilder doc, String id, Map<String, String> keysValues, String defaultKey) {
        doc.append("<select name=\"" + StringEscapeUtils.escapeHtml4((String)id) + "\">\n");
        for (Map.Entry<String, String> entry : keysValues.entrySet()) {
            String key = entry.getKey();
            if (key == null && defaultKey == null || key != null && key.equals(defaultKey)) {
                doc.append("<option value=\"" + StringEscapeUtils.escapeHtml4((String)entry.getValue()) + "\" selected=\"selected\">" + StringEscapeUtils.escapeHtml4((String)entry.getKey()) + "</option>\n");
                continue;
            }
            doc.append("<option value=\"" + StringEscapeUtils.escapeHtml4((String)entry.getValue()) + "\">" + StringEscapeUtils.escapeHtml4((String)entry.getKey()) + "</option>\n");
        }
        doc.append("</select>\n");
    }

    private static void makeTextInput(StringBuilder doc, String id, int size) {
        doc.append("<input name=\"" + StringEscapeUtils.escapeHtml4((String)id) + "\" type=\"text\" size=\"" + size + "\" />\n");
    }

    private static boolean doubleEquals(double d1, double d2) {
        return Demo.doubleEquals(d1, d2, 0.0);
    }

    private static boolean doubleEquals(double d1, double d2, double buffer) {
        double diff = Math.abs(d1 - d2);
        return diff < Math.ulp(d1) + Math.ulp(d2) + buffer;
    }
}

