/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.filter.parameters;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.geowebcache.filter.parameters.ParameterException;

@ParametersAreNonnullByDefault
public abstract class ParameterFilter
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -531248230951783132L;
    private String key;
    private String defaultValue = "";

    public ParameterFilter() {
    }

    public ParameterFilter(String key, @Nullable String defaultValue) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkArgument((!key.isEmpty() ? 1 : 0) != 0, (Object)"Parameter key must not be empty.");
        this.key = key;
        this.defaultValue = defaultValue;
    }

    public ParameterFilter(String key) {
        this(key, "");
    }

    public String getKey() {
        return this.key;
    }

    public String getDefaultValue() {
        if (this.defaultValue == null) {
            return "";
        }
        return this.defaultValue;
    }

    public ParameterFilter clone() {
        try {
            return (ParameterFilter)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean applies(@Nullable String parameterValue) {
        try {
            this.apply(parameterValue);
        }
        catch (ParameterException e) {
            return false;
        }
        return true;
    }

    public abstract String apply(@Nullable String var1) throws ParameterException;

    @Nullable
    public abstract List<String> getLegalValues();

    public void setKey(String key) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkArgument((!key.isEmpty() ? 1 : 0) != 0, (Object)"ParameterFilter key must be non-empty");
        Preconditions.checkState((this.key == null ? 1 : 0) != 0, (Object)"The key for this ParameterFilter has already been set");
        this.key = key;
    }

    public void setDefaultValue(@Nullable String defaultValue) {
        if (defaultValue == null) {
            defaultValue = "";
        }
        this.defaultValue = defaultValue;
    }

    protected Object readResolve() {
        Preconditions.checkNotNull((Object)this.key);
        Preconditions.checkState((!this.key.isEmpty() ? 1 : 0) != 0, (Object)"ParameterFilter key must be non-empty");
        if (this.defaultValue == null) {
            this.defaultValue = "";
        }
        return this;
    }

    public boolean isFilteredValue(String value) {
        if (Objects.equals(value, this.getDefaultValue())) {
            return true;
        }
        if (Optional.ofNullable(this.getLegalValues()).map(values -> values.contains(value)).orElse(false).booleanValue()) {
            return true;
        }
        try {
            return Objects.equals(value, this.apply(value));
        }
        catch (ParameterException ex) {
            return false;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.defaultValue == null ? 0 : this.defaultValue.hashCode());
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ParameterFilter other = (ParameterFilter)obj;
        if (this.defaultValue == null ? other.defaultValue != null : !this.defaultValue.equals(other.defaultValue)) {
            return false;
        }
        return !(this.key == null ? other.key != null : !this.key.equals(other.key));
    }
}

